/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.pubsub;

import fr.emac.gind.generic.application.websocket.pubsub.PubSubEndpoint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EndpointHandler {
    private static EndpointHandler instance_;
    private Map<String, PubSubEndpoint> endpoints_ = new ConcurrentHashMap<String, PubSubEndpoint>();

    public static EndpointHandler getInstance() {
        return instance_;
    }

    public void register(PubSubEndpoint endpoint) {
        this.endpoints_.put(String.valueOf(endpoint.hashCode()), endpoint);
    }

    public PubSubEndpoint remove(String sessionId) {
        return this.endpoints_.remove(sessionId);
    }

    public PubSubEndpoint removeByInstance(PubSubEndpoint endpoint) {
        return this.remove(String.valueOf(endpoint.hashCode()));
    }

    public PubSubEndpoint get(String sessionId) {
        return this.endpoints_.get(sessionId);
    }

    public void broadcastMessage(String message) {
        for (PubSubEndpoint p : this.endpoints_.values()) {
            try {
                p.getSession().getRemote().sendString(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class EndpointHandlerBuilder {
        public static void buildEndpointHandler() {
            instance_ = new EndpointHandler();
        }
    }
}

