/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.pubsub;

import fr.emac.gind.event.pubsub.GJaxbMessage;
import fr.emac.gind.event.pubsub.GJaxbMessageDirection;
import fr.emac.gind.generic.application.websocket.pubsub.EndpointHandler;
import fr.emac.gind.generic.application.websocket.pubsub.MessageLocker;
import fr.emac.gind.generic.application.websocket.pubsub.TopicManager;
import fr.emac.gind.marshaller.JSONJAXBContext;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class PubSubEndpoint {
    private Session session_;
    private static Logger LOG = LoggerFactory.getLogger((String)PubSubEndpoint.class.getName());

    public Session getSession() {
        return this.session_;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session_ = session;
        EndpointHandler handler = EndpointHandler.getInstance();
        TopicManager.getInstance().addTopic(this);
        handler.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onMessage(Session session, String message) throws Exception {
        EndpointHandler handler = EndpointHandler.getInstance();
        GJaxbMessage msg = (GJaxbMessage)JSONJAXBContext.getInstance().unmarshall("{ \"message\" : " + message + "}", GJaxbMessage.class);
        if (msg.getMessageDirection() == GJaxbMessageDirection.OUT) {
            LOG.info("msg.getId = " + msg.getId());
            MessageLocker locker = TopicManager.getInstance().getMessageLockersMap().get(msg.getId());
            assert (locker != null) : "locker cannot be null: " + String.valueOf(msg);
            MessageLocker messageLocker = locker;
            synchronized (messageLocker) {
                locker.setMessage(msg);
                locker.notify();
            }
        }
        handler.broadcastMessage(message);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
        TopicManager.getInstance().removeEndpoint(this);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
        TopicManager.getInstance().removeEndpoint(this);
        cause.printStackTrace(System.err);
    }
}

