/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.pubsub;

import fr.emac.gind.commons.utils.map.MapHelper;
import fr.emac.gind.generic.application.websocket.pubsub.MessageLocker;
import fr.emac.gind.generic.application.websocket.pubsub.PubSubEndpoint;
import fr.emac.gind.logger.GindLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TopicManager {
    private static Logger LOG = LoggerFactory.getLogger((String)TopicManager.class.getName());
    private static TopicManager INSTANCE;
    private static Map<String, List<PubSubEndpoint>> topicsMap;
    private Map<String, MessageLocker> messageLockersMap = Collections.synchronizedMap(new HashMap());

    private TopicManager() {
    }

    public static TopicManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TopicManager();
        }
        return INSTANCE;
    }

    public void addTopic(PubSubEndpoint endpoint) {
        String topic = endpoint.getSession().getUpgradeRequest().getRequestURI().getPath().replace("/ws/pubsub/", "");
        if (topicsMap.get(topic) == null) {
            topicsMap.put(topic, Collections.synchronizedList(new ArrayList()));
        }
        topicsMap.get(topic).add(endpoint);
        GindLogger.log((Logger)LOG, (Level)Level.DEBUG, (String)"wssocket: subscribe new endpoint to topic", (Map)MapHelper.mapOf((Object[])new Object[]{"topic", topic, "consumer", endpoint.getSession().getRemoteAddress().toString()}));
    }

    public List<PubSubEndpoint> findTopic(String topicName) {
        if (topicsMap.get(topicName) != null) {
            return Collections.unmodifiableList(Collections.synchronizedList(topicsMap.get(topicName)));
        }
        if (topicName != null && topicName.startsWith("/") && topicsMap.get(topicName = topicName.replaceFirst("/", "")) != null) {
            return Collections.unmodifiableList(Collections.synchronizedList(topicsMap.get(topicName)));
        }
        return null;
    }

    public Map<String, List<PubSubEndpoint>> getTopicsMap() {
        return topicsMap;
    }

    public Map<String, MessageLocker> getMessageLockersMap() {
        return this.messageLockersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void broadcastMessage(String topic, String message) {
        Iterator it;
        ArrayList<PubSubEndpoint> endpoints = new ArrayList<PubSubEndpoint>(this.findTopic(topic));
        ArrayList<PubSubEndpoint> endpointsToRemote = new ArrayList<PubSubEndpoint>();
        if (endpoints == null) return;
        if (endpoints.isEmpty()) return;
        Iterator iterator = it = endpoints.iterator();
        synchronized (iterator) {
            while (it.hasNext()) {
                PubSubEndpoint p = (PubSubEndpoint)it.next();
                if (p == null) continue;
                try {
                    p.getSession().getRemote().sendString(message);
                    GindLogger.log((Logger)LOG, (Level)Level.DEBUG, (String)"wssocket: send message", (Map)MapHelper.mapOf((Object[])new Object[]{"topic", topic, "consumer", p.getSession().getRemoteAddress().toString(), "payload", message}));
                }
                catch (Throwable e) {
                    GindLogger.log((Logger)LOG, (Level)Level.WARN, (String)"wssocket: error to send message", (Map)MapHelper.mapOf((Object[])new Object[]{"topic", topic, "consumer", p.getSession().getRemoteAddress().toString(), "payload", message, "errorMsg", e.getMessage()}));
                    LOG.warn(e.getMessage(), e);
                    endpointsToRemote.add(p);
                }
            }
            return;
        }
    }

    public void removeEndpoint(PubSubEndpoint endpoint) {
        LOG.debug("Remove endpoint " + String.valueOf(endpoint));
        for (Map.Entry<String, List<PubSubEndpoint>> entry : topicsMap.entrySet()) {
            if (!entry.getValue().contains(endpoint)) continue;
            LOG.debug("... removing endpoint in topic " + entry.getKey());
            entry.getValue().remove(endpoint);
            break;
        }
    }

    static {
        topicsMap = Collections.synchronizedMap(new HashMap());
    }
}

