/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.campaign.manager.client;

import fr.emac.gind.campaign.manager.client.CampaignManagerClient;
import fr.emac.gind.campaign.manager.client.WSCampaignNotifierClient;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.eventtype.GJaxbAddCampaignSolutionEvent;
import fr.emac.gind.eventtype.GJaxbCreateCampaignEvent;
import fr.emac.gind.eventtype.GJaxbRemoveCampaignSolutionEvent;
import fr.emac.gind.eventtype.GJaxbUpdateCampaignEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class CampaignManagerNotifierClient
extends CampaignManagerClient {
    private AbstractNotifierClient notifier = null;
    private NotificationConsumerWebService notifierServer = null;
    private URL serverAddress = null;
    private URL myAddress = null;
    private String producerAddress = null;

    public CampaignManagerNotifierClient(URL serverAddress, URL myAddress) throws Exception {
        super(serverAddress.toString());
        this.serverAddress = serverAddress;
        this.myAddress = myAddress;
        this.producerAddress = this.serverAddress.toString() + "Subscriber";
        this.notifier = new WSCampaignNotifierClient(myAddress.toString(), this);
        this.notifierServer = new NotificationConsumerWebService();
    }

    public void subscribeToCampaignManager(Object localTestCampaignNotifier) throws Exception {
        if (localTestCampaignNotifier != null) {
            this.notifier.subscribeOn((NotificationManagerImpl)localTestCampaignNotifier, new QName("http://www.gind.emac.fr/EventType", "allCampaignTopic"));
            this.notifier.subscribeOn((NotificationManagerImpl)localTestCampaignNotifier, new QName("http://www.gind.emac.fr/EventType", "allSolutionTopic"));
        } else {
            this.notifier.subscribeOn(this.producerAddress, new QName("http://www.gind.emac.fr/EventType", "allCampaignTopic"));
            this.notifier.subscribeOn(this.producerAddress, new QName("http://www.gind.emac.fr/EventType", "allSolutionTopic"));
        }
    }

    public abstract void onCreateCampaignEvent(GJaxbCreateCampaignEvent var1);

    public abstract void onUpdateCampaignEvent(GJaxbUpdateCampaignEvent var1);

    public abstract void onAddSolutionEvent(GJaxbAddCampaignSolutionEvent var1);

    public abstract void onRemoveSolutionEvent(GJaxbRemoveCampaignSolutionEvent var1);

    public void start() throws Exception {
        this.notifierServer.start((Map)new HashMap<String, Object>(){
            {
                this.put("host", CampaignManagerNotifierClient.this.myAddress.getHost());
                this.put("port", CampaignManagerNotifierClient.this.myAddress.getPort());
                this.put("serviceName", CampaignManagerNotifierClient.this.myAddress.getPath());
                this.put("notifierClient", CampaignManagerNotifierClient.this.notifier);
            }
        });
    }

    public void stop() throws Exception {
        this.notifierServer.stop();
    }
}

