/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.campaign.manager.server;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import fr.emac.gind.campaign.manager.CampaignFault;
import fr.emac.gind.campaign.manager.CampaignManagerItf;
import fr.emac.gind.campaign.manager.client.data.GJaxbAddConceptsPostAnalyze;
import fr.emac.gind.campaign.manager.client.data.GJaxbAddConceptsPostAnalyzeResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbAddSolution;
import fr.emac.gind.campaign.manager.client.data.GJaxbAddSolutionResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbCountSolutions;
import fr.emac.gind.campaign.manager.client.data.GJaxbCountSolutionsByMetrics;
import fr.emac.gind.campaign.manager.client.data.GJaxbCountSolutionsByMetricsResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbCountSolutionsResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbCreateCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbCreateCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbDeleteCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbDeleteCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbExpression;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindCampaignByName;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindCampaignByNameResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionById;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionByIdResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionByName;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionByNameResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionBySignature;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionBySignatureResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionsByMetrics;
import fr.emac.gind.campaign.manager.client.data.GJaxbFindSolutionsByMetricsResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetAllCampaignsWithoutResources;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetAllCampaignsWithoutResourcesResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignWithoutResources;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignWithoutResourcesResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignsWithoutResourcesByUser;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignsWithoutResourcesByUserResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetFailureSolutions;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetFailureSolutionsResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbMetricComparison;
import fr.emac.gind.campaign.manager.client.data.GJaxbOperatorType;
import fr.emac.gind.campaign.manager.client.data.GJaxbRemoveSolution;
import fr.emac.gind.campaign.manager.client.data.GJaxbRemoveSolutionResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbUpdateCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbUpdateCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbUpdateSolution;
import fr.emac.gind.campaign.manager.client.data.GJaxbUpdateSolutionResponse;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaignSolution;
import fr.emac.gind.campaign.manager.server.CampaignManagerSubscriber;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.consumer.Consumer;
import fr.emac.gind.event.producer.Notifier;
import fr.emac.gind.eventtype.GJaxbAddCampaignSolutionEvent;
import fr.emac.gind.eventtype.GJaxbAddNodeEvent;
import fr.emac.gind.eventtype.GJaxbCreateCampaignEvent;
import fr.emac.gind.eventtype.GJaxbUpdateCampaignEvent;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbAddNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNodeResponse;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.indicators.plugin.IndicatorsRangeStrategyPluginManager;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPredefinedShape;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.storage.mongodb.StorageImpl;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@WebService(serviceName="campaignManager", portName="campaignManagerSOAP", targetNamespace="http://www.gind.emac.fr/campaign/manager", wsdlLocation="wsdl/campaignManager.wsdl", endpointInterface="fr.emac.gind.campaign.manager.CampaignManagerItf")
public class CampaignManagerImpl
implements CampaignManagerItf {
    private static final Logger LOG = LoggerFactory.getLogger((String)CampaignManagerImpl.class.getName());
    protected String campaignCollection = "testCampaigns";
    protected String solutionsCampaignsCollection = "solutionsCampaigns";
    private Map<String, Object> context = null;
    private MongoClient client = null;
    private MongoDatabase db = null;
    private CoreGov coreClient = null;
    private CampaignManagerSubscriber producer = null;
    private Map<QName, List<Consumer>> notifConsumersEpr = Collections.synchronizedMap(new HashMap());
    private IndicatorsRangeStrategyPluginManager indicatorStrategyManager = null;

    public CampaignManagerImpl(Map<String, Object> context, CampaignManagerSubscriber campaignManagerSubscriber) throws Exception {
        this.client = StorageImpl.createMongoClient(context);
        String database_name = (String)context.get("mongodb-database-name");
        this.db = this.client.getDatabase(database_name);
        this.coreClient = CoreGovClient.createClient((String)context.get("governance").toString().replace("/gov", "/GovCore"));
        this.indicatorStrategyManager = new IndicatorsRangeStrategyPluginManager();
        this.context = context;
        this.producer = campaignManagerSubscriber;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public GJaxbGetCampaignResponse getCampaign(GJaxbGetCampaign parameters) throws CampaignFault {
        LOG.debug("Executing operation getCampaign");
        try {
            GJaxbGetCampaignResponse _return = new GJaxbGetCampaignResponse();
            for (Document doc : this.db.getCollection(this.campaignCollection).find((Bson)new Document("campaign.campaignId", (Object)parameters.getCampaignId()))) {
                String campaignString = ((Document)doc.get((Object)"campaign", Document.class)).toJson();
                GJaxbCampaign campaign = (GJaxbCampaign)JSONJAXBContext.getInstance().unmarshall("{ \"campaign\" : " + campaignString + " }", GJaxbCampaign.class);
                _return.setCampaign(campaign);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbGetAllCampaignsWithoutResourcesResponse getAllCampaignsWithoutResources(GJaxbGetAllCampaignsWithoutResources parameters) throws CampaignFault {
        try {
            GJaxbGetAllCampaignsWithoutResourcesResponse _return = new GJaxbGetAllCampaignsWithoutResourcesResponse();
            MongoCollection collection = this.db.getCollection(this.campaignCollection);
            for (Document doc : collection.find().projection((Bson)new Document("campaign.resource", (Object)0))) {
                String campaignString = ((Document)doc.get((Object)"campaign", Document.class)).toJson();
                GJaxbCampaign campaign = (GJaxbCampaign)JSONJAXBContext.getInstance().unmarshall("{ \"campaign\" : " + campaignString + " }", GJaxbCampaign.class);
                _return.getCampaign().add(campaign);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbAddSolutionResponse addSolution(GJaxbAddSolution parameters) throws CampaignFault {
        LOG.debug("Executing operation addSolution");
        try {
            GJaxbAddSolutionResponse _return = new GJaxbAddSolutionResponse();
            Document doc = Document.parse((String)JSONJAXBContext.getInstance().marshallAnyElement((Object)parameters.getCampaignSolution()));
            this.db.getCollection(this.solutionsCampaignsCollection).insertOne((Object)doc);
            String id = doc.get((Object)"_id").toString();
            this.db.getCollection(this.solutionsCampaignsCollection).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(id)), Updates.set((String)"campaignSolution.campaignSolutionId", (Object)id));
            _return.setCampaignSolutionId(id);
            GJaxbAddCampaignSolutionEvent scEvent = new GJaxbAddCampaignSolutionEvent();
            scEvent.setCampaignSolution(parameters.getCampaignSolution());
            scEvent.setCampaign(parameters.getCampaign());
            String collaborationName = null;
            String knowledgeSpaceName = null;
            if (parameters.getSelectedKnowledgeSpace() != null) {
                collaborationName = parameters.getSelectedKnowledgeSpace().getCollaborationName();
                knowledgeSpaceName = parameters.getSelectedKnowledgeSpace().getKnowledgeName();
            }
            scEvent.setCollaborationName(collaborationName);
            scEvent.setKnowledgeSpaceName(knowledgeSpaceName);
            this.notifyOnAddSolutionTopic(scEvent);
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbUpdateSolutionResponse updateSolution(GJaxbUpdateSolution parameters) throws CampaignFault {
        LOG.debug("Executing operation addSolution");
        try {
            GJaxbUpdateSolutionResponse _return = new GJaxbUpdateSolutionResponse();
            for (GJaxbUpdateSolution.Set set : parameters.getSet()) {
                if (set.getName().contains("[")) {
                    String name = set.getName().substring(0, set.getName().indexOf("["));
                    this.db.getCollection(this.solutionsCampaignsCollection).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(parameters.getCampaignSolutionId())), Updates.addToSet((String)name, (Object)set.getValue()));
                    continue;
                }
                this.db.getCollection(this.solutionsCampaignsCollection).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(parameters.getCampaignSolutionId())), Updates.set((String)set.getName(), (Object)set.getValue()));
            }
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbGetCampaignsWithoutResourcesByUserResponse getCampaignsWithoutResourcesByUser(GJaxbGetCampaignsWithoutResourcesByUser parameters) throws CampaignFault {
        try {
            GJaxbGetCampaignsWithoutResourcesByUserResponse _return = new GJaxbGetCampaignsWithoutResourcesByUserResponse();
            MongoCollection collection = this.db.getCollection(this.campaignCollection);
            for (Document doc : collection.find((Bson)new Document("campaign.userId", (Object)parameters.getUserId())).projection((Bson)new Document("campaign.resource", (Object)0))) {
                String campaignString = ((Document)doc.get((Object)"campaign", Document.class)).toJson();
                GJaxbCampaign campaign = (GJaxbCampaign)JSONJAXBContext.getInstance().unmarshall("{ \"campaign\" : " + campaignString + " }", GJaxbCampaign.class);
                _return.getCampaign().add(campaign);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public void updateCampaign(GJaxbCampaign campaign, String collaborationName, String knowledgeSpaceName) throws CampaignFault {
        GJaxbUpdateCampaign parameters = new GJaxbUpdateCampaign();
        parameters.setCampaign(campaign);
        parameters.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        parameters.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        parameters.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        try {
            this.updateCampaign(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    private void createSetForUpdateSolution(GJaxbUpdateSolution parameters, JSONObject json, String path) throws Exception {
        for (String key : json.keySet()) {
            if (json.get(key) instanceof AbstractJaxbObject) {
                GJaxbUpdateSolution.Set set = new GJaxbUpdateSolution.Set();
                set.setName(path + key);
                set.setValue((Object)Document.parse((String)JSONJAXBContext.getInstance().marshallAnyElement(json.get(key))));
                parameters.getSet().add(set);
                continue;
            }
            if (json.get(key) instanceof JSONObject) {
                GJaxbUpdateSolution.Set set = new GJaxbUpdateSolution.Set();
                set.setName(path + key);
                set.setValue((Object)Document.parse((String)json.get(key).toString()));
                parameters.getSet().add(set);
                continue;
            }
            if (json.get(key) instanceof JSONArray) {
                for (int i = 0; i < ((JSONArray)json.get(key)).length(); ++i) {
                    GJaxbUpdateSolution.Set set = new GJaxbUpdateSolution.Set();
                    set.setName(path + key + "[" + i + "]");
                    set.setValue((Object)Document.parse((String)((JSONArray)json.get(key)).getJSONObject(i).toString()));
                    parameters.getSet().add(set);
                }
                continue;
            }
            GJaxbUpdateSolution.Set set = new GJaxbUpdateSolution.Set();
            set.setName(path + key);
            set.setValue(json.get(key));
            parameters.getSet().add(set);
        }
    }

    public GJaxbUpdateCampaignResponse updateCampaign(GJaxbUpdateCampaign parameters) throws CampaignFault {
        LOG.debug("Executing operation updateCampaign");
        try {
            GJaxbUpdateCampaignResponse _return = new GJaxbUpdateCampaignResponse();
            if (parameters.getCampaign() != null) {
                Document doc = Document.parse((String)JSONJAXBContext.getInstance().marshallAnyElement((Object)parameters.getCampaign()));
                this.db.getCollection(this.campaignCollection).replaceOne(Filters.eq((String)"_id", (Object)new ObjectId(parameters.getCampaign().getCampaignId())), (Object)doc);
            } else {
                for (GJaxbUpdateCampaign.Set set : parameters.getSet()) {
                    if (set.getName().contains("[")) {
                        String name = set.getName().substring(0, set.getName().indexOf("["));
                        this.db.getCollection(this.campaignCollection).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(parameters.getCampaignId())), Updates.addToSet((String)name, (Object)set.getValue()));
                        continue;
                    }
                    this.db.getCollection(this.campaignCollection).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(parameters.getCampaignId())), Updates.set((String)set.getName(), (Object)set.getValue()));
                }
            }
            GJaxbUpdateCampaignEvent csce = new GJaxbUpdateCampaignEvent();
            csce.setCampaign(parameters.getCampaign());
            csce.setCollaborationName(parameters.getSelectedKnowledgeSpace().getCollaborationName());
            csce.setKnowledgeSpaceName(parameters.getSelectedKnowledgeSpace().getKnowledgeName());
            this.notifyOnUpdateCampaignTopic(csce);
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbRemoveSolutionResponse removeSolution(GJaxbRemoveSolution parameters) throws CampaignFault {
        LOG.debug("Executing operation addSolution");
        LOG.debug("Executing operation removeTask");
        try {
            GJaxbRemoveSolutionResponse _return = new GJaxbRemoveSolutionResponse();
            Document doc = (Document)this.db.getCollection(this.solutionsCampaignsCollection).findOneAndDelete((Bson)new Document("campaignSolution.campaignSolutionId", (Object)parameters.getCampaignSolutionId()));
            String campaignSolutionString = ((Document)doc.get((Object)"campaignSolution", Document.class)).toJson();
            GJaxbCampaignSolution campaignSolution = (GJaxbCampaignSolution)JSONJAXBContext.getInstance().unmarshall("{ \"campaignSolution\" : " + campaignSolutionString + " }", GJaxbCampaignSolution.class);
            _return.setCampaignSolutionId(campaignSolution.getCampaignId());
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbCreateCampaignResponse createCampaign(GJaxbCreateCampaign parameters) throws CampaignFault {
        LOG.debug("Executing operation createCampaign");
        try {
            GJaxbCreateCampaignResponse _return = new GJaxbCreateCampaignResponse();
            String collaborationName = null;
            String knowledgeSpaceName = null;
            if (parameters.getSelectedKnowledgeSpace() != null) {
                collaborationName = parameters.getSelectedKnowledgeSpace().getCollaborationName();
                knowledgeSpaceName = parameters.getSelectedKnowledgeSpace().getKnowledgeName();
            }
            Document doc = Document.parse((String)JSONJAXBContext.getInstance().marshallAnyElement((Object)parameters.getCampaign()));
            this.db.getCollection(this.campaignCollection).insertOne((Object)doc);
            String id = doc.get((Object)"_id").toString();
            GJaxbUpdateCampaign updateCampaign = new GJaxbUpdateCampaign();
            parameters.getCampaign().setCampaignId(id);
            this.updateCampaign(parameters.getCampaign(), collaborationName, knowledgeSpaceName);
            GJaxbCreateCampaignEvent cce = new GJaxbCreateCampaignEvent();
            cce.setCampaign(parameters.getCampaign());
            cce.setCollaborationName(collaborationName);
            cce.setKnowledgeSpaceName(knowledgeSpaceName);
            this.notifyOnCreateCampaignTopic(cce);
            _return.setCampaignId(id);
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbFindSolutionsByMetricsResponse findSolutionsByMetrics(GJaxbFindSolutionsByMetrics parameters) throws CampaignFault {
        try {
            GJaxbFindSolutionsByMetricsResponse _return = new GJaxbFindSolutionsByMetricsResponse();
            MongoCollection collection = this.db.getCollection(this.solutionsCampaignsCollection);
            ArrayList<Document> commands = new ArrayList<Document>();
            commands.add(new Document("$match", (Object)new Document("campaignSolution.campaignId", (Object)parameters.getCampaignId())));
            this.analyzeExpression(parameters.getExp(), commands);
            if (parameters.getLimit() > 0) {
                commands.add(new Document("$limit", (Object)parameters.getLimit()));
            }
            AggregateIterable output = collection.aggregate(commands);
            for (Document doc : output) {
                String campaignSolutionString = ((Document)doc.get((Object)"campaignSolution", Document.class)).toJson();
                GJaxbCampaignSolution campaignSolution = (GJaxbCampaignSolution)JSONJAXBContext.getInstance().unmarshall("{ \"campaignSolution\" : " + campaignSolutionString + " }", GJaxbCampaignSolution.class);
                CampaignManagerImpl.minimizeSolution(campaignSolution, parameters.isWithMessages(), parameters.isWithResources());
                _return.getCampaignSolution().add(campaignSolution);
            }
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public static void minimizeSolution(GJaxbCampaignSolution solution, boolean withMessages, boolean withResources) {
        if (!withResources) {
            solution.setSolutionToDeploy(null);
        }
    }

    private void analyzeExpression(GJaxbExpression exp, List<Document> commands) throws Exception {
        if (exp != null) {
            if (exp.getMetricComparison() != null) {
                GJaxbMetricComparison metricComparison = exp.getMetricComparison();
                String metricName = metricComparison.getMetricName();
                String valueType = null;
                Document impedanceDoc = new Document("name", (Object)metricName);
                HashMap<String, Float> jsonMap = new HashMap<String, Float>();
                GJaxbMetricComparison.Operation op = exp.getMetricComparison().getOperation();
                Float value = null;
                valueType = "indicatorValue.simulatedValue.precise";
                value = Float.valueOf(op.getValue());
                String operator = null;
                if (GJaxbOperatorType.EQ.equals((Object)op.getOperator())) {
                    operator = "$eq";
                } else if (GJaxbOperatorType.GT.equals((Object)op.getOperator())) {
                    operator = "$gt";
                } else if (GJaxbOperatorType.GTE.equals((Object)op.getOperator())) {
                    operator = "$gte";
                } else if (GJaxbOperatorType.LT.equals((Object)op.getOperator())) {
                    operator = "$lt";
                } else if (GJaxbOperatorType.LTE.equals((Object)op.getOperator())) {
                    operator = "$lte";
                }
                jsonMap.put(operator, value);
                impedanceDoc.append(valueType, (Object)new Document(jsonMap));
                Document elmtMatch = new Document("$elemMatch", (Object)impedanceDoc);
                Document ImpedanceParent = new Document("campaignSolution.indicator", (Object)elmtMatch);
                commands.add(new Document("$match", (Object)ImpedanceParent));
            } else if (exp.getAndExp() != null) {
                this.analyzeExpression(exp.getAndExp().getExpLeft(), commands);
                this.analyzeExpression(exp.getAndExp().getExpRight(), commands);
            } else {
                throw new Exception("Not implemented for now!!!");
            }
        }
    }

    public GJaxbDeleteCampaignResponse deleteCampaign(GJaxbDeleteCampaign parameters) throws CampaignFault {
        LOG.debug("Executing operation removeTask");
        try {
            GJaxbDeleteCampaignResponse _return = new GJaxbDeleteCampaignResponse();
            Document doc = (Document)this.db.getCollection(this.campaignCollection).findOneAndDelete((Bson)new Document("campaign.campaignSolutionId", (Object)parameters.getCampaignId()));
            String campaignString = ((Document)doc.get((Object)"campaign", Document.class)).toJson();
            GJaxbCampaign campaign = (GJaxbCampaign)JSONJAXBContext.getInstance().unmarshall("{ \"campaign\" : " + campaignString + " }", GJaxbCampaign.class);
            _return.setCampaign(campaign);
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbCountSolutionsByMetricsResponse countSolutionsByMetrics(GJaxbCountSolutionsByMetrics parameters) throws CampaignFault {
        try {
            GJaxbCountSolutionsByMetricsResponse _return = new GJaxbCountSolutionsByMetricsResponse();
            MongoCollection collection = this.db.getCollection(this.solutionsCampaignsCollection);
            ArrayList<Document> commands = new ArrayList<Document>();
            commands.add(new Document("$match", (Object)new Document("campaignSolution.campaignId", (Object)parameters.getCampaignId())));
            this.analyzeExpression(parameters.getExp(), commands);
            commands.add(new Document("$group", (Object)new Document("_id", null).append("count", (Object)new Document("$sum", (Object)1))));
            for (Document document : commands) {
            }
            AggregateIterable output = collection.aggregate(commands);
            for (Document doc : output) {
                _return.setCount(doc.getInteger((Object)"count").intValue());
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbGetCampaignWithoutResourcesResponse getCampaignWithoutResources(GJaxbGetCampaignWithoutResources parameters) throws CampaignFault {
        try {
            GJaxbGetCampaignWithoutResourcesResponse _return = new GJaxbGetCampaignWithoutResourcesResponse();
            MongoCollection collection = this.db.getCollection(this.campaignCollection);
            for (Document doc : collection.find((Bson)new Document("campaign.campaignSolutionId", (Object)parameters.getCampaignId())).projection((Bson)new Document("campaign.resource", (Object)0))) {
                String campaignString = ((Document)doc.get((Object)"campaign", Document.class)).toJson();
                GJaxbCampaign campaign = (GJaxbCampaign)JSONJAXBContext.getInstance().unmarshall("{ \"campaign\" : " + campaignString + " }", GJaxbCampaign.class);
                _return.setCampaign(campaign);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbGetSolutionsFromCampaignResponse getSolutionsFromCampaign(GJaxbGetSolutionsFromCampaign parameters) throws CampaignFault {
        GJaxbFindSolutionsByMetrics request = new GJaxbFindSolutionsByMetrics();
        request.setCampaignId(parameters.getCampaignId());
        request.setWithMessages(true);
        request.setWithResources(false);
        GJaxbFindSolutionsByMetricsResponse response = this.findSolutionsByMetrics(request);
        GJaxbGetSolutionsFromCampaignResponse resp = new GJaxbGetSolutionsFromCampaignResponse();
        resp.getCampaignSolution().addAll(response.getCampaignSolution());
        resp.getCampaignSolution().stream().forEach(sc -> CampaignManagerImpl.minimizeSolution(sc, parameters.isWithMessages(), parameters.isWithResources()));
        return resp;
    }

    public void addSolution(GJaxbCampaignSolution campaignSolution) throws CampaignFault {
        GJaxbAddSolution addReq = new GJaxbAddSolution();
        addReq.setCampaignSolution(campaignSolution);
        this.addSolution(addReq);
    }

    public GJaxbAddConceptsPostAnalyzeResponse addConceptsPostAnalyze(GJaxbAddConceptsPostAnalyze parameters) throws CampaignFault {
        GJaxbAddConceptsPostAnalyzeResponse res = new GJaxbAddConceptsPostAnalyzeResponse();
        try {
            String collaborationName = parameters.getCollaborationName();
            String knowledgeSpaceName = parameters.getKnowledgeSpaceName();
            GJaxbGenericModel model = parameters.getGenericModel();
            Object message = "";
            for (GJaxbNode concept : model.getNode()) {
                if (!concept.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Potentiality"))) continue;
                String organizationId = GenericModelHelper.findProperty((String)"organizationId", (List)concept.getProperty()).getValue();
                String functionId = GenericModelHelper.findProperty((String)"functionId", (List)concept.getProperty()).getValue();
                GJaxbQuery query = new GJaxbQuery();
                query.setQuery("match (r:" + Neo4JReqConstant.collab((String)"Potentiality") + " { property_name: '" + GenericModelHelper.getName((GJaxbNode)concept) + "' } )-[:" + Neo4JReqConstant.uml((String)"Compose") + "]->(f:" + Neo4JReqConstant.collab((String)"Function") + " { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)functionId, (String)collaborationName, (String)knowledgeSpaceName) + "' }) return r");
                query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                GJaxbQueryResponse queryResponse = this.coreClient.query(query);
                if (queryResponse.getSingle() == null || queryResponse.getSingle().getGenericModel() != null && queryResponse.getSingle().getGenericModel().getNode().isEmpty()) {
                    GJaxbGetNode funcReq = new GJaxbGetNode();
                    funcReq.setId(functionId);
                    funcReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                    funcReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                    funcReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                    GJaxbGetNodeResponse funcResp = this.coreClient.getNode(funcReq);
                    GJaxbNode functionNode = funcResp.getNode();
                    GJaxbGetNode organizationReq = new GJaxbGetNode();
                    organizationReq.setId(organizationId);
                    organizationReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                    organizationReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                    organizationReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                    GJaxbGetNodeResponse organizationResp = this.coreClient.getNode(organizationReq);
                    GJaxbNode organizationNode = organizationResp.getNode();
                    concept.setModeling((GJaxbNode.Modeling)GenericModelHelper.clone((AbstractJaxbObject)functionNode.getModeling(), functionNode.getModeling().getClass()));
                    if (organizationNode.getGeolocation() != null && ((GJaxbNode.Geolocation.ItemView)organizationNode.getGeolocation().getItemView().get(0)).getPoint() != null) {
                        concept.setGeolocation(new GJaxbNode.Geolocation());
                        concept.getGeolocation().getItemView().add(new GJaxbNode.Geolocation.ItemView());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().setPredefinedShape(new GJaxbNodeMetaGeolocation.PredefinedShape());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setCircle(new GJaxbNodeMetaGeolocation.PredefinedShape.Circle());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).setPredefinedShape(new GJaxbPredefinedShape());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getPredefinedShape().setCircle(new GJaxbPredefinedShape.Circle());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().setLatitude(((GJaxbNode.Geolocation.ItemView)organizationNode.getGeolocation().getItemView().get(0)).getPoint().getLatitude());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().setLongitude(((GJaxbNode.Geolocation.ItemView)organizationNode.getGeolocation().getItemView().get(0)).getPoint().getLongitude());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().setAltitude(((GJaxbNode.Geolocation.ItemView)organizationNode.getGeolocation().getItemView().get(0)).getPoint().getAltitude());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getPredefinedShape().setCircle(new GJaxbPredefinedShape.Circle());
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().getCircle().setRadius(50.0f);
                        ((GJaxbNode.Geolocation.ItemView)concept.getGeolocation().getItemView().get(0)).setRedesign(Boolean.valueOf(false));
                    }
                    GJaxbAddNode addConceptReq = new GJaxbAddNode();
                    addConceptReq.setNode(concept);
                    addConceptReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                    addConceptReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                    addConceptReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                    this.coreClient.addNode(addConceptReq);
                    GJaxbAddNodeEvent event = new GJaxbAddNodeEvent();
                    event.setNode(concept);
                    event.setCollaborationName(collaborationName);
                    event.setKnowledgeSpaceName(knowledgeSpaceName);
                    event.setParentNodeId(functionId);
                    this.notifyOnAllNodeTopic((AbstractJaxbObject)event);
                    message = (String)message + GenericModelHelper.getName((GJaxbNode)concept) + " is added!!!\n";
                    continue;
                }
                message = (String)message + GenericModelHelper.getName((GJaxbNode)concept) + " was already added!!!\n";
            }
            JSONObject jsonResp = new JSONObject();
            jsonResp.put("message", (Object)("concepts added: \n" + (String)message));
            res.setJsonResult(jsonResp.toString());
        }
        catch (Exception e) {
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    private List<Consumer> getNotifConsumersEpr(QName topic, Object payload) throws Exception {
        if (this.notifConsumersEpr.get(topic) == null) {
            this.notifConsumersEpr.put(topic, this.producer.getNotifier().findClientsForTopic(topic, payload, Boolean.valueOf(false)));
        }
        return this.notifConsumersEpr.get(topic);
    }

    public void notifyOnCreateCampaignTopic(final GJaxbCreateCampaignEvent event) {
        ExecutorService runner = Executors.newSingleThreadExecutor();
        runner.execute(new Runnable(){
            final /* synthetic */ CampaignManagerImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Notifier notifier = this.this$0.producer.getNotifier();
                    synchronized (notifier) {
                        LOG.trace("notif send: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)event)));
                        QName topic = new QName("http://www.gind.emac.fr/EventType", "createCampaignTopic");
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, this.this$0.getNotifConsumersEpr(topic, event), null, Boolean.valueOf(false));
                        topic = new QName("http://www.gind.emac.fr/EventType", "allCampaignTopic");
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, this.this$0.getNotifConsumersEpr(topic, event), null, Boolean.valueOf(false));
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), null, (Object)e);
                }
            }
        });
    }

    public void notifyOnUpdateCampaignTopic(final GJaxbUpdateCampaignEvent event) {
        ExecutorService runner = Executors.newSingleThreadExecutor();
        runner.execute(new Runnable(){
            final /* synthetic */ CampaignManagerImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Notifier notifier = this.this$0.producer.getNotifier();
                    synchronized (notifier) {
                        LOG.trace("notif send: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)event)));
                        QName topic = new QName("http://www.gind.emac.fr/EventType", "updateCampaignTopic");
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, this.this$0.getNotifConsumersEpr(topic, event), null, Boolean.valueOf(false));
                        topic = new QName("http://www.gind.emac.fr/EventType", "allCampaignTopic");
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, this.this$0.getNotifConsumersEpr(topic, event), null, Boolean.valueOf(false));
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), null, (Object)e);
                }
            }
        });
    }

    public void notifyOnAddSolutionTopic(final GJaxbAddCampaignSolutionEvent event) {
        ExecutorService runner = Executors.newSingleThreadExecutor();
        runner.execute(new Runnable(){
            final /* synthetic */ CampaignManagerImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Notifier notifier = this.this$0.producer.getNotifier();
                    synchronized (notifier) {
                        LOG.trace("notif send: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)event)));
                        QName topic = new QName("http://www.gind.emac.fr/EventType", "addSolutionTopic");
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, this.this$0.getNotifConsumersEpr(topic, event), null, Boolean.valueOf(false));
                        topic = new QName("http://www.gind.emac.fr/EventType", "allSolutionTopic");
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, this.this$0.getNotifConsumersEpr(topic, event), null, Boolean.valueOf(false));
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), null, (Object)e);
                }
            }
        });
    }

    public void notifyOnAllNodeTopic(final AbstractJaxbObject event) {
        ExecutorService runner = Executors.newSingleThreadExecutor();
        runner.execute(new Runnable(){
            final /* synthetic */ CampaignManagerImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Notifier notifier = this.this$0.producer.getNotifier();
                    synchronized (notifier) {
                        LOG.trace("notif send: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement(event)));
                        QName topic = new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic");
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, this.this$0.getNotifConsumersEpr(topic, event), null, Boolean.valueOf(false));
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), null, (Object)e);
                }
            }
        });
    }

    public GJaxbGetFailureSolutionsResponse getFailureSolutions(GJaxbGetFailureSolutions parameters) throws CampaignFault {
        try {
            GJaxbGetFailureSolutionsResponse _return = new GJaxbGetFailureSolutionsResponse();
            MongoCollection collection = this.db.getCollection(this.solutionsCampaignsCollection);
            for (Document doc : collection.find(Filters.and((Bson[])new Bson[]{new Document("campaignSolution.campaignId", (Object)parameters.getCampaignId()), Filters.or((Bson[])new Bson[]{new Document("campaignSolution.success", (Object)false), new Document("campaignSolution.success", (Object)"false")})}))) {
                String campaignSolutionString = ((Document)doc.get((Object)"campaignSolution", Document.class)).toJson();
                GJaxbCampaignSolution campaignSolution = (GJaxbCampaignSolution)JSONJAXBContext.getInstance().unmarshall("{ \"campaignSolution\" : " + campaignSolutionString + " }", GJaxbCampaignSolution.class);
                _return.getCampaignSolution().add(campaignSolution);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbFindSolutionByNameResponse findSolutionByName(GJaxbFindSolutionByName parameters) throws CampaignFault {
        try {
            GJaxbFindSolutionByNameResponse _return = new GJaxbFindSolutionByNameResponse();
            MongoCollection collection = this.db.getCollection(this.solutionsCampaignsCollection);
            MongoCursor it = collection.find(Filters.and((Bson[])new Bson[]{new Document("campaignSolution.campaignId", (Object)parameters.getCampaignId()), new Document("campaignSolution.name", (Object)parameters.getName())})).iterator();
            if (it.hasNext()) {
                Document doc = (Document)it.next();
                String campaignSolutionString = ((Document)doc.get((Object)"campaignSolution", Document.class)).toJson();
                GJaxbCampaignSolution campaignSolution = (GJaxbCampaignSolution)JSONJAXBContext.getInstance().unmarshall("{ \"campaignSolution\" : " + campaignSolutionString + " }", GJaxbCampaignSolution.class);
                _return.setCampaignSolution(campaignSolution);
            }
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbFindSolutionBySignatureResponse findSolutionBySignature(GJaxbFindSolutionBySignature parameters) throws CampaignFault {
        try {
            GJaxbFindSolutionBySignatureResponse _return = new GJaxbFindSolutionBySignatureResponse();
            MongoCollection collection = this.db.getCollection(this.solutionsCampaignsCollection);
            MongoCursor it = collection.find(Filters.and((Bson[])new Bson[]{new Document("campaignSolution.campaignId", (Object)parameters.getCampaignId()), new Document("campaignSolution.signature", (Object)parameters.getSignature())})).iterator();
            if (it.hasNext()) {
                Document doc = (Document)it.next();
                String campaignSolutionString = ((Document)doc.get((Object)"campaignSolution", Document.class)).toJson();
                GJaxbCampaignSolution campaignSolution = (GJaxbCampaignSolution)JSONJAXBContext.getInstance().unmarshall("{ \"campaignSolution\" : " + campaignSolutionString + " }", GJaxbCampaignSolution.class);
                _return.setCampaignSolution(campaignSolution);
            }
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbFindSolutionByIdResponse findSolutionById(GJaxbFindSolutionById parameters) throws CampaignFault {
        try {
            GJaxbFindSolutionByIdResponse _return = new GJaxbFindSolutionByIdResponse();
            MongoCollection collection = this.db.getCollection(this.solutionsCampaignsCollection);
            MongoCursor it = collection.find(Filters.and((Bson[])new Bson[]{new Document("campaignSolution.campaignId", (Object)parameters.getCampaignId()), new Document("campaignSolution.campaignSolutionId", (Object)parameters.getCampaignSolutionId())})).iterator();
            if (it.hasNext()) {
                Document doc = (Document)it.next();
                String campaignSolutionString = ((Document)doc.get((Object)"campaignSolution", Document.class)).toJson();
                GJaxbCampaignSolution campaignSolution = (GJaxbCampaignSolution)JSONJAXBContext.getInstance().unmarshall("{ \"campaignSolution\" : " + campaignSolutionString + " }", GJaxbCampaignSolution.class);
                _return.setCampaignSolution(campaignSolution);
            }
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbFindCampaignByNameResponse findCampaignByName(GJaxbFindCampaignByName parameters) throws CampaignFault {
        try {
            GJaxbFindCampaignByNameResponse _return = new GJaxbFindCampaignByNameResponse();
            MongoCollection collection = this.db.getCollection(this.campaignCollection);
            MongoCursor it = collection.find(Filters.and((Bson[])new Bson[]{new Document("campaign.name", (Object)parameters.getName())})).iterator();
            if (it.hasNext()) {
                Document doc = (Document)it.next();
                String campaignString = ((Document)doc.get((Object)"campaign", Document.class)).toJson();
                GJaxbCampaign campaign = (GJaxbCampaign)JSONJAXBContext.getInstance().unmarshall("{ \"campaign\" : " + campaignString + " }", GJaxbCampaign.class);
                _return.setCampaign(campaign);
            }
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbCountSolutionsResponse countSolutions(GJaxbCountSolutions parameters) throws CampaignFault {
        try {
            GJaxbCountSolutionsResponse _return = new GJaxbCountSolutionsResponse();
            MongoCollection collection = this.db.getCollection(this.solutionsCampaignsCollection);
            ArrayList<Document> commands = new ArrayList<Document>();
            commands.add(new Document("$match", (Object)new Document("campaignSolution.campaignId", (Object)parameters.getCampaignId())));
            commands.add(new Document("$group", (Object)new Document("_id", null).append("count", (Object)new Document("$sum", (Object)1))));
            AggregateIterable output = collection.aggregate(commands);
            for (Document doc : output) {
                _return.setSolutionsNumber(doc.getInteger((Object)"count").intValue());
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new CampaignFault(e.getMessage(), null, (Throwable)e);
        }
    }
}

