/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.extensions.model;

import fr.emac.gind.event.cep.extensions.model.bo.NodeBO;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindNodeByPropertyFunction
extends FunctionExecutor {
    private Logger LOG = LoggerFactory.getLogger((String)FindNodeByPropertyFunction.class.getName());

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    protected Object execute(Object[] data) {
        NodeBO nodeBO;
        block4: {
            nodeBO = null;
            try {
                if (data != null && data.length > 2) {
                    GJaxbGenericModel model = (GJaxbGenericModel)data[0];
                    String propertyName = (String)data[1];
                    String propertyValue = (String)data[2];
                    Optional<GJaxbNode> nodeFound = model.getNode().parallelStream().filter(n -> this.findNodeByProperty((GJaxbNode)n, propertyName, propertyValue)).findAny();
                    if (nodeFound.isPresent()) {
                        nodeBO = new NodeBO(nodeFound.get());
                    }
                    break block4;
                }
                throw new SiddhiAppValidationException("findNodeByProperty function cannot be null");
            }
            catch (Exception e) {
                this.LOG.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
                throw new SiddhiAppValidationException((Throwable)e);
            }
        }
        return nodeBO;
    }

    private boolean findNodeByProperty(GJaxbNode node, String property, Object value) {
        GJaxbProperty prop = GenericModelHelper.findProperty((String)property, (List)node.getProperty());
        return prop != null && prop.getValue().equals(value);
    }

    protected Object execute(Object data) {
        return null;
    }

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 3) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to model:findNodeByProperty() function, required 3, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.OBJECT) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the argument of model:findNodeByProperty() function, required " + String.valueOf(Attribute.Type.OBJECT) + ", but found " + attributeType.toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return this.execute(data);
    }

    protected Object execute(Object data, State state) {
        return this.execute(data);
    }
}

