/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.manager;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.cep.manager.CepRulesManagerCommand;
import fr.emac.gind.event.cep.manager.CepRulesManagerNotifier;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.event.producer.ResourcesManager;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicNamespaceType;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class CepRulesManagerWebService
extends SPIWebServicePrimitives {
    private String storageAddress = null;
    private Map<QName, Class<?>> jaxbMapper = new HashMap();
    private NotificationManagerImpl subscriber = null;
    private CepRulesManagerCommand command = null;
    private CepRulesManagerNotifier notifier = null;

    public void onInit(Map<String, Object> context) {
        try {
            if (context.get("storage") == null) {
                throw new UncheckedException("Configuration Error: storage cannot be null!!!");
            }
            this.storageAddress = (String)context.get("storage");
            this.subscriber = new NotificationManagerImpl(CepRulesManagerWebService.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.host, (int)this.port, (int)this.proxyPort, (String)"cepRulesSubscriber"), this.storageAddress, "CEPRulesSubscriber_" + this.getHost(), this.jaxbMapper, new GJaxbTopicSetType(), new GJaxbTopicNamespaceType(), new ResourcesManager[0]);
            this.command = new CepRulesManagerCommand(CepRulesManagerWebService.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.host, (int)this.port, (int)this.proxyPort, (String)"cepRulesManager"), this.subscriber, context);
            this.notifier = new CepRulesManagerNotifier(CepRulesManagerWebService.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.host, (int)this.port, (int)this.proxyPort, (String)"cepRulesNotifier"), this.command);
            this.command.setNotifier(this.notifier);
            this.registerWSImplementation("cepRulesManager", this.command);
            this.registerWSImplementation("cepRulesSubscriber", this.subscriber);
            this.registerWSImplementation("cepRulesNotifier", (Object)this.notifier);
        }
        catch (Exception e) {
            throw new UncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    public void stop() throws Exception {
        this.command.reset();
        super.stop();
    }

    public NotificationManagerImpl getSubscriber() {
        return this.subscriber;
    }

    public CepRulesManagerCommand getCommand() {
        return this.command;
    }

    public CepRulesManagerNotifier getNotifier() {
        return this.notifier;
    }

    public static CepRulesManagerWebService createAndStart(final int port, final String eventStorageAddr, final String govAddr) throws Exception {
        CepRulesManagerWebService cepRulesServer = new CepRulesManagerWebService();
        cepRulesServer.start(new HashMap<String, Object>(){
            {
                this.put("host", "localhost");
                this.put("port", port);
                this.put("storage", eventStorageAddr);
                this.put("governance", govAddr);
            }
        });
        return cepRulesServer;
    }
}

