/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.extensions.model;

import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindNodesByTypesFunction
extends FunctionExecutor {
    private Logger LOG = LoggerFactory.getLogger((String)FindNodesByTypesFunction.class.getName());

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    protected Object execute(Object[] data) {
        GJaxbGenericModel newModel = new GJaxbGenericModel();
        try {
            ArrayList<QName> types;
            GJaxbGenericModel model;
            if (data != null && data.length >= 2) {
                model = (GJaxbGenericModel)data[0];
                types = new ArrayList<QName>();
                for (int i = 1; i < data.length; ++i) {
                    types.add(QName.valueOf(data[i].toString()));
                }
            } else {
                throw new SiddhiAppValidationException("findNodesByTypes function cannot be null");
            }
            GenericModelManager mm = new GenericModelManager(new GJaxbGenericModel[]{model});
            types.forEach(type -> {
                List nodes = mm.getNodesByType(type);
                newModel.getNode().addAll(nodes);
            });
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw new SiddhiAppValidationException((Throwable)e);
        }
        return newModel;
    }

    protected Object execute(Object data) {
        return null;
    }

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to model:findNodesByRoles() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.OBJECT) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the argument of model:findNodesByRoles() function, required " + String.valueOf(Attribute.Type.OBJECT) + ", but found " + attributeType.toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return this.execute(data);
    }

    protected Object execute(Object data, State state) {
        return this.execute(data);
    }
}

