/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.extensions.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ListIntersectionFunction
extends FunctionExecutor {
    private ObjectMapper mapper = new ObjectMapper();

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to util:containsList(list, element) function, required 2, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.OBJECT && attributeType != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the argument of util:containsList(list, element) function, required " + String.valueOf(Attribute.Type.OBJECT) + ", but found " + attributeType.toString());
        }
        return null;
    }

    protected Object execute(Object[] data) {
        ArrayList<JsonNode> list1 = new ArrayList<JsonNode>();
        ArrayList<JsonNode> list2 = new ArrayList<JsonNode>();
        try {
            int i;
            ArrayNode left = (ArrayNode)this.mapper.readTree((String)data[0]);
            ArrayNode right = (ArrayNode)this.mapper.readTree((String)data[0]);
            for (i = 0; i < left.size(); ++i) {
                list1.add(left.get(i));
            }
            for (i = 0; i < right.size(); ++i) {
                list2.add(right.get(i));
            }
            List intersect = list1.stream().filter(list2::contains).collect(Collectors.toList());
            return intersect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object execute(Object data) {
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return this.execute(data);
    }

    protected Object execute(Object data, State state) {
        return this.execute(data);
    }
}

