/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.extensions.date;

import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.xml.datatype.XMLGregorianCalendar;

public class GetLocalDateTimeFunction
extends FunctionExecutor {
    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data != null) {
            try {
                XMLGregorianCalendar calD = XMLGregorianCalendarHelper.getInstance().getNewCalendar(data.toString());
                Instant instant = calD.toGregorianCalendar().getTime().toInstant();
                LocalDateTime localDateTime = instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
                return localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to date:getLocalDateTime(string) function, required 2, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the argument of date:getLocalDateTime(string) function, required " + String.valueOf(Attribute.Type.STRING) + ", but found " + attributeType.toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return this.execute(data);
    }

    protected Object execute(Object data, State state) {
        return this.execute(data);
    }
}

