/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.extensions.model;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.event.cep.extensions.model.bo.BO;
import fr.emac.gind.event.cep.extensions.model.bo.EdgeBO;
import fr.emac.gind.event.cep.extensions.model.bo.NodeBO;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.lang.reflect.InvocationTargetException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatModelInJSONArrayFunction
extends FunctionExecutor {
    private Logger LOG = LoggerFactory.getLogger((String)FormatModelInJSONArrayFunction.class.getName());

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    protected Object execute(Object[] data) {
        JSONArray array;
        block14: {
            array = new JSONArray();
            try {
                if (data != null && data.length > 2) {
                    GJaxbGenericModel model = (GJaxbGenericModel)data[0];
                    String type = (String)data[1];
                    String template = (String)data[2];
                    if ("node".equals(type)) {
                        for (GJaxbNode node : model.getNode()) {
                            this.formatConceptToJSON(array, template, new NodeBO(node));
                        }
                    } else if ("edge".equals(type)) {
                        for (GJaxbEdge edge : model.getEdge()) {
                            this.formatConceptToJSON(array, template, new EdgeBO(edge));
                        }
                    } else if ("any".equals(type)) {
                        for (GJaxbNode node : model.getNode()) {
                            this.formatConceptToJSON(array, template, new NodeBO(node));
                        }
                        for (GJaxbEdge edge : model.getEdge()) {
                            this.formatConceptToJSON(array, template, new EdgeBO(edge));
                        }
                    } else if ("array".equals(type)) {
                        this.formatConceptToJsonArray(array, template, new NodeBO((GJaxbNode)model.getNode().get(0)));
                    }
                    break block14;
                }
                throw new SiddhiAppValidationException("Format function cannot be null");
            }
            catch (Exception e) {
                this.LOG.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
                throw new SiddhiAppValidationException((Throwable)e);
            }
        }
        return array.toString();
    }

    private void formatConceptToJsonArray(JSONArray array, String template, NodeBO nodeBO) throws InvocationTargetException {
        String methodName = template.substring(0, template.indexOf("("));
        String[] durtyParams = template.substring(template.indexOf("(") + 1, template.lastIndexOf(")")).split(",");
        Object[] params = null;
        if (durtyParams.length > 0 && !durtyParams[0].trim().isEmpty()) {
            params = new Object[durtyParams.length];
            int i = 0;
            for (String param : durtyParams) {
                params[i] = param.replace("'", "").replace("\"", "").trim();
                ++i;
            }
        }
        Object res = ReflectionHelper.invokePrivateMethod((Object)nodeBO, (String)methodName, params);
        array.put(res);
    }

    private void formatConceptToJSON(JSONArray array, String template, BO item) throws Exception {
        JSONObject jsonResult = null;
        if (template == null || template.trim().isEmpty()) {
            jsonResult = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)item.getJaxbObject()));
        } else {
            jsonResult = new JSONObject(template);
            for (String key : jsonResult.keySet()) {
                String method = jsonResult.getString(key);
                String methodName = method.substring(0, method.indexOf("("));
                String[] durtyParams = method.substring(method.indexOf("(") + 1, method.lastIndexOf(")")).split(",");
                Object[] params = null;
                if (durtyParams.length > 0 && !durtyParams[0].trim().isEmpty()) {
                    params = new Object[durtyParams.length];
                    int i = 0;
                    for (String param : durtyParams) {
                        params[i] = param.replace("'", "").replace("\"", "").trim();
                        ++i;
                    }
                }
                jsonResult.put(key, ReflectionHelper.invokePrivateMethod((Object)item, (String)methodName, params));
            }
        }
        array.put((Object)jsonResult);
    }

    private String[] getParams(String paramsString) {
        return paramsString.replace("[", "").replace("]", "").split(",");
    }

    protected Object execute(Object data) {
        return null;
    }

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 3) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to model:formatInJSONArray() function, required 3, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.OBJECT) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the argument of model:formatInJSONArray() function, required " + String.valueOf(Attribute.Type.STRING) + ", but found " + attributeType.toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return this.execute(data);
    }

    protected Object execute(Object data, State state) {
        return this.execute(data);
    }
}

