/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.extensions.util;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOrCreateStaticIdWithKeyFunction
extends FunctionExecutor {
    private Logger LOG = LoggerFactory.getLogger((String)GetOrCreateStaticIdWithKeyFunction.class.getName());
    private static Map<String, String> keys = Collections.synchronizedMap(new HashMap());

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected synchronized Object execute(Object data) {
        Object id = null;
        try {
            String key = data.toString();
            if (keys.get(key) != null) {
                id = keys.get(key);
            } else {
                id = key + "_" + UUID.randomUUID().toString();
                keys.put(key, (String)id);
            }
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw new SiddhiAppValidationException((Throwable)e);
        }
        return id;
    }

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to util:getOrCreateStaticIdWithKey() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the argument of util:getOrCreateStaticIdWithKey() function, required " + String.valueOf(Attribute.Type.STRING) + ", but found " + attributeType.toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return this.execute(data);
    }

    protected Object execute(Object data, State state) {
        return this.execute(data);
    }
}

