/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.manager;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbEventAction;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.schema10.XSD2XMLImpl;
import fr.emac.gind.schema10.XSDSchemaManager;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import gind.org.w3._2001.xmlschema.GJaxbElement;
import gind.org.w3._2001.xmlschema.GJaxbSchema;
import io.siddhi.core.event.Event;
import io.siddhi.core.query.output.callback.QueryCallback;
import io.siddhi.core.util.EventPrinter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventListener
extends QueryCallback {
    private static final Logger LOG = LoggerFactory.getLogger((String)EventListener.class.getName());
    private GJaxbInterpretationConfig rule = null;
    private List<GJaxbEventAction> actions = null;
    private String producerAddress;
    private Map<QName, XSDSchemaManager> mapSchemaManagers = new HashMap<QName, XSDSchemaManager>();
    private List<String> outputParamsName = new ArrayList<String>();
    private NotificationManagerImpl subscriber = null;
    private SOAPSender sender = new SOAPSender(new SOAPInterceptor[0]);

    public EventListener(String producerAddress, GJaxbInterpretationConfig rule, NotificationManagerImpl subscriber) throws Exception {
        this.rule = rule;
        this.actions = this.rule.getEventAction();
        this.producerAddress = producerAddress;
        this.subscriber = subscriber;
        this.subscriber.getNotifier().setName("cep");
        for (GJaxbEventAction action : this.actions) {
            GJaxbSchema schema = null;
            if (action.getSchemaDefinition().getContent() != null) {
                schema = (GJaxbSchema)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(action.getSchemaDefinition().getContent().getBytes())), GJaxbSchema.class);
            } else if (action.getSchemaDefinition().getUrl().startsWith("classpath://")) {
                URL jar = Thread.currentThread().getContextClassLoader().getResource(action.getSchemaDefinition().getUrl().replace("classpath://", ""));
                schema = (GJaxbSchema)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().parse(jar.openStream()), GJaxbSchema.class);
                schema.setBaseURI(jar.toURI());
            } else {
                schema = (GJaxbSchema)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().parse(new URL(action.getSchemaDefinition().getUrl()).openStream()), GJaxbSchema.class);
            }
            XSDSchemaManager manager = new XSDSchemaManager(new GJaxbSchema[]{schema});
            this.mapSchemaManagers.put(action.getEventElementName(), manager);
            if (action.getTopic() == null) continue;
            Document doc = DOMUtil.getInstance().newDocument();
            Element elmt = doc.createElementNS(action.getTopic().getNamespaceURI(), action.getTopic().getLocalPart());
            this.subscriber.getTopicset().getAny().add(elmt);
        }
        this.outputParamsName = this.getOuputParamsName(this.rule);
    }

    private List<String> getOuputParamsName(GJaxbInterpretationConfig rule) {
        ArrayList<String> params = new ArrayList<String>();
        String def = rule.getCepRule().getRule();
        int insert_index = def.indexOf("insert into");
        int having_index = def.indexOf("having");
        int group_index = def.indexOf("group by");
        int index = insert_index;
        if (having_index > -1 && group_index > -1) {
            int n = index = having_index < group_index ? having_index : group_index;
        }
        if (having_index > -1) {
            index = having_index;
        } else if (group_index > -1) {
            index = group_index;
        }
        String outputSelect = def.substring(def.indexOf("select") + "select".length(), index);
        StringBuilder builder = new StringBuilder(outputSelect);
        int inQuotes = 0;
        for (int currentIndex = 0; currentIndex < builder.length(); ++currentIndex) {
            char currentChar = builder.charAt(currentIndex);
            if (currentChar == '(') {
                ++inQuotes;
            }
            if (currentChar == ')') {
                --inQuotes;
            }
            if (currentChar != ',' || inQuotes != 0) continue;
            builder.setCharAt(currentIndex, ';');
        }
        String[] outputs = builder.toString().split(";");
        for (String output : Arrays.asList(outputs)) {
            if ((output = output.replaceAll("\\n", " ").replaceAll("\\t", " ")).indexOf(" as ") <= 0) continue;
            params.add(output.split(" as ")[1].trim());
        }
        ArrayList<String> cleanParams = new ArrayList<String>();
        params.forEach(p -> cleanParams.add(p.split(" ")[0].trim()));
        return cleanParams;
    }

    public void receive(long timeStamp, Event[] inEvents, Event[] removeEvents) {
        System.out.println("****** CEP targeted !!!\n");
        EventPrinter.print((long)timeStamp, (Event[])inEvents, (Event[])removeEvents);
        if (inEvents != null && inEvents.length > 0) {
            LOG.debug("Rule triggered: " + this.rule.getName());
            System.out.println("*********** Rule triggered: " + this.rule.getName());
            Event outputEvent = inEvents[inEvents.length - 1];
            for (GJaxbEventAction action : this.actions) {
                XSDSchemaManager manager = this.mapSchemaManagers.get(action.getEventElementName());
                GJaxbElement elmt = manager.getElement(action.getEventElementName());
                try {
                    Element elmtXml = XSD2XMLImpl.getInstance().generateElement(elmt, null, this.createData(this.outputParamsName, outputEvent), manager);
                    Map<QName, String> context = this.getEventContext(outputEvent);
                    if (context.get(new QName("http://www.gind.emac.fr", "collaborationName")) == null) {
                        context.put(new QName("http://www.gind.emac.fr", "collaborationName"), this.rule.getContext().getCollaborationName());
                    }
                    if (context.get(new QName("http://www.gind.emac.fr", "knowledgeSpaceName")) == null) {
                        context.put(new QName("http://www.gind.emac.fr", "knowledgeSpaceName"), this.rule.getContext().getKnowledgeSpaceName());
                    }
                    if (this.rule.getContext().getDataSourcesConcerned() != null) {
                        context.put(new QName("http://www.gind.emac.fr", "dataSourcesConcerned"), JSONJAXBContext.getInstance().marshallAnyElement((Object)this.rule.getContext().getDataSourcesConcerned()));
                    }
                    Document doc = DOMUtil.getInstance().createDocumentFromElement(elmtXml);
                    QName topicUsed = action.getTopic();
                    for (String publisher : action.getPublishDestination()) {
                        GJaxbNotify notify = WSNHelper.getInstance().createNotification(publisher, this.producerAddress, topicUsed, (Object)doc, context);
                        LOG.debug("notification created for " + publisher + " producer : " + this.producerAddress + " on topic " + String.valueOf(topicUsed));
                        Document requestResultEvent = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)notify);
                        LOG.debug("newEvent: " + XMLPrettyPrinter.print((Node)requestResultEvent));
                        LOG.debug("************ SEND COMPLEX EVENT FROM CEP: \n" + XMLPrettyPrinter.print((Node)requestResultEvent));
                        System.out.println("************ SEND COMPLEX EVENT FROM CEP: \n" + XMLPrettyPrinter.print((Node)requestResultEvent));
                        this.sender.sendSoapRequest(requestResultEvent, publisher, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Map<String, Object> createData(List<String> outputParamsName, Event outputEvent) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        int indice = 0;
        for (Object d : outputEvent.getData()) {
            if (d == null) {
                throw new Exception("Missing " + indice + " element " + outputParamsName.get(indice) + " in the rule.");
            }
            if (d.equals("${timeStamp}")) {
                data.put(outputParamsName.get(indice), outputEvent.getTimestamp());
            } else if (d.equals("${collaborationName}")) {
                data.put(outputParamsName.get(indice), this.rule.getContext().getCollaborationName());
            } else if (d.equals("${knowledgeSpaceName}")) {
                data.put(outputParamsName.get(indice), this.rule.getContext().getKnowledgeSpaceName());
            } else if (d instanceof HashMap) {
                data.put(outputParamsName.get(indice), d);
            } else if (d.toString().indexOf("{") >= 0 && d.toString().indexOf("}", d.toString().indexOf(123) + 1) >= 0) {
                data.put(outputParamsName.get(indice), QName.valueOf(d.toString()));
            } else {
                data.put(outputParamsName.get(indice), d);
            }
            ++indice;
        }
        return data;
    }

    private Map<QName, String> getEventContext(Event outputEvent) throws Exception {
        Map<QName, String> context = new HashMap<QName, String>();
        if (outputEvent.getData()[outputEvent.getData().length - 1] instanceof Map) {
            context = (Map)outputEvent.getData()[outputEvent.getData().length - 1];
        }
        return context;
    }
}

