/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.monitoring.detection;

import fr.emac.gind.commons.utils.json.JSONHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.detection.d3.GJaxbConcept;
import fr.emac.gind.detection.d3.GJaxbConceptsMatrix;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.monitoring.detection.AbstractDetection;
import fr.emac.gind.monitoring.detection.ResultConcept;
import fr.emac.gind.monitoring.detectionReport.GJaxbAnalyticDetectionReportType;
import fr.emac.gind.monitoring.detectionReport.GJaxbDetectionReport;
import fr.emac.gind.monitoring.detectionReport.GJaxbDetectionReports;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class D3StrategyDetection
extends AbstractDetection<Map<String, Object>> {
    private static Logger LOG = LoggerFactory.getLogger((String)D3StrategyDetection.class.getName());
    private GJaxbConceptsMatrix d3Matrix;
    private List<QName> exclusions = List.of(QName.valueOf("{http://fr.emac.gind/system}Collaboration"), QName.valueOf("{http://fr.emac.gind/system}User"));

    public String getName() {
        return "D3Strategy detection";
    }

    public String getDescription() {
        return "Calcul a simple deviation of models based on D3 Strategy";
    }

    public String getInputJavascriptFunctionToCall() {
        return null;
    }

    public String getOutputJavascriptFunctionToCall() {
        String function = "this.createD3StrategyDetectionOutputFormDialog(options)";
        return function;
    }

    public void setData(List<GJaxbProperty> data) throws Exception {
        for (GJaxbProperty prop : data) {
            if (!prop.getName().equals("conceptsMatrix")) continue;
            if (JSONHelper.isJSONValid((String)prop.getValue())) {
                this.d3Matrix = (GJaxbConceptsMatrix)((Object)JSONJAXBContext.getInstance().unmarshall(prop.getValue(), GJaxbConceptsMatrix.class));
                break;
            }
            Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(prop.getValue().getBytes()));
            this.d3Matrix = (GJaxbConceptsMatrix)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbConceptsMatrix.class);
            break;
        }
        if (this.d3Matrix == null) {
            throw new Exception("Matrix cannot be null!!!");
        }
    }

    public ResultConcept<Map<String, Object>> compareNodes(GJaxbNode expected, GJaxbNode field) throws Exception {
        ResultConcept res = new ResultConcept();
        res.setResult(new HashMap());
        if (expected == null && field != null) {
            res.setIdField(field.getId());
            res.setIdExpected(null);
            if (!this.exclusions.contains(field.getType())) {
                GJaxbConcept concept = this.findConceptInMatrix(field.getType());
                if (concept == null) {
                    throw new Exception("Imposible to find this concept in matrix: " + String.valueOf(field.getType()));
                }
                ((Map)res.getResult()).compute("addition", (k, v) -> Float.valueOf(v == null ? concept.getAdditionCost() : ((Float)v).floatValue() + concept.getAdditionCost()));
                return res;
            }
        }
        if (expected != null && field == null) {
            res.setIdField(null);
            res.setIdExpected(expected.getId());
            if (!this.exclusions.contains(expected.getType())) {
                GJaxbConcept concept = this.findConceptInMatrix(expected.getType());
                if (concept == null) {
                    throw new Exception("Imposible to find this concept in matrix: " + String.valueOf(expected.getType()));
                }
                ((Map)res.getResult()).compute("deletion", (k, v) -> Float.valueOf(v == null ? concept.getAdditionCost() : ((Float)v).floatValue() + concept.getAdditionCost()));
                return res;
            }
        }
        if (expected != null && field != null) {
            res.setIdField(field.getId());
            res.setIdExpected(expected.getId());
            if (!this.exclusions.contains(expected.getType())) {
                GJaxbConcept concept = this.findConceptInMatrix(expected.getType());
                if (concept == null) {
                    throw new Exception("Imposible to find this concept in matrix: " + String.valueOf(expected.getType()));
                }
                ((Map)res.getResult()).compute("modification", (k, v) -> Float.valueOf(v == null ? concept.getModificationCost() : ((Float)v).floatValue() + concept.getModificationCost()));
                return res;
            }
        }
        return null;
    }

    public ResultConcept<Map<String, Object>> compareEdges(GJaxbEdge expected, GJaxbEdge field) {
        return null;
    }

    private GJaxbConcept findConceptInMatrix(QName conceptName) {
        for (GJaxbConcept concept : this.d3Matrix.getConcept()) {
            if (!concept.getName().equals(conceptName)) continue;
            return concept;
        }
        return null;
    }

    protected ResultConcept<Map<String, Object>> createCommonReport(GJaxbNode node) {
        ResultConcept res = new ResultConcept();
        res.setIdExpected(node.getId());
        res.setIdField(node.getId());
        HashMap map = new HashMap();
        res.setResult(map);
        return res;
    }

    public GJaxbDetectionReports analyseResults(Map<String, Map<String, List<ResultConcept<Map<String, Object>>>>> res) {
        GJaxbDetectionReports reports = new GJaxbDetectionReports();
        for (Map.Entry<String, Map<String, List<ResultConcept<Map<String, Object>>>>> perCat : res.entrySet()) {
            GJaxbDetectionReport report = new GJaxbDetectionReport();
            report.setName("Detection report on " + perCat.getKey());
            GJaxbAnalyticDetectionReportType value = new GJaxbAnalyticDetectionReportType();
            report.setAnalyticDetectionReport(value);
            double dres = 0.0;
            double modification = res.get(perCat.getKey()).get("differentNodes").stream().mapToDouble(e -> e != null ? Double.valueOf(((Object)((Map)e.getResult()).getOrDefault("modification", Float.valueOf(0.0f))).toString()) : 0.0).sum();
            double deletion = res.get(perCat.getKey()).get("expectedNodes").stream().mapToDouble(e -> e != null ? Double.valueOf(((Object)((Map)e.getResult()).getOrDefault("deletion", Float.valueOf(0.0f))).toString()) : 0.0).sum();
            double addition = res.get(perCat.getKey()).get("fieldNodes").stream().mapToDouble(e -> e != null ? Double.valueOf(((Object)((Map)e.getResult()).getOrDefault("addition", Float.valueOf(0.0f))).toString()) : 0.0).sum();
            int diffNodesSize = res.get(perCat.getKey()).get("differentNodes").size();
            int expNodesSize = res.get(perCat.getKey()).get("expectedNodes").size();
            int fieldNodesSize = res.get(perCat.getKey()).get("fieldNodes").size();
            int cpt = diffNodesSize + expNodesSize + fieldNodesSize;
            LOG.debug("mod:" + modification + "  add:" + addition + "  del" + deletion);
            dres = modification + deletion + addition;
            String flavor = "NEUTAL";
            if (addition > deletion) {
                flavor = "MORE_FIELD";
            } else if (deletion > addition) {
                flavor = "MORE_EXPECTED";
            }
            value.setDivergenceFlavor(flavor);
            value.setDivergenceIndice(dres);
            value.setDetectionReportMessage("Divergence Indice correspond to D3 result (the greater the indice, the more important the deviation)\n\nResults: \n " + cpt + " deviation(s) on nodes(addition (" + fieldNodesSize + ") / deletion (" + expNodesSize + ") / modification (" + diffNodesSize + ") ) Attributes deviations " + this.separatedNodes.retrieveAttributesDeviationReport());
            reports.getDetectionReport().add(report);
        }
        return reports;
    }

    protected boolean equalsNodes(GJaxbNode nodeE, GJaxbNode nodeF) {
        return nodeE.getId().equals(nodeF.getId());
    }
}

