/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.producer.simulator;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.event_broker.EventBroker;
import fr.emac.gind.event.event_broker.FaultMessage;
import fr.emac.gind.event.event_broker.data.GJaxbGetAllTopics;
import fr.emac.gind.event.event_broker.data.GJaxbGetAllTopicsResponse;
import fr.emac.gind.event.event_broker.data.GJaxbRegister;
import fr.emac.gind.event.event_broker.data.GJaxbRegisterResponse;
import fr.emac.gind.event.event_broker.data.GJaxbUnregister;
import fr.emac.gind.event.event_broker.data.GJaxbUnregisterResponse;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EventBrokerClient
implements EventBroker {
    private SOAPSender sender = null;
    private String serverAddress = null;

    private EventBrokerClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static EventBroker createClient(String remoteAddress) throws Exception {
        EventBroker client = (EventBroker)LocalRegistry.getInstance().findWSImplementation(EventBroker.class);
        if (client == null) {
            client = new EventBrokerClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public GJaxbUnregisterResponse unregister(GJaxbUnregister parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/event/event_broker/unregister\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbUnregisterResponse response = (GJaxbUnregisterResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbUnregisterResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbRegisterResponse register(GJaxbRegister parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/event/event_broker/register\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbRegisterResponse response = (GJaxbRegisterResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbRegisterResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbGetAllTopicsResponse getAllTopics(GJaxbGetAllTopics parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/event/event_broker/getAllTopics\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbGetAllTopicsResponse response = (GJaxbGetAllTopicsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbGetAllTopicsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }
}

