/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.broker;

import fr.emac.gind.event.broker.EventProducerEndpoint;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.event.producer.ResourcesManager;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import fr.emac.gind.wsn.service.wsnproducer.InvalidFilterFault;
import fr.emac.gind.wsn.service.wsnproducer.InvalidMessageContentExpressionFault;
import fr.emac.gind.wsn.service.wsnproducer.InvalidProducerPropertiesExpressionFault;
import fr.emac.gind.wsn.service.wsnproducer.InvalidTopicExpressionFault;
import fr.emac.gind.wsn.service.wsnproducer.NotifyMessageNotSupportedFault;
import fr.emac.gind.wsn.service.wsnproducer.ResourceUnknownFault;
import fr.emac.gind.wsn.service.wsnproducer.SubscribeCreationFailedFault;
import fr.emac.gind.wsn.service.wsnproducer.TopicExpressionDialectUnknownFault;
import fr.emac.gind.wsn.service.wsnproducer.TopicNotSupportedFault;
import fr.emac.gind.wsn.service.wsnproducer.UnableToDestroySubscriptionFault;
import fr.emac.gind.wsn.service.wsnproducer.UnacceptableInitialTerminationTimeFault;
import fr.emac.gind.wsn.service.wsnproducer.UnrecognizedPolicyRequestFault;
import fr.emac.gind.wsn.service.wsnproducer.UnsupportedPolicyRequestFault;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribeResponse;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribeResponse;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicNamespaceType;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import gind.org.w3._2005._08.addressing.GJaxbEndpointReferenceType;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

@WebService(portName="producerServiceSOAP", serviceName="producerService", targetNamespace="http://www.gind.emac.fr/wsn/service/WsnProducer", wsdlLocation="wsdl/producer.wsdl", endpointInterface="fr.emac.gind.wsn.service.wsnproducer.NotificationProducer")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class SubscriberBrokerManagerImpl
extends NotificationManagerImpl {
    private Map<QName, List<String>> subscribtionMapByTopics = Collections.synchronizedMap(new HashMap());
    private Map<QName, List<EventProducerEndpoint>> eventProviderMapByTopics = Collections.synchronizedMap(new HashMap());
    private SOAPSender soapSender = new SOAPSender(new SOAPInterceptor[0]);

    public SubscriberBrokerManagerImpl(String address, String storageAddress, String collection) throws Exception {
        super(address, storageAddress, collection, new HashMap(), new GJaxbTopicSetType(), new GJaxbTopicNamespaceType(), (ResourcesManager[])null);
    }

    public GJaxbSubscribeResponse subscribe(GJaxbSubscribe subscribeRequest) throws UnacceptableInitialTerminationTimeFault, TopicNotSupportedFault, UnrecognizedPolicyRequestFault, UnsupportedPolicyRequestFault, ResourceUnknownFault, SubscribeCreationFailedFault, NotifyMessageNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, InvalidProducerPropertiesExpressionFault, TopicExpressionDialectUnknownFault, InvalidMessageContentExpressionFault {
        GJaxbSubscribeResponse response = super.subscribe(subscribeRequest);
        try {
            QName topic = WSNHelper.getInstance().getTopicExpression(subscribeRequest.getFilter());
            if (this.subscribtionMapByTopics.get(topic) == null) {
                this.subscribtionMapByTopics.put(topic, new ArrayList());
                this.eventProviderMapByTopics.put(topic, new ArrayList());
            }
            this.subscribtionMapByTopics.get(topic).add(response.getSubscriptionReference().getAddress().getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SubscribeCreationFailedFault(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbUnsubscribeResponse unsubscribe(GJaxbUnsubscribe unsubscribeRequest) throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
        GJaxbUnsubscribeResponse response = super.unsubscribe(unsubscribeRequest);
        try {
            QName topicToUnsubscribe = null;
            GJaxbEndpointReferenceType subscriptionId = WSNHelper.getInstance().getSubscriptionId(unsubscribeRequest);
            for (Map.Entry<QName, List<String>> registeredSubscriptionIdList : this.subscribtionMapByTopics.entrySet()) {
                if (!registeredSubscriptionIdList.getValue().contains(subscriptionId)) continue;
                registeredSubscriptionIdList.getValue().remove(subscriptionId);
                if (!registeredSubscriptionIdList.getValue().isEmpty()) continue;
                topicToUnsubscribe = registeredSubscriptionIdList.getKey();
                break;
            }
            if (topicToUnsubscribe != null) {
                this.subscribtionMapByTopics.remove(topicToUnsubscribe);
                ArrayList<EventProducerEndpoint> epeToRemove = new ArrayList<EventProducerEndpoint>();
                for (EventProducerEndpoint epe : this.eventProviderMapByTopics.get(topicToUnsubscribe)) {
                    GJaxbUnsubscribe request = WSNHelper.getInstance().createUnSubscription(epe.getSubscriptionId());
                    Document doc = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)request);
                    try {
                        this.soapSender.sendSoapRequest(doc, epe.getAddress(), "http://www.gind.emac.fr/wsn/service/WsnProducer/Unsubscribe");
                        epeToRemove.add(epe);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (EventProducerEndpoint epeRem : epeToRemove) {
                    this.eventProviderMapByTopics.get(topicToUnsubscribe).remove(epeRem);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceUnknownFault(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public Map<QName, List<String>> getSubscribtionMapByTopics() {
        return this.subscribtionMapByTopics;
    }

    public Map<QName, List<EventProducerEndpoint>> getEventProviderMapByTopics() {
        return this.eventProviderMapByTopics;
    }
}

