/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.broker;

import fr.emac.gind.event.broker.EventProducerEndpoint;
import fr.emac.gind.event.broker.NotifierBrokerManagerImpl;
import fr.emac.gind.event.broker.SubscriberBrokerManagerImpl;
import fr.emac.gind.event.event_broker.EventBroker;
import fr.emac.gind.event.event_broker.FaultMessage;
import fr.emac.gind.event.event_broker.data.GJaxbGetAllTopics;
import fr.emac.gind.event.event_broker.data.GJaxbGetAllTopicsResponse;
import fr.emac.gind.event.event_broker.data.GJaxbRegister;
import fr.emac.gind.event.event_broker.data.GJaxbRegisterResponse;
import fr.emac.gind.event.event_broker.data.GJaxbTopic;
import fr.emac.gind.event.event_broker.data.GJaxbUnregister;
import fr.emac.gind.event.event_broker.data.GJaxbUnregisterResponse;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="event-broker-serviceSOAP", serviceName="event-broker-service", targetNamespace="http://www.gind.emac.fr/event/event_broker/", wsdlLocation="wsdl/event-broker.wsdl", endpointInterface="fr.emac.gind.event.event_broker.EventBroker")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class EventBrokerRegisterImpl
implements EventBroker {
    private static final Logger LOG = LoggerFactory.getLogger((String)EventBrokerRegisterImpl.class.getName());
    private SubscriberBrokerManagerImpl subscriberBroker = null;
    private NotifierBrokerManagerImpl notifierBroker = null;
    private List<GJaxbTopic> supportedTopics = new ArrayList<GJaxbTopic>();

    public EventBrokerRegisterImpl(SubscriberBrokerManagerImpl subscriberBroker, NotifierBrokerManagerImpl notifierBroker) {
        this.subscriberBroker = subscriberBroker;
        this.notifierBroker = notifierBroker;
    }

    public GJaxbRegisterResponse register(GJaxbRegister parameters) throws FaultMessage {
        LOG.info("Executing operation register");
        try {
            for (GJaxbTopic topic : parameters.getTopic()) {
                if (this.subscriberBroker.getSubscribtionMapByTopics().get(topic.getName()) == null) {
                    this.subscriberBroker.getSubscribtionMapByTopics().put(topic.getName(), new ArrayList());
                }
                if (this.subscriberBroker.getEventProviderMapByTopics().get(topic.getName()) == null) {
                    this.subscriberBroker.getEventProviderMapByTopics().put(topic.getName(), new ArrayList());
                }
                if (this.subscriberBroker.getSubscribtionMapByTopics().get(topic.getName()).stream().filter(subscription -> subscription.startsWith(parameters.getAddress())).count() == 0L) {
                    String subscriptionId = this.notifierBroker.subscribeOn(parameters.getAddress(), topic.getName());
                    this.subscriberBroker.getSubscribtionMapByTopics().get(topic.getName()).add(subscriptionId);
                    EventProducerEndpoint epe = new EventProducerEndpoint(parameters.getAddress(), subscriptionId);
                    this.subscriberBroker.getEventProviderMapByTopics().get(topic.getName()).add(epe);
                }
                if (this.supportedTopics.stream().filter(t -> t.getName().equals(topic.getName())).count() != 0L) continue;
                this.supportedTopics.add(topic);
            }
            GJaxbRegisterResponse _return = new GJaxbRegisterResponse();
            return _return;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public GJaxbUnregisterResponse unregister(GJaxbUnregister parameters) throws FaultMessage {
        LOG.info("Executing operation unregister");
        try {
            String producerAddress = parameters.getAddress();
            for (Map.Entry<QName, List<EventProducerEndpoint>> epes : this.subscriberBroker.getEventProviderMapByTopics().entrySet()) {
                ArrayList<EventProducerEndpoint> epesToRemove = new ArrayList<EventProducerEndpoint>();
                for (EventProducerEndpoint epe : epes.getValue()) {
                    if (!epe.getAddress().equals(producerAddress)) continue;
                    epesToRemove.add(epe);
                    this.notifierBroker.unsubscribeOn(producerAddress, epe.getSubscriptionId());
                    for (List<String> susbcriptionIds : this.subscriberBroker.getSubscribtionMapByTopics().values()) {
                        ArrayList<String> susbcriptionIdsToRemove = new ArrayList<String>();
                        for (String susbscriptionId : susbcriptionIds) {
                            if (!epe.getSubscriptionId().equals(susbscriptionId)) continue;
                            susbcriptionIdsToRemove.add(susbscriptionId);
                        }
                        for (String susbscriptionId : susbcriptionIdsToRemove) {
                            susbcriptionIds.remove(susbscriptionId);
                        }
                    }
                }
                for (EventProducerEndpoint epe : epesToRemove) {
                    epes.getValue().remove(epe);
                }
                if (epes.getValue().size() != 0) continue;
                this.supportedTopics.removeIf(t -> t.getName().equals(epes.getKey()));
            }
            GJaxbUnregisterResponse _return = new GJaxbUnregisterResponse();
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public GJaxbGetAllTopicsResponse getAllTopics(GJaxbGetAllTopics parameters) throws FaultMessage {
        GJaxbGetAllTopicsResponse resp = new GJaxbGetAllTopicsResponse();
        resp.getTopic().addAll(this.supportedTopics);
        return resp;
    }
}

