/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.broker;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.broker.SubscriberBrokerManagerImpl;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.storage.GJaxbPut;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(portName="NotifierClientEndpoint", serviceName="NotifierClientService", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class NotifierBrokerManagerImpl
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger(NotifierBrokerManagerImpl.class);
    private SubscriberBrokerManagerImpl subscribeBroker = null;
    private Storage storageClient = null;
    private Boolean saveEventsInDatabase = false;
    private static int cpt = 0;

    public NotifierBrokerManagerImpl(String address, SubscriberBrokerManagerImpl subscribeBroker, String storageAddress, Map<String, Object> context) throws Exception {
        super(address);
        this.subscribeBroker = subscribeBroker;
        this.subscribeBroker.getNotifier().setName("broker");
        this.storageClient = StorageClient.createClient((String)storageAddress);
        if (context.get("save_events_in_database") != null) {
            this.saveEventsInDatabase = Boolean.parseBoolean(context.get("save_events_in_database").toString());
        }
    }

    public void notify(final GJaxbNotify notify) {
        try {
            Document payload = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            QName topic = WSNHelper.getInstance().getTopicInNotification(notify);
            LOG.debug("event receive on broker: \n" + XMLPrettyPrinter.print((Node)payload));
            HashMap context = new HashMap();
            for (Object obj : notify.getAny()) {
                Element elmt = (Element)obj;
                if (!elmt.getLocalName().equals("context") || !elmt.getNamespaceURI().equals("http://www.gind.emac.fr")) continue;
                List childs = DOMUtil.getInstance().getElements(elmt);
                childs.forEach(e -> {
                    QName qname = new QName(e.getNamespaceURI(), e.getLocalName());
                    String value = e.getTextContent();
                    context.put(qname, value);
                });
            }
            this.subscribeBroker.getNotifier().sendNotificationOnTopic((Object)payload, topic, context, Boolean.valueOf(true));
            if (this.saveEventsInDatabase.booleanValue()) {
                ExecutorService service = Executors.newCachedThreadPool();
                service.execute(new Runnable(){
                    final /* synthetic */ NotifierBrokerManagerImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            this.this$0.saveInDatabase(notify);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void saveInDatabase(GJaxbNotify notify) throws Exception {
        GJaxbPut request = new GJaxbPut();
        request.setCollection("primitive_events");
        String json = JSONJAXBContext.getInstance().marshallAnyElement((Object)notify);
        String document = "<jgind:json xmlns:jgind=\"http://www.gind.emac.fr/json\"><![CDATA[" + json + "]]></jgind:json>";
        Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes("UTF-8")));
        request.setAny((Object)doc.getDocumentElement());
        this.storageClient.put(request);
    }
}

