/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.helper;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.wsn.b_2_extension.GJaxbAndmessageContaining;
import fr.emac.gind.wsn.b_2_extension.GJaxbOrmessageContaining;
import fr.emac.gind.wsn.b_2_extension.ObjectFactory;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbFilterType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotificationMessageHolderType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbQueryExpressionType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbTopicExpressionType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribe;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import gind.org.w3._2005._08.addressing.GJaxbAttributedURIType;
import gind.org.w3._2005._08.addressing.GJaxbEndpointReferenceType;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSNHelper {
    public static String XPATH10_DIALECT = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    private gind.org.oasis_open.docs.wsn.b_2.ObjectFactory factory = new gind.org.oasis_open.docs.wsn.b_2.ObjectFactory();
    private ObjectFactory extensionFactory = new ObjectFactory();
    private static WSNHelper INSTANCE = null;

    private WSNHelper() {
    }

    public static WSNHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WSNHelper();
        }
        return INSTANCE;
    }

    public QName getTopicExpression(GJaxbFilterType filter) throws Exception {
        for (Object obj : filter.getAny()) {
            JAXBElement jelmt;
            if (!(obj instanceof JAXBElement) || !((jelmt = (JAXBElement)obj).getValue() instanceof GJaxbTopicExpressionType)) continue;
            GJaxbTopicExpressionType topic = (GJaxbTopicExpressionType)jelmt.getValue();
            return this.getTopic(topic);
        }
        return null;
    }

    private QName getTopic(GJaxbTopicExpressionType topic) throws Exception {
        for (Object topicObj : topic.getContent()) {
            if (topicObj instanceof JAXBElement) {
                JAXBElement jtopelmt = (JAXBElement)topicObj;
                if (!(jtopelmt.getValue() instanceof QName)) continue;
                return (QName)jtopelmt.getValue();
            }
            if (topicObj instanceof String) {
                return QName.valueOf((String)topicObj);
            }
            if (!(topicObj instanceof Element)) continue;
            Element stelmt = (Element)topicObj;
            String val = stelmt.getTextContent();
            if (val.indexOf("{") > 0 && val.indexOf("}") > 0) {
                return QName.valueOf(val);
            }
            if (val.indexOf(":") > 0) {
                String prefix = val.substring(0, val.indexOf(":"));
                String localname = val.replace(prefix + ":", "");
                String ns = stelmt.lookupNamespaceURI(prefix);
                if (ns == null) {
                    throw new Exception("Impossible to find namespace from this prefix: " + prefix);
                }
                return new QName(ns, localname, prefix);
            }
            return new QName(val);
        }
        return null;
    }

    public GJaxbAndmessageContaining getAndMessageContaining(GJaxbFilterType filter) throws Exception {
        for (Object obj : filter.getAny()) {
            JAXBElement jelmt;
            if (!(obj instanceof JAXBElement) || !((jelmt = (JAXBElement)obj).getValue() instanceof GJaxbQueryExpressionType)) continue;
            GJaxbQueryExpressionType query = (GJaxbQueryExpressionType)jelmt.getValue();
            if (!query.getContent().isEmpty()) {
                for (Object q : query.getContent()) {
                    if (q instanceof JAXBElement) {
                        JAXBElement jq = (JAXBElement)q;
                        if (!(jq.getValue() instanceof GJaxbAndmessageContaining)) continue;
                        return (GJaxbAndmessageContaining)jq.getValue();
                    }
                    if (q instanceof Element) {
                        Element elmt = (Element)q;
                        if (!elmt.getLocalName().equals("andmessageContaining") || !elmt.getNamespaceURI().equals("http://www.gind.emac.fr/wsn/b-2-extension")) continue;
                        return (GJaxbAndmessageContaining)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().createDocumentFromElement(elmt), GJaxbAndmessageContaining.class);
                    }
                    if (!(q instanceof GJaxbAndmessageContaining)) continue;
                    return (GJaxbAndmessageContaining)q;
                }
            }
            return null;
        }
        return null;
    }

    public GJaxbOrmessageContaining getOrMessageContaining(GJaxbFilterType filter) throws Exception {
        for (Object obj : filter.getAny()) {
            JAXBElement jelmt;
            if (!(obj instanceof JAXBElement) || !((jelmt = (JAXBElement)obj).getValue() instanceof GJaxbQueryExpressionType)) continue;
            GJaxbQueryExpressionType query = (GJaxbQueryExpressionType)jelmt.getValue();
            if (!query.getContent().isEmpty()) {
                for (Object q : query.getContent()) {
                    if (q instanceof JAXBElement) {
                        JAXBElement jq = (JAXBElement)q;
                        if (!(jq.getValue() instanceof GJaxbOrmessageContaining)) continue;
                        return (GJaxbOrmessageContaining)jq.getValue();
                    }
                    if (q instanceof Element) {
                        Element elmt = (Element)q;
                        if (!elmt.getLocalName().equals("ormessageContaining") || !elmt.getNamespaceURI().equals("http://www.gind.emac.fr/wsn/b-2-extension")) continue;
                        return (GJaxbOrmessageContaining)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().createDocumentFromElement(elmt), GJaxbOrmessageContaining.class);
                    }
                    if (!(q instanceof GJaxbOrmessageContaining)) continue;
                    return (GJaxbOrmessageContaining)q;
                }
            }
            return null;
        }
        return null;
    }

    public GJaxbSubscribe createSubscription(String consumerAddress, QName topicUsed, QName ... messages) throws Exception {
        GJaxbSubscribe payload = new GJaxbSubscribe();
        GJaxbEndpointReferenceType epr = new GJaxbEndpointReferenceType();
        GJaxbAttributedURIType address = new GJaxbAttributedURIType();
        address.setValue(consumerAddress);
        epr.setAddress(address);
        payload.setConsumerReference(epr);
        GJaxbFilterType filter = new GJaxbFilterType();
        filter.getAny().add(this.createSimpleTopicExpression(topicUsed, XPATH10_DIALECT));
        if (messages != null && messages.length > 0) {
            for (QName msg : messages) {
                GJaxbQueryExpressionType msgQuery = new GJaxbQueryExpressionType();
                msgQuery.getContent().add(this.extensionFactory.createGJaxbMessage(msg));
                JAXBElement messageContent = this.factory.createMessageContent(msgQuery);
                filter.getAny().add(messageContent);
            }
        }
        payload.setFilter(filter);
        return payload;
    }

    public GJaxbSubscribe createSubscription(String consumerAddress, QName topicUsed, GJaxbAndmessageContaining andMsg, GJaxbOrmessageContaining orMsg) throws Exception {
        GJaxbSubscribe payload = new GJaxbSubscribe();
        GJaxbEndpointReferenceType epr = new GJaxbEndpointReferenceType();
        GJaxbAttributedURIType address = new GJaxbAttributedURIType();
        address.setValue(consumerAddress);
        epr.setAddress(address);
        payload.setConsumerReference(epr);
        GJaxbFilterType filter = new GJaxbFilterType();
        filter.getAny().add(this.createSimpleTopicExpression(topicUsed, XPATH10_DIALECT));
        GJaxbQueryExpressionType msgQuery = new GJaxbQueryExpressionType();
        if (andMsg != null && !andMsg.getMessage().isEmpty()) {
            msgQuery.getContent().add(andMsg);
        }
        if (orMsg != null && !orMsg.getMessage().isEmpty()) {
            msgQuery.getContent().add(orMsg);
        }
        JAXBElement messageContent = this.factory.createMessageContent(msgQuery);
        filter.getAny().add(messageContent);
        payload.setFilter(filter);
        return payload;
    }

    public GJaxbUnsubscribe createUnSubscription(String subscriptionId) throws Exception {
        GJaxbUnsubscribe payload = new GJaxbUnsubscribe();
        GJaxbEndpointReferenceType subscriptionIdRef = new GJaxbEndpointReferenceType();
        subscriptionIdRef.setAddress(new GJaxbAttributedURIType());
        subscriptionIdRef.getAddress().setValue(subscriptionId);
        payload.getAny().add(this.factory.createSubscriptionReference(subscriptionIdRef));
        return payload;
    }

    public GJaxbEndpointReferenceType getSubscriptionId(GJaxbUnsubscribe unsubscribeRequest) throws Exception {
        for (Object obj : unsubscribeRequest.getAny()) {
            if (!(obj instanceof JAXBElement)) continue;
            JAXBElement epr = (JAXBElement)obj;
            return (GJaxbEndpointReferenceType)epr.getValue();
        }
        return null;
    }

    public Document getFirstMessageInNotification(GJaxbNotify notify) throws Exception {
        if (!notify.getNotificationMessage().isEmpty()) {
            GJaxbNotificationMessageHolderType.Message msg = ((GJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage();
            if (msg.getAny() instanceof Element) {
                return DOMUtil.getInstance().createDocumentFromElement((Element)msg.getAny());
            }
            if (msg.getAny() instanceof AbstractJaxbObject) {
                return XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)msg.getAny());
            }
        }
        return null;
    }

    public QName getTopicInNotification(GJaxbNotify notify) throws Exception {
        if (!notify.getNotificationMessage().isEmpty()) {
            return this.getTopic(((GJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getTopic());
        }
        return null;
    }

    public GJaxbNotify createNotification(String consumerAddress, String producerAddress, QName topicUsed, Object payload, Map<QName, String> context) throws Exception {
        GJaxbAttributedURIType address;
        GJaxbNotify notifyPayload = new GJaxbNotify();
        GJaxbNotificationMessageHolderType.Message mess = new GJaxbNotificationMessageHolderType.Message();
        if (payload != null) {
            if (payload instanceof Document) {
                mess.setAny((Object)((Document)payload).getDocumentElement());
            } else if (payload instanceof AbstractJaxbObject) {
                mess.setAny(payload);
            } else {
                throw new Exception(String.valueOf(payload.getClass()) + " not take in charge (either Document or ? extends AbstractJaxbObject)");
            }
        }
        GJaxbNotificationMessageHolderType msg = new GJaxbNotificationMessageHolderType();
        msg.setMessage(mess);
        notifyPayload.getNotificationMessage().add(msg);
        if (topicUsed != null) {
            JAXBElement<GJaxbTopicExpressionType> notifyTopicExpr = this.createSimpleTopicExpression(topicUsed, "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
            msg.setTopic((GJaxbTopicExpressionType)notifyTopicExpr.getValue());
        }
        if (consumerAddress != null) {
            GJaxbEndpointReferenceType registrationRef = new GJaxbEndpointReferenceType();
            address = new GJaxbAttributedURIType();
            address.setValue(consumerAddress);
            registrationRef.setAddress(address);
            msg.setSubscriptionReference(registrationRef);
        }
        GJaxbEndpointReferenceType producerRef = new GJaxbEndpointReferenceType();
        address = new GJaxbAttributedURIType();
        address.setValue(producerAddress);
        producerRef.setAddress(address);
        msg.setProducerReference(producerRef);
        Document eventIdDoc = DOMUtil.getInstance().newDocument();
        Element eventId = eventIdDoc.createElementNS("http://www.gind.emac.fr", "eventId");
        eventId.setTextContent(UUID.randomUUID().toString());
        eventIdDoc.appendChild(eventId);
        notifyPayload.getAny().add(eventIdDoc.getDocumentElement());
        Document createAtDoc = DOMUtil.getInstance().newDocument();
        Element createdAt = createAtDoc.createElementNS("http://www.gind.emac.fr", "createAt");
        createdAt.setTextContent(XMLGregorianCalendarHelper.getInstance().getNewCalendar().toXMLFormat());
        createAtDoc.appendChild(createdAt);
        notifyPayload.getAny().add(createAtDoc.getDocumentElement());
        if (context != null) {
            Document contextDoc = DOMUtil.getInstance().newDocument();
            Element contextElmt = contextDoc.createElementNS("http://www.gind.emac.fr", "context");
            contextDoc.appendChild(contextElmt);
            context.forEach((k, v) -> {
                Element elmt = contextDoc.createElementNS(k.getNamespaceURI(), k.getLocalPart());
                elmt.setTextContent((String)v);
                contextElmt.appendChild(elmt);
            });
            notifyPayload.getAny().add(contextDoc.getDocumentElement());
        }
        return notifyPayload;
    }

    public Map<QName, Element> getAdditionalInformationInNotification(GJaxbNotify notify) {
        HashMap<QName, Element> map = new HashMap<QName, Element>();
        for (Object obj : notify.getAny()) {
            if (!(obj instanceof Element)) continue;
            Element elmt = (Element)obj;
            map.put(new QName(elmt.getNamespaceURI(), elmt.getLocalName()), elmt);
        }
        return map;
    }

    private JAXBElement<GJaxbTopicExpressionType> createSimpleTopicExpression(QName topicUsed, String dialect) throws Exception {
        GJaxbTopicExpressionType topDialect = new GJaxbTopicExpressionType();
        topDialect.setDialect(dialect);
        JAXBElement notifyTopicExpr = this.factory.createTopicExpression(topDialect);
        if (topicUsed.getPrefix() == null) {
            throw new Exception("prefix of topicUsed cannot be null");
        }
        ((GJaxbTopicExpressionType)notifyTopicExpr.getValue()).getContent().add(topicUsed.toString());
        return notifyTopicExpr;
    }

    public List<QName> getTopic(GJaxbTopicSetType topicSet) {
        ArrayList<QName> res = new ArrayList<QName>();
        for (Object obj : topicSet.getAny()) {
            if (!(obj instanceof Element)) continue;
            Element elmt = (Element)obj;
            QName topic = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
            res.add(topic);
        }
        return res;
    }
}

