/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.consumer;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.notifier.NotifierClient;
import fr.emac.gind.notifier.SubscribeOnFault;
import fr.emac.gind.notifier.UnSubscribeOnFault;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import fr.emac.gind.wsn.b_2_extension.GJaxbAndmessageContaining;
import fr.emac.gind.wsn.b_2_extension.GJaxbOrmessageContaining;
import gind.notifier.data.GJaxbSubscribeOn;
import gind.notifier.data.GJaxbSubscribeOnResponse;
import gind.notifier.data.GJaxbUnSubscribeOn;
import gind.notifier.data.GJaxbUnSubscribeOnResponse;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribeResponse;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribeResponse;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public abstract class AbstractNotifierClient
implements NotifierClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractNotifierClient.class.getName());
    protected String address = null;
    private SOAPSender soapSender = new SOAPSender(new SOAPInterceptor[0]);

    public AbstractNotifierClient(String address) throws Exception {
        this.address = address;
        LocalRegistry.getInstance().addNotifier(address, (Object)this);
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public String subscribeOn(String producer, QName topic) throws Exception {
        return this.subscribeOn(producer, topic, null, null);
    }

    public String subscribeOn(NotificationManagerImpl producer, QName topic) throws Exception {
        return this.subscribeOn(producer, topic, null, null);
    }

    public String subscribeOn(String producer, QName topic, GJaxbAndmessageContaining andmessageContaining, GJaxbOrmessageContaining ormessageContaining) throws Exception {
        GJaxbSubscribeOn request = new GJaxbSubscribeOn();
        request.setProducer(producer);
        request.setTopic(topic);
        if (andmessageContaining != null) {
            request.setAndmessageContaining(andmessageContaining);
        }
        if (ormessageContaining != null) {
            request.setOrmessageContaining(ormessageContaining);
        }
        GJaxbSubscribeOnResponse res = this.subscribeOn(request);
        return res.getSubscriptionId();
    }

    public String subscribeOn(NotificationManagerImpl producer, QName topic, GJaxbAndmessageContaining andmessageContaining, GJaxbOrmessageContaining ormessageContaining) throws Exception {
        GJaxbSubscribeOn request = new GJaxbSubscribeOn();
        request.setProducer(producer.getAddress());
        request.setTopic(topic);
        if (andmessageContaining != null) {
            request.setAndmessageContaining(andmessageContaining);
        }
        if (ormessageContaining != null) {
            request.setOrmessageContaining(ormessageContaining);
        }
        GJaxbSubscribe subscribe = WSNHelper.getInstance().createSubscription(this.address, request.getTopic(), this.convertAnd(request.getAndmessageContaining()), this.convertOr(request.getOrmessageContaining()));
        GJaxbSubscribeResponse subscribeResponse = producer.subscribe(subscribe, this);
        GJaxbSubscribeOnResponse res = new GJaxbSubscribeOnResponse();
        if (subscribeResponse.getSubscriptionReference() != null && subscribeResponse.getSubscriptionReference().getAddress() != null) {
            res.setSubscriptionId(subscribeResponse.getSubscriptionReference().getAddress().getValue());
        }
        return res.getSubscriptionId();
    }

    @WebResult(name="SubscribeOnResponse", targetNamespace="http://www.gind.emac.fr/notifier/data", partName="parameters")
    @WebMethod(operationName="SubscribeOn", action="http://www.gind.emac.fr/notifier/SubscribeOn")
    public GJaxbSubscribeOnResponse subscribeOn(@WebParam(partName="parameters", name="SubscribeOn", targetNamespace="http://www.gind.emac.fr/notifier/data") GJaxbSubscribeOn parameters) throws SubscribeOnFault {
        GJaxbSubscribeOnResponse res = new GJaxbSubscribeOnResponse();
        try {
            if (this.address == null) {
                throw new SubscribeOnFault("InitializationError: client address cannot be null!!!", null);
            }
            GJaxbSubscribe subscribe = WSNHelper.getInstance().createSubscription(this.address, parameters.getTopic(), this.convertAnd(parameters.getAndmessageContaining()), this.convertOr(parameters.getOrmessageContaining()));
            LOG.debug("Executing operation subscribeOn: " + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)subscribe)));
            LOG.debug("address " + parameters.getProducer());
            Document soapResponse = this.soapSender.sendSoapRequest(XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)subscribe), parameters.getProducer(), "\"http://www.gind.emac.fr/wsn/service/WsnProducer/Subscribe\"");
            LOG.debug("SOAP RESPONSE : \n" + XMLPrettyPrinter.print((Node)soapResponse));
            if (SOAPHandler.isSoapFault((Document)soapResponse)) {
                LOG.debug("WS ERROR: \n" + XMLPrettyPrinter.print((Node)soapResponse));
                throw new Exception("WS ERROR: \n" + XMLPrettyPrinter.print((Node)soapResponse));
            }
            GJaxbSubscribeResponse subscribeResponse = (GJaxbSubscribeResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)soapResponse), GJaxbSubscribeResponse.class);
            if (subscribeResponse.getSubscriptionReference() != null && subscribeResponse.getSubscriptionReference().getAddress() != null) {
                res.setSubscriptionId(subscribeResponse.getSubscriptionReference().getAddress().getValue());
            }
        }
        catch (Exception e) {
            throw new SubscribeOnFault(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    private GJaxbAndmessageContaining convertAnd(GJaxbAndmessageContaining andmessageContaining) {
        if (andmessageContaining == null) {
            return null;
        }
        GJaxbAndmessageContaining res = new GJaxbAndmessageContaining();
        res.getMessage().addAll(andmessageContaining.getMessage());
        return res;
    }

    private GJaxbOrmessageContaining convertOr(GJaxbOrmessageContaining ormessageContaining) {
        if (ormessageContaining == null) {
            return null;
        }
        GJaxbOrmessageContaining res = new GJaxbOrmessageContaining();
        res.getMessage().addAll(ormessageContaining.getMessage());
        return res;
    }

    public String unsubscribeOn(String producer, String subscriptionId) throws SubscribeOnFault {
        GJaxbUnSubscribeOn parameters = new GJaxbUnSubscribeOn();
        parameters.setProducer(producer);
        parameters.setSubscriptionId(subscriptionId);
        try {
            GJaxbUnSubscribeOnResponse gJaxbUnSubscribeOnResponse = this.unSubscribeOn(parameters);
        }
        catch (UnSubscribeOnFault e) {
            e.printStackTrace();
            throw new SubscribeOnFault(e.getMessage(), null, (Throwable)e);
        }
        return subscriptionId;
    }

    @WebResult(name="UnSubscribeOnResponse", targetNamespace="http://www.gind.emac.fr/notifier/data", partName="parameters")
    @WebMethod(operationName="UnSubscribeOn", action="http://www.gind.emac.fr/notifier/UnSubscribeOn")
    public GJaxbUnSubscribeOnResponse unSubscribeOn(@WebParam(partName="parameters", name="UnSubscribeOn", targetNamespace="http://www.gind.emac.fr/notifier/data") GJaxbUnSubscribeOn parameters) throws UnSubscribeOnFault {
        LOG.info("Executing operation UnSubscribeOn");
        GJaxbUnSubscribeOnResponse res = new GJaxbUnSubscribeOnResponse();
        try {
            GJaxbUnsubscribe unsubscribe = WSNHelper.getInstance().createUnSubscription(parameters.getSubscriptionId());
            Document soapResponse = this.soapSender.sendSoapRequest(XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)unsubscribe), parameters.getProducer(), "\"http://www.gind.emac.fr/wsn/service/WsnProducer/Unsubscribe\"");
            if (SOAPHandler.isSoapFault((Document)soapResponse)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)soapResponse));
            }
            Document payload = SOAPHandler.extractPayload((Document)soapResponse);
            LOG.debug("soapResponse: \n" + XMLPrettyPrinter.print((Node)soapResponse));
            if (payload == null) {
                throw new Exception("payload is null !!!");
            }
            GJaxbUnsubscribeResponse gJaxbUnsubscribeResponse = (GJaxbUnsubscribeResponse)XMLJAXBContext.getInstance().unmarshallDocument(payload, GJaxbUnsubscribeResponse.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnSubscribeOnFault("Technical Fault", null, (Throwable)e);
        }
        return res;
    }
}

