/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.producer;

import fr.emac.gind.commons.utils.map.MapHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.Consumer;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.Notifier;
import fr.emac.gind.event.producer.ResourcesManager;
import fr.emac.gind.logger.GindLogger;
import fr.emac.gind.storage.GJaxbPut;
import fr.emac.gind.storage.GJaxbPutResponse;
import fr.emac.gind.storage.GJaxbQuery;
import fr.emac.gind.storage.GJaxbQueryResponse;
import fr.emac.gind.storage.GJaxbRemove;
import fr.emac.gind.storage.ObjectFactory;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import fr.emac.gind.wsn.b_2_extension.GJaxbAndmessageContaining;
import fr.emac.gind.wsn.b_2_extension.GJaxbOrmessageContaining;
import fr.emac.gind.wsn.service.wsnproducer.InvalidFilterFault;
import fr.emac.gind.wsn.service.wsnproducer.InvalidMessageContentExpressionFault;
import fr.emac.gind.wsn.service.wsnproducer.InvalidProducerPropertiesExpressionFault;
import fr.emac.gind.wsn.service.wsnproducer.InvalidResourcePropertyQNameFault;
import fr.emac.gind.wsn.service.wsnproducer.InvalidTopicExpressionFault;
import fr.emac.gind.wsn.service.wsnproducer.MultipleTopicsSpecifiedFault;
import fr.emac.gind.wsn.service.wsnproducer.NoCurrentMessageOnTopicFault;
import fr.emac.gind.wsn.service.wsnproducer.NotificationProducer;
import fr.emac.gind.wsn.service.wsnproducer.NotifyMessageNotSupportedFault;
import fr.emac.gind.wsn.service.wsnproducer.ResourceUnavailableFault;
import fr.emac.gind.wsn.service.wsnproducer.ResourceUnknownFault;
import fr.emac.gind.wsn.service.wsnproducer.SubscribeCreationFailedFault;
import fr.emac.gind.wsn.service.wsnproducer.TopicExpressionDialectUnknownFault;
import fr.emac.gind.wsn.service.wsnproducer.TopicNotSupportedFault;
import fr.emac.gind.wsn.service.wsnproducer.UnableToDestroySubscriptionFault;
import fr.emac.gind.wsn.service.wsnproducer.UnacceptableInitialTerminationTimeFault;
import fr.emac.gind.wsn.service.wsnproducer.UnrecognizedPolicyRequestFault;
import fr.emac.gind.wsn.service.wsnproducer.UnsupportedPolicyRequestFault;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbGetCurrentMessage;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbGetCurrentMessageResponse;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribeResponse;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribeResponse;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicNamespaceType;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import gind.org.oasis_open.docs.wsrf.rp_2.GJaxbGetResourcePropertyResponse;
import gind.org.w3._2005._08.addressing.GJaxbAttributedURIType;
import gind.org.w3._2005._08.addressing.GJaxbEndpointReferenceType;
import jakarta.jws.WebService;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.ws.BindingType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.w3c.dom.Element;

@WebService(portName="producerServiceSOAP", serviceName="producerService", targetNamespace="http://www.gind.emac.fr/wsn/service/WsnProducer", wsdlLocation="wsdl/producer.wsdl", endpointInterface="fr.emac.gind.wsn.service.wsnproducer.NotificationProducer")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class NotificationManagerImpl
implements NotificationProducer {
    private static final Logger LOG = LoggerFactory.getLogger((String)NotificationManagerImpl.class.getName());
    private String storageAddress = null;
    private Storage storage = null;
    protected String address = null;
    private Notifier notifier = null;
    private GJaxbTopicNamespaceType topicNamespace = null;
    private GJaxbTopicSetType topicset = null;
    private gind.org.oasis_open.docs.wsn.b_2.ObjectFactory factory = new gind.org.oasis_open.docs.wsn.b_2.ObjectFactory();
    ObjectFactory storageFactory = new ObjectFactory();
    private String collection = null;
    private List<ResourcesManager> resourcesManagers = new ArrayList<ResourcesManager>();
    protected Map<QName, List<Consumer>> notificationConsumerEprs = Collections.synchronizedMap(new HashMap());

    public NotificationManagerImpl(String address, String storageAddress, String collection, Map<QName, Class<?>> jaxbMapper, GJaxbTopicSetType topicset, GJaxbTopicNamespaceType topicNamespace, ResourcesManager ... resourcesManager) throws Exception {
        this.storageAddress = storageAddress;
        this.collection = collection;
        this.address = address;
        this.notifier = new Notifier(this);
        this.topicset = topicset;
        this.topicNamespace = topicNamespace;
        if (resourcesManager != null) {
            this.resourcesManagers = Arrays.asList(resourcesManager);
        }
    }

    public String getCollection() {
        return this.collection;
    }

    public Storage getStorage() throws Exception {
        if (this.storage == null) {
            this.storage = StorageClient.createClient((String)this.storageAddress);
        }
        return this.storage;
    }

    public void setTopicNamespace(GJaxbTopicNamespaceType topicNamespace) {
        this.topicNamespace = topicNamespace;
    }

    public void setTopicset(GJaxbTopicSetType topicset) {
        this.topicset = topicset;
    }

    public Map<QName, List<Consumer>> getNotificationConsumerEprs() {
        return this.notificationConsumerEprs;
    }

    public String getAddress() {
        return this.address;
    }

    public synchronized Notifier getNotifier() {
        return this.notifier;
    }

    public GJaxbTopicSetType getTopicset() {
        return this.topicset;
    }

    public GJaxbSubscribeResponse subscribe(GJaxbSubscribe subscribeRequest, AbstractNotifierClient notifierClient) throws Exception {
        GJaxbSubscribeResponse subscribeResponse = this.subscribe(subscribeRequest);
        String clientAddress = subscribeRequest.getConsumerReference().getAddress().getValue();
        QName topic = WSNHelper.getInstance().getTopicExpression(subscribeRequest.getFilter());
        List<Consumer> existingConsumers = this.notificationConsumerEprs.get(topic);
        for (Consumer existingConsumer : existingConsumers) {
            if (!existingConsumer.getRemoteClient().getAddress().getValue().startsWith(clientAddress)) continue;
            existingConsumer.setLocalClient(notifierClient);
        }
        return subscribeResponse;
    }

    @Override
    public GJaxbSubscribeResponse subscribe(GJaxbSubscribe subscribeRequest) throws UnacceptableInitialTerminationTimeFault, TopicNotSupportedFault, UnrecognizedPolicyRequestFault, UnsupportedPolicyRequestFault, ResourceUnknownFault, SubscribeCreationFailedFault, NotifyMessageNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, InvalidProducerPropertiesExpressionFault, TopicExpressionDialectUnknownFault, InvalidMessageContentExpressionFault {
        LOG.debug("Executing operation subscribe");
        try {
            GJaxbSubscribeResponse _return = new GJaxbSubscribeResponse();
            QName topic = WSNHelper.getInstance().getTopicExpression(subscribeRequest.getFilter());
            if (topic == null) {
                throw new TopicNotSupportedFault("Impossible to find topic in subscription", null);
            }
            if (this.notificationConsumerEprs.get(topic) == null) {
                this.notificationConsumerEprs.put(topic, new ArrayList());
            }
            String clientAddress = null;
            if (subscribeRequest.getConsumerReference() != null && subscribeRequest.getConsumerReference().getAddress() != null) {
                clientAddress = subscribeRequest.getConsumerReference().getAddress().getValue();
            }
            if (clientAddress == null) {
                throw new SubscribeCreationFailedFault("Impossible to find consumer address in subscription", null);
            }
            GJaxbAndmessageContaining andmessageContaining = WSNHelper.getInstance().getAndMessageContaining(subscribeRequest.getFilter());
            GJaxbOrmessageContaining ormessageContaining = WSNHelper.getInstance().getOrMessageContaining(subscribeRequest.getFilter());
            Object jsonAndMsg = null;
            Object jsonOrMsg = null;
            if (andmessageContaining != null && !andmessageContaining.getMessage().isEmpty()) {
                jsonAndMsg = "\"andmessageContaining\" : [ \n";
                for (String msg : andmessageContaining.getMessage()) {
                    jsonAndMsg = (String)jsonAndMsg + "{\"message\" : \"" + msg.replace("\"", "'") + "\"},\n";
                }
                jsonAndMsg = ((String)jsonAndMsg).substring(0, ((String)jsonAndMsg).length() - ",\n".length()) + "\n";
                jsonAndMsg = (String)jsonAndMsg + "]\n";
            }
            if (ormessageContaining != null && !ormessageContaining.getMessage().isEmpty()) {
                jsonOrMsg = "\"ormessageContaining\" : [ \n";
                for (String msg : ormessageContaining.getMessage()) {
                    jsonOrMsg = (String)jsonOrMsg + "{\"message\" : \"" + msg.replace("\"", "'") + "\"},\n";
                }
                jsonOrMsg = ((String)jsonOrMsg).substring(0, ((String)jsonOrMsg).length() - ",\n".length()) + "\n";
                jsonOrMsg = (String)jsonOrMsg + "]\n";
            }
            GJaxbEndpointReferenceType epr = new GJaxbEndpointReferenceType();
            epr.setAddress(new GJaxbAttributedURIType());
            List<String> ids = this.findSubscription(epr, clientAddress, topic, (String)jsonAndMsg, (String)jsonOrMsg);
            if (ids == null || ids.isEmpty()) {
                GJaxbPut request = new GJaxbPut();
                request.setCollection(this.collection);
                String json = "{\n    \"subscribe\" : {\r\n      \"consumer\" : \"" + clientAddress + "\",\n      \"topicQName\" : \"" + String.valueOf(topic) + "\"" + (String)(jsonAndMsg != null ? ",\n" + (String)jsonAndMsg : "") + (String)(jsonOrMsg != null ? ",\n" + (String)jsonOrMsg : "") + "\n   }\n}";
                String document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\">" + json + "</gind:json>";
                request.setAny((Object)DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes())).getDocumentElement());
                GJaxbPutResponse response = this.getStorage().put(request);
                if (response.getId() != null) {
                    epr.setUserData("subscribe", (Object)json);
                    epr.getAddress().setValue(clientAddress + "?ids=[" + response.getId() + "]");
                    this.notificationConsumerEprs.get(topic).add(new Consumer(epr));
                    GindLogger.log((Logger)LOG, (Level)Level.DEBUG, (String)("add new subscription: " + response.getId()), (Map)MapHelper.mapOf((Object[])new Object[]{"consumer", clientAddress, "producer", this.address, "topic", topic.toString(), "mongo_collection", this.collection, "jsonAndMsg", jsonAndMsg, "jsonOrMsg", jsonOrMsg, "subscriptionId", response.getId()}));
                } else {
                    GindLogger.log((Logger)LOG, (Level)Level.DEBUG, (String)"mongo_driver_bug: mongo put crashed !!!", (Map)MapHelper.mapOf((Object[])new Object[]{"consumer", clientAddress, "producer", this.address, "topic", topic.toString(), "mongo_collection", this.collection, "jsonAndMsg", jsonAndMsg, "jsonOrMsg", jsonOrMsg, "subscriptionId", response.getId()}));
                }
            } else {
                LOG.warn("subscriptions with topic '" + String.valueOf(topic) + "' and consumer address '" + clientAddress + "' already exist.");
                GindLogger.log((Logger)LOG, (Level)Level.WARN, (String)("subscription already exists: " + ids.get(0)), (Map)MapHelper.mapOf((Object[])new Object[]{"consumer", clientAddress, "producer", this.address, "topic", topic.toString(), "mongo_collection", this.collection, "jsonAndMsg", jsonAndMsg, "jsonOrMsg", jsonOrMsg, "subscriptionId", ids.get(0)}));
                epr.getAddress().setValue(clientAddress + "?ids=" + String.valueOf(ids));
            }
            _return.setSubscriptionReference(epr);
            return _return;
        }
        catch (Exception ex) {
            throw new SubscribeCreationFailedFault(ex.getMessage(), null, ex);
        }
    }

    private List<String> findSubscription(GJaxbEndpointReferenceType client, String consumerAddress, QName topic, String jsonAndMsg, String jsonOrMsg) throws Exception {
        Object res = null;
        ArrayList<String> results = new ArrayList<String>();
        GJaxbQuery request = new GJaxbQuery();
        request.setCollection(this.collection);
        String json = "{\n      \"subscribe.consumer\" : \"" + consumerAddress + "\",\n      \"subscribe.topicQName\" : \"" + String.valueOf(topic) + "\"" + (String)(jsonAndMsg != null ? ",\n" + jsonAndMsg : "") + (String)(jsonOrMsg != null ? ",\n" + jsonOrMsg : "") + "\n}\n";
        request.setQuery(json);
        GJaxbQueryResponse response = this.getStorage().query(request);
        for (Object obj : response.getAny()) {
            Element result = (Element)obj;
            Document doc = Document.parse((String)result.getTextContent());
            String id = doc.get((Object)"_id").toString();
            client.setUserData("subscribe", (Object)result.getTextContent());
            results.add(id);
        }
        return results;
    }

    @Override
    public GJaxbGetCurrentMessageResponse getCurrentMessage(GJaxbGetCurrentMessage getCurrentMessageRequest) throws NoCurrentMessageOnTopicFault, TopicNotSupportedFault, MultipleTopicsSpecifiedFault, ResourceUnknownFault, TopicExpressionDialectUnknownFault, InvalidTopicExpressionFault {
        LOG.debug("Executing operation getCurrentMessage");
        try {
            GJaxbGetCurrentMessageResponse _return = new GJaxbGetCurrentMessageResponse();
            if (this.notifier != null) {
                _return.getAny().add(this.notifier.getLastMessage());
            }
            return _return;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public GJaxbUnsubscribeResponse unsubscribe(GJaxbUnsubscribe unsubscribeRequest) throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
        LOG.debug("Executing operation unsubscribe");
        try {
            GJaxbUnsubscribeResponse _return = new GJaxbUnsubscribeResponse();
            GJaxbEndpointReferenceType epr = this.findSubscriptionReference(unsubscribeRequest);
            if (epr != null) {
                String id = epr.getAddress().getValue();
                if (id.indexOf("?id=") > 0) {
                    id = id.substring(id.indexOf("?id=") + "?id=".length(), id.length());
                    GJaxbRemove request = new GJaxbRemove();
                    request.setCollection(this.collection);
                    request.setId(id);
                    this.getStorage().remove(request);
                } else if (id.indexOf("?ids=") > 0) {
                    String[] ids;
                    for (String id_ : ids = id.substring(id.indexOf("?ids=") + "?ids=".length(), id.length()).replace("[", "").replace("]", "").split(",")) {
                        GJaxbRemove request = new GJaxbRemove();
                        request.setCollection(this.collection);
                        request.setId(id_);
                        this.getStorage().remove(request);
                    }
                }
                _return.getAny().add(this.factory.createSubscriptionReference(epr));
            }
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new UnableToDestroySubscriptionFault(ex.getMessage(), null, ex);
        }
    }

    private GJaxbEndpointReferenceType findSubscriptionReference(GJaxbUnsubscribe unsubscribeRequest) {
        GJaxbEndpointReferenceType epr = null;
        for (Object obj : unsubscribeRequest.getAny()) {
            if (obj instanceof GJaxbEndpointReferenceType) {
                epr = (GJaxbEndpointReferenceType)obj;
                break;
            }
            if (!(obj instanceof JAXBElement)) continue;
            epr = (GJaxbEndpointReferenceType)((JAXBElement)obj).getValue();
            break;
        }
        return epr;
    }

    @Override
    public GJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        LOG.debug("Executing operation getResourceProperty");
        try {
            GJaxbGetResourcePropertyResponse _return = null;
            if (getResourcePropertyRequest.getLocalPart().equals("TopicSet") && getResourcePropertyRequest.getNamespaceURI().equals("http://docs.oasis-open.org/wsn/t-1") && this.topicset != null) {
                _return = new GJaxbGetResourcePropertyResponse();
                _return.getAny().add(this.topicset);
            }
            if (_return == null) {
                ResourcesManager rm;
                Iterator<ResourcesManager> iterator = this.resourcesManagers.iterator();
                while (iterator.hasNext() && (_return = (rm = iterator.next()).getSpecificResourceProperty(getResourcePropertyRequest)) == null) {
                }
            }
            if (_return == null) {
                throw new ResourceUnavailableFault("resource " + String.valueOf(getResourcePropertyRequest) + " unknown", null);
            }
            return _return;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public GJaxbTopicNamespaceType getTopicNamespace() {
        return this.topicNamespace;
    }

    public List<QName> getTopicsInTopicSet() {
        ArrayList<QName> topicsProduced = new ArrayList<QName>();
        for (Object obj : this.topicset.getAny()) {
            Element elmt = (Element)obj;
            topicsProduced.add(new QName(elmt.getNamespaceURI(), elmt.getLocalName()));
        }
        return topicsProduced;
    }
}

