/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.producer;

import fr.emac.gind.commons.utils.map.MapHelper;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.Consumer;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.logger.GindLogger;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.storage.GJaxbQuery;
import fr.emac.gind.storage.GJaxbQueryResponse;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotificationMessageHolderType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicNamespaceType;
import gind.org.w3._2005._08.addressing.GJaxbAttributedURIType;
import gind.org.w3._2005._08.addressing.GJaxbEndpointReferenceType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.bson.Document;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Notifier {
    private static final Logger LOG = LoggerFactory.getLogger((String)Notifier.class.getName());
    private NotificationManagerImpl manager = null;
    private String eventProducerAddress = null;
    private GJaxbNotificationMessageHolderType.Message message = null;
    private ThreadLocal<SOAPSender> soapSender = new ThreadLocal<SOAPSender>(this){

        @Override
        protected SOAPSender initialValue() {
            try {
                return new SOAPSender(new SOAPInterceptor[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private String name = null;

    public Notifier(NotificationManagerImpl manager) throws Exception {
        this.manager = manager;
        if (this.manager != null) {
            this.setEventProducerAddress(this.manager.getAddress());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEventProducerAddress() {
        return this.eventProducerAddress;
    }

    public void setEventProducerAddress(String eventProducerAddress) {
        this.eventProducerAddress = eventProducerAddress;
    }

    public GJaxbNotificationMessageHolderType.Message getLastMessage() {
        return this.message;
    }

    public List<Consumer> findClientsForTopic(QName topic, Object payload, Boolean refresh) throws Exception {
        ArrayList<Consumer> res = new ArrayList<Consumer>();
        CopyOnWriteArrayList<Consumer> defaultEprs = new CopyOnWriteArrayList<Consumer>();
        String payloadInString = null;
        try {
            GJaxbQuery request = new GJaxbQuery();
            if (this.manager.getNotificationConsumerEprs().get(topic) == null || this.manager.getNotificationConsumerEprs().get(topic).isEmpty() || refresh.booleanValue()) {
                String query = "{\n   \"subscribe.topicQName\" : \"" + String.valueOf(topic) + "\" \n}";
                request.setCollection(this.manager.getCollection());
                request.setQuery(query);
                GJaxbQueryResponse response = this.manager.getStorage().query(request);
                for (Object obj : response.getAny()) {
                    Element result = (Element)obj;
                    Document dbObject = Document.parse((String)result.getTextContent());
                    Document subscribe = (Document)dbObject.get((Object)"subscribe");
                    String endpoint = (String)subscribe.get((Object)"consumer");
                    GJaxbEndpointReferenceType client = new GJaxbEndpointReferenceType();
                    client.setAddress(new GJaxbAttributedURIType());
                    client.getAddress().setValue(endpoint);
                    client.setUserData("subscribe", (Object)result.getTextContent());
                    defaultEprs.add(new Consumer(client));
                }
            } else {
                defaultEprs.addAll((Collection)this.manager.getNotificationConsumerEprs().get(topic));
            }
            for (Consumer client : defaultEprs) {
                List ormessageContaining;
                Document dbObject = Document.parse((String)((String)client.getRemoteClient().getUserData("subscribe")));
                Document subscribe = (Document)dbObject.get((Object)"subscribe");
                boolean and_ok = true;
                boolean or_ok = true;
                List andmessageContaining = (List)subscribe.get((Object)"andmessageContaining");
                if (andmessageContaining != null && !andmessageContaining.isEmpty()) {
                    if (payloadInString == null) {
                        payloadInString = this.convertPayloadToXMLorJSONString(payload);
                    }
                    for (Document andMsg : andmessageContaining) {
                        String msg = andMsg.getString((Object)"message");
                        String tmpPayloadInString = new JSONObject(payloadInString).toString().replace("'", "").replace("\"", "").replace("\\", "").replaceAll("\\s+", "");
                        if (this.validContent(msg = msg.replace("'", "").replace("\"", "").replace("\\", "").replaceAll("\\s+", ""), tmpPayloadInString)) continue;
                        and_ok = false;
                        break;
                    }
                }
                if (and_ok && (ormessageContaining = (List)subscribe.get((Object)"ormessageContaining")) != null && !ormessageContaining.isEmpty()) {
                    if (payloadInString == null) {
                        payloadInString = this.convertPayloadToXMLorJSONString(payload);
                    }
                    Iterator orMsgs = ormessageContaining.iterator();
                    or_ok = false;
                    while (orMsgs.hasNext()) {
                        Document orMsg = (Document)orMsgs.next();
                        String msg = orMsg.getString((Object)"message");
                        String tmpPayloadInString = new JSONObject(payloadInString).toString().replace("'", "").replace("\"", "").replace("\\", "").replaceAll("\\s+", "");
                        if (!this.validContent(msg = msg.replace("'", "").replace("\"", "").replace("\\", "").replaceAll("\\s+", ""), tmpPayloadInString)) continue;
                        or_ok = true;
                        break;
                    }
                }
                if (!and_ok || !or_ok) continue;
                res.add(client);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof JSONException) {
                LOG.debug("problem with this string that is not a JSON Object " + payloadInString);
            }
            throw new Exception(e);
        }
        return res;
    }

    private boolean validContent(String msg, String tmpPayloadInString) {
        String[] splitter = msg.split(":");
        String key = splitter[0].strip().stripIndent();
        String value = splitter[1].strip().stripIndent();
        String regexp = key + "\\s*:\\s*\\[[^\\[]*" + value + ".*\\]";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(tmpPayloadInString);
        boolean matchFound = matcher.find();
        return tmpPayloadInString.contains(msg) || matchFound;
    }

    private String convertPayloadToXMLorJSONString(Object payload) throws Exception {
        if (payload != null) {
            if (payload instanceof org.w3c.dom.Document) {
                return XMLCompactPrinter.print((Node)((org.w3c.dom.Document)payload).getDocumentElement());
            }
            if (payload instanceof AbstractJaxbObject) {
                return JSONJAXBContext.getInstance().marshallAnyElement(payload);
            }
            throw new Exception(String.valueOf(payload.getClass()) + " not taken in charge");
        }
        return null;
    }

    public List<Consumer> sendNotificationOnTopic(Object payload, QName topic, Map<QName, String> context, Boolean refresh) throws Exception {
        return this.sendNotificationOnTopic(payload, topic, null, context, refresh);
    }

    public List<Consumer> sendNotificationOnTopic(Object payload, QName topic, List<Consumer> eprs, Map<QName, String> context, Boolean refresh) throws Exception {
        GJaxbNotify notify = WSNHelper.getInstance().createNotification(null, this.getEventProducerAddress(), topic, payload, context);
        this.message = ((GJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage();
        String buffer = "<gind:sendAt xmlns:gind=\"http://www.gind.emac.fr\">" + System.currentTimeMillis() + "</gind:sendAt>";
        org.w3c.dom.Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(buffer.getBytes()));
        notify.getAny().add(doc.getDocumentElement());
        if (eprs == null) {
            eprs = this.findClientsForTopic(topic, payload, refresh);
        }
        for (Consumer epr : eprs) {
            ((GJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).setSubscriptionReference(epr.getRemoteClient());
            LOG.debug("Send notification to: " + epr.getRemoteClient().getAddress().getValue());
            String clientAddress = epr.getRemoteClient().getAddress().getValue();
            LOG.debug(clientAddress + " is client of topic: " + String.valueOf(topic));
            try {
                AbstractNotifierClient notifier;
                if (clientAddress.indexOf("?") > 0) {
                    clientAddress = clientAddress.substring(0, clientAddress.indexOf("?"));
                }
                String payloadTxt = null;
                payloadTxt = payload instanceof Node ? XMLCompactPrinter.print((Node)((Node)payload)) : (payload instanceof AbstractJaxbObject ? XMLCompactPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)payload)) : payload.toString());
                if (epr.getLocalClient() != null) {
                    notifier = epr.getLocalClient();
                    notifier.notify(notify);
                    GindLogger.log((Logger)LOG, (Level)Level.DEBUG, (String)"send notification", (Map)MapHelper.mapOf((Object[])new Object[]{"producer", this.getEventProducerAddress(), "consumer", clientAddress, "topic", topic.toString(), "payload", payloadTxt, "mode", "local"}));
                    continue;
                }
                if (LocalRegistry.getInstance().findNotifier(clientAddress) != null) {
                    notifier = (AbstractNotifierClient)LocalRegistry.getInstance().findNotifier(clientAddress);
                    notifier.notify(notify);
                    GindLogger.log((Logger)LOG, (Level)Level.DEBUG, (String)"send notification", (Map)MapHelper.mapOf((Object[])new Object[]{"producer", this.getEventProducerAddress(), "consumer", clientAddress, "topic", topic.toString(), "payload", payloadTxt, "mode", "local"}));
                    continue;
                }
                org.w3c.dom.Document payloadDoc = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)notify);
                this.soapSender.get().sendSoapRequest(payloadDoc, clientAddress, "http://www.gind.emac.fr/notifier/Notify");
                GindLogger.log((Logger)LOG, (Level)Level.DEBUG, (String)"send notification", (Map)MapHelper.mapOf((Object[])new Object[]{"producer", this.getEventProducerAddress(), "consumer", clientAddress, "topic", topic.toString(), "payload", payloadTxt, "mode", "remote"}));
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOG.warn("Impossible to send notification to : " + clientAddress + "!!! Reason: " + e.getMessage());
            }
        }
        return eprs;
    }

    public List<QName> findTopicsFromPayload(org.w3c.dom.Document payload) {
        ArrayList<QName> topicsProvided = new ArrayList<QName>();
        QName messageEvent = new QName(payload.getDocumentElement().getNamespaceURI(), payload.getDocumentElement().getLocalName());
        for (GJaxbTopicNamespaceType.Topic t : this.manager.getTopicNamespace().getTopic()) {
            QName topicName = new QName(this.manager.getTopicNamespace().getTargetNamespace().trim(), t.getName().trim());
            if (!t.getMessageTypes().contains(messageEvent) || !this.manager.getTopicsInTopicSet().contains(topicName)) continue;
            topicsProvided.add(topicName);
        }
        return topicsProvided;
    }
}

