/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.h2gis.gis;

import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.find.gis.client.FindGisCallbackClient;
import fr.emac.gind.gis.find_gis.FaultMessage;
import fr.emac.gind.gis.find_gis.FindGis;
import fr.emac.gind.gis.find_gis.FindGisCallback;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsFromLatLng;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsFromLatLngResponse;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsideBBox;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsideBBoxResponse;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsidePolygon;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsidePolygonResponse;
import fr.emac.gind.gis.find_gis.GJaxbPoint;
import fr.emac.gind.gis.find_gis.GJaxbPolygon;
import fr.emac.gind.gis.find_gis.GJaxbReceiveConceptContainedInPolygon;
import fr.emac.gind.gis.mappingmodel.GJaxbTable;
import fr.emac.gind.gis.mappingmodel.GJaxbTypeType;
import fr.emac.gind.gis.store_gis.GJaxbQuery;
import fr.emac.gind.gis.store_gis.GJaxbQueryResponse;
import fr.emac.gind.h2gis.gis.H2GisStoreGisImpl;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import jakarta.jws.WebService;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@WebService(serviceName="find_gis", portName="find_gisSOAP", targetNamespace="http://www.gind.emac.fr/gis/find_gis/", wsdlLocation="wsdl/find-gis.wsdl", endpointInterface="fr.emac.gind.gis.find_gis.FindGis")
public class H2GisFindGisImpl
implements FindGis {
    private static final Logger LOG = LoggerFactory.getLogger((String)H2GisFindGisImpl.class.getName());
    private H2GisStoreGisImpl storeConnexion = null;

    public H2GisFindGisImpl(H2GisStoreGisImpl storeConnexion) throws Exception {
        this.storeConnexion = storeConnexion;
    }

    public H2GisStoreGisImpl getStoreConnexion() {
        return this.storeConnexion;
    }

    public GJaxbFindConceptsInsidePolygonResponse findConceptsInsidePolygon(final GJaxbFindConceptsInsidePolygon parameters) throws FaultMessage {
        GJaxbFindConceptsInsidePolygonResponse res = new GJaxbFindConceptsInsidePolygonResponse();
        final String queryId = "qis_query_id_" + String.valueOf(UUID.randomUUID());
        try {
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
            service.execute(new Runnable(){
                final /* synthetic */ H2GisFindGisImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        GJaxbPolygon polygon = parameters.getPolygon();
                        Object multiPolygon = "MULTIPOLYGON (((";
                        for (GJaxbPoint point : polygon.getPoint()) {
                            multiPolygon = (String)multiPolygon + point.getLongitude() + " " + point.getLatitude() + ", ";
                        }
                        GJaxbPoint p1 = (GJaxbPoint)polygon.getPoint().get(0);
                        multiPolygon = (String)multiPolygon + p1.getLongitude() + "  " + p1.getLatitude();
                        Object mp = multiPolygon = (String)multiPolygon + ")))";
                        final GJaxbReceiveConceptContainedInPolygon.Statistic stat = new GJaxbReceiveConceptContainedInPolygon.Statistic();
                        stat.setNumberNodesFound(0);
                        stat.setNumberNodesReceived(0);
                        int numberFound = 0;
                        for (Map.Entry<String, GJaxbTable> entry : this.this$0.getStoreConnexion().getTablesMapping().entrySet()) {
                            LOG.debug("Looking in " + entry.getKey() + "   , numberFound " + numberFound);
                            final FindGisCallback client = FindGisCallbackClient.createClient((String)parameters.getCallbackAddress());
                            String tableName = entry.getKey().trim();
                            GJaxbTable table = entry.getValue();
                            Object query = "";
                            query = GJaxbTypeType.POLYGON.equals((Object)table.getType()) || GJaxbTypeType.POINT.equals((Object)table.getType()) ? "SELECT *, ST_Area(`" + tableName + "`.THE_GEOM) FROM `" + tableName + "` WHERE `" + tableName + "`.THE_GEOM && ST_GeomFromText('" + (String)mp + "', 4326) AND ST_Contains(ST_GeomFromText('" + (String)mp + "', 4326), `" + tableName + "`.THE_GEOM)" : "SELECT * FROM `" + tableName + "` WHERE ST_GeomFromText('" + (String)mp + "', 4326) && `" + tableName + "`.THE_GEOM AND ST_Intersects(ST_GeomFromText('" + (String)mp + "', 4326), `" + tableName + "`.THE_GEOM)";
                            ResultSet rs = this.this$0.getStoreConnexion().executeQuery((String)query);
                            List<Map<String, Object>> list = this.this$0.getStoreConnexion().getResult(rs);
                            LOG.debug("numberFound " + (numberFound += list.size()));
                            final List<String> tables = this.this$0.getStoreConnexion().findTables((String)query);
                            for (final Map<String, Object> map : list) {
                                ExecutorService service3 = Executors.newSingleThreadExecutor();
                                service3.execute(new Runnable(){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            GJaxbNode node = this.this$1.this$0.getStoreConnexion().convertToNode(map, tables);
                                            GJaxbGenericModel genModel = new GJaxbGenericModel();
                                            genModel.getNode().add(node);
                                            GJaxbReceiveConceptContainedInPolygon respCpt = new GJaxbReceiveConceptContainedInPolygon();
                                            respCpt.getProperty().addAll(parameters.getProperty());
                                            respCpt.setGenericModel(genModel);
                                            respCpt.setStatistic(stat);
                                            respCpt.setQueryId(queryId);
                                            LOG.debug("concepts " + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)respCpt)));
                                            client.receiveConceptContainedInPolygon(respCpt);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            LOG.error(e.getMessage(), null, (Object)e);
                                        }
                                    }
                                });
                            }
                        }
                        LOG.debug("stat numberFound " + numberFound);
                        stat.setNumberNodesFound(numberFound);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LOG.error(e.getMessage(), null, (Object)e);
                    }
                }
            });
            res.setQueryId(queryId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbFindConceptsFromLatLngResponse findConceptsFromLatLng(GJaxbFindConceptsFromLatLng parameters) throws FaultMessage {
        GJaxbFindConceptsFromLatLngResponse res = new GJaxbFindConceptsFromLatLngResponse();
        try {
            GJaxbGenericModel genModel = new GJaxbGenericModel();
            for (Map.Entry<String, GJaxbTable> entry : this.getStoreConnexion().getTablesMapping().entrySet()) {
                String tableName = entry.getKey().trim();
                GJaxbQuery request = new GJaxbQuery();
                request.setQuery("SELECT *, ST_Area(`" + tableName + "`.THE_GEOM) FROM `" + tableName + "` WHERE ST_Contains(`" + tableName + "`.THE_GEOM, ST_GeomFromText('POINT(" + parameters.getPoint().getLongitude() + " " + parameters.getPoint().getLatitude() + ")', 4326))");
                GJaxbQueryResponse resp = this.getStoreConnexion().query(request);
                genModel.getNode().addAll(resp.getSingle().getGenericModel().getNode());
            }
            this.getStoreConnexion().findParentNode(genModel);
            res.setGenericModel(genModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbFindConceptsInsideBBoxResponse findConceptsInsideBBox(GJaxbFindConceptsInsideBBox parameters) throws FaultMessage {
        LOG.info("Executing operation findConceptsInsideBBox");
        try {
            GJaxbFindConceptsInsideBBoxResponse _return = null;
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

