/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.osm.gis.amenity;

import fr.emac.gind.osm.gis.amenity.Amenity;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmenityManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)AmenityManager.class.getName());
    public static String htmlWikiAddress = "https://wiki.openstreetmap.org";
    private static String htmlAmenityPageAddress = htmlWikiAddress + "/wiki/Key:amenity";
    private static AmenityManager INSTANCE = null;
    private Map<String, Amenity> amenities = new HashMap<String, Amenity>();

    private AmenityManager() throws Exception {
        this.initialize();
    }

    public static AmenityManager getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new AmenityManager();
        }
        return INSTANCE;
    }

    private void initialize() throws Exception {
        Document doc = Jsoup.connect((String)htmlAmenityPageAddress).get();
        Element table = doc.select("table.wikitable").first();
        table.select("tr[id^='amenity-']").forEach(tr -> {
            Elements tds = tr.select("td");
            String amenityName = ((Element)tds.get(1)).text();
            String amenityDescription = ((Element)tds.get(3)).text();
            String amenitySvgHtmlPage = null;
            if (!((Element)tds.get(4)).select("a").isEmpty()) {
                amenitySvgHtmlPage = htmlWikiAddress + ((Element)tds.get(4)).select("a").first().attr("href");
            }
            Object amenityImageUrl = null;
            if (!((Element)tds.get(5)).select("img").isEmpty() && !((String)(amenityImageUrl = ((Element)tds.get(5)).select("img").first().attr("src"))).startsWith("http://")) {
                amenityImageUrl = htmlWikiAddress + (String)amenityImageUrl;
            }
            Amenity a = new Amenity(amenityName, amenityDescription, amenitySvgHtmlPage, (String)amenityImageUrl);
            this.amenities.put(a.getName(), a);
        });
    }

    public Map<String, Amenity> getAmenities() {
        return this.amenities;
    }
}

