/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.osm.gis.launcher;

import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.osm.gis.OsmGisWebService;
import java.util.HashMap;
import java.util.Map;

public class OSMGisLauncher
extends AbstractLauncher {
    private OsmGisWebService storage = null;
    private Map<String, Object> map = new HashMap<String, Object>();

    public String getInfo() {
        StringBuffer res = new StringBuffer();
        res.append("Storage Service based on MongoDB.\n");
        res.append("Number of services exposed: " + this.storage.getAllAddresses().size() + "\n");
        res.append("\nList of services:\n");
        for (String string : this.storage.getAllAddresses()) {
            res.append("\t- " + string + "\n");
        }
        if (!this.map.isEmpty()) {
            res.append("\nConfiguration:\n");
            for (Map.Entry entry : this.map.entrySet()) {
                res.append("\t" + (String)entry.getKey() + " = " + String.valueOf(entry.getValue()) + "\n");
            }
        }
        return res.toString();
    }

    public String getName() {
        return "Storage Service based on MongoDB";
    }

    public String getPromptName() {
        return "store";
    }

    public void startRunner(Configuration conf) throws Exception {
        this.storage = new OsmGisWebService();
        this.map.clear();
        this.map.put("serviceName", "StorageService");
        this.map.putAll(conf.getProperties());
        this.storage.start(this.map);
    }

    public void stopRunner() throws Exception {
        this.storage.stop();
    }
}

