/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.client;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.ai_chatbot.FaultMessage;
import fr.emac.gind.gov.ai_chatbot.GJaxbExportDocumentsFromRAG;
import fr.emac.gind.gov.ai_chatbot.GJaxbExportDocumentsFromRAGResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesFromPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesFromPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventBuildings;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventBuildingsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventCodeExplanation;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventCodeExplanationResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctions;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctionsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGoods;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGoodsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGroups;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGroupsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventIots;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventIotsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPersons;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPersonsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPositionFromTerritory;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPositionFromTerritoryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotential;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNews;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNewsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoads;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoadsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoles;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesFromObjectives;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesFromObjectivesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensors;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensorsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTerritories;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTerritoriesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTweets;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTweetsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbLoadDocumentsForRAG;
import fr.emac.gind.gov.ai_chatbot.GJaxbLoadDocumentsForRAGResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbQuery;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectory;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectoryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevel;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevelResponse;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AIChatbotClient
implements AiChatbot {
    private SOAPSender sender = null;
    private String serverAddress = null;

    private AIChatbotClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static AiChatbot createClient(String remoteAddress) throws Exception {
        AiChatbot client = (AiChatbot)LocalRegistry.getInstance().findWSImplementation(AiChatbot.class);
        if (client == null) {
            client = new AIChatbotClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public GJaxbQueryResponse query(GJaxbQuery parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/query\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbQueryResponse response = (GJaxbQueryResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbQueryResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbQueryOnPicturesResponse queryOnPictures(GJaxbQueryOnPictures parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/queryOnPictures\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbQueryOnPicturesResponse response = (GJaxbQueryOnPicturesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbQueryOnPicturesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventRolesResponse inventRoles(GJaxbInventRoles parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventRoles\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventRolesResponse response = (GJaxbInventRolesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventRolesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventActualitiesResponse inventActualities(GJaxbInventActualities parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventActualities\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventActualitiesResponse response = (GJaxbInventActualitiesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventActualitiesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventPersonsResponse inventPersons(GJaxbInventPersons parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventPersons\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventPersonsResponse response = (GJaxbInventPersonsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventPersonsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventGoodsResponse inventGoods(GJaxbInventGoods parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventGoods\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventGoodsResponse response = (GJaxbInventGoodsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventGoodsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventTerritoriesResponse inventTerritories(GJaxbInventTerritories parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventTerritories\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventTerritoriesResponse response = (GJaxbInventTerritoriesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventTerritoriesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbSimilarityLevelResponse similarityLevel(GJaxbSimilarityLevel parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/similarityLevel\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbSimilarityLevelResponse response = (GJaxbSimilarityLevelResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbSimilarityLevelResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventGroupsResponse inventGroups(GJaxbInventGroups parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventGroups\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventGroupsResponse response = (GJaxbInventGroupsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventGroupsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventPotentialitiesResponse inventPotentialities(GJaxbInventPotentialities parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventPotentialities\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventPotentialitiesResponse response = (GJaxbInventPotentialitiesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventPotentialitiesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventFunctionsResponse inventFunctions(GJaxbInventFunctions parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventFunctions\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventFunctionsResponse response = (GJaxbInventFunctionsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventFunctionsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventSensorsResponse inventSensors(GJaxbInventSensors parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventSensors\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventSensorsResponse response = (GJaxbInventSensorsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventSensorsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventActualitiesFromPicturesResponse inventActualitiesFromPictures(GJaxbInventActualitiesFromPictures parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventActualitiesFromPictures\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventActualitiesFromPicturesResponse response = (GJaxbInventActualitiesFromPicturesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventActualitiesFromPicturesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventPositionFromTerritoryResponse inventPositionFromTerritory(GJaxbInventPositionFromTerritory parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventPositionFromTerritory\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventPositionFromTerritoryResponse response = (GJaxbInventPositionFromTerritoryResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventPositionFromTerritoryResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventTweetsResponse inventTweets(GJaxbInventTweets parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventTweets\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventTweetsResponse response = (GJaxbInventTweetsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventTweetsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventPicturesResponse inventPictures(GJaxbInventPictures parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventPictures\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventPicturesResponse response = (GJaxbInventPicturesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventPicturesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventIotsResponse inventIots(GJaxbInventIots parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventIots\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventIotsResponse response = (GJaxbInventIotsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventIotsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventRolesFromObjectivesResponse inventRolesFromObjectives(GJaxbInventRolesFromObjectives parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventRolesFromObjectives\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventRolesFromObjectivesResponse response = (GJaxbInventRolesFromObjectivesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventRolesFromObjectivesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventPotentialResponse inventPotential(GJaxbInventPotential parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventPotential\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventPotentialResponse response = (GJaxbInventPotentialResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventPotentialResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventCodeExplanationResponse inventCodeExplanation(GJaxbInventCodeExplanation parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventCodeExplanation\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventCodeExplanationResponse response = (GJaxbInventCodeExplanationResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventCodeExplanationResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventBuildingsResponse inventBuildings(GJaxbInventBuildings parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventBuildings\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventBuildingsResponse response = (GJaxbInventBuildingsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventBuildingsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventRoadsResponse inventRoads(GJaxbInventRoads parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventRoads\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventRoadsResponse response = (GJaxbInventRoadsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventRoadsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbLoadDocumentsForRAGResponse loadDocumentsForRAG(GJaxbLoadDocumentsForRAG parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/loadDocumentsForRAG\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbLoadDocumentsForRAGResponse response = (GJaxbLoadDocumentsForRAGResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbLoadDocumentsForRAGResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbExportDocumentsFromRAGResponse exportDocumentsFromRAG(GJaxbExportDocumentsFromRAG parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/exportDocumentsFromRAG\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbExportDocumentsFromRAGResponse response = (GJaxbExportDocumentsFromRAGResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbExportDocumentsFromRAGResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbRestoreRAGFromDirectoryResponse restoreRAGFromDirectory(GJaxbRestoreRAGFromDirectory parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/restoreRAGFromDirectory\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbRestoreRAGFromDirectoryResponse response = (GJaxbRestoreRAGFromDirectoryResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbRestoreRAGFromDirectoryResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbInventProblemsFromNewsResponse inventProblemsFromNews(GJaxbInventProblemsFromNews parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/gov/ai_chatbot/inventProblemsFromNews\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbInventProblemsFromNewsResponse response = (GJaxbInventProblemsFromNewsResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbInventProblemsFromNewsResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }
}

