/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ChatModelBuilder;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama.OllamaContainerConfig;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;

public class OllamaChatModelBuilder
implements ChatModelBuilder {
    private OllamaChatModel chatLanguageModel = null;
    private OllamaContainerConfig config = null;

    public OllamaChatModelBuilder(OllamaContainerConfig conf) {
        this.config = conf;
    }

    @Override
    public String getName() {
        return this.config.getOllamaChatBotType().toString();
    }

    public OllamaContainerConfig getConfig() {
        return this.config;
    }

    private boolean needToRebuild(GJaxbContext context) {
        GJaxbContext newContext;
        int hash2;
        int hash1 = context.hashCode();
        return hash1 != (hash2 = (newContext = this.mergeConfiguration(context)).hashCode());
    }

    private GJaxbContext mergeConfiguration(GJaxbContext newContext) {
        GJaxbContext defaultContext = this.createDefaultConfigurationForChatModel();
        GJaxbContext.OllamaContext defaultOllamaCtxt = defaultContext.getOllamaContext();
        GJaxbContext.OllamaContext newOllamaCtxt = newContext.getOllamaContext();
        if (!newOllamaCtxt.isSetModelName()) {
            newOllamaCtxt.setModelName(defaultOllamaCtxt.getModelName());
        }
        if (!newOllamaCtxt.isSetMaxTokens()) {
            newOllamaCtxt.setMaxTokens(defaultOllamaCtxt.getMaxTokens());
        }
        if (!newOllamaCtxt.isSetResponseFormat()) {
            newOllamaCtxt.setResponseFormat(defaultOllamaCtxt.getResponseFormat());
        }
        if (!newOllamaCtxt.isSetTemperature()) {
            newOllamaCtxt.setTemperature(defaultOllamaCtxt.getTemperature());
        }
        return newContext;
    }

    @Override
    public ChatModel getChatModel(GJaxbContext context) {
        if (this.chatLanguageModel == null) {
            this.buildChatModel(context);
        } else if (this.needToRebuild(context)) {
            this.buildChatModel(context);
        }
        return this.chatLanguageModel;
    }

    @Override
    public boolean existChatModel() {
        GJaxbContext context = new GJaxbContext();
        context.setOllamaContext(new GJaxbContext.OllamaContext());
        context.getOllamaContext().setModelName(this.config.model);
        return this.getChatModel(context) != null;
    }

    @Override
    public GJaxbContext createDefaultConfigurationForChatModel() {
        GJaxbContext.OllamaContext mistralCtxt = new GJaxbContext.OllamaContext();
        mistralCtxt.setModelName(this.config.model);
        GJaxbContext ctxt = new GJaxbContext();
        ctxt.setOllamaContext(mistralCtxt);
        return ctxt;
    }

    private void buildChatModel(GJaxbContext.OllamaContext ollamaCtxt) {
        this.chatLanguageModel = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(this.config.url)).modelName(this.config.model)).responseFormat(ResponseFormat.JSON)).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
    }

    @Override
    public void buildChatModel(GJaxbContext context) {
        if (context == null) {
            context = this.createDefaultConfigurationForChatModel();
        } else if (context.getOllamaContext() == null) {
            context.setOllamaContext(this.createDefaultConfigurationForChatModel().getOllamaContext());
        } else {
            context = this.mergeConfiguration(context);
        }
        this.buildChatModel(context.getOllamaContext());
    }

    @Override
    public ChatModel getImageAnalysisChatModel(GJaxbContext context) {
        return null;
    }

    @Override
    public GJaxbContext createDefaultConfigurationForImageAnalysisChatModel() {
        return null;
    }

    @Override
    public boolean existImageAnalysisChatModel() {
        return false;
    }

    private void buildImageAnalysisChatModel(GJaxbContext.ChatGPTContext gptCtxt) {
    }

    @Override
    public void buildImageAnalysisChatModel(GJaxbContext context) {
        if (context == null) {
            context = this.createDefaultConfigurationForImageAnalysisChatModel();
        } else if (context.getChatGPTContext() == null) {
            context.setChatGPTContext(this.createDefaultConfigurationForImageAnalysisChatModel().getChatGPTContext());
        } else {
            context = this.mergeConfiguration(context);
        }
        this.buildImageAnalysisChatModel(context.getChatGPTContext());
    }

    @Override
    public ImageModel getImageCreationModel(GJaxbContext context) {
        return null;
    }

    @Override
    public boolean existImageCreationModel() {
        return false;
    }

    private void buildImageCreationModel(GJaxbContext.ChatGPTContext gptCtxt) {
    }

    @Override
    public void buildImageCreationModel(GJaxbContext context) {
        if (context == null) {
            context = this.createDefaultConfigurationForImageCreationModel();
        } else if (context.getChatGPTContext() == null) {
            context.setChatGPTContext(this.createDefaultConfigurationForImageCreationModel().getChatGPTContext());
        } else {
            context = this.mergeConfiguration(context);
        }
        this.buildImageCreationModel(context.getChatGPTContext());
    }

    @Override
    public GJaxbContext createDefaultConfigurationForImageCreationModel() {
        return null;
    }
}

