/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.ImageResult;
import com.google.maps.PlaceDetailsRequest;
import com.google.maps.PlacesApi;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.PlaceDetails;
import com.google.maps.model.PlacesSearchResponse;
import com.google.maps.model.PlacesSearchResult;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.loader.FileSystemDocumentLoader;
import dev.langchain4j.data.document.parser.TextDocumentParser;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.content.retriever.EmbeddingStoreContentRetriever;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.output.ServiceOutputParser;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.gov.ai.chatbot.service.builder.ModelBuilderSelector;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoAsset;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoFunction;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoGood;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoPerson;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoRole;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoSensor;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoTerritory;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoActuality;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoPotential;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoPotentiality;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoProblem;
import fr.emac.gind.gov.ai.chatbot.service.tools.IdGenerator;
import fr.emac.gind.gov.ai.chatbot.service.util.PhotosHelper;
import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.ai_chatbot.FaultMessage;
import fr.emac.gind.gov.ai_chatbot.GJaxbAddressInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbAiChatBotType;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExportDocumentsFromRAG;
import fr.emac.gind.gov.ai_chatbot.GJaxbExportDocumentsFromRAGResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbGoodInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbGroupType;
import fr.emac.gind.gov.ai_chatbot.GJaxbHasReferenceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesFromPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesFromPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventBuildings;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventBuildingsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventCodeExplanation;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventCodeExplanationResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctions;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctionsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGoods;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGoodsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGroups;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGroupsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventIots;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventIotsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPersons;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPersonsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPositionFromTerritory;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPositionFromTerritoryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotential;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNews;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNewsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoads;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoadsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoles;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesFromObjectives;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesFromObjectivesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensors;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensorsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTerritories;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTerritoriesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTweets;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTweetsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbLoadDocumentsForRAG;
import fr.emac.gind.gov.ai_chatbot.GJaxbLoadDocumentsForRAGResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbPersonInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbPictureInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbProblemInputType;
import fr.emac.gind.gov.ai_chatbot.GJaxbProblemType;
import fr.emac.gind.gov.ai_chatbot.GJaxbQuery;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectory;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectoryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbRole;
import fr.emac.gind.gov.ai_chatbot.GJaxbRoleForType;
import fr.emac.gind.gov.ai_chatbot.GJaxbRoleInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbRolesFromObjectivesInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbSemanticMethodType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSensorNatureDedicatedType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSensorNatureOthersType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSensorType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarAnalysisType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevel;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevelResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbSyntacticMethodType;
import fr.emac.gind.gov.ai_chatbot.GJaxbThreshold;
import fr.emac.gind.gov.ai_chatbot.GJaxbThresholdType;
import fr.emac.gind.gov.ai_chatbot.GJaxbUnpreciseAddressInput;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbArea;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.tweet.GJaxbExtendedEntities;
import fr.emac.gind.tweet.GJaxbMediaObject;
import fr.emac.gind.tweet.GJaxbTweetObject;
import fr.emac.gind.wsdl11.WSDLDefinitionsManager;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTDefinitions;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTOperation;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPortType;
import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import jakarta.xml.ws.BindingType;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.StringMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="ai_chatbotSOAP", serviceName="ai_chatbot", targetNamespace="http://www.gind.emac.fr/gov/ai_chatbot/", wsdlLocation="wsdl/ai-chatbot.wsdl", endpointInterface="fr.emac.gind.gov.ai_chatbot.AiChatbot")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class AIChatbotImpl
implements AiChatbot {
    private static final Logger LOG = LoggerFactory.getLogger((String)AIChatbotImpl.class.getName());
    private String googleMapsKey = null;
    private GeoApiContext geoApiContext = null;
    private Map<String, Integer> sensorNatureMap = new HashMap<String, Integer>();
    private String riopiotAddress = null;
    private CoreGov coreGovClient = null;
    private InMemoryEmbeddingStore<TextSegment> embeddingStore = null;

    public AIChatbotImpl(Map<String, Object> context) throws Exception {
        if (System.getenv("GOOGLE_API_KEY") != null) {
            this.googleMapsKey = System.getenv("GOOGLE_API_KEY");
            this.geoApiContext = new GeoApiContext.Builder().apiKey(this.googleMapsKey).build();
        }
        if (context != null) {
            if (context.containsKey("tools_r-iopiot")) {
                this.riopiotAddress = context.get("tools_r-iopiot").toString();
            }
            if (context.containsKey("governance")) {
                this.coreGovClient = CoreGovClient.createClient((String)context.get("governance").toString().replace("/gov", "/GovCore"));
            }
        }
        this.embeddingStore = new InMemoryEmbeddingStore();
    }

    private <T> T getExtractor(Class<T> extractorClass, GJaxbContext context) throws Exception {
        if (GJaxbAiChatBotType.OLLAMA_MISTRAL.equals((Object)context.getSelectedAiChatBot()) || GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL.equals((Object)context.getSelectedAiChatBot()) || GJaxbAiChatBotType.OLLAMA_LLAMA_3_2.equals((Object)context.getSelectedAiChatBot()) || GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1.equals((Object)context.getSelectedAiChatBot())) {
            return (T)AiServices.builder(extractorClass).chatModel(ModelBuilderSelector.getInstance().getSelectedChatModel(context)).contentRetriever((ContentRetriever)EmbeddingStoreContentRetriever.from(this.embeddingStore)).build();
        }
        return (T)AiServices.builder(extractorClass).chatModel(ModelBuilderSelector.getInstance().getSelectedChatModel(context)).contentRetriever((ContentRetriever)EmbeddingStoreContentRetriever.from(this.embeddingStore)).tools(new Object[]{new IdGenerator()}).build();
    }

    public GJaxbQueryResponse query(GJaxbQuery parameters) throws FaultMessage {
        GJaxbQueryResponse resp = new GJaxbQueryResponse();
        String response = null;
        try {
            ArrayList<TextContent> contents = new ArrayList<TextContent>();
            for (String userMsg : parameters.getUserMessage()) {
                contents.add(TextContent.from((String)userMsg));
            }
            UserMessage userMessage = UserMessage.from(contents);
            SystemMessage systemMessage = SystemMessage.from((String)parameters.getSystemMessage());
            response = ModelBuilderSelector.getInstance().getSelectedChatModel(parameters.getContext()).chat(new ChatMessage[]{userMessage, systemMessage}).aiMessage().text();
            if (response.startsWith("```json")) {
                response = response.substring(response.indexOf("```json") + "```json".length(), response.lastIndexOf("```"));
            }
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        resp.setResponse(response);
        return resp;
    }

    public GJaxbQueryOnPicturesResponse queryOnPictures(GJaxbQueryOnPictures parameters) throws FaultMessage {
        GJaxbQueryOnPicturesResponse resp = new GJaxbQueryOnPicturesResponse();
        try {
            ChatModel imageAnalysisChatLanguageModel = ModelBuilderSelector.getInstance().getSelectedImageAnalysisChatModel(parameters.getContext());
            if (imageAnalysisChatLanguageModel == null) {
                throw new Exception("Image analysis chat model not supported on " + String.valueOf(parameters.getContext().getSelectedAiChatBot()));
            }
            ArrayList<Object> chatMessages = new ArrayList<Object>();
            if (parameters.isSetSystemMessage()) {
                chatMessages.add(SystemMessage.from((String)parameters.getSystemMessage()));
            }
            ArrayList<Object> userContents = new ArrayList<Object>();
            for (String userMsg : parameters.getUserMessage()) {
                userContents.add(TextContent.from((String)userMsg));
            }
            for (GJaxbPictureInput pictureInput : parameters.getPictureInput()) {
                userContents.add(TextContent.from((String)("image identifier (imageId) of image below : " + pictureInput.getPictureId())));
                if (pictureInput.isSetPictureUrl()) {
                    userContents.add(ImageContent.from((Image)Image.builder().url(pictureInput.getPictureUrl()).build()));
                    continue;
                }
                if (!pictureInput.isSetPictureDataEncodedBase64()) continue;
                if (!pictureInput.getPictureDataEncodedBase64().startsWith("data:")) {
                    String mimeType = "image/png";
                    if (pictureInput.isSetPictureMimeType()) {
                        mimeType = pictureInput.getPictureMimeType();
                    }
                    userContents.add(ImageContent.from((Image)Image.builder().base64Data(pictureInput.getPictureDataEncodedBase64()).mimeType(mimeType).build()));
                    continue;
                }
                userContents.add(ImageContent.from((String)pictureInput.getPictureDataEncodedBase64(), (ImageContent.DetailLevel)ImageContent.DetailLevel.HIGH));
            }
            UserMessage userMessage = UserMessage.from(userContents);
            chatMessages.add(userMessage);
            ChatResponse response = imageAnalysisChatLanguageModel.chat(chatMessages);
            String buffer = response.aiMessage().text();
            if (buffer.startsWith("```json")) {
                buffer = buffer.substring(buffer.indexOf("```json") + "```json".length(), buffer.lastIndexOf("```"));
            }
            resp.setResponse(buffer);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    public GJaxbInventFunctionsResponse inventFunctions(GJaxbInventFunctions parameters) throws FaultMessage {
        GJaxbInventFunctionsResponse response = new GJaxbInventFunctionsResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoFunction.FunctionExtractor extractor = this.getExtractor(PojoFunction.FunctionExtractor.class, parameters.getContext());
            for (GJaxbInventFunctions.FunctionInput input : parameters.getFunctionInput()) {
                PojoFunction.AIFunction aifunct = new PojoFunction.AIFunction();
                aifunct.functionId = input.getFunctionId();
                aifunct.functionName = input.getFunctionName();
                aifunct.jobName = "undefined";
                if (input.getAssociatedRole() != null && input.getAssociatedRole().getNode() != null) {
                    aifunct.jobName = GenericModelHelper.getName((GJaxbNode)input.getAssociatedRole().getNode());
                }
                PojoFunction.AIFunction aifunctionCompleted = extractor.extractFunctionFrom(aifunct.toString());
                System.out.println(aifunctionCompleted);
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aifunctionCompleted.convertToModel(input));
                if (input.getAssociatedRole() == null || input.getAssociatedRole().getNode() == null) continue;
                model.getNode().add(input.getAssociatedRole().getNode());
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventRolesResponse inventRoles(GJaxbInventRoles parameters) throws FaultMessage {
        GJaxbInventRolesResponse response = new GJaxbInventRolesResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoRole.RoleExtractor extractor = this.getExtractor(PojoRole.RoleExtractor.class, parameters.getContext());
            for (GJaxbRoleInput input : parameters.getRoleInput()) {
                AIPojo aiRoleCompleted;
                AIPojo aiRole;
                if (input.getRoleType().equals((Object)GJaxbRoleForType.PERSON)) {
                    aiRole = new PojoRole.AIRoleForPerson();
                    ((PojoRole.AIRoleForPerson)aiRole).setRoleName(input.getRoleName());
                    aiRoleCompleted = extractor.extractRoleForPersonFrom(((PojoRole.AIRoleForPerson)aiRole).getRoleName().toString());
                    System.out.println(aiRoleCompleted);
                    model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)((PojoRole.AIRoleForPerson)aiRoleCompleted).convertToModel(input, parameters.getContext(), this));
                    continue;
                }
                if (!input.getRoleType().equals((Object)GJaxbRoleForType.GOOD)) continue;
                aiRole = new PojoRole.AIRoleForGood();
                ((PojoRole.AIRoleForGood)aiRole).setGoodName(input.getRoleName());
                aiRoleCompleted = extractor.extractRoleForGoodFrom(((PojoRole.AIRoleForGood)aiRole).getGoodName().toString());
                System.out.println(aiRoleCompleted);
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)((PojoRole.AIRoleForGood)aiRoleCompleted).convertToModel(input, parameters.getContext(), this));
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventRolesFromObjectivesResponse inventRolesFromObjectives(GJaxbInventRolesFromObjectives parameters) throws FaultMessage {
        GJaxbInventRolesFromObjectivesResponse response = new GJaxbInventRolesFromObjectivesResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoRole.RoleExtractor extractor = this.getExtractor(PojoRole.RoleExtractor.class, parameters.getContext());
            for (GJaxbRolesFromObjectivesInput input : parameters.getRolesFromObjectivesInput()) {
                for (GJaxbRolesFromObjectivesInput.ObjectiveInput obj : input.getObjectiveInput()) {
                    PojoProblem.AIProblem problem = new PojoProblem.AIProblem();
                    problem.problemId = obj.getObjectiveId();
                    problem.problemName = obj.getObjectiveName();
                    PojoRole.AIRoleForPerson aiRoleCompleted = extractor.extractRoleForPersonFromProblem(problem.toString());
                    System.out.println(aiRoleCompleted);
                    GJaxbRoleInput roleInput = new GJaxbRoleInput();
                    roleInput.setRoleType(GJaxbRoleForType.PERSON);
                    model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiRoleCompleted.convertToModel(roleInput, parameters.getContext(), this));
                }
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventActualitiesResponse inventActualities(GJaxbInventActualities parameters) throws FaultMessage {
        GJaxbInventActualitiesResponse response = new GJaxbInventActualitiesResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoActuality.ActualityExtractor extractor = this.getExtractor(PojoActuality.ActualityExtractor.class, parameters.getContext());
            for (GJaxbProblemInputType actualityInput : parameters.getActualityInput()) {
                PojoActuality.AIActuality aiActualityToComplete = new PojoActuality.AIActuality();
                aiActualityToComplete.actualityName = actualityInput.getProblemName();
                aiActualityToComplete.actualityId = actualityInput.getProblemId();
                if (actualityInput.getProblemType() != null) {
                    if (actualityInput.getProblemType().equals((Object)GJaxbProblemType.TREAT_A_DAMAGE_ACTUALITY)) {
                        aiActualityToComplete.actualityType = PojoActuality.ActualityType.DAMAGE;
                    } else if (actualityInput.getProblemType().equals((Object)GJaxbProblemType.TREAT_A_BENEFIT_ACTUALITY)) {
                        aiActualityToComplete.actualityType = PojoActuality.ActualityType.BENEFIT;
                    }
                }
                if (actualityInput.isSetHasRef() && GJaxbHasReferenceType.YES.equals((Object)actualityInput.getHasRef())) {
                    model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiActualityToComplete.convertToModel(actualityInput, parameters.getContext(), response.getExternalResource(), this));
                    continue;
                }
                PojoActuality.AIActuality aiActualityCompleted = extractor.extractActuality(aiActualityToComplete.toString());
                System.out.println(aiActualityCompleted);
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiActualityCompleted.convertToModel(actualityInput, parameters.getContext(), response.getExternalResource(), this));
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventActualitiesFromPicturesResponse inventActualitiesFromPictures(GJaxbInventActualitiesFromPictures parameters) throws FaultMessage {
        GJaxbInventActualitiesFromPicturesResponse response = new GJaxbInventActualitiesFromPicturesResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbQueryOnPictures request = new GJaxbQueryOnPictures();
            request.setContext(parameters.getContext());
            request.setSystemMessage("    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tproblems: [\n    \t\t\t\t  {\n    \t\t\t\t  \tproblemName: ...,\n    \t\t\t\t\tproblemId: ...,\n    \t\t\t\t\tproblemType: ...,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\timagesId: [...]\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n");
            String instruction = new ServiceOutputParser().outputFormatInstructions(PojoProblem.AIProblems.class);
            request.getUserMessage().add("Are there any danger in these images, if so, what are they ? " + instruction);
            request.getPictureInput().addAll(parameters.getPictureInput());
            GJaxbQueryOnPicturesResponse resp = this.queryOnPictures(request);
            PojoProblem.AIProblems aiProblemsFound = PojoProblem.AIProblems.parse(new JSONObject(resp.getResponse()));
            System.out.println(aiProblemsFound);
            model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiProblemsFound.convertToModel(parameters.getPictureInput(), parameters.getContext(), response.getExternalResource(), this));
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventPotentialitiesResponse inventPotentialities(GJaxbInventPotentialities parameters) throws FaultMessage {
        GJaxbInventPotentialitiesResponse response = null;
        try {
            if (parameters.getPotentialityInput().isSetIsolatedPotentialityInput()) {
                response = this.inventPotentialitiesIsolated(parameters.getPotentialityInput().getIsolatedPotentialityInput(), parameters.getContext());
            } else if (parameters.getPotentialityInput().isSetPotentialityFromPotentialInput()) {
                response = this.inventPotentialitiesFromPotential(parameters.getPotentialityInput().getPotentialityFromPotentialInput(), parameters.getContext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    private GJaxbInventPotentialitiesResponse inventPotentialitiesFromPotential(List<GJaxbInventPotentialities.PotentialityInput.PotentialityFromPotentialInput> potentialityFromPotentialInput, GJaxbContext context) throws Exception {
        GJaxbInventPotentialitiesResponse response = new GJaxbInventPotentialitiesResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoPotentiality.PotentialityExtractor extractor = this.getExtractor(PojoPotentiality.PotentialityExtractor.class, context);
            for (GJaxbInventPotentialities.PotentialityInput.PotentialityFromPotentialInput input : potentialityFromPotentialInput) {
                PojoPotential.AIPotential potential = new PojoPotential.AIPotential();
                potential.potentialId = input.getPotential().getNode().getId();
                potential.potentialName = GenericModelHelper.getName((GJaxbNode)input.getPotential().getNode());
                potential.description = GenericModelHelper.findProperty((String)"description", (List)input.getPotential().getNode().getProperty(), (boolean)true).getValue();
                potential.susceptibleAssets = new ArrayList<PojoAsset.AIAsset>();
                PojoAsset.AIAsset susceptibleAsset = new PojoAsset.AIAsset();
                susceptibleAsset.assetId = input.getSusceptibleAsset().getNode().getId();
                susceptibleAsset.assetName = GenericModelHelper.getName((GJaxbNode)input.getSusceptibleAsset().getNode());
                susceptibleAsset.assetType = PojoAsset.AssetType.valueOf(input.getSusceptibleAsset().getNode().getType().getLocalPart().toString());
                potential.susceptibleAssets.add(susceptibleAsset);
                PojoPotentiality.AIPotentialities aiPotentialities = extractor.extractPotentialitiesFromPotential(potential.toString());
                System.out.println(aiPotentialities);
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiPotentialities.convertToModel(input, context, this));
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public GJaxbInventPotentialitiesResponse inventPotentialitiesIsolated(List<GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput> isolatedPotentialityInputs, GJaxbContext context) throws Exception {
        GJaxbInventPotentialitiesResponse response = new GJaxbInventPotentialitiesResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoPotentiality.PotentialityExtractor extractor = this.getExtractor(PojoPotentiality.PotentialityExtractor.class, context);
            for (GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput isolatedPotentialityInput : isolatedPotentialityInputs) {
                PojoPotentiality.AIPotentiality aiPotentialityToComplete = new PojoPotentiality.AIPotentiality();
                aiPotentialityToComplete.potentialityName = isolatedPotentialityInput.getPotentiality().getProblemName();
                aiPotentialityToComplete.potentialityId = isolatedPotentialityInput.getPotentiality().getProblemId();
                if (isolatedPotentialityInput.getPotentiality().getProblemType() != null) {
                    if (isolatedPotentialityInput.getPotentiality().getProblemType().equals((Object)GJaxbProblemType.PREVENT_A_RISK)) {
                        aiPotentialityToComplete.potentialityType = PojoPotentiality.PotentialityType.RISK;
                    } else if (isolatedPotentialityInput.getPotentiality().getProblemType().equals((Object)GJaxbProblemType.OFFER_AN_OPPORTUNITY)) {
                        aiPotentialityToComplete.potentialityType = PojoPotentiality.PotentialityType.OPPORTUNITY;
                    }
                }
                PojoPotentiality.AIPotentiality aiPotentialityCompleted = extractor.extractPotentiality(aiPotentialityToComplete.toString());
                System.out.println(aiPotentialityCompleted);
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiPotentialityCompleted.convertToModel(isolatedPotentialityInput, context, (List<GJaxbExternalResourceType>)response.getExternalResource(), this));
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventPotentialResponse inventPotential(GJaxbInventPotential parameters) throws FaultMessage {
        GJaxbInventPotentialResponse response = new GJaxbInventPotentialResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            ArrayList<PojoAsset.AIAsset> assets = new ArrayList<PojoAsset.AIAsset>();
            PojoPotential.PotentialExtractor extractor = this.getExtractor(PojoPotential.PotentialExtractor.class, parameters.getContext());
            for (GJaxbInventPotential.PotentialInput input : parameters.getPotentialInput()) {
                PojoAsset.AIAsset asset = new PojoAsset.AIAsset();
                asset.assetId = input.getFromAsset().getNode().getId();
                asset.assetName = GenericModelHelper.getName((GJaxbNode)input.getFromAsset().getNode());
                asset.assetType = PojoAsset.AssetType.valueOf(input.getFromAsset().getNode().getType().getLocalPart());
                asset.assetDescription = GenericModelHelper.findProperty((String)"description", (List)input.getFromAsset().getNode().getProperty(), (boolean)true).getValue();
                assets.add(asset);
            }
            PojoPotential.AIPotentials aiPotentialsCompleted = extractor.extractPotentialFromAssets(((Object)assets).toString());
            System.out.println(aiPotentialsCompleted);
            model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiPotentialsCompleted.convertToModel(parameters.getPotentialInput(), parameters.getContext(), this));
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventPersonsResponse inventPersons(GJaxbInventPersons parameters) throws FaultMessage {
        GJaxbInventPersonsResponse response = new GJaxbInventPersonsResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            fr.emac.gind.gov.core_gov.GJaxbQuery query = new fr.emac.gind.gov.core_gov.GJaxbQuery();
            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            query.getSelectedKnowledgeSpace().setCollaborationName(parameters.getContext().getCurrentCollaborationName());
            query.getSelectedKnowledgeSpace().setKnowledgeName(parameters.getContext().getCurrentKnowledgeSpaceName());
            query.setQuery("match (p:`" + String.valueOf(GenericModelHelper.collab((String)"Person")) + "`) return p;");
            fr.emac.gind.gov.core_gov.GJaxbQueryResponse queryResp = this.coreGovClient.query(query);
            ArrayList<String> avoidsNames = new ArrayList<String>();
            if (queryResp.getSingle() != null && queryResp.getSingle().getGenericModel() != null) {
                for (GJaxbNode node : queryResp.getSingle().getGenericModel().getNode()) {
                    avoidsNames.add(GenericModelHelper.getName((GJaxbNode)node));
                }
            }
            PojoPerson.PersonExtractor extractor = this.getExtractor(PojoPerson.PersonExtractor.class, parameters.getContext());
            for (GJaxbPersonInput input : parameters.getPersonInput()) {
                PojoPerson.AIGroupOfPersons aiGroup = new PojoPerson.AIGroupOfPersons();
                aiGroup.groupId = input.getGroupId();
                aiGroup.numberOfPersonsInGroup = input.getNumber();
                aiGroup.avoidNames = avoidsNames;
                PojoPerson.AIGroupOfPersons aiGroupCompleted = extractor.extractGroupOfPersons(aiGroup.toString());
                System.out.println(aiGroupCompleted);
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiGroupCompleted.convertToModel(input, parameters.getContext(), response.getExternalResource(), this));
                List newPersons = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Person"), (List)model.getNode());
                for (GJaxbNode node : newPersons) {
                    avoidsNames.add(GenericModelHelper.getName((GJaxbNode)node));
                }
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventGoodsResponse inventGoods(GJaxbInventGoods parameters) throws FaultMessage {
        GJaxbInventGoodsResponse response = new GJaxbInventGoodsResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoGood.GoodExtractor extractor = this.getExtractor(PojoGood.GoodExtractor.class, parameters.getContext());
            for (GJaxbGoodInput input : parameters.getGoodInput()) {
                PojoGood.AIGroupOfGoods aiGroup = new PojoGood.AIGroupOfGoods();
                aiGroup.groupId = input.getGroupId();
                aiGroup.numberOfPGoodsInGroup = input.getNumber();
                for (GJaxbRole r : input.getRole()) {
                    aiGroup.model = GenericModelHelper.getName((GJaxbNode)r.getNode()) + ", ";
                }
                aiGroup.model = aiGroup.model.substring(0, aiGroup.model.length() - ", ".length());
                PojoGood.AIGroupOfGoods aiGroupCompleted = null;
                if (input.isUseAIForGroupOfGoods()) {
                    aiGroupCompleted = extractor.extractGroupOfGoods(aiGroup.toString());
                    System.out.println(aiGroupCompleted);
                } else {
                    aiGroupCompleted = new PojoGood.AIGroupOfGoods();
                    aiGroupCompleted.goods = new ArrayList<PojoGood.AIGood>();
                    for (int i = 1; i <= aiGroup.numberOfPGoodsInGroup; ++i) {
                        PojoGood.AIGood good = new PojoGood.AIGood();
                        good.model = aiGroup.model;
                        good.name = aiGroup.model + " " + i;
                        aiGroupCompleted.goods.add(good);
                    }
                }
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiGroupCompleted.convertToModel(input, parameters.getContext(), response.getExternalResource(), this));
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbInventTerritoriesResponse inventTerritories(GJaxbInventTerritories parameters) throws FaultMessage {
        GJaxbInventTerritoriesResponse response = new GJaxbInventTerritoriesResponse();
        if (this.geoApiContext != null) {
            return this.inventTerritoriesByGoogleMaps(parameters);
        }
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            PojoTerritory.TerritoryExtractor extractor = this.getExtractor(PojoTerritory.TerritoryExtractor.class, parameters.getContext());
            for (GJaxbAddressInput input : parameters.getAddressInput()) {
                PojoTerritory.AITerritory territoryToComplete = new PojoTerritory.AITerritory();
                territoryToComplete.territoryName = input.getName();
                territoryToComplete.territoryType = input.getType();
                PojoTerritory.AITerritory territoryCompleted = extractor.extractTerritory(territoryToComplete.toString());
                System.out.println(territoryCompleted);
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)territoryCompleted.convertToModel(input, parameters.getContext(), response.getExternalResource(), this));
            }
            GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            response.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    private GJaxbInventTerritoriesResponse inventTerritoriesByGoogleMaps(GJaxbInventTerritories parameters) throws FaultMessage {
        GJaxbInventTerritoriesResponse res = new GJaxbInventTerritoriesResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbEffectiveConceptType concept = EffectiveMetaModelPluginManager.getInstance().getConceptByType(GenericModelHelper.collab((String)"Territory"));
            String fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
            String strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            for (GJaxbAddressInput input : parameters.getAddressInput()) {
                if (input.getGooglePlaceId() != null && !input.getGooglePlaceId().isBlank()) {
                    PlaceDetailsRequest resultPlace = PlacesApi.placeDetails((GeoApiContext)this.geoApiContext, (String)input.getGooglePlaceId());
                    PlaceDetails resultPlaceDetails = null;
                    try {
                        resultPlaceDetails = (PlaceDetails)resultPlace.await();
                    }
                    catch (Exception e) {
                        LOG.warn("Impossible to realize 'placeDetails' methods on " + input.getName(), (Throwable)e);
                    }
                    GJaxbNode territory = PojoTerritory.createAddressFromPlaceDetails(this.geoApiContext, res.getExternalResource(), concept, fillColor, strokeColor, input, resultPlaceDetails);
                    model.getNode().add(territory);
                    fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
                    strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
                    continue;
                }
                if (input.getAddress() == null || input.getAddress().isBlank()) {
                    throw new Exception("Addres cannot be null or empty !!!");
                }
                PlacesSearchResponse results = (PlacesSearchResponse)PlacesApi.textSearchQuery((GeoApiContext)this.geoApiContext, (String)(input.getAddress() + " (" + input.getType().toString().toLowerCase() + ")")).await();
                if (results == null) continue;
                if (results.results.length > 1 || parameters.isForceUnpreciseQuery()) {
                    res.setUnpreciseQuery(new GJaxbInventTerritoriesResponse.UnpreciseQuery());
                    GJaxbUnpreciseAddressInput uti = new GJaxbUnpreciseAddressInput();
                    uti.setId(input.getId());
                    uti.setName(input.getName());
                    uti.setAddress(input.getAddress());
                    uti.setType(input.getType());
                    uti.setGooglePlaceId(input.getGooglePlaceId());
                    res.getUnpreciseQuery().getUnpreciseAddressInput().add(uti);
                    for (int i = 0; i < results.results.length; ++i) {
                        PlacesSearchResult resPlace = results.results[i];
                        GJaxbUnpreciseAddressInput.PlaceSearchResult rp = new GJaxbUnpreciseAddressInput.PlaceSearchResult();
                        rp.setName(resPlace.name);
                        rp.setAddress(resPlace.formattedAddress);
                        rp.setIcon(resPlace.icon.toString());
                        rp.setGooglePlaceId(resPlace.placeId);
                        rp.getType().addAll(Arrays.asList(resPlace.types));
                        uti.getPlaceSearchResult().add(rp);
                    }
                    continue;
                }
                if (results.results.length != 1) continue;
                PlacesSearchResult resPlace1 = results.results[0];
                PlaceDetailsRequest resultPlace1 = PlacesApi.placeDetails((GeoApiContext)this.geoApiContext, (String)resPlace1.placeId);
                PlaceDetails resultPlaceDetails = (PlaceDetails)resultPlace1.await();
                GJaxbNode territory = PojoTerritory.createAddressFromPlaceDetails(this.geoApiContext, res.getExternalResource(), concept, fillColor, strokeColor, input, resultPlaceDetails);
                model.getNode().add(territory);
                fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
                strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            }
            res.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbSimilarityLevelResponse similarityLevel(GJaxbSimilarityLevel parameters) throws FaultMessage {
        GJaxbSimilarityLevelResponse response = new GJaxbSimilarityLevelResponse();
        GJaxbQuery request = new GJaxbQuery();
        request.setContext(parameters.getContext());
        for (GJaxbSimilarityLevel.SimilarityLevelInput input : parameters.getSimilarityLevelInput()) {
            if (input.getSimilarAnalysisTypeSelected().equals((Object)GJaxbSimilarAnalysisType.SYNTACTIC)) {
                StringMetric metric = null;
                if (input.getSyntacticMethodSelected().equals((Object)GJaxbSyntacticMethodType.COSINE)) {
                    metric = StringMetrics.cosineSimilarity();
                } else if (input.getSyntacticMethodSelected().equals((Object)GJaxbSyntacticMethodType.DICE)) {
                    metric = StringMetrics.dice();
                } else if (input.getSyntacticMethodSelected().equals((Object)GJaxbSyntacticMethodType.EUCLIDEAN_DISTANCE)) {
                    metric = StringMetrics.euclideanDistance();
                } else if (input.getSyntacticMethodSelected().equals((Object)GJaxbSyntacticMethodType.JACCARD)) {
                    metric = StringMetrics.jaccard();
                } else if (input.getSyntacticMethodSelected().equals((Object)GJaxbSyntacticMethodType.LEVENSHTEIN)) {
                    metric = StringMetrics.levenshtein();
                }
                if (metric == null) continue;
                GJaxbSimilarityLevelResponse.SimilarityLevelOutput output = new GJaxbSimilarityLevelResponse.SimilarityLevelOutput();
                output.setSimilarityId(input.getSimilarityId());
                output.setSourceSentence(new GJaxbSimilarityLevelResponse.SimilarityLevelOutput.SourceSentence());
                output.getSourceSentence().setId(input.getSourceSentence().getId());
                output.getSourceSentence().setSentence(input.getSourceSentence().getSentence());
                for (GJaxbSimilarityLevel.SimilarityLevelInput.TargetSentence ts : input.getTargetSentence()) {
                    if (input.getSourceSentence().getId().equals(ts.getId())) continue;
                    float syntacticLevel = metric.compare(input.getSourceSentence().getSentence(), ts.getSentence());
                    GJaxbSimilarityLevelResponse.SimilarityLevelOutput.TargetSentence target = new GJaxbSimilarityLevelResponse.SimilarityLevelOutput.TargetSentence();
                    target.setId(ts.getId());
                    target.setSentence(ts.getSentence());
                    target.setSyntacticLevel(Float.valueOf(syntacticLevel));
                    output.getTargetSentence().add(target);
                }
                Collections.sort(output.getTargetSentence(), new Comparator<GJaxbSimilarityLevelResponse.SimilarityLevelOutput.TargetSentence>(this){

                    @Override
                    public int compare(GJaxbSimilarityLevelResponse.SimilarityLevelOutput.TargetSentence o1, GJaxbSimilarityLevelResponse.SimilarityLevelOutput.TargetSentence o2) {
                        return o1.getSyntacticLevel().compareTo(o2.getSyntacticLevel());
                    }
                });
                Collections.reverse(output.getTargetSentence());
                response.getSimilarityLevelOutput().add(output);
                continue;
            }
            if (!input.getSimilarAnalysisTypeSelected().equals((Object)GJaxbSimilarAnalysisType.SEMANTIC) || !input.getSemanticMethodSelected().equals((Object)GJaxbSemanticMethodType.IA)) continue;
            ArrayList targetSentencesArray = new ArrayList();
            input.getTargetSentence().forEach(s -> {
                if (!s.getId().equals(input.getSourceSentence().getId())) {
                    JSONObject ts = new JSONObject();
                    ts.put("target_id", (Object)s.getId());
                    ts.put("target_sentence", (Object)s.getSentence());
                    targetSentencesArray.add(ts.toString());
                }
            });
            request.setSystemMessage("You are an expert in semantic.\nThe output must be formatted in a valid json array with at most the four best solution ordered by the semanctic level found like that:\n{\n\tsemanticResearchs: [\n\t\t{\n\t\t\ttarget_id: ...(string),\n\t\t  \ttarget_sentence: ...(string),\n\t\t  \tsemantic_level: ... (float between 0.00 and 1.00),\n\t\t  \texplanation: ... (string)\n\t\t},\n\t\t...\n\t]\n}\n");
            request.getUserMessage().add("Among the following list of sentences: " + String.valueOf(targetSentencesArray) + " (targetSentences), which one is semantically closest to this sentence: '" + input.getSourceSentence().getSentence() + " (sourceSentence)'  ?");
            System.out.println("Query (similarityLevel): \n" + String.valueOf(request.getUserMessage()));
            GJaxbQueryResponse resp = this.query(request);
            String jsonResponse = resp.getResponse();
            System.out.println("\n\nJSON Response: \n" + jsonResponse);
            JSONObject semanticResearchs = new JSONObject(jsonResponse);
            JSONArray semanticsArray = semanticResearchs.getJSONArray("semanticResearchs");
            try {
                GJaxbSimilarityLevelResponse.SimilarityLevelOutput output = new GJaxbSimilarityLevelResponse.SimilarityLevelOutput();
                output.setSimilarityId(input.getSimilarityId());
                output.setSourceSentence(new GJaxbSimilarityLevelResponse.SimilarityLevelOutput.SourceSentence());
                output.getSourceSentence().setId(input.getSourceSentence().getId());
                output.getSourceSentence().setId(input.getSourceSentence().getSentence());
                for (int i = 0; i < semanticsArray.length(); ++i) {
                    JSONObject semantic = semanticsArray.getJSONObject(i);
                    GJaxbSimilarityLevelResponse.SimilarityLevelOutput.TargetSentence target = new GJaxbSimilarityLevelResponse.SimilarityLevelOutput.TargetSentence();
                    target.setId(semantic.getString("target_id"));
                    target.setSentence(semantic.getString("target_sentence"));
                    target.setSemanticLevel(Float.valueOf((float)semantic.getDouble("semantic_level")));
                    target.setExplanation(semantic.getString("explanation"));
                    output.getTargetSentence().add(target);
                }
                response.getSimilarityLevelOutput().add(output);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FaultMessage(e.getMessage(), null, (Throwable)e);
            }
        }
        return response;
    }

    public GJaxbInventGroupsResponse inventGroups(GJaxbInventGroups parameters) throws FaultMessage {
        GJaxbInventGroupsResponse resp = new GJaxbInventGroupsResponse();
        GJaxbGenericModel model = new GJaxbGenericModel();
        resp.setGenericModel(model);
        try {
            for (GJaxbInventGroups.GroupInput groupInput : parameters.getGroupInput()) {
                GJaxbExternalResourceType company;
                boolean hasPicture = false;
                GJaxbNode group = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Group"));
                group.setBrokenEdges(new GJaxbNode.BrokenEdges());
                GenericModelHelper.findProperty((String)"name", (List)group.getProperty(), (boolean)true).setValue(groupInput.getGroupName());
                if (groupInput.getGroupAddress() != null) {
                    GenericModelHelper.findProperty((String)"address", (List)group.getProperty(), (boolean)true).setValue(groupInput.getGroupAddress());
                }
                GenericModelHelper.findProperty((String)"color", (List)group.getProperty(), (boolean)true).setValue(ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor()));
                if (this.geoApiContext != null && groupInput.getGroupAddress() != null && !groupInput.getGroupAddress().isBlank()) {
                    PlacesSearchResponse results = (PlacesSearchResponse)PlacesApi.textSearchQuery((GeoApiContext)this.geoApiContext, (String)(groupInput.getGroupName() + ", " + groupInput.getGroupAddress())).await();
                    if (results != null && results.results.length > 0) {
                        PlacesSearchResult resPlace = results.results[0];
                        GeocodingResult[] detail = (GeocodingResult[])GeocodingApi.newRequest((GeoApiContext)this.geoApiContext).place(resPlace.placeId).await();
                        if (detail != null && detail.length > 0) {
                            if (resPlace.photos != null && resPlace.photos.length > 0) {
                                ImageResult img = (ImageResult)PlacesApi.photo((GeoApiContext)this.geoApiContext, (String)resPlace.photos[0].photoReference).maxWidth(48).maxHeight(48).await();
                                GJaxbExternalResourceType extRsc = new GJaxbExternalResourceType();
                                extRsc.setId(group.getId() + "::picture");
                                extRsc.setContentType(img.contentType);
                                extRsc.setData(img.imageData);
                                resp.getExternalResource().add(extRsc);
                                hasPicture = true;
                            }
                            group.setGeolocation(new GJaxbNode.Geolocation());
                            GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
                            iv.setPoint(new GJaxbPointType());
                            iv.getPoint().setLatitude(Double.valueOf(detail[0].geometry.location.lat));
                            iv.getPoint().setLongitude(Double.valueOf(detail[0].geometry.location.lng));
                            group.getGeolocation().getItemView().add(iv);
                        }
                    }
                } else if (groupInput.getGroupTerritory() != null && groupInput.getGroupTerritory().getNode() != null) {
                    Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromGJaxbNode(groupInput.getGroupTerritory().getNode()).get(0);
                    Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
                    group.setGeolocation(new GJaxbNode.Geolocation());
                    GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
                    iv.setPoint(new GJaxbPointType());
                    iv.getPoint().setLatitude(Double.valueOf(randomPoint.getY()));
                    iv.getPoint().setLongitude(Double.valueOf(randomPoint.getX()));
                    group.getGeolocation().getItemView().add(iv);
                }
                ArrayList<GJaxbNode> existingRolesOfGroup = new ArrayList<GJaxbNode>();
                for (GJaxbInventGroups.GroupInput.GroupRole role : groupInput.getGroupRole()) {
                    GJaxbEdge hasRole = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Has"));
                    hasRole.setSource(group);
                    hasRole.setTarget(role.getNode());
                    model.getEdge().add(hasRole);
                    GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
                    be.setEdge(hasRole);
                    be.setSourceId(group.getId());
                    be.setTargetId(role.getNode().getId());
                    group.getBrokenEdges().getBrokenEdge().add(be);
                    model.getNode().add(role.getNode());
                    existingRolesOfGroup.add(role.getNode());
                }
                if (groupInput.getGroupDef() != null && !groupInput.getGroupDef().isEmpty()) {
                    ArrayList<GJaxbPersonInput> groupOfPersonsList = new ArrayList<GJaxbPersonInput>();
                    ArrayList<GJaxbGoodInput> groupOfGoodsList = new ArrayList<GJaxbGoodInput>();
                    for (GJaxbInventGroups.GroupInput.GroupDef groupDef : groupInput.getGroupDef()) {
                        if (groupDef.getGroupType().equals((Object)GJaxbGroupType.GROUP_OF_PERSONS)) {
                            groupOfPersonsList.add(groupDef.getPersonInput());
                            continue;
                        }
                        groupOfGoodsList.add(groupDef.getGoodInput());
                    }
                    if (!groupOfPersonsList.isEmpty()) {
                        Object person2;
                        GJaxbInventPersons reqPers = new GJaxbInventPersons();
                        reqPers.getPersonInput().addAll(groupOfPersonsList);
                        reqPers.setContext(parameters.getContext());
                        respPers = this.inventPersons(reqPers);
                        model.getNode().addAll(respPers.getGenericModel().getNode());
                        model.getEdge().addAll(respPers.getGenericModel().getEdge());
                        List persons = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Person"), (List)respPers.getGenericModel().getNode());
                        for (Object person2 : persons) {
                            has = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Has"));
                            has.setSource(group);
                            has.setTarget((GJaxbNode)person2);
                            model.getEdge().add(has);
                        }
                        rolesOfPersonGroups = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Role"), (List)respPers.getGenericModel().getNode());
                        person2 = rolesOfPersonGroups.iterator();
                        while (person2.hasNext()) {
                            personRole = (GJaxbNode)person2.next();
                            if (GenericModelHelper.contains((GJaxbNode)personRole, existingRolesOfGroup)) continue;
                            hasRole = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Has"));
                            hasRole.setSource(group);
                            hasRole.setTarget(personRole);
                            model.getEdge().add(hasRole);
                            be = new GJaxbNode.BrokenEdges.BrokenEdge();
                            be.setEdge(hasRole);
                            be.setSourceId(group.getId());
                            be.setTargetId(personRole.getId());
                            group.getBrokenEdges().getBrokenEdge().add(be);
                            existingRolesOfGroup.add(personRole);
                        }
                        resp.getExternalResource().addAll(respPers.getExternalResource());
                    } else {
                        GJaxbInventGoods reqGoods = new GJaxbInventGoods();
                        reqGoods.getGoodInput().addAll(groupOfGoodsList);
                        reqGoods.setContext(parameters.getContext());
                        respPers = this.inventGoods(reqGoods);
                        model.getNode().addAll(respPers.getGenericModel().getNode());
                        model.getEdge().addAll(respPers.getGenericModel().getEdge());
                        List goods = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Good"), (List)respPers.getGenericModel().getNode());
                        for (GJaxbNode good : goods) {
                            has = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Has"));
                            has.setSource(group);
                            has.setTarget(good);
                            model.getEdge().add(has);
                        }
                        rolesOfPersonGroups = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Role"), (List)respPers.getGenericModel().getNode());
                        Iterator iterator = rolesOfPersonGroups.iterator();
                        while (iterator.hasNext()) {
                            personRole = (GJaxbNode)iterator.next();
                            if (GenericModelHelper.contains((GJaxbNode)personRole, existingRolesOfGroup)) continue;
                            hasRole = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Has"));
                            hasRole.setSource(group);
                            hasRole.setTarget(personRole);
                            model.getEdge().add(hasRole);
                            be = new GJaxbNode.BrokenEdges.BrokenEdge();
                            be.setEdge(hasRole);
                            be.setSourceId(group.getId());
                            be.setTargetId(personRole.getId());
                            group.getBrokenEdges().getBrokenEdge().add(be);
                            existingRolesOfGroup.add(personRole);
                        }
                        resp.getExternalResource().addAll(respPers.getExternalResource());
                    }
                }
                if (!hasPicture && !existingRolesOfGroup.isEmpty() && (company = PhotosHelper.getInstance().getRandomPhotos(GenericModelHelper.getName((GJaxbNode)((GJaxbNode)existingRolesOfGroup.get(0))) + "'s office")) != null) {
                    company.setId(group.getId() + "::picture");
                    resp.getExternalResource().add(company);
                }
                model.getNode().add(group);
                GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
                GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    public GJaxbInventSensorsResponse inventSensors(GJaxbInventSensors parameters) throws FaultMessage {
        GJaxbInventSensorsResponse resp = new GJaxbInventSensorsResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            for (GJaxbInventSensors.SensorInput si : parameters.getSensorInput()) {
                int number = si.getNumber();
                for (int indexSensor = 0; indexSensor < number; ++indexSensor) {
                    GJaxbNode sensor = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.core((String)"Sensor"));
                    sensor.setBrokenEdges(new GJaxbNode.BrokenEdges());
                    GenericModelHelper.findProperty((String)"type", (List)sensor.getProperty(), (boolean)true).setValue(si.getType().toString());
                    Color borderColor = ColorHelper.randomBrighterColor();
                    if (si.getType().equals((Object)GJaxbSensorType.SPATIAL)) {
                        indexNature = this.sensorNatureMap.get(si.getType().toString());
                        if (indexNature == null) {
                            indexNature = 0;
                            this.sensorNatureMap.put(si.getType().toString(), indexNature);
                        }
                        Integer n = indexNature;
                        indexNature = indexNature + 1;
                        name = si.getType().toString().replaceAll("_", " ").toLowerCase() + " sensor " + indexNature;
                        this.sensorNatureMap.put(si.getType().toString(), indexNature);
                        GenericModelHelper.findProperty((String)"name", (List)sensor.getProperty(), (boolean)true).setValue((String)name);
                        sensorUrl = PojoSensor.getSensorUrl(si);
                        PojoSensor.setSensorImageModeling(sensor, sensorUrl);
                        PojoSensor.setGeolocOnSensor(this.geoApiContext, si, sensor, sensorUrl, model);
                        PojoSensor.setPilots(si, sensor, model);
                    } else if (si.getType().equals((Object)GJaxbSensorType.QUANTITATIVE)) {
                        indexNature = this.sensorNatureMap.get(si.getNature().getQuantitativeNature().toString());
                        if (indexNature == null) {
                            indexNature = 0;
                            this.sensorNatureMap.put(si.getNature().getQuantitativeNature().toString(), indexNature);
                        }
                        name = indexNature;
                        indexNature = indexNature + 1;
                        this.sensorNatureMap.put(si.getNature().getQuantitativeNature().toString(), indexNature);
                        sensorName = si.getNature().getQuantitativeNature().toString().replaceAll("_", " ").toLowerCase() + " sensor " + indexNature;
                        if (si.getQuantitativeInput().isSetNameForOther()) {
                            sensorName = si.getQuantitativeInput().getNameForOther();
                        }
                        GenericModelHelper.findProperty((String)"name", (List)sensor.getProperty(), (boolean)true).setValue((String)sensorName);
                        GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getQuantitativeNature().toString());
                        PojoSensor.createThresholds(sensor, si.getQuantitativeInput().getThreshold());
                        if (si.getQuantitativeInput().getUnit() != null) {
                            GenericModelHelper.findProperty((String)"unit", (List)sensor.getProperty(), (boolean)true).setValue(si.getQuantitativeInput().getUnit().toString());
                        }
                        sensorUrl = PojoSensor.getSensorUrl(si);
                        PojoSensor.setSensorImageModeling(sensor, sensorUrl);
                        PojoSensor.setGeolocOnSensor(this.geoApiContext, si, sensor, sensorUrl, model);
                        PojoSensor.setPilots(si, sensor, model);
                    } else if (si.getType().equals((Object)GJaxbSensorType.SOCIAL)) {
                        indexNature = this.sensorNatureMap.get(si.getNature().getSocialNature().toString());
                        if (indexNature == null) {
                            indexNature = 0;
                            this.sensorNatureMap.put(si.getNature().getSocialNature().toString(), indexNature);
                        }
                        sensorName = indexNature;
                        indexNature = indexNature + 1;
                        this.sensorNatureMap.put(si.getNature().getSocialNature().toString(), indexNature);
                        GenericModelHelper.findProperty((String)"name", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getSocialNature().toString().replaceAll("_", " ").toLowerCase() + " sensor " + indexNature);
                        GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getSocialNature().toString());
                        sensorUrl = PojoSensor.getSensorUrl(si);
                        PojoSensor.setSensorImageModeling(sensor, (String)sensorUrl);
                        PojoSensor.setGeolocOnSensor(this.geoApiContext, si, sensor, (String)sensorUrl, model);
                        PojoSensor.setPilots(si, sensor, model);
                    } else if (si.getType().equals((Object)GJaxbSensorType.MEDIA)) {
                        indexNature = this.sensorNatureMap.get(si.getNature().getMediaNature().toString());
                        if (indexNature == null) {
                            indexNature = 0;
                            this.sensorNatureMap.put(si.getNature().getMediaNature().toString(), indexNature);
                        }
                        sensorUrl = indexNature;
                        indexNature = indexNature + 1;
                        this.sensorNatureMap.put(si.getNature().getMediaNature().toString(), indexNature);
                        GenericModelHelper.findProperty((String)"name", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getMediaNature().toString().replaceAll("_", " ").toLowerCase() + " sensor " + indexNature);
                        GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getMediaNature().toString());
                        sensorUrl = PojoSensor.getSensorUrl(si);
                        PojoSensor.setSensorImageModeling(sensor, (String)sensorUrl);
                        PojoSensor.setGeolocOnSensor(this.geoApiContext, si, sensor, (String)sensorUrl, model);
                        PojoSensor.setPilots(si, sensor, model);
                    } else if (si.getType().equals((Object)GJaxbSensorType.DEDICATED)) {
                        indexNature = this.sensorNatureMap.get(si.getNature().getDedicatedNature().toString());
                        if (indexNature == null) {
                            indexNature = 0;
                            this.sensorNatureMap.put(si.getNature().getDedicatedNature().toString(), indexNature);
                        }
                        sensorUrl = indexNature;
                        indexNature = indexNature + 1;
                        this.sensorNatureMap.put(si.getNature().getDedicatedNature().toString(), indexNature);
                        name = si.getNature().getDedicatedNature().toString().replaceAll("_", " ").toLowerCase() + " sensor " + indexNature;
                        this.sensorNatureMap.put(si.getNature().getDedicatedNature().toString(), indexNature);
                        GenericModelHelper.findProperty((String)"name", (List)sensor.getProperty(), (boolean)true).setValue((String)name);
                        GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getDedicatedNature().toString());
                        sensorUrl = PojoSensor.getSensorUrl(si);
                        PojoSensor.setSensorImageModeling(sensor, sensorUrl);
                        PojoSensor.setGeolocOnSensor(this.geoApiContext, si, sensor, sensorUrl, model);
                        if (si.getNature().getDedicatedNature().equals((Object)GJaxbSensorNatureDedicatedType.RADAR)) {
                            if (!sensor.isSetGeolocation()) {
                                sensor.setGeolocation(new GJaxbNode.Geolocation());
                            }
                            GJaxbNode.Geolocation.ItemView iv = null;
                            if (sensor.getGeolocation().getItemView().isEmpty()) {
                                iv = new GJaxbNode.Geolocation.ItemView();
                                sensor.getGeolocation().getItemView().add(iv);
                            } else {
                                iv = (GJaxbNode.Geolocation.ItemView)sensor.getGeolocation().getItemView().get(0);
                            }
                            iv.setArea(new GJaxbArea());
                            iv.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                            iv.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                            iv.getSpecificGeolocation().getNodeMetaGeolocation().setArea(new GJaxbNodeMetaGeolocation.Area());
                            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillColor(ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor()));
                            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillOpacity(0.4);
                            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeColor(ColorHelper.formatColorToHexaString((Color)borderColor));
                            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeDashArray(null);
                            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeOpacity(1.0);
                            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeWidth(5.0);
                            if (iv.isSetPoint()) {
                                GJaxbPointType center = iv.getPoint();
                                iv.setPoint(null);
                                GJaxbPointType top = new GJaxbPointType();
                                top.setLatitude(Double.valueOf(center.getLatitude() + (double)5.0E-4f));
                                top.setLongitude(center.getLongitude());
                                GJaxbPointType left = new GJaxbPointType();
                                left.setLatitude(center.getLatitude());
                                left.setLongitude(Double.valueOf(center.getLongitude() + (double)5.0E-4f));
                                iv.getArea().getPoint().add(center);
                                iv.getArea().getPoint().add(top);
                                iv.getArea().getPoint().add(left);
                            }
                        }
                        threshold = new GJaxbThreshold();
                        threshold.setType(GJaxbThresholdType.MAX);
                        threshold.setValue(Float.valueOf(1.0f));
                        threshold.setReferencedActualities(si.getDedicatedInput().getReferencedActualities());
                        PojoSensor.createThresholds(sensor, Arrays.asList(threshold));
                        PojoSensor.setPilots(si, sensor, model);
                    } else if (si.getType().equals((Object)GJaxbSensorType.OTHERS)) {
                        indexNature = this.sensorNatureMap.get(si.getNature().getOthersNature().toString());
                        if (indexNature == null) {
                            indexNature = 0;
                            this.sensorNatureMap.put(si.getNature().getOthersNature().toString(), indexNature);
                        }
                        name = indexNature;
                        indexNature = indexNature + 1;
                        this.sensorNatureMap.put(si.getNature().getOthersNature().toString(), indexNature);
                        GenericModelHelper.findProperty((String)"name", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getOthersNature().toString().replaceAll("_", " ").toLowerCase() + " sensor " + indexNature);
                        GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty(), (boolean)true).setValue(si.getNature().getOthersNature().toString());
                        sensorUrl = PojoSensor.getSensorUrl(si);
                        PojoSensor.setSensorImageModeling(sensor, (String)sensorUrl);
                        PojoSensor.setGeolocOnSensor(this.geoApiContext, si, sensor, (String)sensorUrl, model);
                        PojoSensor.setPilots(si, sensor, model);
                        if (si.getNature().getOthersNature().equals((Object)GJaxbSensorNatureOthersType.KNOWLEDGE)) {
                            String ruleCondition = si.getOthersInput().getKnowledgeInput().getThresholdCondition().getCypherCondition();
                            threshold = new GJaxbThreshold();
                            threshold.setRule(ruleCondition);
                            threshold.setReferencedActualities(si.getOthersInput().getKnowledgeInput().getReferencedActualities());
                            PojoSensor.createThresholds(sensor, Arrays.asList(threshold));
                        }
                    }
                    GenericModelHelper.findProperty((String)"color", (List)sensor.getProperty(), (boolean)true).setValue(ColorHelper.formatColorToHexaString((Color)borderColor));
                    model.getNode().add(sensor);
                }
            }
            resp.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    public GJaxbInventPositionFromTerritoryResponse inventPositionFromTerritory(GJaxbInventPositionFromTerritory parameters) throws FaultMessage {
        GJaxbInventPositionFromTerritoryResponse res = new GJaxbInventPositionFromTerritoryResponse();
        try {
            if (parameters.getTerritory().getNode() == null) {
                throw new Exception("Territory cannot be null !!!");
            }
            Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromGJaxbNode(parameters.getTerritory().getNode()).get(0);
            Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
            GJaxbPointType point = new GJaxbPointType();
            point.setLatitude(Double.valueOf(randomPoint.getY()));
            point.setLongitude(Double.valueOf(randomPoint.getX()));
            res.setPoint(point);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbInventTweetsResponse inventTweets(GJaxbInventTweets parameters) throws FaultMessage {
        GJaxbInventTweetsResponse resp = new GJaxbInventTweetsResponse();
        try {
            for (GJaxbInventTweets.TweetInput tweetInput : parameters.getTweetInput()) {
                GJaxbQuery reqti = new GJaxbQuery();
                reqti.setContext(parameters.getContext());
                reqti.setSystemMessage("You are a scenarist.\nThe output must be a valid json format without comments like this:\n\t{\n\t\tid_str: ... (string),\n\t\tcreated_at: ... (date[ISO 8601]),\n\t\ttext: ... (string),\n\t\tcoordinates: {\n\t\t\tcoordinates: [\n\t\t\t\tGPS_latitude_Value_Of_City (number),\n\t\t\t\tGPS_longitude_Value_Of_City (number)\n\t\t\t]\n\t\t}\n\t}\n");
                reqti.getUserMessage().add("Could you create a fake tweet geolocated in any city and describing " + tweetInput.getDescribing() + " in ?");
                GJaxbQueryResponse respti = this.query(reqti);
                String tweetJson = respti.getResponse();
                System.out.println("tweetJson:\n" + tweetJson);
                GJaxbTweetObject tweet = (GJaxbTweetObject)JSONJAXBContext.getInstance().unmarshall("{ \"tweet\" : " + tweetJson + " }", GJaxbTweetObject.class);
                System.out.println("tweet: " + String.valueOf(tweet));
                if (tweetInput.isInventPicture()) {
                    ImageModel imageCreationLanguageModel = ModelBuilderSelector.getInstance().getSelectedImageCreationModel(parameters.getContext());
                    if (imageCreationLanguageModel == null) {
                        GJaxbInventPictures pictReq = new GJaxbInventPictures();
                        pictReq.setContext(parameters.getContext());
                        GJaxbInventPictures.PictureInput pictureInput = new GJaxbInventPictures.PictureInput();
                        pictureInput.setDescription(tweet.getText());
                        pictReq.getPictureInput().add(pictureInput);
                        GJaxbInventPicturesResponse pictResp = this.inventPictures(pictReq);
                        String generatedActalityImgUrl = ((GJaxbInventPicturesResponse.PictureOutput)pictResp.getPictureOutput().get(0)).getPictureUrl();
                        if (generatedActalityImgUrl != null) {
                            GJaxbExternalResourceType actualityRsc = PhotosHelper.uploadUrl(generatedActalityImgUrl, tweet.getIdStr(), "image/png");
                            resp.getExternalResource().add(actualityRsc);
                            tweet.setExtendedEntities(new GJaxbExtendedEntities());
                            GJaxbMediaObject media = new GJaxbMediaObject();
                            media.setIdStr("media_" + String.valueOf(UUID.randomUUID()));
                            media.setType("photo");
                            media.setMediaUrl(generatedActalityImgUrl);
                            tweet.getExtendedEntities().getMedia().add(media);
                        }
                    } else {
                        LOG.warn("Impossible to generate image because Image creation model is not supported on : " + String.valueOf(parameters.getContext().getSelectedAiChatBot()));
                    }
                }
                resp.getTweet().add(tweet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    public GJaxbInventPicturesResponse inventPictures(GJaxbInventPictures parameters) throws FaultMessage {
        GJaxbInventPicturesResponse resp = new GJaxbInventPicturesResponse();
        try {
            ImageModel imageCreationLanguageModel = ModelBuilderSelector.getInstance().getSelectedImageCreationModel(parameters.getContext());
            if (imageCreationLanguageModel == null) {
                throw new Exception("Image creation model not supported on " + String.valueOf(parameters.getContext().getSelectedAiChatBot()));
            }
            for (GJaxbInventPictures.PictureInput pictureInput : parameters.getPictureInput()) {
                Response response = imageCreationLanguageModel.generate(pictureInput.getDescription());
                String generatedActalityImgUrl = ((Image)response.content()).url().toString();
                if (generatedActalityImgUrl == null) continue;
                GJaxbInventPicturesResponse.PictureOutput pictureOutput = new GJaxbInventPicturesResponse.PictureOutput();
                pictureOutput.setPictureId(pictureInput.getPictureId());
                pictureOutput.setPictureUrl(generatedActalityImgUrl);
                resp.getPictureOutput().add(pictureOutput);
                GJaxbExternalResourceType actualityRsc = PhotosHelper.uploadUrl(generatedActalityImgUrl, pictureInput.getPictureId(), "image/png");
                resp.getExternalResource().add(actualityRsc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    public GJaxbInventIotsResponse inventIots(GJaxbInventIots parameters) throws FaultMessage {
        GJaxbInventIotsResponse res = new GJaxbInventIotsResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            res.setGenericModel(model);
            for (GJaxbInventIots.IotInput param : parameters.getIotInput()) {
                if (!param.getType().equals("camera")) continue;
                String name = param.getName();
                GJaxbNode camera = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Good"));
                camera.setBrokenEdges(new GJaxbNode.BrokenEdges());
                GenericModelHelper.findProperty((String)"name", (List)camera.getProperty(), (boolean)true).setValue(name);
                GenericModelHelper.findProperty((String)"iot", (List)camera.getProperty(), (boolean)true).setValue("yes");
                GenericModelHelper.findProperty((String)"type", (List)camera.getProperty(), (boolean)true).setValue("camera");
                GenericModelHelper.findProperty((String)"wsdl", (List)camera.getProperty(), (boolean)true).setValue("/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/context_partners/functions/wsdls/camera.wsdl");
                GenericModelHelper.findProperty((String)"endpoint address", (List)camera.getProperty(), (boolean)true).setValue(this.riopiotAddress + "/" + RegExpHelper.toRegexFriendlyName((String)name));
                GenericModelHelper.findProperty((String)"picture", (List)camera.getProperty(), (boolean)true).setValue("/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/context_partners/camera.png");
                GJaxbTDefinitions wsdl = (GJaxbTDefinitions)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("META-INF/resources/webjars/gind/rio/collaborative_model/images/model/nodes/context_partners/functions/wsdls/camera.wsdl"), GJaxbTDefinitions.class);
                WSDLDefinitionsManager wsdlMan = new WSDLDefinitionsManager(new GJaxbTDefinitions[]{wsdl});
                model.getNode().add(camera);
                GJaxbTPortType portType = wsdlMan.getPortTypes()[0];
                for (GJaxbTOperation op : portType.getOperation()) {
                    GJaxbNode computerFunction = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Function"));
                    computerFunction.setBrokenEdges(new GJaxbNode.BrokenEdges());
                    computerFunction.setId("node_" + wsdl.getTargetNamespace().hashCode() + "_" + op.getName().hashCode());
                    computerFunction.getStatus().clear();
                    computerFunction.getStatus().add(GJaxbStatusType.FREEZE);
                    GenericModelHelper.findProperty((String)"name", (List)computerFunction.getProperty()).setValue(op.getName());
                    GenericModelHelper.findProperty((String)"type", (List)computerFunction.getProperty()).setValue("Computer");
                    model.getNode().add(computerFunction);
                    GJaxbEdge provides = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Provides"));
                    provides.setSource(camera);
                    provides.setTarget(computerFunction);
                    model.getEdge().add(provides);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbInventCodeExplanationResponse inventCodeExplanation(GJaxbInventCodeExplanation parameters) throws FaultMessage {
        GJaxbInventCodeExplanationResponse response;
        block5: {
            response = new GJaxbInventCodeExplanationResponse();
            try {
                if (!parameters.isSetCode() || parameters.getCode().isBlank()) break block5;
                GJaxbQuery request = new GJaxbQuery();
                request.setContext(parameters.getContext());
                request.setSystemMessage("You are an IT engineer.\nThe output must be formatted in a valid json object like that:\n{\n\texplanation: ... (string)\n}\n");
                request.getUserMessage().add("Can you briefly explain (in less than 200 words) the piece of code below written in " + parameters.getLanguage() + " ?: \n" + parameters.getCode());
                System.out.println("Query: \n" + String.valueOf(request.getUserMessage()));
                GJaxbQueryResponse resp = this.query(request);
                String jsonResponse = resp.getResponse();
                System.out.println("\n\nJSON Response: \n" + jsonResponse);
                JSONObject codeExplanationJson = null;
                try {
                    if (jsonResponse == null) {
                        throw new JSONException("No json found in response");
                    }
                    codeExplanationJson = new JSONObject(jsonResponse);
                    String explanation = codeExplanationJson.getString("explanation");
                    response.setExplanation(explanation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return this.inventCodeExplanation(parameters);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FaultMessage(e.getMessage(), null, (Throwable)e);
            }
        }
        return response;
    }

    public GJaxbInventBuildingsResponse inventBuildings(GJaxbInventBuildings parameters) throws FaultMessage {
        GJaxbInventBuildingsResponse res = new GJaxbInventBuildingsResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbEffectiveConceptType concept = EffectiveMetaModelPluginManager.getInstance().getConceptByType(GenericModelHelper.collab((String)"Good"));
            String fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
            String strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            for (GJaxbAddressInput input : parameters.getAddressInput()) {
                if (input.getGooglePlaceId() != null && !input.getGooglePlaceId().isBlank()) {
                    PlaceDetailsRequest resultPlace = PlacesApi.placeDetails((GeoApiContext)this.geoApiContext, (String)input.getGooglePlaceId());
                    PlaceDetails resultPlaceDetails = null;
                    try {
                        resultPlaceDetails = (PlaceDetails)resultPlace.await();
                    }
                    catch (Exception e) {
                        LOG.warn("Impossible to realize 'placeDetails' methods on " + input.getName(), (Throwable)e);
                    }
                    GJaxbNode building = PojoTerritory.createAddressFromPlaceDetails(this.geoApiContext, res.getExternalResource(), concept, fillColor, strokeColor, input, resultPlaceDetails);
                    GenericModelHelper.findProperty((String)"type", (List)building.getProperty(), (boolean)true).setValue("building");
                    model.getNode().add(building);
                    fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
                    strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
                    continue;
                }
                PlacesSearchResponse results = (PlacesSearchResponse)PlacesApi.textSearchQuery((GeoApiContext)this.geoApiContext, (String)(input.getAddress() + " (" + input.getType().toString().toLowerCase() + ")")).await();
                if (results == null) continue;
                if (results.results.length > 1 || parameters.isForceUnpreciseQuery()) {
                    res.setUnpreciseQuery(new GJaxbInventBuildingsResponse.UnpreciseQuery());
                    GJaxbUnpreciseAddressInput uti = new GJaxbUnpreciseAddressInput();
                    uti.setId(input.getId());
                    uti.setName(input.getName());
                    uti.setAddress(input.getAddress());
                    uti.setType(input.getType());
                    uti.setGooglePlaceId(input.getGooglePlaceId());
                    res.getUnpreciseQuery().getUnpreciseAddressInput().add(uti);
                    for (int i = 0; i < results.results.length; ++i) {
                        PlacesSearchResult resPlace = results.results[i];
                        GJaxbUnpreciseAddressInput.PlaceSearchResult rp = new GJaxbUnpreciseAddressInput.PlaceSearchResult();
                        rp.setName(resPlace.name);
                        rp.setAddress(resPlace.formattedAddress);
                        rp.setIcon(resPlace.icon.toString());
                        rp.setGooglePlaceId(resPlace.placeId);
                        rp.getType().addAll(Arrays.asList(resPlace.types));
                        uti.getPlaceSearchResult().add(rp);
                    }
                    continue;
                }
                if (results.results.length != 1) continue;
                PlacesSearchResult resPlace1 = results.results[0];
                PlaceDetailsRequest resultPlace1 = PlacesApi.placeDetails((GeoApiContext)this.geoApiContext, (String)resPlace1.placeId);
                PlaceDetails resultPlaceDetails = (PlaceDetails)resultPlace1.await();
                GJaxbNode building = PojoTerritory.createAddressFromPlaceDetails(this.geoApiContext, res.getExternalResource(), concept, fillColor, strokeColor, input, resultPlaceDetails);
                model.getNode().add(building);
                fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
                strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            }
            res.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbInventRoadsResponse inventRoads(GJaxbInventRoads parameters) throws FaultMessage {
        GJaxbInventRoadsResponse res = new GJaxbInventRoadsResponse();
        try {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbEffectiveConceptType concept = EffectiveMetaModelPluginManager.getInstance().getConceptByType(GenericModelHelper.collab((String)"Good"));
            String fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
            String strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            for (GJaxbAddressInput input : parameters.getAddressInput()) {
                if (input.getGooglePlaceId() != null && !input.getGooglePlaceId().isBlank()) {
                    PlaceDetailsRequest resultPlace = PlacesApi.placeDetails((GeoApiContext)this.geoApiContext, (String)input.getGooglePlaceId());
                    PlaceDetails resultPlaceDetails = null;
                    try {
                        resultPlaceDetails = (PlaceDetails)resultPlace.await();
                    }
                    catch (Exception e) {
                        LOG.warn("Impossible to realize 'placeDetails' methods on " + input.getName(), (Throwable)e);
                    }
                    GJaxbNode road = PojoTerritory.createAddressFromPlaceDetails(this.geoApiContext, res.getExternalResource(), concept, fillColor, strokeColor, input, resultPlaceDetails);
                    model.getNode().add(road);
                    fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
                    strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
                    continue;
                }
                PlacesSearchResponse results = (PlacesSearchResponse)PlacesApi.textSearchQuery((GeoApiContext)this.geoApiContext, (String)(input.getAddress() + " (" + input.getType().toString().toLowerCase() + ")")).await();
                if (results == null) continue;
                if (results.results.length > 1 || parameters.isForceUnpreciseQuery()) {
                    res.setUnpreciseQuery(new GJaxbInventRoadsResponse.UnpreciseQuery());
                    GJaxbUnpreciseAddressInput uti = new GJaxbUnpreciseAddressInput();
                    uti.setId(input.getId());
                    uti.setName(input.getName());
                    uti.setAddress(input.getAddress());
                    uti.setType(input.getType());
                    uti.setGooglePlaceId(input.getGooglePlaceId());
                    res.getUnpreciseQuery().getUnpreciseAddressInput().add(uti);
                    for (int i = 0; i < results.results.length; ++i) {
                        PlacesSearchResult resPlace = results.results[i];
                        GJaxbUnpreciseAddressInput.PlaceSearchResult rp = new GJaxbUnpreciseAddressInput.PlaceSearchResult();
                        rp.setName(resPlace.name);
                        rp.setAddress(resPlace.formattedAddress);
                        rp.setIcon(resPlace.icon.toString());
                        rp.setGooglePlaceId(resPlace.placeId);
                        rp.getType().addAll(Arrays.asList(resPlace.types));
                        uti.getPlaceSearchResult().add(rp);
                    }
                    continue;
                }
                if (results.results.length != 1) continue;
                PlacesSearchResult resPlace1 = results.results[0];
                PlaceDetailsRequest resultPlace1 = PlacesApi.placeDetails((GeoApiContext)this.geoApiContext, (String)resPlace1.placeId);
                PlaceDetails resultPlaceDetails = (PlaceDetails)resultPlace1.await();
                GJaxbNode road = PojoTerritory.createAddressFromPlaceDetails(this.geoApiContext, res.getExternalResource(), concept, fillColor, strokeColor, input, resultPlaceDetails);
                model.getNode().add(road);
                fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
                strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            }
            res.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbLoadDocumentsForRAGResponse loadDocumentsForRAG(GJaxbLoadDocumentsForRAG parameters) throws FaultMessage {
        GJaxbLoadDocumentsForRAGResponse res = new GJaxbLoadDocumentsForRAGResponse();
        try {
            File rag = AIChatbotImpl.getOrCreateRAGDirectory(parameters.getContext());
            for (GJaxbLoadDocumentsForRAG.FileForRAG file : parameters.getFileForRAG()) {
                try {
                    LOG.debug("Add resource on RAG: " + file.getFileName());
                    File ragFileInFolder = new File(rag, file.getFileName());
                    if (ragFileInFolder.exists()) {
                        ragFileInFolder.delete();
                    }
                    FileOutputStream out = new FileOutputStream(ragFileInFolder);
                    String base64Image = Base64.getEncoder().encodeToString(file.getDataEncodedBase64());
                    byte[] decodedFile = Base64.getDecoder().decode(base64Image);
                    FileUtil.copy((InputStream)new ByteArrayInputStream(decodedFile), (OutputStream)out);
                    out.close();
                    Document document = FileSystemDocumentLoader.loadDocument((String)ragFileInFolder.toString(), (DocumentParser)new TextDocumentParser());
                    EmbeddingStoreIngestor.ingest((Document)document, this.embeddingStore);
                    res.getFileDone().add(file.getFileName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    res.getFileError().add(file.getFileName() + " : " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public static File getOrCreateRAGDirectory(GJaxbContext context) {
        File target = new File(RIOConstant.RESOURCES_FOLDER);
        File ragCollab = new File(target, RegExpHelper.toRegexFriendlyName((String)context.getCurrentCollaborationName()));
        File ragKnowledge = new File(ragCollab, RegExpHelper.toRegexFriendlyName((String)context.getCurrentKnowledgeSpaceName()));
        File rag = new File(ragKnowledge, "rag");
        rag.mkdirs();
        return rag;
    }

    public GJaxbExportDocumentsFromRAGResponse exportDocumentsFromRAG(GJaxbExportDocumentsFromRAG parameters) throws FaultMessage {
        GJaxbExportDocumentsFromRAGResponse res = new GJaxbExportDocumentsFromRAGResponse();
        try {
            File[] filesIntoRag;
            File rag = AIChatbotImpl.getOrCreateRAGDirectory(parameters.getContext());
            for (File file : filesIntoRag = FileUtil.getAllFiles((File)rag)) {
                GJaxbExportDocumentsFromRAGResponse.FileIntoRAG fir = new GJaxbExportDocumentsFromRAGResponse.FileIntoRAG();
                fir.setFileName(file.getName());
                fir.setMimeType(FileUtil.getExtension((String)file.getName()));
                fir.setDataEncodedBase64(FileUtils.readFileToByteArray((File)file));
                res.getFileIntoRAG().add(fir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbRestoreRAGFromDirectoryResponse restoreRAGFromDirectory(GJaxbRestoreRAGFromDirectory parameters) throws FaultMessage {
        GJaxbRestoreRAGFromDirectoryResponse res = new GJaxbRestoreRAGFromDirectoryResponse();
        try {
            File[] filesIntoRag;
            File rag = AIChatbotImpl.getOrCreateRAGDirectory(parameters.getContext());
            for (File file : filesIntoRag = FileUtil.getAllFiles((File)rag)) {
                try {
                    LOG.debug("Add resource on RAG: " + file.getName());
                    Document document = FileSystemDocumentLoader.loadDocument((Path)file.toPath(), (DocumentParser)new TextDocumentParser());
                    EmbeddingStoreIngestor.ingest((Document)document, this.embeddingStore);
                    res.getFileDone().add(file.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    res.getFileError().add(file.getName() + " : " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbInventProblemsFromNewsResponse inventProblemsFromNews(GJaxbInventProblemsFromNews parameters) throws FaultMessage {
        GJaxbInventProblemsFromNewsResponse response = new GJaxbInventProblemsFromNewsResponse();
        try {
            try {
                for (GJaxbInventProblemsFromNews.News news : parameters.getNews()) {
                    PojoProblem.AIProblems aiProblemsFound;
                    GJaxbQueryResponse resp;
                    String instruction;
                    GJaxbQuery request;
                    GJaxbInventProblemsFromNewsResponse.NewsOutput newsOutput = new GJaxbInventProblemsFromNewsResponse.NewsOutput();
                    newsOutput.setNewsId(news.getNewsId());
                    newsOutput.setGenericModel(new GJaxbGenericModel());
                    if (news.isSetText()) {
                        request = new GJaxbQuery();
                        request.setContext(parameters.getContext());
                        request.setSystemMessage("    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tproblems: [\n    \t\t\t\t  {\n    \t\t\t\t  \tproblemName: ...,\n    \t\t\t\t\tproblemId: ...,\n    \t\t\t\t\tproblemType: ...,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\timagesId: [...]\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n");
                        instruction = new ServiceOutputParser().outputFormatInstructions(PojoProblem.AIProblems.class);
                        request.getUserMessage().add("Are there any danger (a alert or risk) to take into account in this news (If you can, try to find alerts or information about risks related to road safety, public safety, or national security [traffic jams, riots, property damage, floods, forest fires, etc.]): '" + news.getText() + "', if so, what are they ? " + instruction);
                        resp = this.query(request);
                        aiProblemsFound = PojoProblem.AIProblems.parse(new JSONObject(resp.getResponse()));
                        System.out.println(aiProblemsFound);
                        GenericModelHelper.pushInModel((GJaxbGenericModel)newsOutput.getGenericModel(), (GJaxbGenericModel)aiProblemsFound.convertToModel(news.getPictureInput(), parameters.getContext(), newsOutput.getExternalResource(), this));
                    }
                    if (news.isSetPictureInput()) {
                        request = new GJaxbQueryOnPictures();
                        request.setContext(parameters.getContext());
                        request.setSystemMessage("    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tproblems: [\n    \t\t\t\t  {\n    \t\t\t\t  \tproblemName: ...,\n    \t\t\t\t\tproblemId: ...,\n    \t\t\t\t\tproblemType: ...,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\timagesId: [...]\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n");
                        instruction = new ServiceOutputParser().outputFormatInstructions(PojoProblem.AIProblems.class);
                        request.getUserMessage().add("Are there any danger in these images, if so, what are they If you can, try to find alerts or information about risks related to road safety, public safety, or national security [traffic jams, riots, property damage, floods, forest fires, etc.]) ? " + instruction);
                        request.getPictureInput().addAll(news.getPictureInput());
                        resp = this.queryOnPictures((GJaxbQueryOnPictures)request);
                        aiProblemsFound = PojoProblem.AIProblems.parse(new JSONObject(resp.getResponse()));
                        System.out.println(aiProblemsFound);
                        GenericModelHelper.pushInModel((GJaxbGenericModel)newsOutput.getGenericModel(), (GJaxbGenericModel)aiProblemsFound.convertToModel(news.getPictureInput(), parameters.getContext(), newsOutput.getExternalResource(), this));
                    }
                    GenericModelHelper.deleteDuplicateNodes((List)newsOutput.getGenericModel().getNode());
                    GenericModelHelper.deleteDuplicateEdges((List)newsOutput.getGenericModel().getEdge());
                    response.getNewsOutput().add(newsOutput);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FaultMessage(e.getMessage(), null, (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }
}

