/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.context;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.PlacesApi;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.PlacesSearchResponse;
import com.google.maps.model.PlacesSearchResult;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensors;
import fr.emac.gind.gov.ai_chatbot.GJaxbPersonInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbReferencedActualities;
import fr.emac.gind.gov.ai_chatbot.GJaxbSensorType;
import fr.emac.gind.gov.ai_chatbot.GJaxbThreshold;
import fr.emac.gind.gov.ai_chatbot.GJaxbThresholdType;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.metamodel.GJaxbDimension;
import fr.emac.gind.modeler.metamodel.GJaxbModelingViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class PojoSensor {
    public static GJaxbThreshold createThreshold(GJaxbThresholdType type, float value, GJaxbReferencedActualities referencedActualities, boolean deleteOlderAlerts) {
        GJaxbThreshold t = new GJaxbThreshold();
        t.setType(type);
        t.setValue(Float.valueOf(value));
        t.setReferencedActualities(referencedActualities);
        return t;
    }

    public static void createThresholds(GJaxbNode sensor, List<GJaxbThreshold> thresholds) {
        ArrayList tableProps = new ArrayList();
        for (GJaxbThreshold threshold : thresholds) {
            ArrayList<GJaxbProperty> rowProp = new ArrayList<GJaxbProperty>();
            if (threshold.isSetType()) {
                rowProp.add(GenericModelHelper.createProperty((String)"type", (String)threshold.getType().toString()));
                rowProp.add(GenericModelHelper.createProperty((String)"value", (String)String.valueOf(threshold.getValue())));
            } else {
                rowProp.add(GenericModelHelper.createProperty((String)"rule", (String)threshold.getRule()));
            }
            rowProp.add(GenericModelHelper.createProperty((String)"referenced events", (String)GenericModelHelper.convertTableToJSONArray(PojoSensor.addReferencedActualitiesForSensor(threshold.getReferencedActualities())).toString()));
            tableProps.add(rowProp);
        }
        GenericModelHelper.findProperty((String)"thresholds", (List)sensor.getProperty(), (boolean)true).setValue(GenericModelHelper.convertTableToJSONArray(tableProps).toString());
    }

    public static List<List<GJaxbProperty>> addReferencedActualitiesForSensor(GJaxbReferencedActualities referencedActualities) {
        ArrayList<List<GJaxbProperty>> refsTableAct = new ArrayList<List<GJaxbProperty>>();
        if (referencedActualities != null) {
            for (GJaxbNode refActObj : referencedActualities.getNode()) {
                ArrayList<GJaxbProperty> refsRowAct = new ArrayList<GJaxbProperty>();
                refsRowAct.add(GenericModelHelper.createProperty((String)"id", (String)refActObj.getId()));
                refsRowAct.add(GenericModelHelper.createProperty((String)"name", (String)GenericModelHelper.getName((GJaxbNode)refActObj)));
                refsTableAct.add(refsRowAct);
            }
        }
        return refsTableAct;
    }

    public static void setPilots(GJaxbInventSensors.SensorInput si, GJaxbNode sensor, GJaxbGenericModel model) throws Exception {
        if (si.isSetPilots()) {
            for (GJaxbNode iot : si.getPilots().getNode()) {
                GJaxbEdge pilots = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Pilots"));
                pilots.setSource(sensor);
                pilots.setTarget(iot);
                GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
                be.setEdge(pilots);
                be.setSourceId(sensor.getId());
                be.setTargetId(iot.getId());
                sensor.getBrokenEdges().getBrokenEdge().add(be);
                model.getEdge().add(pilots);
                model.getNode().add(iot);
            }
        }
    }

    public static void setSensorImageModeling(GJaxbNode sensor, String sensorUrl) {
        sensor.setModeling(new GJaxbNode.Modeling());
        GJaxbNode.Modeling.ItemView iv = new GJaxbNode.Modeling.ItemView();
        iv.setViewId("view_" + UUID.randomUUID().toString());
        iv.setPackageName("Context And Partners");
        iv.setPosition(new GJaxbPosition());
        iv.getPosition().setX(0.0f);
        iv.getPosition().setY(0.0f);
        iv.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
        iv.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
        iv.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(sensorUrl);
        sensor.getModeling().getItemView().add(iv);
    }

    public static String getSensorUrl(GJaxbInventSensors.SensorInput si) throws Exception {
        HashMap<String, String> mapSensorsUrls = new HashMap<String, String>();
        mapSensorsUrls.put("Water Level".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/water_level.png");
        mapSensorsUrls.put("Thermal".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/thermal.png");
        mapSensorsUrls.put("Humidity".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/humidity.png");
        mapSensorsUrls.put("Pressure".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/pressure.png");
        mapSensorsUrls.put("Radiation".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/radiation.png");
        mapSensorsUrls.put("Toxic Gas".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/toxic_gas.png");
        mapSensorsUrls.put("Explosive Gas".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/explosive_gas.png");
        mapSensorsUrls.put("Cardiac Rythm".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/cardiac_rythm.png");
        mapSensorsUrls.put("Other".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/other_sensor.png");
        mapSensorsUrls.put("Twitter".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/twitter.png");
        mapSensorsUrls.put("Messaging".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/messaging.png");
        mapSensorsUrls.put("Smoke".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/smoke.png");
        mapSensorsUrls.put("Intrusion alarm".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/intrusion_alarm.png");
        mapSensorsUrls.put("Pushbutton".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/pushbutton.png");
        mapSensorsUrls.put("Radar".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/radar.png");
        mapSensorsUrls.put("Spatial".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/spatial.png");
        mapSensorsUrls.put("Picture".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/media_picture_sensor.png");
        mapSensorsUrls.put("Sound".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/media_sound_sensor.png");
        mapSensorsUrls.put("Video".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/media_video_sensor.png");
        mapSensorsUrls.put("Knowledge".toLowerCase(), "/##application_name##/webjars/gind/rio/core_model/images/model/context/sensors/knowledge.png");
        String sensorNatureType = null;
        if (si.getType().equals((Object)GJaxbSensorType.SPATIAL)) {
            sensorNatureType = si.getType().toString().replaceAll("_", " ").toLowerCase();
        } else if (si.getType().equals((Object)GJaxbSensorType.QUANTITATIVE)) {
            sensorNatureType = si.getNature().getQuantitativeNature().toString().replaceAll("_", " ").toLowerCase();
        } else if (si.getType().equals((Object)GJaxbSensorType.SOCIAL)) {
            sensorNatureType = si.getNature().getSocialNature().toString().replaceAll("_", " ").toLowerCase();
        } else if (si.getType().equals((Object)GJaxbSensorType.DEDICATED)) {
            sensorNatureType = si.getNature().getDedicatedNature().toString().replaceAll("_", " ").toLowerCase();
        } else if (si.getType().equals((Object)GJaxbSensorType.MEDIA)) {
            sensorNatureType = si.getNature().getMediaNature().toString().replaceAll("_", " ").toLowerCase();
        } else if (si.getType().equals((Object)GJaxbSensorType.OTHERS)) {
            sensorNatureType = si.getNature().getOthersNature().toString().replaceAll("_", " ").toLowerCase();
        }
        String imageUrl = (String)mapSensorsUrls.get(sensorNatureType);
        if (imageUrl == null) {
            throw new Exception("Impossible to find image url corresponding to: " + sensorNatureType);
        }
        return imageUrl;
    }

    public static void setGeolocOnSensor(GeoApiContext geoApiContext, GJaxbInventSensors.SensorInput si, GJaxbNode sensor, String sensorUrl, GJaxbGenericModel model) throws Exception {
        if (si.isByAddress() && geoApiContext != null && si.getSensorAddress() != null && !si.getSensorAddress().isBlank()) {
            PlacesSearchResponse results = (PlacesSearchResponse)PlacesApi.textSearchQuery((GeoApiContext)geoApiContext, (String)si.getSensorAddress()).await();
            if (results != null && results.results.length > 0) {
                PlacesSearchResult resPlace = results.results[0];
                GeocodingResult[] detail = (GeocodingResult[])GeocodingApi.newRequest((GeoApiContext)geoApiContext).place(resPlace.placeId).await();
                if (detail != null && detail.length > 0) {
                    sensor.setGeolocation(new GJaxbNode.Geolocation());
                    GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
                    iv.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                    iv.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                    iv.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                    iv.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(sensorUrl);
                    iv.setPoint(new GJaxbPointType());
                    iv.getPoint().setLatitude(Double.valueOf(detail[0].geometry.location.lat));
                    iv.getPoint().setLongitude(Double.valueOf(detail[0].geometry.location.lng));
                    sensor.getGeolocation().getItemView().add(iv);
                }
            }
        } else if (si.getSensorTerritory() != null && si.getSensorTerritory().getNode() != null) {
            Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromGJaxbNode(si.getSensorTerritory().getNode()).get(0);
            Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
            sensor.setGeolocation(new GJaxbNode.Geolocation());
            GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
            iv.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
            iv.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(sensorUrl);
            iv.setPoint(new GJaxbPointType());
            iv.getPoint().setLatitude(Double.valueOf(randomPoint.getY()));
            iv.getPoint().setLongitude(Double.valueOf(randomPoint.getX()));
            sensor.getGeolocation().getItemView().add(iv);
            GJaxbEdge fixedOnto = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Fixed_Onto"));
            fixedOnto.setSource(sensor);
            fixedOnto.setTarget(si.getSensorTerritory().getNode());
            GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
            be.setEdge(fixedOnto);
            be.setSourceId(sensor.getId());
            be.setTargetId(si.getSensorTerritory().getNode().getId());
            sensor.getBrokenEdges().getBrokenEdge().add(be);
        }
    }

    public static interface SensorExtractor {
    }

    public static class AISensor
    extends AIPojo {
        public GJaxbGenericModel convertToModel(GJaxbPersonInput input, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            return model;
        }
    }
}

