/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoProblem;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctions;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import java.util.List;

public class PojoFunction {

    public static interface FunctionExtractor {
        @SystemMessage(value={"    \t\t\tYou are an expert in human and material resources. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tfunctionId: ...,\n    \t\t\t\tfunctionName: ...,\n    \t\t\t\tjobName: ...,\n    \t\t\t\tdescription: ...,\n    \t\t\t\tproblem: {\n    \t\t\t\t\t\tproblemName: ...,\n    \t\t\t\t\t\tproblemId: ...,\n    \t\t\t\t\t\tproblemType: ...\n    \t\t\t\t\t},\n    \t\t\t\tresolution_level: ...,\n    \t\t\t\tprerequisites: [\n    \t\t\t\t  {\n    \t\t\t\t  \tfunctionId: ...,\n    \t\t\t\t\tfunctionName: ...,\n    \t\t\t\t\tjobName: ... (can be the same job name of the main function or another such as Policeman, Physician),\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t],\n    \t\t\t\tpostrequisites: [\n    \t\t\t\t  {\n    \t\t\t\t  \tfunctionId: ...,\n    \t\t\t\t\tfunctionName: ...,\n    \t\t\t\t\tjobName: ... (can be the same job name of the main function or another such as Policeman, Physician),\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t],\n    \t\t\t\tparallelActions: [\n    \t\t\t\t  {\n    \t\t\t\t  \tfunctionId: ...,\n    \t\t\t\t\tfunctionName: ...,\n    \t\t\t\t\tjobName: ... (can be the same job name of the main function or another such as Policeman, Physician),\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"Complete the missing attributes of this json main function {{it}} by imagining the actions that it should do as a prerequisite (if you can find any), the actions that it should do as a postrequisite (if you can find any) and the actions that it should do in parallel (if you can find any)"})
        public AIFunction extractFunctionFrom(String var1);
    }

    public static class AIFunction
    extends AIPojo {
        @JsonProperty(value="functionName")
        @Description(value={"the name of the function"})
        public String functionName;
        @JsonProperty(value="functionId")
        @Description(value={"the identifier (uuid v4) of the function"})
        public String functionId;
        @JsonProperty(value="jobName")
        @Description(value={"the jobName of the function"})
        public String jobName;
        @JsonProperty(value="description")
        @Description(value={"the description of the function"})
        public String description;
        @JsonProperty(value="problem")
        @Description(value={"the problem resolved by the function"})
        public PojoProblem.AIProblem problem;
        @JsonProperty(value="resolutionLevel")
        @Description(value={"the resolution level of the function in relation to the problem (in percentage)"})
        public Float resolutionLevel;
        @JsonProperty(value="expertiseLevel")
        @Description(value={"the expertise level of the role to achieved the function (in percentage)"})
        public Float expertiseLevel;
        @JsonProperty(value="prerequisites")
        @Description(value={"the list of pre-requisite functions"})
        public List<AIFunction> prerequisites;
        @JsonProperty(value="postrequisites")
        @Description(value={"the list of post-requisite functions"})
        public List<AIFunction> postrequisites;
        @JsonProperty(value="parallelActions")
        @Description(value={"the list of functions to execute in the same time"})
        public List<AIFunction> parallelActions;

        public GJaxbGenericModel convertToModel(GJaxbInventFunctions.FunctionInput input) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            if (this.functionId != null && !this.functionId.isEmpty()) {
                GJaxbNode subNode;
                GJaxbNode function = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Function"));
                function.setId(this.functionId);
                GenericModelHelper.findProperty((String)"name", (List)function.getProperty(), (boolean)true).setValue(this.functionName);
                GenericModelHelper.findProperty((String)"description", (List)function.getProperty(), (boolean)true).setValue(this.description);
                model.getNode().add(function);
                if (this.problem != null) {
                    GJaxbNode objective = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Objective"));
                    objective.setId(this.problem.problemId);
                    GenericModelHelper.findProperty((String)"name", (List)objective.getProperty(), (boolean)true).setValue(this.problem.problemName);
                    model.getNode().add(objective);
                    GJaxbEdge satisfies = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Satisfies"));
                    if (this.resolutionLevel != null) {
                        GenericModelHelper.findProperty((String)"pertinence", (List)satisfies.getProperty(), (boolean)true).setValue(this.resolutionLevel.toString());
                    }
                    satisfies.setSource(function);
                    satisfies.setTarget(objective);
                    model.getEdge().add(satisfies);
                }
                if (this.prerequisites != null && !this.prerequisites.isEmpty()) {
                    for (AIFunction subFunct : this.prerequisites) {
                        model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)subFunct.convertToModel(input));
                        subNode = GenericModelHelper.findNodeById((String)subFunct.functionId, (List)model.getNode());
                        GJaxbEdge needs = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Needs"));
                        needs.setSource(function);
                        needs.setTarget(subNode);
                        model.getEdge().add(needs);
                        this.setRoleAndProvideEdge(input, model, subFunct, subNode);
                    }
                }
                if (this.postrequisites != null && !this.postrequisites.isEmpty()) {
                    for (AIFunction subFunct : this.postrequisites) {
                        model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)subFunct.convertToModel(input));
                        subNode = GenericModelHelper.findNodeById((String)subFunct.functionId, (List)model.getNode());
                        GJaxbEdge implies = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Implies"));
                        implies.setSource(function);
                        implies.setTarget(subNode);
                        model.getEdge().add(implies);
                        this.setRoleAndProvideEdge(input, model, subFunct, subNode);
                    }
                }
                if (this.parallelActions != null && !this.parallelActions.isEmpty()) {
                    for (AIFunction subFunct : this.parallelActions) {
                        model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)subFunct.convertToModel(input));
                        subNode = GenericModelHelper.findNodeById((String)subFunct.functionId, (List)model.getNode());
                        GJaxbEdge support = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Supports"));
                        support.setSource(function);
                        support.setTarget(subNode);
                        model.getEdge().add(support);
                        this.setRoleAndProvideEdge(input, model, subFunct, subNode);
                    }
                }
            }
            return model;
        }

        private void setRoleAndProvideEdge(GJaxbInventFunctions.FunctionInput input, GJaxbGenericModel model, AIFunction subFunct, GJaxbNode subNode) throws Exception {
            if (input.isSetAssociatedRole()) {
                if (subFunct.jobName.equals(this.jobName)) {
                    GJaxbEdge provides = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Provides"));
                    provides.setSource(input.getAssociatedRole().getNode());
                    provides.setTarget(subNode);
                    model.getEdge().add(provides);
                } else {
                    boolean existingRoleFound = false;
                    for (GJaxbInventFunctions.FunctionInput.ExistingRoles er : input.getExistingRoles()) {
                        if (!er.getRoleName().equals(subFunct.jobName)) continue;
                        GJaxbNode eRole = new GJaxbNode();
                        eRole.setId(er.getRoleId());
                        GenericModelHelper.findProperty((String)"name", (List)eRole.getProperty(), (boolean)true).setValue(er.getRoleName());
                        model.getNode().add(eRole);
                        GJaxbEdge provides = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Provides"));
                        provides.setSource(eRole);
                        provides.setTarget(subNode);
                        model.getEdge().add(provides);
                        existingRoleFound = true;
                    }
                    if (!existingRoleFound) {
                        GJaxbNode newRole = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Role"));
                        GenericModelHelper.findProperty((String)"name", (List)newRole.getProperty(), (boolean)true).setValue(subFunct.jobName);
                        model.getNode().add(newRole);
                        GJaxbEdge provides = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Provides"));
                        provides.setSource(newRole);
                        provides.setTarget(subNode);
                        model.getEdge().add(provides);
                        GJaxbInventFunctions.FunctionInput.ExistingRoles newEr = new GJaxbInventFunctions.FunctionInput.ExistingRoles();
                        newEr.setRoleId(newRole.getId());
                        newEr.setRoleName(GenericModelHelper.getName((GJaxbNode)newRole));
                        input.getExistingRoles().add(newEr);
                    }
                }
            }
        }
    }
}

