/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoSensor;
import fr.emac.gind.gov.ai.chatbot.service.util.PhotosHelper;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensors;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensorsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbPersonInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbRole;
import fr.emac.gind.gov.ai_chatbot.GJaxbSensorNatureQuantitativeType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSensorType;
import fr.emac.gind.gov.ai_chatbot.GJaxbThresholdType;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbRelationModeType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import fr.emac.gind.rio.PluginCollaborativeModel;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;

public class PojoPerson {

    public static interface PersonExtractor {
        @SystemMessage(value={"    \t\t\tYou are an expert in human and material resources. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tgroupId: ...,\n    \t\t\t\tnumberOfPersonsInGroup: ...,\n    \t\t\t\tpersons: [\n    \t\t\t\t\t{\n    \t\t\t\t\t\tlastname: ... (conventional last name (not an identifier)),\n    \t\t\t\t\t\tfirstname: ... (conventional first name (not an identifier)),\n    \t\t\t\t\t\tgender: ...\n    \t\t\t\t\t\tmobilePhoneNumber: ...\n    \t\t\t\t\t\temail: ...\n    \t\t\t\t\t\tbirthDate: ...\n    \t\t\t\t\t\theightInCm: ...\n    \t\t\t\t\t\tnationality: ...\n    \t\t\t\t\t},\n    \t\t\t\t\t...\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"For each group in this array {{it}}, do you invent me the gender, a fake phone mobile number, a fake email, a fake birthdate (between 18 and 60 years), a fake height, a fake nationality, the firstname and the lastname of each person of group (avoid duplicates names and names in this 'avoidsNames' list)"})
        public AIGroupOfPersons extractGroupOfPersons(String var1);
    }

    public static class AIGroupOfPersons
    extends AIPojo {
        @JsonProperty(value="groupId")
        @Description(value={"the identifier  (uuid v4) of the group"})
        public String groupId;
        @JsonProperty(value="numberOfPersonsInGroup")
        @Description(value={"the number of persons in the group"})
        public int numberOfPersonsInGroup;
        @JsonProperty(value="persons")
        @Description(value={"the list of persons"})
        public List<AIPerson> persons;
        @JsonProperty(value="avoidNames")
        @Description(value={"the list of name of persons to avoid"})
        public List<String> avoidNames;

        public GJaxbGenericModel convertToModel(GJaxbPersonInput personInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            for (AIPerson aiPerson : this.persons) {
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiPerson.convertToModel(personInput, context, externalResource, aiChatbotImpl));
            }
            return model;
        }
    }

    public static class AIPerson
    extends AIPojo {
        @JsonProperty(value="lastname")
        @Description(value={"the last name of the person"})
        public String lastname;
        @JsonProperty(value="firstname")
        @Description(value={"the first name of the person"})
        public String firstname;
        @JsonProperty(value="gender")
        @Description(value={"the gender of the person"})
        public GenderType gender;
        @JsonProperty(value="mobilePhoneNumber")
        @Description(value={"the mobile phone number of the person"})
        public String mobilePhoneNumber;
        @JsonProperty(value="email")
        @Description(value={"the email of the person"})
        public String email;
        @JsonProperty(value="birthDate")
        @Description(value={"the birthDate of the person (ISO format yyyy-MM-ddTHH:mm:ss)"})
        public String birthDate;
        @JsonProperty(value="heightInCm")
        @Description(value={"the height of the person in cm (between 150 and 210)"})
        public int heightInCm;
        @JsonProperty(value="nationality")
        @Description(value={"the nationality of the person in ISO 3166-1 alpha-2 format"})
        public String nationality;

        public GJaxbGenericModel convertToModel(GJaxbPersonInput input, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbInventSensorsResponse inventSensorsResp;
            GJaxbInventSensors inventSensors;
            GJaxbExternalResourceType face;
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbEffectiveConceptType concept = EffectiveMetaModelPluginManager.getInstance().getConceptByType(GenericModelHelper.collab((String)"Person"));
            GJaxbNode person = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Person"));
            person.setBrokenEdges(new GJaxbNode.BrokenEdges());
            person.setModeling(new GJaxbNode.Modeling());
            GJaxbNode.Modeling.ItemView ivCtxtAndPartner = new GJaxbNode.Modeling.ItemView();
            ivCtxtAndPartner.setViewId("view_" + String.valueOf(UUID.randomUUID()));
            ivCtxtAndPartner.setPackageName("Context and partners");
            ivCtxtAndPartner.setPosition(new GJaxbPosition());
            person.getModeling().getItemView().add(ivCtxtAndPartner);
            GenericModelHelper.findProperty((String)"name", (List)person.getProperty(), (boolean)true).setValue(this.firstname + " " + this.lastname);
            GenericModelHelper.findProperty((String)"firstName", (List)person.getProperty(), (boolean)true).setValue(this.firstname);
            GenericModelHelper.findProperty((String)"lastName", (List)person.getProperty(), (boolean)true).setValue(this.lastname);
            GenericModelHelper.findProperty((String)"gender", (List)person.getProperty(), (boolean)true).setValue(this.gender.toString());
            GenericModelHelper.findProperty((String)"mobile phone number", (List)person.getProperty(), (boolean)true).setValue(this.mobilePhoneNumber);
            GenericModelHelper.findProperty((String)"email", (List)person.getProperty(), (boolean)true).setValue(this.email);
            GenericModelHelper.findProperty((String)"birthdate", (List)person.getProperty(), (boolean)true).setValue(this.birthDate);
            GenericModelHelper.findProperty((String)"Presence", (List)person.getProperty(), (boolean)true).setValue("Available");
            GenericModelHelper.findProperty((String)"height", (List)person.getProperty(), (boolean)true).setValue(String.valueOf(this.heightInCm));
            GenericModelHelper.findProperty((String)"nationality", (List)person.getProperty(), (boolean)true).setValue(this.nationality);
            GenericModelHelper.findProperty((String)"color", (List)person.getProperty(), (boolean)true).setValue(ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor()));
            if (input.isAddFace() && (face = PhotosHelper.getInstance().getRandomPhotos(this.gender.toString() + " face")) != null) {
                face.setId(person.getId() + "::picture");
                externalResource.add(face);
                ivCtxtAndPartner.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
                ivCtxtAndPartner.getSpecificModeling().setNodeMetaModeling((GJaxbNodeMetaModeling)GenericModelHelper.clone((AbstractJaxbObject)concept.getNodeMetaModeling(), GJaxbNodeMetaModeling.class));
            }
            for (GJaxbRole role : input.getRole()) {
                GJaxbEdge has = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Has"));
                has.setSource(person);
                has.setTarget(role.getNode());
                model.getEdge().add(has);
                GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
                be.setEdge(has);
                be.setSourceId(person.getId());
                be.setTargetId(role.getNode().getId());
                person.getBrokenEdges().getBrokenEdge().add(be);
                model.getNode().add(role.getNode());
            }
            GJaxbNode.Geolocation.ItemView personPositionIv = null;
            if (input.getTerritory() != null && input.getTerritory().getNode() != null && input.getTerritory().getNode().getGeolocation() != null) {
                Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromGJaxbNode(input.getTerritory().getNode()).get(0);
                Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
                person.setGeolocation(new GJaxbNode.Geolocation());
                personPositionIv = new GJaxbNode.Geolocation.ItemView();
                personPositionIv.setPoint(new GJaxbPointType());
                personPositionIv.getPoint().setLatitude(Double.valueOf(randomPoint.getY()));
                personPositionIv.getPoint().setLongitude(Double.valueOf(randomPoint.getX()));
                person.getGeolocation().getItemView().add(personPositionIv);
            }
            if (input.isAddPhone()) {
                GJaxbNode phone = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Good"));
                phone.setId(person.getId() + "_phone");
                GenericModelHelper.findProperty((String)"name", (List)phone.getProperty(), (boolean)true).setValue("Phone of " + GenericModelHelper.getName((GJaxbNode)person));
                GJaxbEdge fixedOntoPhone = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)phone, (GJaxbNode)person, (QName)GenericModelHelper.collab((String)"Fixed_Onto"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                fixedOntoPhone.setId(person.getId() + "_fixedOntoPhone");
                inventSensors = new GJaxbInventSensors();
                inventSensors.setContext(context);
                GJaxbInventSensors.SensorInput si = new GJaxbInventSensors.SensorInput();
                si.setType(GJaxbSensorType.SPATIAL);
                si.setNumber(1);
                inventSensors.getSensorInput().add(si);
                inventSensorsResp = aiChatbotImpl.inventSensors(inventSensors);
                GJaxbNode spatialSensor = (GJaxbNode)inventSensorsResp.getGenericModel().getNode().get(0);
                spatialSensor.setId(person.getId() + "_spatialSensor");
                GJaxbNode.Geolocation.ItemView ivGpsSensor = GenericModelHelper.getItemViewPoint((GJaxbNode)spatialSensor, (boolean)true);
                ivGpsSensor.setShow(Boolean.valueOf(false));
                if (personPositionIv != null && personPositionIv.getPoint() != null) {
                    ivGpsSensor.getPoint().setLatitude(personPositionIv.getPoint().getLatitude());
                    ivGpsSensor.getPoint().setLongitude(personPositionIv.getPoint().getLongitude());
                }
                GJaxbNode.Geolocation.ItemView ivCellPhone = GenericModelHelper.getItemViewPoint((GJaxbNode)phone, (boolean)true);
                ivCellPhone.setShow(Boolean.valueOf(false));
                if (personPositionIv != null && personPositionIv.getPoint() != null) {
                    ivCellPhone.getPoint().setLatitude(personPositionIv.getPoint().getLatitude());
                    ivCellPhone.getPoint().setLongitude(personPositionIv.getPoint().getLongitude());
                }
                GJaxbEdge fixedOntoSpatialSensor = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)spatialSensor, (GJaxbNode)phone, (QName)new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Fixed_Onto"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                fixedOntoSpatialSensor.setId(person.getId() + "_fixedOntoSpatialSensor");
                model.getNode().add(phone);
                model.getNode().add(spatialSensor);
                model.getEdge().add(fixedOntoPhone);
                model.getEdge().add(fixedOntoSpatialSensor);
            }
            if (input.isAddWatch()) {
                GJaxbNode watch = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Good"));
                watch.setId(person.getId() + "_watch");
                GenericModelHelper.findProperty((String)"name", (List)watch.getProperty(), (boolean)true).setValue("Watch of " + GenericModelHelper.getName((GJaxbNode)person));
                GJaxbEdge fixedOntoWatch = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)watch, (GJaxbNode)person, (QName)new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Fixed_Onto"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                fixedOntoWatch.setId(person.getId() + "_fixedOntoWatch");
                inventSensors = new GJaxbInventSensors();
                inventSensors.setContext(context);
                GJaxbInventSensors.SensorInput siThermal = new GJaxbInventSensors.SensorInput();
                siThermal.setType(GJaxbSensorType.QUANTITATIVE);
                siThermal.setNature(new GJaxbInventSensors.SensorInput.Nature());
                siThermal.getNature().setQuantitativeNature(GJaxbSensorNatureQuantitativeType.THERMAL);
                siThermal.setQuantitativeInput(new GJaxbInventSensors.SensorInput.QuantitativeInput());
                siThermal.getQuantitativeInput().getThreshold().add(PojoSensor.createThreshold(GJaxbThresholdType.MIN, 36.0f, null, false));
                siThermal.getQuantitativeInput().getThreshold().add(PojoSensor.createThreshold(GJaxbThresholdType.MAX, 39.0f, null, false));
                siThermal.getQuantitativeInput().setUnit("celsius");
                siThermal.setNumber(1);
                inventSensors.getSensorInput().add(siThermal);
                inventSensorsResp = aiChatbotImpl.inventSensors(inventSensors);
                GJaxbNode temperatureSensor = (GJaxbNode)inventSensorsResp.getGenericModel().getNode().get(0);
                temperatureSensor.setId(person.getId() + "_temperatureSensor");
                GJaxbNode.Geolocation.ItemView ivThermalSensor = GenericModelHelper.getItemViewPoint((GJaxbNode)temperatureSensor, (boolean)true);
                ivThermalSensor.setShow(Boolean.valueOf(false));
                if (personPositionIv != null && personPositionIv.getPoint() != null) {
                    ivThermalSensor.getPoint().setLatitude(personPositionIv.getPoint().getLatitude());
                    ivThermalSensor.getPoint().setLongitude(personPositionIv.getPoint().getLongitude());
                }
                inventSensors = new GJaxbInventSensors();
                inventSensors.setContext(context);
                GJaxbInventSensors.SensorInput siCardiacRythm = new GJaxbInventSensors.SensorInput();
                siCardiacRythm.setType(GJaxbSensorType.QUANTITATIVE);
                siCardiacRythm.setNature(new GJaxbInventSensors.SensorInput.Nature());
                siCardiacRythm.getNature().setQuantitativeNature(GJaxbSensorNatureQuantitativeType.CARDIAC_RYTHM);
                siCardiacRythm.setQuantitativeInput(new GJaxbInventSensors.SensorInput.QuantitativeInput());
                siCardiacRythm.getQuantitativeInput().getThreshold().add(PojoSensor.createThreshold(GJaxbThresholdType.MIN, 60.0f, null, false));
                siCardiacRythm.getQuantitativeInput().getThreshold().add(PojoSensor.createThreshold(GJaxbThresholdType.MAX, 150.0f, null, false));
                siCardiacRythm.getQuantitativeInput().setUnit("bpm");
                siCardiacRythm.setNumber(1);
                inventSensors.getSensorInput().add(siCardiacRythm);
                inventSensorsResp = aiChatbotImpl.inventSensors(inventSensors);
                GJaxbNode cardiacRythmSensor = (GJaxbNode)inventSensorsResp.getGenericModel().getNode().get(0);
                cardiacRythmSensor.setId(person.getId() + "_cardiacRythmSensor");
                GJaxbNode.Geolocation.ItemView ivCardiacRythmSensor = GenericModelHelper.getItemViewPoint((GJaxbNode)cardiacRythmSensor, (boolean)true);
                ivCardiacRythmSensor.setShow(Boolean.valueOf(false));
                if (personPositionIv != null && personPositionIv.getPoint() != null) {
                    ivCardiacRythmSensor.getPoint().setLatitude(personPositionIv.getPoint().getLatitude());
                    ivCardiacRythmSensor.getPoint().setLongitude(personPositionIv.getPoint().getLongitude());
                }
                GJaxbNode.Geolocation.ItemView ivWatch = GenericModelHelper.getItemViewPoint((GJaxbNode)watch, (boolean)true);
                ivWatch.setShow(Boolean.valueOf(false));
                if (personPositionIv != null && personPositionIv.getPoint() != null) {
                    ivWatch.getPoint().setLatitude(personPositionIv.getPoint().getLatitude());
                    ivWatch.getPoint().setLongitude(personPositionIv.getPoint().getLongitude());
                }
                GJaxbEdge temperatureFixedOnto = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)temperatureSensor, (GJaxbNode)watch, (QName)new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Fixed_Onto"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                temperatureFixedOnto.setId(person.getId() + "_temperatureFixedOnto");
                GJaxbEdge cardiacRythmFixedOnto = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)cardiacRythmSensor, (GJaxbNode)watch, (QName)new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Fixed_Onto"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                cardiacRythmFixedOnto.setId(person.getId() + "_cardiacRythmFixedOnto");
                model.getNode().add(watch);
                model.getNode().add(temperatureSensor);
                model.getNode().add(cardiacRythmSensor);
                model.getEdge().add(fixedOntoWatch);
                model.getEdge().add(temperatureFixedOnto);
                model.getEdge().add(cardiacRythmFixedOnto);
            }
            model.getNode().add(person);
            return model;
        }
    }

    public static enum GenderType {
        MALE("MALE"),
        FEMALE("FEMALE");

        private final String text;

        private GenderType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

