/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.objectives;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.commons.utils.regexp.AccentRemover;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoAsset;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoActuality;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoObjective;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoProblem;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbProblemInputType;
import fr.emac.gind.gov.ai_chatbot.GJaxbProblemType;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbRelationModeType;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbDimension;
import fr.emac.gind.modeler.metamodel.GJaxbModelingViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;

public class PojoPotentiality {
    public static String potRiskUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/risk.png";
    public static String potOpportunityUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/opportunity.png";

    public static interface PotentialityExtractor {
        @SystemMessage(value={"    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n   \t\t\t\t\tpotentialityName: ...,\n   \t\t\t\t\tpotentialityId: ...,\n   \t\t\t\t\tpotentialityType: ...,\n   \t\t\t\t\tprobability: ...,\n   \t\t\t\t\tpotentialityDescription: ...,\n   \t\t\t\t\tpriorityLevel: ...\n   \t\t\t\t\timpactedAssets: [\n   \t\t\t\t\t\t{\n   \t\t\t\t\t\t\tassetId: ...,\n   \t\t\t\t\t\t\tassetName: ...,\n   \t\t\t\t\t\t\tassetType: ...\n   \t\t\t\t\t\t}\n   \t\t\t\t\t],\n   \t\t\t\t\tobjectives: [\n    \t\t\t\t  {\n    \t\t\t\t  \tobjectiveName: ...,\n    \t\t\t\t\tobjectiveId: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n\t    \t\t}\n"})
        @UserMessage(value={"Complete the missing attributes of this json main potentiality (risk or opportunity) {{it}} by imagining the sub problems such as the risks (problemType='PREVENT_A_RISK') or the opportunities (problemType='OFFER_AN_OPPORTUNITY') that we should pay attention to and what would be the objectives to be accomplished immediately if this main potentiality (risk or opportunity) happened"})
        public AIPotentiality extractPotentiality(String var1);

        @SystemMessage(value={"    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tpotentialities: [\n\t    \t\t\t\t{\n\t    \t\t\t\t\tpotentialityName: ...,\n\t    \t\t\t\t\tpotentialityId: ...,\n\t    \t\t\t\t\tpotentialityType: ...,\n\t    \t\t\t\t\tprobability: ...,\n\t    \t\t\t\t\tpotentialityDescription: ...,\n\t    \t\t\t\t\tpriorityLevel: ...\n\t    \t\t\t\t\timpactedAssets: [\n\t    \t\t\t\t\t\t{\n\t    \t\t\t\t\t\t\tassetId: ...,\n\t    \t\t\t\t\t\t\tassetName: ...,\n\t    \t\t\t\t\t\t\tassetType: ...\n\t    \t\t\t\t\t\t}\n\t    \t\t\t\t\t]\n\t    \t\t\t\t},\n\t    \t\t\t\t...\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"Find out the risks (potentialities) that could arise if the componenent ('asset') was confronted with the associated danger {{it}}"})
        public AIPotentialities extractPotentialitiesFromPotential(String var1);
    }

    public static class AIPotentialities
    extends AIPojo {
        @JsonProperty(value="potentialities")
        @Description(value={"the list of potentialities"})
        List<AIPotentiality> potentialities;

        public GJaxbGenericModel convertToModel(GJaxbInventPotentialities.PotentialityInput.PotentialityFromPotentialInput input, GJaxbContext context, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            for (AIPotentiality aiPotentiality : this.potentialities) {
                String riskName = aiPotentiality.potentialityName;
                Double riskProbability = aiPotentiality.probability;
                String riskDescription = aiPotentiality.potentialityDescription;
                GJaxbNode impactedNode = input.getSusceptibleAsset().getNode();
                GJaxbNode potential = input.getPotential().getNode();
                ArrayList<GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput> ipis = new ArrayList<GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput>();
                GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput ipi = new GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput();
                ipi.setPotentiality(new GJaxbProblemInputType());
                ipi.getPotentiality().setProblemId("potentiality_" + String.valueOf(UUID.randomUUID()));
                ipi.getPotentiality().setProblemName(riskName);
                ipi.getPotentiality().setProblemType(GJaxbProblemType.PREVENT_A_RISK);
                ipi.getPotentiality().setProblemDescription(riskDescription);
                ipi.setPotentialityProbability(riskProbability);
                ipi.getPotentiality().setGenerateAssociateObjective(true);
                ipi.setGenerateAssociateActuality(true);
                GJaxbProblemInputType.Impacts impact = new GJaxbProblemInputType.Impacts();
                impact.setNode(impactedNode);
                ipi.getPotentiality().getImpacts().add(impact);
                ipis.add(ipi);
                GJaxbInventPotentialitiesResponse iresp = aiChatbotImpl.inventPotentialitiesIsolated(ipis, context);
                GJaxbNode risk = GenericModelHelper.findNodeById((String)ipi.getPotentiality().getProblemId(), (List)iresp.getGenericModel().getNode());
                GJaxbEdge generatedBy = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Generated_By"));
                generatedBy.setSource(risk);
                generatedBy.setTarget(potential);
                model.getNode().add(potential);
                model.getEdge().add(generatedBy);
                model.getNode().addAll(iresp.getGenericModel().getNode());
                model.getEdge().addAll(iresp.getGenericModel().getEdge());
                if (!input.isConnectAssetToPotential()) continue;
                GJaxbNode actuality = (GJaxbNode)GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Actuality"), (List)iresp.getGenericModel().getNode()).get(0);
                GJaxbEdge isSusceptibleTo = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Is_Susceptible_To"));
                GenericModelHelper.findProperty((String)"susceptibility condition", (List)isSusceptibleTo.getProperty(), (boolean)true).setValue(this.generateSusceptibleCode(impactedNode, potential, risk, actuality));
                isSusceptibleTo.setSource(impactedNode);
                isSusceptibleTo.setTarget(potential);
                model.getNode().add(impactedNode);
                model.getNode().add(potential);
                model.getEdge().add(isSusceptibleTo);
            }
            return model;
        }

        private String generateSusceptibleCode(GJaxbNode impactedNode, GJaxbNode potential, GJaxbNode risk, GJaxbNode actuality) {
            String varAssetSourceName = AccentRemover.removeAccents((String)RegExpHelper.toRegexFriendlyName((String)GenericModelHelper.getName((GJaxbNode)impactedNode)).replaceAll("-", "_"));
            String varPotentialTargetName = AccentRemover.removeAccents((String)(RegExpHelper.toRegexFriendlyName((String)GenericModelHelper.getName((GJaxbNode)potential)).replaceAll("-", "_") + "_danger"));
            String riskName = GenericModelHelper.getName((GJaxbNode)risk);
            String varRiskName = AccentRemover.removeAccents((String)(RegExpHelper.toRegexFriendlyName((String)GenericModelHelper.getName((GJaxbNode)risk)).replaceAll("-", "_") + "_risk"));
            String actualityName = AccentRemover.removeAccents((String)GenericModelHelper.getName((GJaxbNode)actuality));
            String code = "Node $varAssetSourceName = $source;\nNode $varPotentialTargetName = $target;\nNode $varRiskName = findNodeInstance(\"Potentiality\", \"$riskName\");\nNode actuality_generated_by_$varRiskName = findNodeInstance(\"Actuality\", \"$actualityName\");\nif($varPotentialTargetName.isActive()\n\t&& $varAssetSourceName.isInside($varPotentialTargetName) && actuality_generated_by_$varRiskName.isFreeze()) {\n\t$varRiskName.active();\n\t$varRiskName.getGeoloc().setPosition($varAssetSourceName.getGeoloc().getPosition());\n\t$varRiskName.probability = 0.5;\n} else {\n\t$varRiskName.freeze();\n\t$varRiskName.getGeoloc().setPosition(null);\n\t$varRiskName.probability = 0.0;\n}\n";
            code = code.replace("$varAssetSourceName", varAssetSourceName);
            code = code.replace("$varPotentialTargetName", varPotentialTargetName);
            code = code.replace("$varRiskName", varRiskName);
            code = code.replace("$riskName", riskName);
            code = code.replace("$actualityName", actualityName);
            return code;
        }
    }

    public static class AIPotentiality
    extends AIPojo {
        @JsonProperty(value="potentialityName")
        @Description(value={"the name of the potentiality"})
        public String potentialityName;
        @JsonProperty(value="potentialityId")
        @Description(value={"the identifier (uuid v4) of the potentiality"})
        public String potentialityId;
        @JsonProperty(value="potentialityType")
        @Description(value={"the type of the potentiality"})
        public PotentialityType potentialityType;
        @JsonProperty(value="probability")
        @Description(value={"the probability that this potentiality (risk or opportunity) occurs (value between 0 and 1)"})
        public double probability;
        @JsonProperty(value="potentialityDescription")
        @Description(value={"the description of the potentiality"})
        public String potentialityDescription;
        @JsonProperty(value="priorityLevel")
        @Description(value={"the priority level of this potentiality (risk or opportunity) (value between 0 and 1)"})
        public float priorityLevel;
        @JsonProperty(value="impactedAssets")
        @Description(value={"the list of impacted assets by this potentiality"})
        public List<PojoAsset.AIAsset> impactedAssets;
        @JsonProperty(value="objectives")
        @Description(value={"the list of objectives to achieve"})
        public List<PojoObjective.AIObjective> objectives;

        public GJaxbGenericModel convertToModel(GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput isolatedPotentialityInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbot) throws Exception {
            if (isolatedPotentialityInput.isSetPotentialityProbability()) {
                this.probability = isolatedPotentialityInput.getPotentialityProbability();
            }
            GJaxbGenericModel model = this.convertToModel(isolatedPotentialityInput.getPotentiality(), context, externalResource, aiChatbot);
            if (isolatedPotentialityInput.isGenerateAssociateActuality()) {
                GJaxbNode potentiality = GenericModelHelper.findNodeById((String)this.potentialityId, (List)model.getNode());
                GJaxbNode actuality = this.generateAssociateActualityFromPotentiality(model, potentiality);
                model.getNode().add(actuality);
                GJaxbEdge generatedByActPot = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)actuality, (GJaxbNode)potentiality, (QName)GenericModelHelper.collab((String)"Generated_By"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                generatedByActPot.setId("edgeFrom_" + potentiality.getId() + "_" + actuality.getId());
                GJaxbNode firstImpactAsset = null;
                if (this.impactedAssets.size() > 0) {
                    GJaxbGenericModel modelAsset = this.impactedAssets.get(0).convertToModel(context, aiChatbot);
                    firstImpactAsset = (GJaxbNode)modelAsset.getNode().get(0);
                }
                GenericModelHelper.findProperty((String)"activation condition", (List)generatedByActPot.getProperty(), (boolean)true).setValue(this.generateActivationCode(potentiality, actuality, firstImpactAsset));
                model.getEdge().add(generatedByActPot);
                actuality.getStatus().remove(GJaxbStatusType.ACTIVE);
                actuality.getStatus().add(GJaxbStatusType.FREEZE);
            }
            return model;
        }

        public GJaxbGenericModel convertToModel(GJaxbProblemInputType problemInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbot) throws Exception {
            PojoProblem.AIProblem problem = new PojoProblem.AIProblem();
            problem.problemId = this.potentialityId;
            problem.problemName = this.potentialityName;
            problem.problemType = PojoProblem.ProblemType.PREVENT_A_RISK;
            if (this.potentialityType == PotentialityType.OPPORTUNITY) {
                problem.problemType = PojoProblem.ProblemType.OFFER_AN_OPPORTUNITY;
            }
            problem.objectives = this.objectives;
            problem.impactedAssets = this.impactedAssets;
            problem.priorityLevel = this.priorityLevel;
            problem.probability = this.probability;
            GJaxbGenericModel model = PojoProblem.AIProblem.convertProblemToModel(problem, problemInput, context, externalResource, aiChatbot);
            return model;
        }

        private String generateActivationCode(GJaxbNode potentiality, GJaxbNode actuality, GJaxbNode asset) {
            String assetName = GenericModelHelper.getName((GJaxbNode)asset);
            String varAssetName = AccentRemover.removeAccents((String)RegExpHelper.toRegexFriendlyName((String)GenericModelHelper.getName((GJaxbNode)asset)).replaceAll("-", "_"));
            String actualityName = GenericModelHelper.getName((GJaxbNode)actuality);
            String varActualityName = AccentRemover.removeAccents((String)(RegExpHelper.toRegexFriendlyName((String)GenericModelHelper.getName((GJaxbNode)actuality)).replaceAll("-", "_") + "_actuality"));
            String potentialityName = GenericModelHelper.getName((GJaxbNode)potentiality);
            String varPotentialityName = AccentRemover.removeAccents((String)(RegExpHelper.toRegexFriendlyName((String)GenericModelHelper.getName((GJaxbNode)potentiality)).replaceAll("-", "_") + "_risk"));
            String code = "Node $varPotentialityName = $target;\nNode $varActualityName = $source;\nNode danger = $varPotentialityName.Generated_By();\nNode $varAssetName = danger.Impacts(\"$assetName\");\nif($varAssetName != null && $varAssetName.getGeoloc().getPosition().isNear(danger.getGeoloc().getCenter(), 0.000028)) {\n\t$varPotentialityName.probability = 1;\n\t$varPotentialityName.freeze();\n\tNode objective_that_prevents_$varPotentialityName = $varPotentialityName.Prevents(\"Prevent $potentialityName\");\n\tif(objective_that_prevents_$varPotentialityName != null) {\n\t\tobjective_that_prevents_$varPotentialityName.freeze();\n\t}\n\t$varActualityName.getGeoloc().setPosition(asset.getGeoloc().getPosition());\n\t$varActualityName.active();\n\n\tNode objective_that_treats_$varActualityName = $varActualityName.Treats(\"Treat $actualityName\");\n\tif(objective_that_treats_$varActualityName != null) {\n\t\tobjective_that_treats_$varActualityName.active();\n\t}\n}\n";
            code = code.replace("$varPotentialityName", varPotentialityName);
            code = code.replace("$potentialityName", potentialityName);
            code = code.replace("$varActualityName", varActualityName);
            code = code.replace("$actualityName", actualityName);
            code = code.replace("$assetName", assetName);
            code = code.replace("$varAssetName", varAssetName);
            return code;
        }

        private GJaxbNode generateAssociateActualityFromPotentiality(GJaxbGenericModel model, GJaxbNode potentiality) throws Exception {
            GJaxbNode actuality = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Actuality"));
            actuality.setId("actFrom_" + potentiality.getId());
            actuality.setBrokenEdges(new GJaxbNode.BrokenEdges());
            GenericModelHelper.findProperty((String)"name", (List)actuality.getProperty(), (boolean)true).setValue(GenericModelHelper.getName((GJaxbNode)potentiality).replace(" risk", " fact").replace(" Risk", " Fact"));
            if (GenericModelHelper.findProperty((String)"type", (List)potentiality.getProperty(), (boolean)true).getValue().toLowerCase().equals("risk")) {
                GenericModelHelper.findProperty((String)"type", (List)actuality.getProperty(), (boolean)true).setValue("Damage");
            } else {
                GenericModelHelper.findProperty((String)"type", (List)actuality.getProperty(), (boolean)true).setValue("Benefit");
            }
            actuality.setModeling(new GJaxbNode.Modeling());
            GJaxbNode.Modeling.ItemView ivAct = new GJaxbNode.Modeling.ItemView();
            ivAct.setViewId("view_" + UUID.randomUUID().toString());
            ivAct.setPackageName("Objectives");
            ivAct.setPosition(new GJaxbPosition());
            ivAct.getPosition().setX(0.0f);
            ivAct.getPosition().setY(0.0f);
            ivAct.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
            ivAct.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
            ivAct.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
            ivAct.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
            ivAct.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
            ivAct.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
            ivAct.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
            if (GenericModelHelper.findProperty((String)"type", (List)actuality.getProperty(), (boolean)true).getValue().equals("Damage")) {
                ivAct.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(PojoActuality.actDamageUrl);
            } else {
                ivAct.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(PojoActuality.actBeneficeUrl);
            }
            actuality.getModeling().getItemView().add(ivAct);
            model.getNode().add(actuality);
            return actuality;
        }
    }

    public static enum PotentialityType {
        RISK("RISK"),
        OPPORTUNITY("OPPORTUNITY");

        private final String text;

        private PotentialityType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

