/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.objectives;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import dev.langchain4j.internal.Json;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoAsset;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoActuality;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoObjective;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoPotentiality;
import fr.emac.gind.gov.ai.chatbot.service.util.PhotosHelper;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbHasReferenceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbPictureInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbProblemInputType;
import fr.emac.gind.gov.ai_chatbot.GJaxbProblemType;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.metamodel.GJaxbDimension;
import fr.emac.gind.modeler.metamodel.GJaxbModelingViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

public class PojoProblem {

    public static interface ProblemsExtractor {
        public static final String SYSTEM_MSG = "    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tproblems: [\n    \t\t\t\t  {\n    \t\t\t\t  \tproblemName: ...,\n    \t\t\t\t\tproblemId: ...,\n    \t\t\t\t\tproblemType: ...,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\timagesId: [...]\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n";

        @SystemMessage(value={"    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tproblems: [\n    \t\t\t\t  {\n    \t\t\t\t  \tproblemName: ...,\n    \t\t\t\t\tproblemId: ...,\n    \t\t\t\t\tproblemType: ...,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\timagesId: [...]\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n"})
        public AIProblems extractProblemsFromPictures(@UserMessage String var1);
    }

    public static class AIProblems
    extends AIPojo {
        @JsonProperty(value="problems")
        @Description(value={"the list of problems"})
        List<AIProblem> problems;

        public GJaxbGenericModel convertToModel(List<GJaxbPictureInput> picturesInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            for (AIProblem aiProblem : this.problems) {
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiProblem.convertToModel(picturesInput, context, externalResource, aiChatbotImpl));
            }
            return model;
        }

        public static AIProblems parse(JSONObject jsonObject) {
            String text = jsonObject.toString();
            return (AIProblems)Json.fromJson((String)text, AIProblems.class);
        }
    }

    public static class AIProblem
    extends AIPojo {
        @JsonProperty(value="problemName")
        @Description(value={"the name of the problem"})
        public String problemName;
        @JsonProperty(value="problemId")
        @Description(value={"the identifier (uuid v4) of the problem"})
        public String problemId;
        @JsonProperty(value="problemType")
        @Description(value={"the type of the problem"})
        public ProblemType problemType;
        @JsonProperty(value="probability")
        @Description(value={"the probability that this problem occurs (only if problemType='PREVENT_A_RISK' or problemType='OFFER_AN_OPPORTUNITY') occurs (value between 0 and 1)"})
        public double probability;
        @JsonProperty(value="description")
        @Description(value={"the description of the problem"})
        public String description;
        @JsonProperty(value="priorityLevel")
        @Description(value={"the priority level of this problem (value between 0 and 1)"})
        public float priorityLevel;
        @JsonProperty(value="impactedAssets")
        @Description(value={"the list of impacted assets by this problem"})
        public List<PojoAsset.AIAsset> impactedAssets;
        @JsonProperty(value="objectives")
        @Description(value={"the list of objectives to achieve"})
        public List<PojoObjective.AIObjective> objectives;
        @JsonProperty(value="risks")
        @Description(value={"the list of risks"})
        public List<PojoPotentiality.AIPotentiality> risks;
        @JsonProperty(value="opportunities")
        @Description(value={"the list of opportunities"})
        public List<PojoPotentiality.AIPotentiality> opportunities;
        @JsonProperty(value="imagesId")
        @Description(value={"the list of images identifier that apparts to the same problem"})
        public List<String> imagesId;

        @Override
        public String toString() {
            String res = null;
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String jsonString;
                res = jsonString = objectMapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            return res;
        }

        public GJaxbGenericModel convertToModel(List<GJaxbPictureInput> picturesInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbNode problemNode = null;
            GJaxbProblemInputType problemInput = new GJaxbProblemInputType();
            problemInput.setProblemId(this.problemId);
            problemInput.setProblemName(this.problemName);
            problemInput.setProblemType(GJaxbProblemType.valueOf((String)this.problemType.toString()));
            problemInput.setGeneratePicture(false);
            problemInput.setHasRef(GJaxbHasReferenceType.NO);
            problemInput.setGenerateAssociateObjective(true);
            if (this.problemType.equals((Object)ProblemType.TREAT_A_DAMAGE_ACTUALITY)) {
                GJaxbInventActualities actRequest = new GJaxbInventActualities();
                actRequest.setContext(context);
                actRequest.getActualityInput().add(problemInput);
                GJaxbInventActualitiesResponse actResponse = aiChatbotImpl.inventActualities(actRequest);
                problemNode = GenericModelHelper.findNodeById((String)this.problemId, (List)actResponse.getGenericModel().getNode());
                model.getNode().addAll(actResponse.getGenericModel().getNode());
                model.getEdge().addAll(actResponse.getGenericModel().getEdge());
            } else {
                GJaxbInventPotentialities potRequest = new GJaxbInventPotentialities();
                potRequest.setContext(context);
                GJaxbInventPotentialities.PotentialityInput pi2 = new GJaxbInventPotentialities.PotentialityInput();
                potRequest.setPotentialityInput(pi2);
                GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput ipi = new GJaxbInventPotentialities.PotentialityInput.IsolatedPotentialityInput();
                pi2.getIsolatedPotentialityInput().add(ipi);
                ipi.setPotentiality(problemInput);
                potRequest.getPotentialityInput().getIsolatedPotentialityInput().add(ipi);
                GJaxbInventPotentialitiesResponse actResponse = aiChatbotImpl.inventPotentialities(potRequest);
                problemNode = GenericModelHelper.findNodeById((String)this.problemId, (List)actResponse.getGenericModel().getNode());
                model.getNode().addAll(actResponse.getGenericModel().getNode());
                model.getEdge().addAll(actResponse.getGenericModel().getEdge());
            }
            if (this.imagesId != null && !this.imagesId.isEmpty()) {
                String imageId = this.imagesId.get(0);
                GJaxbPictureInput pInput = picturesInput.stream().filter(pi -> pi.getPictureId().equals(imageId)).findFirst().get();
                problemNode.setGeolocation(new GJaxbNode.Geolocation());
                GJaxbNode.Geolocation.ItemView ivRisk = new GJaxbNode.Geolocation.ItemView();
                ivRisk.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                ivRisk.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                ivRisk.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                ivRisk.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(pInput.getPictureUrl());
                problemNode.getGeolocation().getItemView().add(ivRisk);
            }
            return model;
        }

        public static GJaxbGenericModel convertProblemToModel(AIProblem aiProblem, GJaxbProblemInputType problemInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbot) throws Exception {
            GJaxbNode potentiality;
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbNode problem = null;
            String problemImgUrl = null;
            if (aiProblem.problemType.equals((Object)ProblemType.TREAT_A_DAMAGE_ACTUALITY) || aiProblem.problemType.equals((Object)ProblemType.TREAT_A_BENEFIT_ACTUALITY)) {
                problem = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Actuality"));
                if (aiProblem.problemType.equals((Object)ProblemType.TREAT_A_DAMAGE_ACTUALITY)) {
                    GenericModelHelper.findProperty((String)"type", (List)problem.getProperty(), (boolean)true).setValue("Damage");
                    problemImgUrl = PojoActuality.actDamageUrl;
                } else if (aiProblem.problemType.equals((Object)ProblemType.TREAT_A_BENEFIT_ACTUALITY)) {
                    GenericModelHelper.findProperty((String)"type", (List)problem.getProperty(), (boolean)true).setValue("Benefit");
                    problemImgUrl = PojoActuality.actBeneficeUrl;
                }
            } else if (aiProblem.problemType.equals((Object)ProblemType.PREVENT_A_RISK) || aiProblem.problemType.equals((Object)ProblemType.OFFER_AN_OPPORTUNITY)) {
                problem = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Potentiality"));
                GenericModelHelper.findProperty((String)"probability", (List)problem.getProperty(), (boolean)true).setValue("{\"theoricValue\":{\"precise\":" + aiProblem.priorityLevel + "}}");
                if (aiProblem.problemType.equals((Object)ProblemType.PREVENT_A_RISK)) {
                    GenericModelHelper.findProperty((String)"type", (List)problem.getProperty(), (boolean)true).setValue("Risk");
                    problemImgUrl = PojoPotentiality.potRiskUrl;
                } else if (aiProblem.problemType.equals((Object)ProblemType.OFFER_AN_OPPORTUNITY)) {
                    GenericModelHelper.findProperty((String)"type", (List)problem.getProperty(), (boolean)true).setValue("Opportunity");
                    problemImgUrl = PojoPotentiality.potOpportunityUrl;
                }
            }
            model.getNode().add(problem);
            problem.setId(aiProblem.problemId);
            problem.setBrokenEdges(new GJaxbNode.BrokenEdges());
            GenericModelHelper.findProperty((String)"name", (List)problem.getProperty(), (boolean)true).setValue(aiProblem.problemName);
            GenericModelHelper.findProperty((String)"priority", (List)problem.getProperty(), (boolean)true).setValue(String.valueOf(aiProblem.priorityLevel));
            if (problemInput.isGeneratePicture()) {
                GJaxbInventPictures pictReq = new GJaxbInventPictures();
                pictReq.setContext(context);
                GJaxbInventPictures.PictureInput pictureInput = new GJaxbInventPictures.PictureInput();
                pictureInput.setDescription(aiProblem.problemName);
                pictReq.getPictureInput().add(pictureInput);
                GJaxbInventPicturesResponse pictResp = aiChatbot.inventPictures(pictReq);
                String generatedActalityImgUrl = ((GJaxbInventPicturesResponse.PictureOutput)pictResp.getPictureOutput().get(0)).getPictureUrl();
                if (generatedActalityImgUrl != null) {
                    GJaxbExternalResourceType actualityRsc = PhotosHelper.uploadUrl(generatedActalityImgUrl, problem.getId() + "::picture", "image/png");
                    externalResource.add(actualityRsc);
                    problemImgUrl = generatedActalityImgUrl;
                }
            }
            problem.setModeling(new GJaxbNode.Modeling());
            GJaxbNode.Modeling.ItemView iv = new GJaxbNode.Modeling.ItemView();
            iv.setPackageName("Objectives");
            iv.setViewId("view_" + UUID.randomUUID().toString());
            iv.setPosition(new GJaxbPosition());
            iv.getPosition().setX(0.0f);
            iv.getPosition().setY(0.0f);
            iv.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
            iv.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
            iv.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(problemImgUrl);
            problem.getModeling().getItemView().add(iv);
            ArrayList<GJaxbNode> impactedAssets = new ArrayList<GJaxbNode>();
            for (GJaxbProblemInputType.Impacts impact : problemInput.getImpacts()) {
                if (impact.getNode() == null) continue;
                impactedAssets.add(impact.getNode());
                GJaxbEdge has = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Impacts"));
                has.setSource(problem);
                has.setTarget(impact.getNode());
                model.getEdge().add(has);
                GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
                be.setEdge(has);
                be.setSourceId(problem.getId());
                be.setTargetId(impact.getNode().getId());
                problem.getBrokenEdges().getBrokenEdge().add(be);
                model.getNode().add(impact.getNode());
            }
            boolean alreadyGeolocated = false;
            if (problemInput.isSetPoint()) {
                GJaxbPointType point = problemInput.getPoint();
                problem.setGeolocation(new GJaxbNode.Geolocation());
                GJaxbNode.Geolocation.ItemView ivAct = new GJaxbNode.Geolocation.ItemView();
                ivAct.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                ivAct.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(problemImgUrl);
                ivAct.setPoint(new GJaxbPointType());
                ivAct.getPoint().setLatitude(point.getLatitude());
                ivAct.getPoint().setLongitude(point.getLongitude());
                problem.getGeolocation().getItemView().add(ivAct);
                alreadyGeolocated = true;
            }
            Polygon impactedAssetPolygon = null;
            if (impactedAssets.size() > 0 && !alreadyGeolocated) {
                GJaxbNode firstImpactAsset = (GJaxbNode)impactedAssets.get(0);
                List geoms = GeometryHelper.getInstance().extractGeometryFromGJaxbNode(firstImpactAsset);
                if (geoms != null && !geoms.isEmpty()) {
                    problem.setGeolocation(new GJaxbNode.Geolocation());
                    GJaxbNode.Geolocation.ItemView ivAct = new GJaxbNode.Geolocation.ItemView();
                    ivAct.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                    ivAct.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                    ivAct.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                    ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(problemImgUrl);
                    ivAct.setPoint(new GJaxbPointType());
                    problem.getGeolocation().getItemView().add(ivAct);
                    Geometry geom = (Geometry)geoms.get(0);
                    if (geom instanceof Polygon) {
                        impactedAssetPolygon = (Polygon)geom;
                        Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(impactedAssetPolygon);
                        ivAct.getPoint().setLatitude(Double.valueOf(randomPoint.getY()));
                        ivAct.getPoint().setLongitude(Double.valueOf(randomPoint.getX()));
                    } else if (geom instanceof Point) {
                        Point point = (Point)geom;
                        ivAct.getPoint().setLatitude(Double.valueOf(point.getY()));
                        ivAct.getPoint().setLongitude(Double.valueOf(point.getX()));
                    }
                }
            }
            if (problemInput.isSetHasRef() && !GJaxbHasReferenceType.NO.equals((Object)problemInput.getHasRef())) {
                GJaxbNode nearInstance = problemInput.getReference().getNode();
                GJaxbEdge near = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.core((String)"Near"));
                near.setSource(problem);
                near.setTarget(nearInstance);
                model.getEdge().add(near);
                GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
                be.setEdge(near);
                be.setSourceId(problem.getId());
                be.setTargetId(nearInstance.getId());
                problem.getBrokenEdges().getBrokenEdge().add(be);
                model.getNode().add(nearInstance);
            }
            if (aiProblem.risks != null && !aiProblem.risks.isEmpty()) {
                for (PojoPotentiality.AIPotentiality aiRisk : aiProblem.risks) {
                    model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiRisk.convertToModel(problemInput, context, externalResource, aiChatbot));
                    potentiality = GenericModelHelper.findNodeById((String)aiRisk.potentialityId, (List)model.getNode());
                    AIProblem.connectPotentialityToProblem(model, problem, potentiality);
                    AIProblem.assignGeoLocFromAera(alreadyGeolocated, impactedAssetPolygon, potentiality);
                }
            }
            if (aiProblem.opportunities != null && !aiProblem.opportunities.isEmpty()) {
                for (PojoPotentiality.AIPotentiality aiOpportunity : aiProblem.opportunities) {
                    model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiOpportunity.convertToModel(problemInput, context, externalResource, aiChatbot));
                    potentiality = GenericModelHelper.findNodeById((String)aiOpportunity.potentialityId, (List)model.getNode());
                    AIProblem.connectPotentialityToProblem(model, problem, potentiality);
                    AIProblem.assignGeoLocFromAera(alreadyGeolocated, impactedAssetPolygon, potentiality);
                }
            }
            if (aiProblem.objectives != null && !aiProblem.objectives.isEmpty()) {
                for (PojoObjective.AIObjective aiObjective : aiProblem.objectives) {
                    model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiObjective.convertToModel(context, aiChatbot));
                    GJaxbNode objective = GenericModelHelper.findNodeById((String)aiObjective.objectiveId, (List)model.getNode());
                    if (aiProblem.problemType.equals((Object)ProblemType.TREAT_A_DAMAGE_ACTUALITY) || aiProblem.problemType.equals((Object)ProblemType.TREAT_A_BENEFIT_ACTUALITY)) {
                        GJaxbEdge treats = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Treats"));
                        treats.setSource(objective);
                        treats.setTarget(problem);
                        model.getEdge().add(treats);
                        continue;
                    }
                    if (!aiProblem.problemType.equals((Object)ProblemType.PREVENT_A_RISK) && !aiProblem.problemType.equals((Object)ProblemType.OFFER_AN_OPPORTUNITY)) continue;
                    GJaxbEdge prevents = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Prevents"));
                    prevents.setSource(objective);
                    prevents.setTarget(problem);
                    model.getEdge().add(prevents);
                }
            } else if (problemInput.isGenerateAssociateObjective()) {
                GJaxbNode objective = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Objective"));
                model.getNode().add(objective);
                if (aiProblem.problemType.equals((Object)ProblemType.TREAT_A_DAMAGE_ACTUALITY) || aiProblem.problemType.equals((Object)ProblemType.TREAT_A_BENEFIT_ACTUALITY)) {
                    GenericModelHelper.findProperty((String)"name", (List)objective.getProperty(), (boolean)true).setValue("Treats " + GenericModelHelper.getName((GJaxbNode)problem));
                    GJaxbEdge treats = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Treats"));
                    treats.setSource(objective);
                    treats.setTarget(problem);
                    model.getEdge().add(treats);
                } else if (aiProblem.problemType.equals((Object)ProblemType.PREVENT_A_RISK) || aiProblem.problemType.equals((Object)ProblemType.OFFER_AN_OPPORTUNITY)) {
                    GenericModelHelper.findProperty((String)"name", (List)objective.getProperty(), (boolean)true).setValue("Prevents " + GenericModelHelper.getName((GJaxbNode)problem));
                    GJaxbEdge prevents = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Prevents"));
                    prevents.setSource(objective);
                    prevents.setTarget(problem);
                    model.getEdge().add(prevents);
                }
            }
            return model;
        }

        private static void assignGeoLocFromAera(boolean alreadyGeolocated, Polygon impactedAssetPolygon, GJaxbNode potentiality) {
            if (impactedAssetPolygon != null && !alreadyGeolocated) {
                Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(impactedAssetPolygon);
                potentiality.setGeolocation(new GJaxbNode.Geolocation());
                GJaxbNode.Geolocation.ItemView ivRisk = new GJaxbNode.Geolocation.ItemView();
                ivRisk.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                ivRisk.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                ivRisk.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                ivRisk.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(PojoPotentiality.potRiskUrl);
                ivRisk.setPoint(new GJaxbPointType());
                ivRisk.getPoint().setLatitude(Double.valueOf(randomPoint.getY()));
                ivRisk.getPoint().setLongitude(Double.valueOf(randomPoint.getX()));
                potentiality.getGeolocation().getItemView().add(ivRisk);
            }
        }

        private static void connectPotentialityToProblem(GJaxbGenericModel model, GJaxbNode actuality, GJaxbNode potentiality) throws Exception {
            GJaxbEdge generatedBy = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Generated_By"));
            generatedBy.setSource(potentiality);
            generatedBy.setTarget(actuality);
            model.getEdge().add(generatedBy);
            GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
            be.setEdge(generatedBy);
            be.setSourceId(potentiality.getId());
            be.setTargetId(actuality.getId());
            potentiality.getBrokenEdges().getBrokenEdge().add(be);
        }
    }

    public static enum ProblemType {
        TREAT_A_DAMAGE_ACTUALITY("TREAT_A_DAMAGE_ACTUALITY"),
        TREAT_A_BENEFIT_ACTUALITY("TREAT_A_BENEFIT_ACTUALITY"),
        PREVENT_A_RISK("PREVENT_A_RISK"),
        OFFER_AN_OPPORTUNITY("OFFER_AN_OPPORTUNITY");

        private final String text;

        private ProblemType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

