/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.util;

import fr.emac.gind.commons.utils.rest.HTTPClientUtil;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.util.Base64;
import org.json.JSONObject;

public class PhotosHelper {
    private String unsplash_api_key = null;
    private static PhotosHelper INSTANCE = null;

    private PhotosHelper() {
        if (System.getenv("UNSPLASH_ACCESS_KEY") != null) {
            this.unsplash_api_key = System.getenv("UNSPLASH_ACCESS_KEY");
        }
    }

    public static PhotosHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PhotosHelper();
        }
        return INSTANCE;
    }

    public GJaxbExternalResourceType getRandomPhotos(String query) throws Exception {
        GJaxbExternalResourceType res = null;
        if (this.unsplash_api_key == null) {
            return null;
        }
        String address = "https://api.unsplash.com/photos/random/?client_id=" + this.unsplash_api_key + "&query=" + query.replaceAll(" ", "%20");
        HttpResponse response = HTTPClientUtil.sendHTTPRequest((HTTPClientUtil.HTTPProtocol)HTTPClientUtil.HTTPProtocol.GET, (String)address, null, null, null, null);
        int statusCode = response.statusCode();
        if (statusCode == 200) {
            String responseBody = (String)response.body();
            JSONObject respObj = new JSONObject(responseBody);
            String id = respObj.getString("id");
            JSONObject urls = respObj.getJSONObject("urls");
            String imgRegularUrl = urls.getString("regular");
            System.out.println("R\u00e9ponse de l'API Unsplash :");
            System.out.println(responseBody);
            res = PhotosHelper.uploadUrl(imgRegularUrl, id, "image/jpg");
        }
        return res;
    }

    public static GJaxbExternalResourceType uploadUrl(String imgRegularUrl, String id, String type) throws IOException, InterruptedException {
        GJaxbExternalResourceType res = null;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(imgRegularUrl));
        requestBuilder = requestBuilder.GET();
        HttpResponse<byte[]> responseImgRegular = HttpClient.newBuilder().build().send(requestBuilder.build(), HttpResponse.BodyHandlers.ofByteArray());
        int statusCodeImgRegular = responseImgRegular.statusCode();
        if (statusCodeImgRegular == 200) {
            res = new GJaxbExternalResourceType();
            res.setId(id);
            res.setContentType(type);
            res.setData(responseImgRegular.body());
        }
        return res;
    }

    public static String encodeImageTOBase64FromFile(File file) throws IOException {
        byte[] fileContent = Files.readAllBytes(file.toPath());
        String base64Image = Base64.getEncoder().encodeToString(fileContent);
        return base64Image;
    }

    public static byte[] decodeImageFromBase64ToFile(String bufferBase64) throws IOException {
        if (bufferBase64.contains("base64,")) {
            bufferBase64 = bufferBase64.substring(bufferBase64.indexOf("base64,") + "base64,".length(), bufferBase64.length());
        }
        byte[] fileBuffer = Base64.getDecoder().decode(bufferBase64);
        return fileBuffer;
    }
}

