/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.builder.model.openai;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiImageModel;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ChatModelBuilder;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import java.lang.reflect.Field;
import java.util.Arrays;

public class OpenAiChatModelBuilder
implements ChatModelBuilder {
    private static OpenAiChatModel chatLanguageModel = null;
    private static OpenAiChatModel imageAnalysisChatLanguageModel = null;
    private static OpenAiImageModel imageCreationLanguageModel = null;
    private static GJaxbContext.ChatGPTContext currentGptCtxt = null;

    @Override
    public String getName() {
        return "Chat-GPT";
    }

    private boolean needToRebuild(GJaxbContext defaultContext, GJaxbContext context) {
        GJaxbContext newContext;
        int hash2;
        int hash1 = context.hashCode();
        return hash1 != (hash2 = (newContext = this.mergeConfiguration(defaultContext, context)).hashCode());
    }

    private GJaxbContext mergeConfiguration(GJaxbContext defaultContext, GJaxbContext newContext) {
        GJaxbContext.ChatGPTContext defaultGptCtxt = defaultContext.getChatGPTContext();
        GJaxbContext.ChatGPTContext newGptCtxt = newContext.getChatGPTContext();
        if (newGptCtxt == null) {
            newContext.setChatGPTContext(defaultGptCtxt);
            newGptCtxt = newContext.getChatGPTContext();
        }
        if (!newGptCtxt.isSetModelName()) {
            newGptCtxt.setModelName(defaultGptCtxt.getModelName());
        }
        if (!newGptCtxt.isSetMaxTokens()) {
            newGptCtxt.setMaxTokens(defaultGptCtxt.getMaxTokens());
        }
        if (!newGptCtxt.isSetResponseFormat()) {
            newGptCtxt.setResponseFormat(defaultGptCtxt.getResponseFormat());
        }
        if (!newGptCtxt.isSetTemperature()) {
            newGptCtxt.setTemperature(defaultGptCtxt.getTemperature());
        }
        return newContext;
    }

    @Override
    public ChatModel getChatModel(GJaxbContext context) {
        if (chatLanguageModel == null) {
            this.buildChatModel(context);
        } else if (this.needToRebuild(this.createDefaultConfigurationForChatModel(), context)) {
            this.buildChatModel(context);
        }
        return chatLanguageModel;
    }

    @Override
    public boolean existChatModel() {
        GJaxbContext context = new GJaxbContext();
        context.setChatGPTContext(new GJaxbContext.ChatGPTContext());
        return this.getChatModel(context) != null;
    }

    @Override
    public GJaxbContext createDefaultConfigurationForChatModel() {
        GJaxbContext.ChatGPTContext gptCtxt = new GJaxbContext.ChatGPTContext();
        gptCtxt.setModelName(ChatModelName.gpt_4.toString());
        gptCtxt.setTemperature(Double.valueOf(0.3));
        gptCtxt.setResponseFormat("json_object");
        GJaxbContext ctxt = new GJaxbContext();
        ctxt.setChatGPTContext(gptCtxt);
        return ctxt;
    }

    private void buildChatModel(GJaxbContext.ChatGPTContext gptCtxt) {
        String OPENAI_CHATGPT_API_KEY = System.getenv("OPENAI_CHATGPT_API_KEY");
        if (OPENAI_CHATGPT_API_KEY != null && !OPENAI_CHATGPT_API_KEY.isBlank()) {
            currentGptCtxt = gptCtxt;
            chatLanguageModel = OpenAiChatModel.builder().apiKey(OPENAI_CHATGPT_API_KEY).modelName(ChatModelName.gpt_4.toString()).maxTokens(currentGptCtxt.getMaxTokens()).responseFormat("json_object").temperature(currentGptCtxt.getTemperature()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
        }
    }

    @Override
    public void buildChatModel(GJaxbContext context) {
        if (context == null) {
            context = this.createDefaultConfigurationForChatModel();
        } else if (context.getChatGPTContext() == null) {
            context.setChatGPTContext(this.createDefaultConfigurationForChatModel().getChatGPTContext());
        } else {
            context = this.mergeConfiguration(this.createDefaultConfigurationForChatModel(), context);
        }
        this.buildChatModel(context.getChatGPTContext());
    }

    @Override
    public ChatModel getImageAnalysisChatModel(GJaxbContext context) {
        if (imageAnalysisChatLanguageModel == null) {
            this.buildImageAnalysisChatModel(context);
        } else if (this.needToRebuild(this.createDefaultConfigurationForImageAnalysisChatModel(), context)) {
            this.buildImageAnalysisChatModel(context);
        }
        return imageAnalysisChatLanguageModel;
    }

    @Override
    public GJaxbContext createDefaultConfigurationForImageAnalysisChatModel() {
        GJaxbContext.ChatGPTContext gptCtxt = new GJaxbContext.ChatGPTContext();
        gptCtxt.setModelName(ImageAnalysisModelName.gpt_4_vision.toString());
        gptCtxt.setTemperature(Double.valueOf(0.3));
        gptCtxt.setResponseFormat("json_object");
        GJaxbContext ctxt = new GJaxbContext();
        ctxt.setChatGPTContext(gptCtxt);
        return ctxt;
    }

    @Override
    public boolean existImageAnalysisChatModel() {
        GJaxbContext context = new GJaxbContext();
        context.setChatGPTContext(new GJaxbContext.ChatGPTContext());
        return this.getImageAnalysisChatModel(context) != null;
    }

    private void buildImageAnalysisChatModel(GJaxbContext.ChatGPTContext gptCtxt) {
        String OPENAI_CHATGPT_API_KEY = System.getenv("OPENAI_CHATGPT_API_KEY");
        if (OPENAI_CHATGPT_API_KEY != null && !OPENAI_CHATGPT_API_KEY.isBlank()) {
            currentGptCtxt = gptCtxt;
            imageAnalysisChatLanguageModel = OpenAiChatModel.builder().apiKey(OPENAI_CHATGPT_API_KEY).modelName(ImageAnalysisModelName.gpt_4_vision.toString()).responseFormat("json_object").maxTokens(currentGptCtxt.getMaxTokens()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).listeners(Arrays.asList(new ChatModelListener(this){

                public void onResponse(ChatModelResponseContext responseContext) {
                    try {
                        if (responseContext.chatResponse().modelName().equals(ImageAnalysisModelName.gpt_4_vision.toString())) {
                            System.out.println("************ WRAP RESPONSE TO CONVERT JSON");
                            String jsonResponse = responseContext.chatResponse().aiMessage().text();
                            if (jsonResponse.indexOf("```json") >= 0) {
                                jsonResponse = jsonResponse.substring(jsonResponse.indexOf("```json") + "```json".length(), jsonResponse.lastIndexOf("```")).strip();
                            } else if (jsonResponse.indexOf("```") >= 0) {
                                jsonResponse = jsonResponse.substring(jsonResponse.indexOf("```") + "```".length(), jsonResponse.lastIndexOf("```")).strip();
                            }
                            Field textField = AiMessage.class.getDeclaredField("text");
                            textField.setAccessible(true);
                            ReflectionHelper.setFieldValue((Object)responseContext.chatResponse().aiMessage(), (Field)textField, (Object)jsonResponse);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    super.onResponse(responseContext);
                }
            })).build();
        }
    }

    @Override
    public void buildImageAnalysisChatModel(GJaxbContext context) {
        if (context == null) {
            context = this.createDefaultConfigurationForImageAnalysisChatModel();
        } else if (context.getChatGPTContext() == null) {
            context.setChatGPTContext(this.createDefaultConfigurationForImageAnalysisChatModel().getChatGPTContext());
        } else {
            context = this.mergeConfiguration(this.createDefaultConfigurationForImageAnalysisChatModel(), context);
        }
        this.buildImageAnalysisChatModel(context.getChatGPTContext());
    }

    @Override
    public ImageModel getImageCreationModel(GJaxbContext context) {
        if (imageCreationLanguageModel == null) {
            this.buildImageCreationModel(context);
        } else if (this.needToRebuild(this.createDefaultConfigurationForImageCreationModel(), context)) {
            this.buildImageCreationModel(context);
        }
        return imageCreationLanguageModel;
    }

    @Override
    public boolean existImageCreationModel() {
        GJaxbContext context = new GJaxbContext();
        context.setChatGPTContext(new GJaxbContext.ChatGPTContext());
        return this.getImageCreationModel(context) != null;
    }

    private void buildImageCreationModel(GJaxbContext.ChatGPTContext gptCtxt) {
        String OPENAI_CHATGPT_API_KEY = System.getenv("OPENAI_CHATGPT_API_KEY");
        if (OPENAI_CHATGPT_API_KEY != null && !OPENAI_CHATGPT_API_KEY.isBlank()) {
            currentGptCtxt = gptCtxt;
            imageCreationLanguageModel = OpenAiImageModel.builder().apiKey(OPENAI_CHATGPT_API_KEY).modelName(ImageCreationModelName.DALLE_3.toString()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
        }
    }

    @Override
    public void buildImageCreationModel(GJaxbContext context) {
        if (context == null) {
            context = this.createDefaultConfigurationForImageCreationModel();
        } else if (context.getChatGPTContext() == null) {
            context.setChatGPTContext(this.createDefaultConfigurationForImageCreationModel().getChatGPTContext());
        } else {
            context = this.mergeConfiguration(this.createDefaultConfigurationForImageCreationModel(), context);
        }
        this.buildImageCreationModel(context.getChatGPTContext());
    }

    @Override
    public GJaxbContext createDefaultConfigurationForImageCreationModel() {
        GJaxbContext.ChatGPTContext gptCtxt = new GJaxbContext.ChatGPTContext();
        gptCtxt.setModelName(ImageCreationModelName.DALLE_3.toString());
        GJaxbContext ctxt = new GJaxbContext();
        ctxt.setChatGPTContext(gptCtxt);
        return ctxt;
    }

    public static enum ChatModelName {
        gpt_4("gpt-4o");

        private final String text;

        private ChatModelName(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum ImageAnalysisModelName {
        gpt_4_vision("gpt-4o");

        private final String text;

        private ImageAnalysisModelName(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum ImageCreationModelName {
        DALLE_3("dall-e-3");

        private final String text;

        private ImageCreationModelName(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

