/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.util.PhotosHelper;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbGoodInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbRole;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import java.awt.Color;
import java.util.List;
import java.util.UUID;

public class PojoGood {

    public static interface GoodExtractor {
        @SystemMessage(value={"    \t\t\tYou are an expert in material resources. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tgroupId: ...,\n    \t\t\t\tnumberOfGoodsInGroup: ...,\n    \t\t\t\tmodel: ...,\n    \t\t\t\tgoods: [\n    \t\t\t\t\t{\n    \t\t\t\t\t\tname: ...\n    \t\t\t\t\t\tmodel: ...\n    \t\t\t\t\t},\n    \t\t\t\t\t...\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"For each group in this array {{it}}, do you invent me the name for this good that correspond to the model (avoid duplicates and invent at random, at the moment, depending on the location of the request)"})
        public AIGroupOfGoods extractGroupOfGoods(String var1);
    }

    public static class AIGroupOfGoods
    extends AIPojo {
        @JsonProperty(value="groupId")
        @Description(value={"the identifier (uuid v4) of the group"})
        public String groupId;
        @JsonProperty(value="numberOfGoodsInGroup")
        @Description(value={"the number of goods in the group"})
        public int numberOfPGoodsInGroup;
        @JsonProperty(value="model")
        @Description(value={"the model, the type, the role of good to invent"})
        public String model;
        @JsonProperty(value="goods")
        @Description(value={"the list of goods"})
        public List<AIGood> goods;

        public GJaxbGenericModel convertToModel(GJaxbGoodInput gooodInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            for (AIGood aiGood : this.goods) {
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiGood.convertToModel(gooodInput, context, externalResource, aiChatbotImpl));
            }
            return model;
        }
    }

    public static class AIGood
    extends AIPojo {
        @JsonProperty(value="name")
        @Description(value={"the name of good"})
        public String name;
        @JsonProperty(value="model")
        @Description(value={"the model, the role, the type of good"})
        public String model;

        public GJaxbGenericModel convertToModel(GJaxbGoodInput input, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbExternalResourceType face;
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbEffectiveConceptType concept = EffectiveMetaModelPluginManager.getInstance().getConceptByType(GenericModelHelper.collab((String)"Good"));
            GJaxbNode good = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Good"));
            good.setBrokenEdges(new GJaxbNode.BrokenEdges());
            good.setModeling(new GJaxbNode.Modeling());
            GJaxbNode.Modeling.ItemView ivCtxtAndPartner = new GJaxbNode.Modeling.ItemView();
            ivCtxtAndPartner.setViewId("view_" + String.valueOf(UUID.randomUUID()));
            ivCtxtAndPartner.setPackageName("Context and partners");
            ivCtxtAndPartner.setPosition(new GJaxbPosition());
            good.getModeling().getItemView().add(ivCtxtAndPartner);
            GenericModelHelper.findProperty((String)"name", (List)good.getProperty(), (boolean)true).setValue(this.name);
            GenericModelHelper.findProperty((String)"color", (List)good.getProperty(), (boolean)true).setValue(ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor()));
            String queryPhoto = this.name;
            if (input.isSetRole() && !input.getRole().isEmpty()) {
                queryPhoto = GenericModelHelper.getName((GJaxbNode)((GJaxbRole)input.getRole().get(0)).getNode());
            }
            if ((face = PhotosHelper.getInstance().getRandomPhotos(queryPhoto)) != null) {
                face.setId(good.getId() + "::picture");
                externalResource.add(face);
                ivCtxtAndPartner.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
                ivCtxtAndPartner.getSpecificModeling().setNodeMetaModeling((GJaxbNodeMetaModeling)GenericModelHelper.clone((AbstractJaxbObject)concept.getNodeMetaModeling(), GJaxbNodeMetaModeling.class));
            }
            for (GJaxbRole role : input.getRole()) {
                GJaxbEdge has = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Has"));
                has.setSource(good);
                has.setTarget(role.getNode());
                model.getEdge().add(has);
                GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
                be.setEdge(has);
                be.setSourceId(good.getId());
                be.setTargetId(role.getNode().getId());
                good.getBrokenEdges().getBrokenEdge().add(be);
                model.getNode().add(role.getNode());
            }
            GJaxbNode.Geolocation.ItemView goodPositionIv = null;
            if (input.getTerritory() != null && input.getTerritory().getNode() != null && input.getTerritory().getNode().getGeolocation() != null) {
                Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromGJaxbNode(input.getTerritory().getNode()).get(0);
                Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
                good.setGeolocation(new GJaxbNode.Geolocation());
                goodPositionIv = new GJaxbNode.Geolocation.ItemView();
                goodPositionIv.setPoint(new GJaxbPointType());
                goodPositionIv.getPoint().setLatitude(Double.valueOf(randomPoint.getY()));
                goodPositionIv.getPoint().setLongitude(Double.valueOf(randomPoint.getX()));
                good.getGeolocation().getItemView().add(goodPositionIv);
            }
            model.getNode().add(good);
            return model;
        }
    }
}

