/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.builder;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.image.ImageModel;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama.OllamaChatModelBuilder;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama.OllamaContainerConfig;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama.OllamaManager;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.openai.OpenAiChatModelBuilder;
import fr.emac.gind.gov.ai_chatbot.GJaxbAiChatBotType;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelBuilderSelector {
    private static ModelBuilderSelector INSTANCE;
    OpenAiChatModelBuilder openAiChatModelBuilder = null;
    Map<GJaxbAiChatBotType, OllamaChatModelBuilder> ollamaChatModelBuilders = new HashMap<GJaxbAiChatBotType, OllamaChatModelBuilder>();

    ModelBuilderSelector() {
        this.openAiChatModelBuilder = new OpenAiChatModelBuilder();
        if (OllamaManager.getInstance().getContainersConfig() != null) {
            for (OllamaContainerConfig ollamaConfig : OllamaManager.getInstance().getContainersConfig()) {
                if ((ollamaConfig.embedded == null || !ollamaConfig.embedded.booleanValue()) && (ollamaConfig.url == null || ollamaConfig.url.isEmpty())) continue;
                OllamaChatModelBuilder ollamaBuilder = new OllamaChatModelBuilder(ollamaConfig);
                this.ollamaChatModelBuilders.put(ollamaConfig.getOllamaChatBotType(), ollamaBuilder);
            }
        }
    }

    public static ModelBuilderSelector getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModelBuilderSelector();
        }
        return INSTANCE;
    }

    public ChatModel getSelectedChatModel(GJaxbContext context) throws Exception {
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.CHAT_GPT)) {
            return this.openAiChatModelBuilder.getChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_MISTRAL)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_MISTRAL.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_MISTRAL).getChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL).getChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_LLAMA_3_2)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_LLAMA_3_2.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_LLAMA_3_2).getChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1).getChatModel(context);
        }
        throw new Exception("No chat model found !!!");
    }

    public ChatModel getSelectedImageAnalysisChatModel(GJaxbContext context) throws Exception {
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.CHAT_GPT)) {
            return this.openAiChatModelBuilder.getImageAnalysisChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_MISTRAL)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_MISTRAL.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_MISTRAL).getImageAnalysisChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL).getImageAnalysisChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_LLAMA_3_2)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_LLAMA_3_2.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_LLAMA_3_2).getImageAnalysisChatModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1).getImageAnalysisChatModel(context);
        }
        throw new Exception("No image analysis chat model found !!!");
    }

    public ImageModel getSelectedImageCreationModel(GJaxbContext context) throws Exception {
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.CHAT_GPT)) {
            return this.openAiChatModelBuilder.getImageCreationModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_MISTRAL)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_MISTRAL.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_MISTRAL).getImageCreationModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL).getImageCreationModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_LLAMA_3_2)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_LLAMA_3_2.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_LLAMA_3_2).getImageCreationModel(context);
        }
        if (context.getSelectedAiChatBot().equals((Object)GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1)) {
            context.getOllamaContext().setModelName(GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1.toString());
            return this.ollamaChatModelBuilders.get(GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1).getImageCreationModel(context);
        }
        throw new Exception("No image creation model found !!!");
    }

    public List<String> existingChatModels() {
        ArrayList<String> existingChatModels = new ArrayList<String>();
        if (this.openAiChatModelBuilder.existChatModel()) {
            existingChatModels.add(this.openAiChatModelBuilder.getName());
        }
        for (OllamaChatModelBuilder ollamaBuilder : this.ollamaChatModelBuilders.values()) {
            if (!ollamaBuilder.existChatModel()) continue;
            existingChatModels.add(ollamaBuilder.getName());
        }
        return existingChatModels;
    }

    public List<String> existingImageAnalysisChatModels() {
        ArrayList<String> existingImageAnalysisChatModels = new ArrayList<String>();
        if (this.openAiChatModelBuilder.existImageAnalysisChatModel()) {
            existingImageAnalysisChatModels.add(this.openAiChatModelBuilder.getName());
        }
        for (OllamaChatModelBuilder ollamaBuilder : this.ollamaChatModelBuilders.values()) {
            if (!ollamaBuilder.existImageAnalysisChatModel()) continue;
            existingImageAnalysisChatModels.add(ollamaBuilder.getName());
        }
        return existingImageAnalysisChatModels;
    }

    public List<String> existingImageCreationModels() {
        ArrayList<String> existingImageCreationModels = new ArrayList<String>();
        if (this.openAiChatModelBuilder.existImageCreationModel()) {
            existingImageCreationModels.add(this.openAiChatModelBuilder.getName());
        }
        for (OllamaChatModelBuilder ollamaBuilder : this.ollamaChatModelBuilders.values()) {
            if (!ollamaBuilder.existImageCreationModel()) continue;
            existingImageCreationModels.add(ollamaBuilder.getName());
        }
        return existingImageCreationModels;
    }
}

