/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoFunction;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoProblem;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctions;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctionsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbRoleForType;
import fr.emac.gind.gov.ai_chatbot.GJaxbRoleInput;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import java.util.List;

public class PojoRole {

    public static interface RoleExtractor {
        public static final String SYSTEM_MSG_PERSON = "    \t\t\tYou are an expert in human resources. The output must be a json object like that (remark: The 'functionsOfRole' json array must contain json objects where 'functionName' attributes are not null):\n    \t\t\t{\n    \t\t\t\troleName: ...,\n    \t\t\t\tfunctionsOfRole: [\n    \t\t\t\t  {\n    \t\t\t\t  \tfunctionId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\tfunctionName: ... (must be non-null),\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\tproblem: {\n    \t\t\t\t\t\tproblemName: ...,\n    \t\t\t\t\t\tproblemId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\t\tproblemType: ...\n    \t\t\t\t\t},\n    \t\t\t\t\tresolutionLevel: ...,\n    \t\t\t\t\texpertiseLevel: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n\n";
        public static final String SYSTEM_MSG_PERSON_WITH_PERSON = "    \t\t\tYou are an expert in human resources. The output must be a json object like that (remark: The 'functionsOfRole' json array must contain at least one json object where 'functionName' is not null):\n    \t\t\t{\n    \t\t\t\troleName: ...,\n    \t\t\t\tfunctionsOfRole: [\n    \t\t\t\t  {\n    \t\t\t\t  \tfunctionId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\tfunctionName: ... (must be non-null),\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\tproblem: {\n    \t\t\t\t\t\tproblemName: ...,\n    \t\t\t\t\t\tproblemId: ... (the same that the problemId in request),\n    \t\t\t\t\t\tproblemType: ...\n    \t\t\t\t\t},\n    \t\t\t\t\tresolutionLevel: ...,\n    \t\t\t\t\texpertiseLevel: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n\n";
        public static final String SYSTEM_MSG_GOOD = "    \t\t\tYou are an expert in material resources. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tgoodName: ...,\n    \t\t\t\tactionsOfGood: [\n    \t\t\t\t  {\n    \t\t\t\t  \tgoodId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\tgoodName: ...,\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\tproblem: {\n    \t\t\t\t\t\tproblemName: ...,\n    \t\t\t\t\t\tproblemId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\t\tproblemType: ...\n    \t\t\t\t\t},\n    \t\t\t\t\tresolutionLevel: ...,\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n";

        @SystemMessage(value={"    \t\t\tYou are an expert in material resources. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tgoodName: ...,\n    \t\t\t\tactionsOfGood: [\n    \t\t\t\t  {\n    \t\t\t\t  \tgoodId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\tgoodName: ...,\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\tproblem: {\n    \t\t\t\t\t\tproblemName: ...,\n    \t\t\t\t\t\tproblemId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\t\tproblemType: ...\n    \t\t\t\t\t},\n    \t\t\t\t\tresolutionLevel: ...,\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"Find the actions that this good '{{it}}' can do ?"})
        public AIRoleForGood extractRoleForGoodFrom(String var1);

        @SystemMessage(value={"    \t\t\tYou are an expert in human resources. The output must be a json object like that (remark: The 'functionsOfRole' json array must contain json objects where 'functionName' attributes are not null):\n    \t\t\t{\n    \t\t\t\troleName: ...,\n    \t\t\t\tfunctionsOfRole: [\n    \t\t\t\t  {\n    \t\t\t\t  \tfunctionId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\tfunctionName: ... (must be non-null),\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\tproblem: {\n    \t\t\t\t\t\tproblemName: ...,\n    \t\t\t\t\t\tproblemId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\t\tproblemType: ...\n    \t\t\t\t\t},\n    \t\t\t\t\tresolutionLevel: ...,\n    \t\t\t\t\texpertiseLevel: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n\n"})
        @UserMessage(value={"Find the functions that this job '{{it}}' can do ? "})
        public AIRoleForPerson extractRoleForPersonFrom(String var1);

        @SystemMessage(value={"    \t\t\tYou are an expert in human resources. The output must be a json object like that (remark: The 'functionsOfRole' json array must contain at least one json object where 'functionName' is not null):\n    \t\t\t{\n    \t\t\t\troleName: ...,\n    \t\t\t\tfunctionsOfRole: [\n    \t\t\t\t  {\n    \t\t\t\t  \tfunctionId: ... (invent identifier [uuid v4]),\n    \t\t\t\t\tfunctionName: ... (must be non-null),\n    \t\t\t\t\tdescription: ...,\n    \t\t\t\t\tproblem: {\n    \t\t\t\t\t\tproblemName: ...,\n    \t\t\t\t\t\tproblemId: ... (the same that the problemId in request),\n    \t\t\t\t\t\tproblemType: ...\n    \t\t\t\t\t},\n    \t\t\t\t\tresolutionLevel: ...,\n    \t\t\t\t\texpertiseLevel: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n\n"})
        @UserMessage(value={"Can you identify which a role (job) and only one function of this job that could satisfy this problem {{it}}"})
        public AIRoleForPerson extractRoleForPersonFromProblem(String var1);
    }

    public static class AIRoleForGood
    extends AIPojo {
        @JsonProperty(value="goodName")
        @Description(value={"the name of the good"})
        private String goodName;
        @JsonProperty(value="goodDescription")
        @Description(value={"the description of the godd"})
        private String goodDescription;
        @JsonProperty(value="actionsOfGood")
        @Description(value={"the list of actions"})
        private List<AIAction> actionsOfGood;

        public String getGoodName() {
            return this.goodName;
        }

        public void setGoodName(String roleName) {
            this.goodName = roleName;
        }

        public String getGoodDescription() {
            return this.goodDescription;
        }

        public void setGoodDescription(String roleDescription) {
            this.goodDescription = roleDescription;
        }

        public GJaxbGenericModel convertToModel(GJaxbRoleInput roleInput, GJaxbContext context, AIChatbotImpl aiChatbot) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbNode role = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Role"));
            GenericModelHelper.findProperty((String)"name", (List)role.getProperty(), (boolean)true).setValue(this.goodName);
            model.getNode().add(role);
            if (this.actionsOfGood != null && !this.actionsOfGood.isEmpty()) {
                for (AIAction actionOfGood : this.actionsOfGood) {
                    PojoFunction.AIFunction functOfRole = new PojoFunction.AIFunction();
                    functOfRole.functionId = actionOfGood.actionId;
                    functOfRole.functionName = actionOfGood.actionName;
                    functOfRole.expertiseLevel = Float.valueOf(100.0f);
                    functOfRole.description = actionOfGood.description;
                    functOfRole.problem = actionOfGood.problem;
                    functOfRole.resolutionLevel = actionOfGood.resolutionLevel;
                    if (functOfRole.functionId == null || functOfRole.functionId.isEmpty()) continue;
                    GJaxbNode function = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Function"));
                    function.setId(functOfRole.functionId);
                    GenericModelHelper.findProperty((String)"name", (List)function.getProperty(), (boolean)true).setValue(functOfRole.functionName);
                    GenericModelHelper.findProperty((String)"description", (List)function.getProperty(), (boolean)true).setValue(functOfRole.description);
                    model.getNode().add(function);
                    GJaxbEdge provides = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Provides"));
                    if (functOfRole.expertiseLevel != null) {
                        GenericModelHelper.findProperty((String)"expertise", (List)provides.getProperty(), (boolean)true).setValue(functOfRole.expertiseLevel.toString());
                    }
                    provides.setSource(role);
                    provides.setTarget(function);
                    model.getEdge().add(provides);
                    GJaxbInventFunctions.FunctionInput fi = new GJaxbInventFunctions.FunctionInput();
                    fi.setFunctionId(function.getId());
                    fi.setFunctionName(functOfRole.functionName);
                    fi.setAssociatedRole(new GJaxbInventFunctions.FunctionInput.AssociatedRole());
                    fi.getAssociatedRole().setNode(role);
                    if (roleInput.isAddPrePostSupportFunction()) {
                        GJaxbInventFunctions reqFunc = new GJaxbInventFunctions();
                        reqFunc.setContext(context);
                        reqFunc.getFunctionInput().add(fi);
                        GJaxbInventFunctionsResponse respFunc = aiChatbot.inventFunctions(reqFunc);
                        GJaxbNode duplicateFunctNode = GenericModelHelper.findNodeById((String)function.getId(), (List)respFunc.getGenericModel().getNode());
                        respFunc.getGenericModel().getNode().remove(duplicateFunctNode);
                        GJaxbNode duplicateRoleNode = GenericModelHelper.findNodeById((String)role.getId(), (List)respFunc.getGenericModel().getNode());
                        respFunc.getGenericModel().getNode().remove(duplicateRoleNode);
                        model.getNode().addAll(respFunc.getGenericModel().getNode());
                        model.getEdge().addAll(respFunc.getGenericModel().getEdge());
                        continue;
                    }
                    GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)functOfRole.convertToModel(fi));
                }
            }
            return model;
        }
    }

    public static class AIAction
    extends AIPojo {
        @JsonProperty(value="actionName")
        @Description(value={"the name of the action"})
        public String actionName;
        @JsonProperty(value="actionId")
        @Description(value={"the identifier (uuid v4) of the action"})
        public String actionId;
        @JsonProperty(value="jobName")
        @Description(value={"the jobName of the action"})
        public String jobName;
        @JsonProperty(value="description")
        @Description(value={"the description of the action"})
        public String description;
        @JsonProperty(value="problem")
        @Description(value={"the problem resolved by the action"})
        public PojoProblem.AIProblem problem;
        @JsonProperty(value="resolutionLevel")
        @Description(value={"the resolution level of the action in relation to the problem (in percentage)"})
        public Float resolutionLevel;
    }

    public static class AIRoleForPerson
    extends AIPojo {
        @JsonProperty(value="roleName")
        @Description(value={"the name of the role"})
        private String roleName;
        @JsonProperty(value="roleDescription")
        @Description(value={"the description of the role"})
        private String roleDescription;
        @JsonProperty(value="functionsOfRole")
        @Description(value={"the list of functions of this role"})
        private List<PojoFunction.AIFunction> functionsOfRole;

        public String getRoleName() {
            return this.roleName;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public String getRoleDescription() {
            return this.roleDescription;
        }

        public void setRoleDescription(String roleDescription) {
            this.roleDescription = roleDescription;
        }

        public GJaxbGenericModel convertToModel(GJaxbRoleInput roleInput, GJaxbContext context, AIChatbotImpl aiChatbot) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbNode role = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Role"));
            GenericModelHelper.findProperty((String)"name", (List)role.getProperty(), (boolean)true).setValue(this.roleName);
            model.getNode().add(role);
            if (this.functionsOfRole != null && !this.functionsOfRole.isEmpty()) {
                for (PojoFunction.AIFunction functOfRole : this.functionsOfRole) {
                    if (functOfRole.functionId == null || functOfRole.functionId.isEmpty()) continue;
                    GJaxbNode function = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Function"));
                    function.setId(functOfRole.functionId);
                    GenericModelHelper.findProperty((String)"name", (List)function.getProperty(), (boolean)true).setValue(functOfRole.functionName);
                    GenericModelHelper.findProperty((String)"description", (List)function.getProperty(), (boolean)true).setValue(functOfRole.description);
                    model.getNode().add(function);
                    GJaxbEdge provides = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Provides"));
                    if (roleInput.getRoleType().equals((Object)GJaxbRoleForType.PERSON)) {
                        GenericModelHelper.findProperty((String)"type", (List)function.getProperty(), (boolean)true).setValue("Human");
                    } else if (roleInput.getRoleType().equals((Object)GJaxbRoleForType.GOOD)) {
                        GenericModelHelper.findProperty((String)"type", (List)function.getProperty(), (boolean)true).setValue("Computer");
                    }
                    if (functOfRole.expertiseLevel != null) {
                        GenericModelHelper.findProperty((String)"expertise", (List)provides.getProperty(), (boolean)true).setValue(functOfRole.expertiseLevel.toString());
                    }
                    provides.setSource(role);
                    provides.setTarget(function);
                    model.getEdge().add(provides);
                    GJaxbInventFunctions.FunctionInput fi = new GJaxbInventFunctions.FunctionInput();
                    fi.setFunctionId(function.getId());
                    fi.setFunctionName(functOfRole.functionName);
                    fi.setAssociatedRole(new GJaxbInventFunctions.FunctionInput.AssociatedRole());
                    fi.getAssociatedRole().setNode(role);
                    if (roleInput.isAddPrePostSupportFunction()) {
                        GJaxbInventFunctions reqFunc = new GJaxbInventFunctions();
                        reqFunc.setContext(context);
                        reqFunc.getFunctionInput().add(fi);
                        GJaxbInventFunctionsResponse respFunc = aiChatbot.inventFunctions(reqFunc);
                        GJaxbNode duplicateFunctNode = GenericModelHelper.findNodeById((String)function.getId(), (List)respFunc.getGenericModel().getNode());
                        respFunc.getGenericModel().getNode().remove(duplicateFunctNode);
                        GJaxbNode duplicateRoleNode = GenericModelHelper.findNodeById((String)role.getId(), (List)respFunc.getGenericModel().getNode());
                        respFunc.getGenericModel().getNode().remove(duplicateRoleNode);
                        model.getNode().addAll(respFunc.getGenericModel().getNode());
                        model.getEdge().addAll(respFunc.getGenericModel().getEdge());
                        continue;
                    }
                    GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)functOfRole.convertToModel(fi));
                }
            }
            return model;
        }
    }
}

