/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.maps.DirectionsApi;
import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.ImageResult;
import com.google.maps.PlacesApi;
import com.google.maps.RoadsApi;
import com.google.maps.errors.ApiException;
import com.google.maps.model.Bounds;
import com.google.maps.model.DirectionsResult;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import com.google.maps.model.PlaceDetails;
import com.google.maps.model.SnappedPoint;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.commons.utils.json.JSONHelper;
import fr.emac.gind.commons.utils.net.URIUtil;
import fr.emac.gind.commons.utils.rest.HTTPClientUtil;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai_chatbot.GJaxbAddressInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbAddressType;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbPersonInput;
import fr.emac.gind.modeler.genericmodel.GJaxbArea;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPolyline;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import java.awt.Color;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class PojoTerritory {
    public static GJaxbNode createAddressFromPlaceDetails(GeoApiContext geoApiContext, List<GJaxbExternalResourceType> externalResources, GJaxbEffectiveConceptType concept, String fillColor, String strokeColor, GJaxbAddressInput input, PlaceDetails resultPlaceDetails) throws Exception, ApiException, InterruptedException, IOException {
        ArrayList<GJaxbPointType> polylines = new ArrayList<GJaxbPointType>();
        if (!input.getType().equals((Object)GJaxbAddressType.BUILDING) && !input.getType().equals((Object)GJaxbAddressType.ROAD)) {
            JSONArray arrayNominatim;
            String nominatimRequest;
            HttpResponse nominatimResponse;
            String buffer;
            Object formattedAddress = input.getName() + ", " + input.getAddress();
            if (resultPlaceDetails != null) {
                formattedAddress = resultPlaceDetails.formattedAddress;
            }
            if (JSONHelper.isJSONArrayValid((String)(buffer = (String)(nominatimResponse = HTTPClientUtil.sendHTTPRequest((HTTPClientUtil.HTTPProtocol)HTTPClientUtil.HTTPProtocol.GET, (String)(nominatimRequest = "https://nominatim.openstreetmap.org/search.php?q=" + URIUtil.encodePath((String)formattedAddress) + "&polygon_threshold=0.009&polygon_geojson=1&format=json"), null, null, null, null)).body())) && (arrayNominatim = new JSONArray(buffer)).length() > 0) {
                JSONObject obj = arrayNominatim.getJSONObject(0);
                JSONObject geojson = obj.getJSONObject("geojson");
                String geojsonType = geojson.getString("type");
                JSONArray coordinatesArray = geojson.getJSONArray("coordinates");
                if (coordinatesArray.length() > 0) {
                    if ("Polygon".equals(geojsonType)) {
                        coordinates = coordinatesArray.getJSONArray(0);
                        for (int pi = 0; pi < coordinates.length(); ++pi) {
                            JSONArray ptN = coordinates.getJSONArray(pi);
                            GJaxbPointType pt1 = new GJaxbPointType();
                            pt1.setLatitude(Double.valueOf(ptN.getDouble(1)));
                            pt1.setLongitude(Double.valueOf(ptN.getDouble(0)));
                            polylines.add(pt1);
                        }
                    } else if ("MultiPolygon".equals(geojsonType)) {
                        coordinates = coordinatesArray.getJSONArray(0);
                        JSONArray coords = coordinates.getJSONArray(0);
                        for (int pi = 0; pi < coords.length(); ++pi) {
                            JSONArray ptN = coords.getJSONArray(pi);
                            GJaxbPointType pt1 = new GJaxbPointType();
                            pt1.setLatitude(Double.valueOf(ptN.getDouble(1)));
                            pt1.setLongitude(Double.valueOf(ptN.getDouble(0)));
                            polylines.add(pt1);
                        }
                    }
                }
            }
        }
        if (polylines.isEmpty()) {
            GeocodingResult[] detail;
            String placeId = input.getGooglePlaceId();
            if (resultPlaceDetails != null) {
                placeId = resultPlaceDetails.placeId;
            }
            if ((detail = (GeocodingResult[])GeocodingApi.newRequest((GeoApiContext)geoApiContext).place(placeId).await()) != null && detail.length > 0) {
                if (!input.getType().equals((Object)GJaxbAddressType.ROAD)) {
                    Bounds bounds = detail[0].geometry.viewport;
                    LatLng northeast = bounds.northeast;
                    LatLng southwest = bounds.southwest;
                    LatLng northwest = new LatLng(northeast.lat, southwest.lng);
                    SnappedPoint[] southeast = new LatLng(southwest.lat, northeast.lng);
                    GJaxbPointType pt1 = new GJaxbPointType();
                    pt1.setLatitude(Double.valueOf(northwest.lat));
                    pt1.setLongitude(Double.valueOf(northwest.lng));
                    polylines.add(pt1);
                    GJaxbPointType pt2 = new GJaxbPointType();
                    pt2.setLatitude(Double.valueOf(northeast.lat));
                    pt2.setLongitude(Double.valueOf(northeast.lng));
                    polylines.add(pt2);
                    GJaxbPointType pt3 = new GJaxbPointType();
                    pt3.setLatitude(Double.valueOf(southeast.lat));
                    pt3.setLongitude(Double.valueOf(southeast.lng));
                    polylines.add(pt3);
                    GJaxbPointType pt4 = new GJaxbPointType();
                    pt4.setLatitude(Double.valueOf(southwest.lat));
                    pt4.setLongitude(Double.valueOf(southwest.lng));
                    polylines.add(pt4);
                    if (!input.getType().equals((Object)GJaxbAddressType.BUILDING)) {
                        LatLng north = new LatLng(northwest.lat, northeast.lng + (northwest.lng - northeast.lng) / 2.0);
                        LatLng west = new LatLng(southwest.lat + (northwest.lat - southwest.lat) / 2.0, northwest.lng);
                        LatLng south = new LatLng(southwest.lat, southeast.lng + (southwest.lng - southeast.lng) / 2.0);
                        LatLng east = new LatLng(southeast.lat + (northeast.lat - southeast.lat) / 2.0, northeast.lng);
                        DirectionsResult resultsDir = (DirectionsResult)DirectionsApi.newRequest((GeoApiContext)geoApiContext).origin(northwest).waypoints(new LatLng[]{north, northeast, east, southeast, south, southwest, west}).destination(northwest).await();
                        if (resultsDir.routes.length > 0) {
                            polylines.clear();
                            int indexPoint = 0;
                            for (LatLng latlng : resultsDir.routes[0].overviewPolyline.decodePath()) {
                                if (++indexPoint % 10 != 0) continue;
                                GJaxbPointType pt = new GJaxbPointType();
                                pt.setLatitude(Double.valueOf(latlng.lat));
                                pt.setLongitude(Double.valueOf(latlng.lng));
                                polylines.add(pt);
                            }
                        }
                    }
                } else {
                    LatLng location = detail[0].geometry.location;
                    String name = input.getName();
                    if (resultPlaceDetails != null) {
                        name = resultPlaceDetails.name;
                    }
                    System.out.println("Coordinates of " + name + ": (" + location.lat + ", " + location.lng + ")");
                    LatLng[] path = new LatLng[]{location};
                    SnappedPoint[] snappedPoints = (SnappedPoint[])RoadsApi.snapToRoads((GeoApiContext)geoApiContext, (LatLng[])path).await();
                    if (snappedPoints.length > 0) {
                        polylines.clear();
                        for (SnappedPoint point : snappedPoints) {
                            System.out.println("Snapped point: (" + point.location.lat + ", " + point.location.lng + ")");
                            GJaxbPointType pt = new GJaxbPointType();
                            pt.setLatitude(Double.valueOf(point.location.lat));
                            pt.setLongitude(Double.valueOf(point.location.lng));
                            polylines.add(pt);
                        }
                        if (polylines.size() < 3) {
                            GJaxbPointType pRef = (GJaxbPointType)polylines.get(polylines.size() - 1);
                            while (polylines.size() < 3) {
                                GJaxbPointType pt = new GJaxbPointType();
                                pt.setLatitude(pRef.getLatitude());
                                pt.setLongitude(Double.valueOf(pRef.getLongitude() + 5.0E-4));
                                polylines.add(pt);
                                pRef = pt;
                            }
                        }
                    }
                }
            }
        }
        GJaxbNode address = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(concept.getType());
        String name = input.getName();
        if (name == null || name.isBlank()) {
            name = input.getAddress();
        }
        GenericModelHelper.findProperty((String)"name", (List)address.getProperty(), (boolean)true).setValue(name);
        GenericModelHelper.findProperty((String)"type", (List)address.getProperty(), (boolean)true).setValue(input.getType().value());
        if (resultPlaceDetails != null && resultPlaceDetails.photos != null && resultPlaceDetails.photos.length > 0) {
            ImageResult img = (ImageResult)PlacesApi.photo((GeoApiContext)geoApiContext, (String)resultPlaceDetails.photos[0].photoReference).maxWidth(48).maxHeight(48).await();
            GJaxbExternalResourceType extRsc = new GJaxbExternalResourceType();
            extRsc.setId(address.getId() + "::picture");
            extRsc.setContentType(img.contentType);
            extRsc.setData(img.imageData);
            externalResources.add(extRsc);
        }
        address.setGeolocation(new GJaxbNode.Geolocation());
        GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
        iv.setViewId("view_" + UUID.randomUUID().toString());
        iv.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
        iv.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
        if (input.getType().equals((Object)GJaxbAddressType.ROAD)) {
            iv.getSpecificGeolocation().getNodeMetaGeolocation().setPolyline(new GJaxbNodeMetaGeolocation.Polyline());
            if (concept.getNodeMetaGeolocation().getPolyline() != null) {
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillColor(fillColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillOpacity(concept.getNodeMetaGeolocation().getPolyline().getFillOpacity());
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeColor(strokeColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeDashArray(concept.getNodeMetaGeolocation().getPolyline().getStrokeDashArray());
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeOpacity(concept.getNodeMetaGeolocation().getPolyline().getStrokeOpacity());
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeWidth(concept.getNodeMetaGeolocation().getPolyline().getStrokeWidth());
            } else {
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillColor(fillColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillOpacity(1.0);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeColor(strokeColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeDashArray(null);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeOpacity(1.0);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeWidth(5.0);
            }
            iv.setPolyline(new GJaxbPolyline());
            iv.getPolyline().getPoint().addAll(polylines);
        } else {
            iv.getSpecificGeolocation().getNodeMetaGeolocation().setArea(new GJaxbNodeMetaGeolocation.Area());
            if (concept.getNodeMetaGeolocation().getArea() != null) {
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillColor(fillColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillOpacity(concept.getNodeMetaGeolocation().getArea().getFillOpacity());
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeColor(strokeColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeDashArray(concept.getNodeMetaGeolocation().getArea().getStrokeDashArray());
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeOpacity(concept.getNodeMetaGeolocation().getArea().getStrokeOpacity());
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeWidth(concept.getNodeMetaGeolocation().getArea().getStrokeWidth());
            } else {
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillColor(fillColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillOpacity(0.4);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeColor(strokeColor);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeDashArray(null);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeOpacity(1.0);
                iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeWidth(5.0);
            }
            iv.setArea(new GJaxbArea());
            iv.getArea().getPoint().addAll(polylines);
        }
        address.getGeolocation().getItemView().add(iv);
        return address;
    }

    public static interface TerritoryExtractor {
        public static final String SYSTEM_MSG = "    \t\t\tYou are an expert in geographer expert. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tterritoryName: ...,\n    \t\t\t\ttype: ...,\n    \t\t\t\tpoints: [\n    \t\t\t\t  {\n    \t\t\t\t    lat: ...,\n    \t\t\t\t    lng: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n";

        @SystemMessage(value={"    \t\t\tYou are an expert in geographer expert. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tterritoryName: ...,\n    \t\t\t\ttype: ...,\n    \t\t\t\tpoints: [\n    \t\t\t\t  {\n    \t\t\t\t    lat: ...,\n    \t\t\t\t    lng: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"Could you give me the perimeters of this territory {{it}} in GPS coordinates (latitude and longitude) ?"})
        public AITerritory extractTerritory(String var1);
    }

    public static class AITerritory
    extends AIPojo {
        @JsonProperty(value="territoryName")
        @Description(value={"the name of the territory"})
        public String territoryName;
        @JsonProperty(value="territoryType")
        @Description(value={"the type of the territory"})
        public GJaxbAddressType territoryType;
        @JsonProperty(value="points")
        @Description(value={"the list of points"})
        public List<AIPoint> points;

        public GJaxbGenericModel convertToModel(GJaxbAddressInput input, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbEffectiveConceptType concept = EffectiveMetaModelPluginManager.getInstance().getConceptByType(GenericModelHelper.collab((String)"Territory"));
            String fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
            String strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            GJaxbNode territory = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Territory"));
            GenericModelHelper.findProperty((String)"name", (List)territory.getProperty(), (boolean)true).setValue(this.territoryName);
            GenericModelHelper.findProperty((String)"type", (List)territory.getProperty(), (boolean)true).setValue(this.territoryType.toString());
            model.getNode().add(territory);
            territory.setGeolocation(new GJaxbNode.Geolocation());
            GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
            iv.setArea(new GJaxbArea());
            iv.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
            iv.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().setArea(new GJaxbNodeMetaGeolocation.Area());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillColor(fillColor);
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillOpacity(concept.getNodeMetaGeolocation().getArea().getFillOpacity());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeColor(strokeColor);
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeDashArray(concept.getNodeMetaGeolocation().getArea().getStrokeDashArray());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeOpacity(concept.getNodeMetaGeolocation().getArea().getStrokeOpacity());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeWidth(concept.getNodeMetaGeolocation().getArea().getStrokeWidth());
            fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
            strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            territory.getGeolocation().getItemView().add(iv);
            for (AIPoint point : this.points) {
                if (point.latitude == null || point.longitude == null) continue;
                GJaxbPointType pt = new GJaxbPointType();
                pt.setLatitude(point.latitude);
                pt.setLongitude(point.longitude);
                iv.getArea().getPoint().add(pt);
            }
            return model;
        }
    }

    public static class AIPoint
    extends AIPojo {
        @JsonProperty(value="lat")
        @Description(value={"the latitude"})
        public Double latitude;
        @JsonProperty(value="lng")
        @Description(value={"the longitude"})
        public Double longitude;

        public GJaxbGenericModel convertToModel(GJaxbPersonInput input, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbotImpl) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            return model;
        }
    }
}

