/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.internal.Json;
import fr.emac.gind.gov.ai_chatbot.GJaxbAiChatBotType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class OllamaContainerConfig {
    @JsonProperty(value="model")
    public String model;
    @JsonProperty(value="embedded")
    public Boolean embedded;
    @JsonProperty(value="url")
    public String url;

    public String toString() {
        String res = null;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            String jsonString;
            res = jsonString = objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return res;
    }

    public GJaxbAiChatBotType getOllamaChatBotType() {
        if (this.model.equals("llama3.2")) {
            return GJaxbAiChatBotType.OLLAMA_LLAMA_3_2;
        }
        if (this.model.equals("deepseek-r1")) {
            return GJaxbAiChatBotType.OLLAMA_DEEPSEEK_R_1;
        }
        if (this.model.equals("mistral-small")) {
            return GJaxbAiChatBotType.OLLAMA_MISTRAL_SMALL;
        }
        if (this.model.equals("mistral")) {
            return GJaxbAiChatBotType.OLLAMA_MISTRAL;
        }
        return null;
    }

    public static OllamaContainerConfig parse(JSONObject jsonObject) {
        String text = jsonObject.toString();
        return (OllamaContainerConfig)Json.fromJson((String)text, OllamaContainerConfig.class);
    }

    public static List<OllamaContainerConfig> parse(JSONArray jsonArray) {
        ArrayList<OllamaContainerConfig> containers = new ArrayList<OllamaContainerConfig>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject containerJson = jsonArray.getJSONObject(i);
            containers.add(OllamaContainerConfig.parse(containerJson));
        }
        return containers;
    }
}

