/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama;

import fr.emac.gind.gov.ai.chatbot.service.builder.model.ollama.OllamaContainerConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.ollama.OllamaContainer;
import org.testcontainers.utility.DockerImageName;

public class OllamaManager {
    public static OllamaManager INSTANCE;
    private List<OllamaContainerConfig> containersConfig = null;
    private Map<OllamaContainerConfig, OllamaContainer> containers = new HashMap<OllamaContainerConfig, OllamaContainer>();

    public static OllamaManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OllamaManager();
        }
        return INSTANCE;
    }

    public static String baseUrl(GenericContainer<?> ollama) {
        return String.format("http://%s:%d", ollama.getHost(), ollama.getFirstMappedPort());
    }

    public void addContainers(List<OllamaContainerConfig> conts) {
        this.containersConfig = conts;
        for (OllamaContainerConfig containerConfig : this.containersConfig) {
            if (containerConfig.embedded == null || !containerConfig.embedded.booleanValue()) continue;
            OllamaContainer ollama = new OllamaContainer(DockerImageName.parse((String)("langchain4j/ollama-" + containerConfig.model + ":latest")).asCompatibleSubstituteFor("ollama/ollama"));
            containerConfig.url = OllamaManager.baseUrl(ollama);
            this.containers.put(containerConfig, ollama);
        }
    }

    public void startEmbeddedContainer() {
        for (Map.Entry<OllamaContainerConfig, OllamaContainer> containerEntry : this.containers.entrySet()) {
            OllamaContainerConfig containerConfig = containerEntry.getKey();
            OllamaContainer ollamaContainer = containerEntry.getValue();
            if (containerConfig.embedded == null || !containerConfig.embedded.booleanValue()) continue;
            ollamaContainer.start();
        }
    }

    public void stopEmbeddedContainer() {
        for (Map.Entry<OllamaContainerConfig, OllamaContainer> containerEntry : this.containers.entrySet()) {
            OllamaContainerConfig containerConfig = containerEntry.getKey();
            OllamaContainer ollamaContainer = containerEntry.getValue();
            if (containerConfig.embedded == null || !containerConfig.embedded.booleanValue()) continue;
            ollamaContainer.stop();
        }
    }

    public List<OllamaContainerConfig> getContainersConfig() {
        return this.containersConfig;
    }
}

