/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.objectives;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoAsset;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoObjective;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoPotentiality;
import fr.emac.gind.gov.ai.chatbot.service.pojo.objectives.PojoProblem;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbProblemInputType;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import java.util.List;

public class PojoActuality {
    public static String actDamageUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/damage.png";
    public static String actBeneficeUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/benefit.png";

    public static interface ActualityExtractor {
        public static final String SYSTEM_MSG = "    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tactualityName: ...,\n    \t\t\t\tactualityId: ...,\n    \t\t\t\tactualityType: ...,\n    \t\t\t\trisks: [\n    \t\t\t\t  {\n    \t\t\t\t  \tpotentialityName: ...,\n    \t\t\t\t\tpotentialityId: ...,\n    \t\t\t\t\tpotentialityType: RISK,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t],\n    \t\t\t\topportunities: [\n    \t\t\t\t  {\n    \t\t\t\t  \tpotentialityName: ...,\n    \t\t\t\t\tpotentialityId: ...,\n    \t\t\t\t\tpotentialityType: OPPORTUNITY,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t],\n    \t\t\t\tobjectives: [\n    \t\t\t\t  {\n    \t\t\t\t  \tobjectiveName: ...,\n    \t\t\t\t\tobjectiveId: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n";

        @SystemMessage(value={"    \t\t\tYou are an expert in crisis management. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tactualityName: ...,\n    \t\t\t\tactualityId: ...,\n    \t\t\t\tactualityType: ...,\n    \t\t\t\trisks: [\n    \t\t\t\t  {\n    \t\t\t\t  \tpotentialityName: ...,\n    \t\t\t\t\tpotentialityId: ...,\n    \t\t\t\t\tpotentialityType: RISK,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t],\n    \t\t\t\topportunities: [\n    \t\t\t\t  {\n    \t\t\t\t  \tpotentialityName: ...,\n    \t\t\t\t\tpotentialityId: ...,\n    \t\t\t\t\tpotentialityType: OPPORTUNITY,\n    \t\t\t\t\tprobability: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t],\n    \t\t\t\tobjectives: [\n    \t\t\t\t  {\n    \t\t\t\t  \tobjectiveName: ...,\n    \t\t\t\t\tobjectiveId: ...,\n    \t\t\t\t\tpriorityLevel: ...,\n    \t\t\t\t\tdescription: ...\n    \t\t\t\t  },\n    \t\t\t\t  ...\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"Complete the missing attributes of this json main actuality {{it}} by imagining the sub problems such as the risks (problemType='PREVENT_A_RISK') or the opportunities (problemType='OFFER_AN_OPPORTUNITY') that we should pay attention to and what would be the objectives to be accomplished immediately if this main actuality happened"})
        public AIActuality extractActuality(String var1);

        public AIActuality extractActualityFromPicture(@UserMessage dev.langchain4j.data.message.UserMessage var1);
    }

    public static class AIActuality
    extends AIPojo {
        @JsonProperty(value="actualityName")
        @Description(value={"the name of the actuality"})
        public String actualityName;
        @JsonProperty(value="actualityId")
        @Description(value={"the identifier (uuid v4) of the actuality"})
        public String actualityId;
        @JsonProperty(value="actualityType")
        @Description(value={"the type of the actuality"})
        public ActualityType actualityType;
        @JsonProperty(value="actualityDescription")
        @Description(value={"the description of the actuality"})
        public String actualityDescription;
        @JsonProperty(value="priorityLevel")
        @Description(value={"the priority level of this actuality (risk or opportunity) (value between 0 and 1)"})
        public float priorityLevel;
        @JsonProperty(value="risks")
        @Description(value={"the list of risks"})
        public List<PojoPotentiality.AIPotentiality> risks;
        @JsonProperty(value="opportunities")
        @Description(value={"the list of opportunities"})
        public List<PojoPotentiality.AIPotentiality> opportunities;
        @JsonProperty(value="objectives")
        @Description(value={"the list of objectives to achieve"})
        public List<PojoObjective.AIObjective> objectives;
        @JsonProperty(value="impactedAssets")
        @Description(value={"the list of impacted assets by this potentiality"})
        public List<PojoAsset.AIAsset> impactedAssets;

        public GJaxbGenericModel convertToModel(GJaxbProblemInputType problemInput, GJaxbContext context, List<GJaxbExternalResourceType> externalResource, AIChatbotImpl aiChatbot) throws Exception {
            PojoProblem.AIProblem problem = new PojoProblem.AIProblem();
            problem.problemId = this.actualityId;
            problem.problemName = this.actualityName;
            problem.description = this.actualityDescription;
            problem.problemType = PojoProblem.ProblemType.TREAT_A_DAMAGE_ACTUALITY;
            if (this.actualityType == ActualityType.BENEFIT) {
                problem.problemType = PojoProblem.ProblemType.TREAT_A_BENEFIT_ACTUALITY;
            }
            problem.objectives = this.objectives;
            problem.risks = this.risks;
            problem.opportunities = this.opportunities;
            problem.impactedAssets = this.impactedAssets;
            problem.priorityLevel = this.priorityLevel;
            GJaxbGenericModel model = PojoProblem.AIProblem.convertProblemToModel(problem, problemInput, context, externalResource, aiChatbot);
            return model;
        }
    }

    public static enum ActualityType {
        BENEFIT("BENEFIT"),
        DAMAGE("DAMAGE");

        private final String text;

        private ActualityType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

