/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.ai.chatbot.service.pojo.objectives;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.chatbot.service.pojo.AIPojo;
import fr.emac.gind.gov.ai.chatbot.service.pojo.context.PojoAsset;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotential;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbPredefinedShape;
import fr.emac.gind.modeler.metamodel.GJaxbDimension;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbModelingViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import java.awt.Color;
import java.util.List;
import java.util.UUID;

public class PojoPotential {
    public static String potDangerUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/danger.png";
    public static String potFavorableCircumstanceUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/favorable_circumstance.png";

    public static interface PotentialExtractor {
        public static final String SYSTEM_MSG = "    \t\t\tYou are an expert in human and material resources. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tpotentials: [\n    \t\t\t\t\t{\n    \t\t\t\t\t\tpotentialName: ...,\n\t\t    \t\t\t\tpotentialId: ...,\n\t\t    \t\t\t\tpotentialType: ...,\n\t\t    \t\t\t\tpotentialDescription: ...,\n\t\t    \t\t\t\tpotentialRadius: ...,\n\t\t    \t\t\t\tsusceptibleAssets: [\n\t\t    \t\t\t\t  {\n\t\t    \t\t\t\t  \tassetName: ...,\n\t\t    \t\t\t\t  \tassetId: ...,\n\t\t    \t\t\t\t  \tassetType: ...\n\t\t    \t\t\t\t  },\n\t\t    \t\t\t\t  ...\n\t\t    \t\t\t\t]\n    \t\t\t\t\t}\n    \t\t\t\t]\n    \t\t\t}\n";

        @SystemMessage(value={"    \t\t\tYou are an expert in human and material resources. The output must be a json object like that:\n    \t\t\t{\n    \t\t\t\tpotentials: [\n    \t\t\t\t\t{\n    \t\t\t\t\t\tpotentialName: ...,\n\t\t    \t\t\t\tpotentialId: ...,\n\t\t    \t\t\t\tpotentialType: ...,\n\t\t    \t\t\t\tpotentialDescription: ...,\n\t\t    \t\t\t\tpotentialRadius: ...,\n\t\t    \t\t\t\tsusceptibleAssets: [\n\t\t    \t\t\t\t  {\n\t\t    \t\t\t\t  \tassetName: ...,\n\t\t    \t\t\t\t  \tassetId: ...,\n\t\t    \t\t\t\t  \tassetType: ...\n\t\t    \t\t\t\t  },\n\t\t    \t\t\t\t  ...\n\t\t    \t\t\t\t]\n    \t\t\t\t\t}\n    \t\t\t\t]\n    \t\t\t}\n"})
        @UserMessage(value={"For each component (asset) in this array: {{it}}, Imagine the potential hazards (with blast radius in meters) of each component using the given name, type and description if they exist"})
        public AIPotentials extractPotentialFromAssets(String var1);
    }

    public static class AIPotentials
    extends AIPojo {
        @JsonProperty(value="potentials")
        @Description(value={"the list of potentials"})
        public List<AIPotential> potentials;

        public GJaxbGenericModel convertToModel(List<GJaxbInventPotential.PotentialInput> potentialInputs, GJaxbContext context, AIChatbotImpl aiChatbot) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            for (AIPotential aiPotential : this.potentials) {
                model = GenericModelHelper.pushInModel((GJaxbGenericModel)model, (GJaxbGenericModel)aiPotential.convertToModel(potentialInputs, context, aiChatbot));
            }
            return model;
        }
    }

    public static class AIPotential
    extends AIPojo {
        @JsonProperty(value="potentialName")
        @Description(value={"the name of the potential"})
        public String potentialName;
        @JsonProperty(value="potentialId")
        @Description(value={"the identifier (uuid v4) of the potential"})
        public String potentialId;
        @JsonProperty(value="potentialType")
        @Description(value={"the type of the potential"})
        public PotentialType potentialType;
        @JsonProperty(value="potentialDescription")
        @Description(value={"the description of the potential"})
        public String description;
        @JsonProperty(value="potentialRadius")
        @Description(value={"the blast radius in meters"})
        public Double radius;
        @JsonProperty(value="susceptibleAssets")
        @Description(value={"the assets that are susceptible to this potential"})
        public List<PojoAsset.AIAsset> susceptibleAssets;

        public GJaxbGenericModel convertToModel(List<GJaxbInventPotential.PotentialInput> potentialInputs, GJaxbContext context, AIChatbotImpl aiChatbot) throws Exception {
            GJaxbGenericModel model = new GJaxbGenericModel();
            GJaxbEffectiveConceptType concept = EffectiveMetaModelPluginManager.getInstance().getConceptByType(GenericModelHelper.collab((String)"Potential"));
            String fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
            String strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
            for (PojoAsset.AIAsset aiAsset : this.susceptibleAssets) {
                GJaxbNode asset = potentialInputs.stream().filter(pi -> pi.getFromAsset().getNode().getId().equals(aiAsset.assetId)).findFirst().get().getFromAsset().getNode();
                GJaxbNode potential = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Potential"));
                potential.setBrokenEdges(new GJaxbNode.BrokenEdges());
                GenericModelHelper.findProperty((String)"name", (List)potential.getProperty(), (boolean)true).setValue(this.potentialName);
                GenericModelHelper.findProperty((String)"type", (List)potential.getProperty(), (boolean)true).setValue(this.potentialType.toString());
                GenericModelHelper.findProperty((String)"description", (List)potential.getProperty(), (boolean)true).setValue(this.description);
                String potentialUrl = potDangerUrl;
                if (this.potentialType.equals((Object)PotentialType.FAVORABLE_CIRCUMSTANCE)) {
                    potentialUrl = potFavorableCircumstanceUrl;
                }
                potential.setModeling(new GJaxbNode.Modeling());
                GJaxbNode.Modeling.ItemView iv = new GJaxbNode.Modeling.ItemView();
                iv.setViewId("view_" + UUID.randomUUID().toString());
                iv.setPackageName("Objectives");
                iv.setPosition(new GJaxbPosition());
                iv.getPosition().setX(0.0f);
                iv.getPosition().setY(0.0f);
                iv.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
                iv.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
                iv.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
                iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
                iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
                iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
                iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
                iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(potentialUrl);
                potential.getModeling().getItemView().add(iv);
                potential.setGeolocation(new GJaxbNode.Geolocation());
                GJaxbNode.Geolocation.ItemView ivAct = new GJaxbNode.Geolocation.ItemView();
                ivAct.setPredefinedShape(new GJaxbPredefinedShape());
                ivAct.getPredefinedShape().setCircle(new GJaxbPredefinedShape.Circle());
                ivAct.getPredefinedShape().getCircle().setCenter(new GJaxbPointType());
                ivAct.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                ivAct.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().setPredefinedShape(new GJaxbNodeMetaGeolocation.PredefinedShape());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setCircle(new GJaxbNodeMetaGeolocation.PredefinedShape.Circle());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setFillColor(fillColor);
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setFillOpacity(concept.getNodeMetaGeolocation().getPredefinedShape().getFillOpacity());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setStrokeColor(strokeColor);
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setStrokeDashArray(concept.getNodeMetaGeolocation().getPredefinedShape().getStrokeDashArray());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setStrokeOpacity(concept.getNodeMetaGeolocation().getPredefinedShape().getStrokeOpacity());
                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().setStrokeWidth(concept.getNodeMetaGeolocation().getPredefinedShape().getStrokeWidth());
                fillColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor());
                strokeColor = ColorHelper.formatColorToHexaString((Color)ColorHelper.randomDarkerColor());
                if (this.radius != null) {
                    ivAct.setPredefinedShape(new GJaxbPredefinedShape());
                    ivAct.getPredefinedShape().setCircle(new GJaxbPredefinedShape.Circle());
                    ivAct.getPredefinedShape().getCircle().setCenter(new GJaxbPointType());
                    ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().getCircle().setRadius(this.radius.floatValue());
                }
                if (asset.getGeolocation() != null && asset.getGeolocation().getItemView() != null) {
                    GJaxbNode.Geolocation.ItemView it = (GJaxbNode.Geolocation.ItemView)asset.getGeolocation().getItemView().get(0);
                    if (it.isSetPoint()) {
                        ivAct.getPredefinedShape().getCircle().getCenter().setLatitude(it.getPoint().getLatitude());
                        ivAct.getPredefinedShape().getCircle().getCenter().setLongitude(it.getPoint().getLongitude());
                    } else if (it.isSetArea()) {
                        Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromGJaxbNode(asset).get(0);
                        Point center = polygon.getCentroid();
                        ivAct.getPredefinedShape().getCircle().getCenter().setLatitude(Double.valueOf(center.getCoordinate().y));
                        ivAct.getPredefinedShape().getCircle().getCenter().setLongitude(Double.valueOf(center.getCoordinate().x));
                    }
                }
                potential.getGeolocation().getItemView().add(ivAct);
                model.getNode().add(potential);
                model.getNode().add(asset);
                GJaxbEdge generatedBy = EffectiveMetaModelPluginManager.getInstance().createEdgeConcept(GenericModelHelper.collab((String)"Generated_By"));
                generatedBy.setSource(potential);
                generatedBy.setTarget(asset);
                model.getEdge().add(generatedBy);
            }
            return model;
        }
    }

    public static enum PotentialType {
        DANGER("Danger"),
        FAVORABLE_CIRCUMSTANCE("Favorable Circumstance");

        private final String text;

        private PotentialType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

