/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.GeocoderHelper;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class GoogleGeocoderHelper
implements GeocoderHelper {
    private final OkHttpClient client = new OkHttpClient();
    private final ObjectMapper mapper = new ObjectMapper();
    private String apiKey;
    private String language = "fr";

    public GoogleGeocoderHelper() {
        this.apiKey = System.getenv("GOOGLE_MAPS_API_KEY");
        if (this.apiKey == null || this.apiKey.isBlank()) {
            throw new IllegalStateException("GoogleGeocoderHelper: API key manquante. D\u00e9finir GOOGLE_MAPS_API_KEY ou passer la cl\u00e9 au constructeur.");
        }
    }

    public GoogleGeocoderHelper(String apiKey) {
        if (apiKey == null || apiKey.isBlank()) {
            throw new IllegalArgumentException("API key invalide.");
        }
        this.apiKey = apiKey;
    }

    public GoogleGeocoderHelper(String apiKey, String language) {
        this(apiKey);
        if (language != null && !language.isBlank()) {
            this.language = language;
        }
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        if (language != null && !language.isBlank()) {
            this.language = language;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GJaxbPointType geocodeCity(String place) {
        GJaxbPointType point = new GJaxbPointType();
        if (place == null) return point;
        if (place.isBlank()) {
            return point;
        }
        try {
            String q = URLEncoder.encode(place, StandardCharsets.UTF_8);
            String url = "https://maps.googleapis.com/maps/api/geocode/json?address=" + q + "&language=" + URLEncoder.encode(this.language, StandardCharsets.UTF_8) + "&key=" + URLEncoder.encode(this.apiKey, StandardCharsets.UTF_8);
            Request req = new Request.Builder().url(url).header("Accept", "application/json").build();
            try (Response res = this.client.newCall(req).execute();){
                if (!res.isSuccessful() || res.body() == null) {
                    GJaxbPointType gJaxbPointType = point;
                    return gJaxbPointType;
                }
                JsonNode root = this.mapper.readTree(res.body().byteStream());
                if (!"OK".equalsIgnoreCase(GoogleGeocoderHelper.textOrNull(root, "status"))) {
                    GJaxbPointType gJaxbPointType = point;
                    return gJaxbPointType;
                }
                JsonNode results = root.path("results");
                if (!results.isArray() || results.size() == 0) {
                    GJaxbPointType gJaxbPointType = point;
                    return gJaxbPointType;
                }
                JsonNode first = results.get(0);
                JsonNode loc = first.path("geometry").path("location");
                if (loc.hasNonNull("lat") && loc.hasNonNull("lng")) {
                    point.setLatitude(Double.valueOf(loc.get("lat").asDouble()));
                    point.setLongitude(Double.valueOf(loc.get("lng").asDouble()));
                }
                GJaxbPointType gJaxbPointType = point;
                return gJaxbPointType;
            }
        }
        catch (IOException e) {
            return point;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GeocoderHelper.Address reverseGeocode(double lat, double lon) {
        GoogleGeocoderHelper.validateLatLon(lat, lon);
        try {
            String latlng = lat + "," + lon;
            String url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=" + URLEncoder.encode(latlng, StandardCharsets.UTF_8) + "&language=" + URLEncoder.encode(this.language, StandardCharsets.UTF_8) + "&key=" + URLEncoder.encode(this.apiKey, StandardCharsets.UTF_8);
            Request req = new Request.Builder().url(url).header("Accept", "application/json").build();
            try (Response res = this.client.newCall(req).execute();){
                if (!res.isSuccessful() || res.body() == null) {
                    GeocoderHelper.Address address = null;
                    return address;
                }
                JsonNode root = this.mapper.readTree(res.body().byteStream());
                String status = GoogleGeocoderHelper.textOrNull(root, "status");
                if (!"OK".equalsIgnoreCase(status)) {
                    GeocoderHelper.Address address = null;
                    return address;
                }
                JsonNode results = root.path("results");
                if (!results.isArray() || results.size() == 0) {
                    GeocoderHelper.Address address = null;
                    return address;
                }
                JsonNode r0 = results.get(0);
                GeocoderHelper.Address out = new GeocoderHelper.Address();
                out.displayName = GoogleGeocoderHelper.textOrNull(r0, "formatted_address");
                out.lat = String.valueOf(lat);
                out.lon = String.valueOf(lon);
                JsonNode comps = r0.path("address_components");
                out.houseNumber = GoogleGeocoderHelper.component(comps, "street_number");
                out.road = GoogleGeocoderHelper.component(comps, "route");
                out.city = GoogleGeocoderHelper.coalesce(GoogleGeocoderHelper.component(comps, "locality"), GoogleGeocoderHelper.component(comps, "postal_town"), GoogleGeocoderHelper.component(comps, "sublocality"), GoogleGeocoderHelper.component(comps, "administrative_area_level_3"));
                out.postcode = GoogleGeocoderHelper.component(comps, "postal_code");
                out.county = GoogleGeocoderHelper.coalesce(GoogleGeocoderHelper.component(comps, "administrative_area_level_2"), GoogleGeocoderHelper.component(comps, "administrative_area_level_3"));
                out.state = GoogleGeocoderHelper.component(comps, "administrative_area_level_1");
                out.country = GoogleGeocoderHelper.component(comps, "country");
                out.countryCode = GoogleGeocoderHelper.componentShort(comps, "country");
                out.neighbourhood = GoogleGeocoderHelper.component(comps, "neighborhood");
                out.suburb = GoogleGeocoderHelper.component(comps, "sublocality_level_1");
                GeocoderHelper.Address address = out;
                return address;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void validateLatLon(double lat, double lon) {
        if (Double.isNaN(lat) || lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Latitude invalide: " + lat);
        }
        if (Double.isNaN(lon) || lon < -180.0 || lon > 180.0) {
            throw new IllegalArgumentException("Longitude invalide: " + lon);
        }
    }

    private static String textOrNull(JsonNode node, String field) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        JsonNode n = node.get(field);
        return n == null || n.isNull() ? null : n.asText();
    }

    private static String component(JsonNode components, String wantedType) {
        if (components == null || !components.isArray()) {
            return null;
        }
        for (JsonNode c : components) {
            JsonNode types = c.path("types");
            if (!types.isArray()) continue;
            for (JsonNode t : types) {
                if (!wantedType.equalsIgnoreCase(t.asText())) continue;
                JsonNode v = c.get("long_name");
                return v != null && !v.isNull() ? v.asText() : null;
            }
        }
        return null;
    }

    private static String componentShort(JsonNode components, String wantedType) {
        if (components == null || !components.isArray()) {
            return null;
        }
        for (JsonNode c : components) {
            JsonNode types = c.path("types");
            if (!types.isArray()) continue;
            for (JsonNode t : types) {
                if (!wantedType.equalsIgnoreCase(t.asText())) continue;
                JsonNode v = c.get("short_name");
                return v != null && !v.isNull() ? v.asText() : null;
            }
        }
        return null;
    }

    private static String coalesce(String ... vals) {
        if (vals == null) {
            return null;
        }
        for (String v : vals) {
            if (v == null || v.isBlank()) continue;
            return v;
        }
        return null;
    }
}

