/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.HashMap;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsTools
extends AbstractAiTool {
    private static final Logger LOG = LoggerFactory.getLogger(NewsTools.class);
    private static String API_KEY;

    public NewsTools() throws Exception {
        if (System.getenv("GNEWS_API_KEY") == null) {
            LOG.warn("\u26a0\ufe0f Warning: No GNEWS_API_KEY environment variable set. Please set it to use NewsTools.");
        }
        API_KEY = System.getenv("GNEWS_API_KEY");
    }

    @Tool(value={"Give me the latest news for the place. (already normalized, e.g., 'paris')."})
    @ToolDoc(semantics={"give me the news for [place]", "give me the actualities for [place]", "show me the news for [place]", "show me the actualities for [place]"}, rules={"If the place is explicitly mentioned \u2192 giveNews(<place>, <userLanguage>).", "The userLanguage is either EN (for English) or FR (for French)"})
    public GJaxbCommandResponse giveNews(@Named(value="place") String place, @Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        String countMsg;
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        if (API_KEY == null || API_KEY.isBlank()) {
            String msg = "No GNEWS_API_KEY environment variable set. Please set it to use NewsTools.";
            LOG.error(msg);
            e.setCommandOutputMessage(msg);
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            return e;
        }
        e.setForGiveNewsResponse(new GJaxbCommandResponse.ForGiveNewsResponse());
        e.getForGiveNewsResponse().setPlace(place);
        OkHttpClient client = new OkHttpClient.Builder().callTimeout(Duration.ofSeconds(20L)).connectTimeout(Duration.ofSeconds(10L)).readTimeout(Duration.ofSeconds(20L)).build();
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("gnews.io").addPathSegment("api").addPathSegment("v4").addPathSegment("search").addQueryParameter("q", place).addQueryParameter("lang", "fr").addQueryParameter("country", "fr").addQueryParameter("max", "10").addQueryParameter("apikey", API_KEY).build();
        Request request = new Request.Builder().url(url).get().header("Accept", "application/json").build();
        HashMap<String, GJaxbCommandResponse.ForGiveNewsResponse.Article> articlesBySource = new HashMap<String, GJaxbCommandResponse.ForGiveNewsResponse.Article>();
        try (Response resp = client.newCall(request).execute();){
            if (!resp.isSuccessful()) {
                System.err.println("Erreur HTTP " + resp.code() + " : " + resp.message());
                if (resp.body() != null) {
                    System.err.println(resp.body().string());
                }
                e.setCommandOutputMessage(resp.body().string());
                e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
                GJaxbCommandResponse gJaxbCommandResponse = e;
                return gJaxbCommandResponse;
            }
            ObjectMapper mapper = new ObjectMapper();
            String body = resp.body().string();
            JsonNode root = mapper.readTree(body);
            JsonNode articles = root.path("articles");
            if (!articles.isArray() || articles.isEmpty()) {
                System.out.println("Aucun article trouv\u00e9 pour: " + place);
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Aucune actualit\u00e9 trouv\u00e9e pour : " + place);
                } else {
                    e.setCommandOutputMessage("No news found for: " + place);
                }
                e.setCommandOutputMessageType(GJaxbMessageType.WARNING);
                GJaxbCommandResponse gJaxbCommandResponse = e;
                return gJaxbCommandResponse;
            }
            System.out.println("Actus (" + articles.size() + ") pour: " + place + "\n");
            for (JsonNode art : articles) {
                String title = art.path("title").asText("");
                String source = art.path("source").path("name").asText("");
                String publishedAt = art.path("publishedAt").asText("");
                String urlArt = art.path("url").asText("");
                System.out.println("- " + title);
                System.out.println("  Source: " + source);
                System.out.println("  Date:   " + publishedAt);
                System.out.println("  Lien:   " + urlArt);
                System.out.println();
                GJaxbCommandResponse.ForGiveNewsResponse.Article a = new GJaxbCommandResponse.ForGiveNewsResponse.Article();
                a.setTitle(title);
                a.setSource(source);
                a.setPublishedAt(publishedAt);
                a.setUrl(urlArt);
                if (articlesBySource.containsKey(title)) continue;
                articlesBySource.put(title, a);
            }
        }
        e.getForGiveNewsResponse().getArticle().addAll(articlesBySource.values());
        String string = articlesBySource.size() > 1 ? articlesBySource.size() + " articles" : (countMsg = articlesBySource.size() == 1 ? "1 article" : "no article");
        if (userLanguage == UserTools.Language.FR) {
            countMsg = articlesBySource.size() > 1 ? articlesBySource.size() + " actualit\u00e9s" : (articlesBySource.size() == 1 ? "1 actualit\u00e9" : "aucune actualit\u00e9");
        }
        Object outputMsg = "";
        outputMsg = userLanguage == UserTools.Language.FR ? countMsg + " actualit\u00e9e(s) d\u00e9tect\u00e9e(s) pour " + place + " : " + String.join((CharSequence)"; -- ", e.getForGiveNewsResponse().getArticle().stream().map(GJaxbCommandResponse.ForGiveNewsResponse.Article::getTitle).toList()) : countMsg + " news item(s) detected for " + place + ": " + String.join((CharSequence)"; -- ", e.getForGiveNewsResponse().getArticle().stream().map(GJaxbCommandResponse.ForGiveNewsResponse.Article::getTitle).toList());
        e.setCommandOutputMessage((String)outputMsg);
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }
}

