/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import jakarta.inject.Named;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class WeatherTools
extends AbstractAiTool {
    private static final OkHttpClient HTTP = new OkHttpClient.Builder().callTimeout(Duration.ofSeconds(20L)).connectTimeout(Duration.ofSeconds(10L)).readTimeout(Duration.ofSeconds(20L)).build();
    private static final ObjectMapper JSON = new ObjectMapper();

    @Tool(value={"Give me the latest weather forecast for this place. (already normalized, e.g., 'paris')."})
    @ToolDoc(semantics={"give me weather forecast for [place]", "show me weather forecast for [place]"}, rules={"If the utterance contains weather forecast + [place] \u2192 giveWheatherForecast(<place>, <userLanguage>).", "The userLanguage is either EN (for English) or FR (for French).", "If the place is explicitly mentioned \u2192 giveNews(<place>)."})
    public GJaxbCommandResponse giveWheatherForecast(@Named(value="place") String place, @Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        e.setForGiveWheatherForecastResponse(new GJaxbCommandResponse.ForGiveWheatherForecastResponse());
        e.getForGiveWheatherForecastResponse().setPlace(place);
        HttpUrl geocodeUrl = HttpUrl.parse((String)"https://geocoding-api.open-meteo.com/v1/search").newBuilder().addQueryParameter("name", place).addQueryParameter("language", "en").addQueryParameter("count", "1").build();
        JsonNode geo = WeatherTools.getJson(geocodeUrl);
        JsonNode placeResult = WeatherTools.firstArrayElem(geo.path("results")).orElse(null);
        if (place == null) {
            System.err.println("City not found: " + place);
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Ville non trouv\u00e9e : " + place);
            } else {
                e.setCommandOutputMessage("City not found: " + place);
            }
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            return e;
        }
        double lat = placeResult.path("latitude").asDouble();
        double lon = placeResult.path("longitude").asDouble();
        String label = placeResult.path("name").asText() + (String)(placeResult.hasNonNull("admin1") ? ", " + placeResult.get("admin1").asText() : "") + " (" + placeResult.path("country").asText("") + ")";
        System.out.println("\u2192 " + label + "  lat=" + lat + "  lon=" + lon);
        HttpUrl forecastUrl = HttpUrl.parse((String)"https://api.open-meteo.com/v1/forecast").newBuilder().addQueryParameter("latitude", String.valueOf(lat)).addQueryParameter("longitude", String.valueOf(lon)).addQueryParameter("current", "temperature_2m,weather_code,wind_speed_10m").addQueryParameter("daily", String.join((CharSequence)",", "temperature_2m_max", "temperature_2m_min", "precipitation_sum", "rain_sum", "weather_code", "wind_speed_10m_max", "wind_gusts_10m_max", "wind_direction_10m_dominant")).addQueryParameter("timezone", "auto").addQueryParameter("forecast_days", "7").build();
        JsonNode fc = WeatherTools.getJson(forecastUrl);
        String tzStr = fc.path("timezone").asText(null);
        ZoneId zone = tzStr != null ? WeatherTools.safeZoneId(tzStr) : ZoneId.systemDefault();
        LocalDate today = LocalDate.now(zone);
        JsonNode cur = fc.path("current");
        int curCode = cur.path("weather_code").asInt();
        System.out.println("\n--- Now ---");
        System.out.println("Temp:   " + cur.path("temperature_2m").asDouble() + " \u00b0C");
        System.out.println("Wind:   " + cur.path("wind_speed_10m").asDouble() + " km/h");
        System.out.println("Weather: " + WeatherTools.wmoToEn(curCode) + " (code " + curCode + ")");
        JsonNode daily = fc.path("daily");
        JsonNode dates = daily.path("time");
        if (!dates.isArray() || dates.size() == 0) {
            System.err.println("No daily forecast available.");
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Pas de pr\u00e9visions m\u00e9t\u00e9orologiques disponibles.");
            } else {
                e.setCommandOutputMessage("No daily forecast available.");
            }
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            return e;
        }
        int todayIdx = WeatherTools.indexOfDate(dates, today).orElse(0);
        JsonNode tmax = daily.path("temperature_2m_max");
        JsonNode tmin = daily.path("temperature_2m_min");
        JsonNode precip = daily.path("precipitation_sum");
        JsonNode rainOnly = daily.path("rain_sum");
        JsonNode wcode = daily.path("weather_code");
        JsonNode windMax = daily.path("wind_speed_10m_max");
        JsonNode gustMax = daily.path("wind_gusts_10m_max");
        JsonNode windDir = daily.path("wind_direction_10m_dominant");
        double todayPrecip = WeatherTools.getDoubleAt(precip, todayIdx, 0.0);
        Double todayRainOnly = rainOnly.isMissingNode() ? null : WeatherTools.getNullableDoubleAt(rainOnly, todayIdx);
        double todayWind = WeatherTools.getDoubleAt(windMax, todayIdx, Double.NaN);
        double todayGust = WeatherTools.getDoubleAt(gustMax, todayIdx, Double.NaN);
        int todayDirDeg = WeatherTools.getIntAt(windDir, todayIdx, 0);
        System.out.println("\n--- Today ---");
        System.out.printf("Rain (total precip): %.1f mm%n", todayPrecip);
        if (todayRainOnly != null) {
            System.out.printf("Rain (rain only):   %.1f mm%n", todayRainOnly);
        } else {
            System.out.println("Rain (rain only):   <not provided by model>");
        }
        System.out.printf("Wind max:           %s km/h (gusts: %s km/h, dir: %d\u00b0)%n", WeatherTools.formatNum(todayWind), WeatherTools.formatNum(todayGust), todayDirDeg);
        System.out.println("\n--- Next 7 days (incl. wind) ---");
        for (int i = 0; i < dates.size(); ++i) {
            int code = WeatherTools.getIntAt(wcode, i, -1);
            System.out.printf("%s  max:%5s\u00b0C  min:%5s\u00b0C  precip:%5s mm  wind:%5s km/h  gusts:%5s km/h  dir:%3d\u00b0  %s (code %d)%n", dates.get(i).asText(), WeatherTools.formatNum(WeatherTools.getDoubleAt(tmax, i, Double.NaN)), WeatherTools.formatNum(WeatherTools.getDoubleAt(tmin, i, Double.NaN)), WeatherTools.formatNum(WeatherTools.getDoubleAt(precip, i, 0.0)), WeatherTools.formatNum(WeatherTools.getDoubleAt(windMax, i, Double.NaN)), WeatherTools.formatNum(WeatherTools.getDoubleAt(gustMax, i, Double.NaN)), WeatherTools.getIntAt(windDir, i, 0), WeatherTools.wmoToEn(code), code);
            GJaxbCommandResponse.ForGiveWheatherForecastResponse.Forecast f = new GJaxbCommandResponse.ForGiveWheatherForecastResponse.Forecast();
            f.setDate(dates.get(i).asText());
            f.setTemperatureMax(WeatherTools.getDoubleAt(tmax, i, Double.NaN));
            f.setTemperatureMin(WeatherTools.getDoubleAt(tmin, i, Double.NaN));
            f.setRainPrecipitation(WeatherTools.getDoubleAt(precip, i, 0.0));
            f.setWeatherCode(WeatherTools.getIntAt(wcode, i, -1));
            f.setWeatherLabel(WeatherTools.wmoToEn(WeatherTools.getIntAt(wcode, i, -1)));
            f.setWindSpeedMax(WeatherTools.getDoubleAt(windMax, i, Double.NaN));
            f.setWindGustsMax(WeatherTools.getDoubleAt(gustMax, i, Double.NaN));
            f.setWindDirectionDominant(WeatherTools.getIntAt(windDir, i, 0));
            e.getForGiveWheatherForecastResponse().getForecast().add(f);
        }
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("Les derni\u00e8res pr\u00e9visions m\u00e9t\u00e9orologiques sont les suivantes : " + String.join((CharSequence)", ", e.getForGiveWheatherForecastResponse().getForecast().stream().map(GJaxbCommandResponse.ForGiveWheatherForecastResponse.Forecast::getWeatherLabel).toList()));
        } else {
            e.setCommandOutputMessage("The latest weather forecast updates are as follows: " + String.join((CharSequence)", ", e.getForGiveWheatherForecastResponse().getForecast().stream().map(GJaxbCommandResponse.ForGiveWheatherForecastResponse.Forecast::getWeatherLabel).toList()));
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }

    private static JsonNode getJson(HttpUrl url) throws IOException {
        Request req = new Request.Builder().url(url).header("Accept", "application/json").build();
        try (Response r = HTTP.newCall(req).execute();){
            if (!r.isSuccessful()) {
                String errBody = r.body() != null ? r.body().string() : "<no body>";
                throw new IOException("HTTP " + r.code() + " " + r.message() + " \u2014 " + errBody);
            }
            if (r.body() == null) {
                throw new IOException("Empty response body for: " + String.valueOf(url));
            }
            JsonNode jsonNode = JSON.readTree(r.body().string());
            return jsonNode;
        }
    }

    private static Optional<JsonNode> firstArrayElem(JsonNode arr) {
        if (arr == null || !arr.isArray()) {
            return Optional.empty();
        }
        Iterator it = arr.elements();
        return it.hasNext() ? Optional.of((JsonNode)it.next()) : Optional.empty();
    }

    private static Optional<Integer> indexOfDate(JsonNode dates, LocalDate target) {
        for (int i = 0; i < dates.size(); ++i) {
            try {
                if (!LocalDate.parse(dates.get(i).asText()).equals(target)) continue;
                return Optional.of(i);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static ZoneId safeZoneId(String id) {
        try {
            return ZoneId.of(id);
        }
        catch (Exception e) {
            return ZoneId.systemDefault();
        }
    }

    private static double getDoubleAt(JsonNode arr, int idx, double def) {
        if (arr == null || !arr.isArray() || idx < 0 || idx >= arr.size()) {
            return def;
        }
        JsonNode n = arr.get(idx);
        return n == null || n.isNull() ? def : n.asDouble(def);
    }

    private static Double getNullableDoubleAt(JsonNode arr, int idx) {
        if (arr == null || !arr.isArray() || idx < 0 || idx >= arr.size()) {
            return null;
        }
        JsonNode n = arr.get(idx);
        return n == null || n.isNull() ? null : Double.valueOf(n.asDouble());
    }

    private static int getIntAt(JsonNode arr, int idx, int def) {
        if (arr == null || !arr.isArray() || idx < 0 || idx >= arr.size()) {
            return def;
        }
        JsonNode n = arr.get(idx);
        return n == null || n.isNull() ? def : n.asInt(def);
    }

    private static String formatNum(double v) {
        if (Double.isNaN(v)) {
            return "NA";
        }
        return String.format("%.1f", v);
    }

    private static String wmoToEn(int code) {
        switch (code) {
            case 0: {
                return "Clear sky";
            }
            case 1: {
                return "Mainly clear";
            }
            case 2: {
                return "Partly cloudy";
            }
            case 3: {
                return "Overcast";
            }
            case 45: {
                return "Fog";
            }
            case 48: {
                return "Depositing rime fog";
            }
            case 51: {
                return "Light drizzle";
            }
            case 53: {
                return "Moderate drizzle";
            }
            case 55: {
                return "Dense drizzle";
            }
            case 56: {
                return "Light freezing drizzle";
            }
            case 57: {
                return "Dense freezing drizzle";
            }
            case 61: {
                return "Slight rain";
            }
            case 63: {
                return "Moderate rain";
            }
            case 65: {
                return "Heavy rain";
            }
            case 66: {
                return "Light freezing rain";
            }
            case 67: {
                return "Heavy freezing rain";
            }
            case 71: {
                return "Slight snow";
            }
            case 73: {
                return "Moderate snow";
            }
            case 75: {
                return "Heavy snow";
            }
            case 77: {
                return "Snow grains";
            }
            case 80: {
                return "Rain showers (slight)";
            }
            case 81: {
                return "Rain showers (moderate)";
            }
            case 82: {
                return "Rain showers (violent)";
            }
            case 85: {
                return "Snow showers (slight)";
            }
            case 86: {
                return "Snow showers (heavy)";
            }
            case 95: {
                return "Thunderstorm";
            }
            case 96: {
                return "Thunderstorm with slight hail";
            }
            case 99: {
                return "Thunderstorm with heavy hail";
            }
        }
        return "Unknown";
    }
}

