/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.service;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import fr.emac.gind.gov.ai.chatbot.client.AIChatbotClient;
import fr.emac.gind.gov.ai.chatbot.service.builder.ModelBuilderSelector;
import fr.emac.gind.gov.ai.command.assistant.AiCommandAssistant;
import fr.emac.gind.gov.ai.command.assistant.FaultMessage;
import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.ai_chatbot.GJaxbAiChatBotType;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.governance.ai.command.assistant.GJaxbAssistantRequest;
import fr.emac.gind.governance.ai.command.assistant.GJaxbAssistantResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbDetectedCommands;
import fr.emac.gind.governance.ai.command.assistant.GJaxbGetToolsInfo;
import fr.emac.gind.governance.ai.command.assistant.GJaxbGetToolsInfoResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolsInfo;
import fr.emac.gind.governance.ai.command.assistant.agent.IACommandAgent;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AiContext;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.ToolsManager;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="ai_command_assistantSOAP", serviceName="ai_command_assistant", targetNamespace="http://www.gind.emac.fr/gov/ai/command/assistant/", wsdlLocation="wsdl/ai-command-assistant.wsdl", endpointInterface="fr.emac.gind.gov.ai.command.assistant.AiCommandAssistant")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class AICommandAssistantImpl
implements AiCommandAssistant {
    private static final Logger LOG = LoggerFactory.getLogger((String)AICommandAssistantImpl.class.getName());
    private IACommandAgent agent;
    private GJaxbToolsInfo info;
    private CoreGov coreGovClient = null;
    private AiChatbot aiChatbotClient = null;

    public AICommandAssistantImpl(Map<String, Object> context) throws Exception {
        GJaxbToolsInfo toolsInfo;
        if (context != null && context.containsKey("governance")) {
            this.coreGovClient = CoreGovClient.createClient((String)context.get("governance").toString().replace("/gov", "/GovCore"));
            this.aiChatbotClient = AIChatbotClient.createClient((String)context.get("governance").toString().replace("/gov", "/GovAIChatbot"));
        }
        GJaxbContext aiContext = new GJaxbContext();
        aiContext.setSelectedAiChatBot(GJaxbAiChatBotType.CHAT_GPT);
        ChatModel model = ModelBuilderSelector.getInstance().getSelectedChatModel(aiContext);
        ToolsManager.getInstance().initialize(this.coreGovClient, this.aiChatbotClient, context);
        this.info = toolsInfo = ToolsManager.getInstance().getToolsInfoForChatSystem();
        String OPENAI_CHATGPT_API_KEY = System.getenv("OPENAI_CHATGPT_API_KEY");
        if (OPENAI_CHATGPT_API_KEY != null && !OPENAI_CHATGPT_API_KEY.isBlank()) {
            IACommandAgent agent;
            List<AbstractAiTool> tools = ToolsManager.getInstance().getToolsList();
            this.agent = agent = (IACommandAgent)AiServices.builder(IACommandAgent.class).chatModel(model).tools(tools.toArray(new Object[tools.size()])).build();
        }
    }

    public GJaxbAssistantResponse handle(GJaxbAssistantRequest parameters) throws FaultMessage {
        GJaxbAssistantResponse r = new GJaxbAssistantResponse();
        try {
            String text = parameters.getUserRequestText().trim();
            if (text.isEmpty()) {
                r.setDetectedCommands(new GJaxbDetectedCommands());
                r.getDetectedCommands().setAnswerIfNoneToolsAreDetected("Tell me what you want to do or ask");
                return r;
            }
            GJaxbSelectedKnowledgeSpace sks = new GJaxbSelectedKnowledgeSpace();
            sks.setCollaborationName(parameters.getCollaborationName());
            sks.setKnowledgeName(parameters.getKnowledgeSpaceName());
            AiContext aiContext = new AiContext(sks);
            ToolsManager.getInstance().setContext(aiContext);
            GJaxbDetectedCommands commands = this.agent.route(this.info.getToolsDefinition(), this.info.getToolsSemantic(), this.info.getToolsRules(), this.info.getToolsJsonSchema(), text);
            r.setDetectedCommands(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage("Error in handle: " + e.getMessage(), null, (Throwable)e);
        }
        return r;
    }

    public GJaxbGetToolsInfoResponse getToolsInfo(GJaxbGetToolsInfo parameters) throws FaultMessage {
        GJaxbGetToolsInfoResponse response = new GJaxbGetToolsInfoResponse();
        response.setToolsInfo(this.info);
        return response;
    }
}

