/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import jakarta.xml.bind.annotation.XmlElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PojoToSchemaAndExample {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Set<String> EXCLUDED_PROP_NAMES = Set.of("adoptiveParent", "baseURI", "jaxbElement", "namespaceContext", "naturalParent", "userData", "userDataKeysUsed");

    private static SchemaGeneratorConfig buildConfig() {
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(MAPPER, SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        builder.forFields().withIgnoreCheck(field -> EXCLUDED_PROP_NAMES.contains(field.getName()));
        builder.forMethods().withIgnoreCheck(method -> {
            String name = method.getName();
            String prop = null;
            if (name.startsWith("get") && name.length() > 3) {
                prop = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            } else if (name.startsWith("is") && name.length() > 2) {
                prop = Character.toLowerCase(name.charAt(2)) + name.substring(3);
            }
            return prop != null && EXCLUDED_PROP_NAMES.contains(prop);
        });
        return builder.build();
    }

    public static ObjectNode generateSchema(Class<?> rootClass) {
        SchemaGeneratorConfig config = PojoToSchemaAndExample.buildConfig();
        SchemaGenerator generator = new SchemaGenerator(config);
        return generator.generateSchema(rootClass, new Type[0]);
    }

    public static JsonNode buildExampleFromSchema(JsonNode schema, Class<?> typeHint) {
        return new ExampleBuilder(typeHint).fromSchema(schema);
    }

    public static void main(String[] args) throws Exception {
        ObjectNode schema = PojoToSchemaAndExample.generateSchema(GJaxbCommandResponse.class);
        JsonNode example = PojoToSchemaAndExample.buildExampleFromSchema((JsonNode)schema, GJaxbCommandResponse.class);
        System.out.println("=== JSON SCHEMA (GJaxbDetectedCommands) ===");
        System.out.println(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema));
        System.out.println("\n=== EXEMPLE JSON ===");
        System.out.println(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)example));
    }

    private static class ExampleBuilder {
        private final Class<?> rootType;
        private final ObjectMapper om = MAPPER;

        ExampleBuilder(Class<?> rootType) {
            this.rootType = rootType;
        }

        JsonNode fromSchema(JsonNode schema) {
            return this.buildForObject(schema, this.rootType);
        }

        private ObjectNode buildForObject(JsonNode schema, Class<?> typeHint) {
            ObjectNode out = this.om.createObjectNode();
            ObjectNode props = ExampleBuilder.asObj(schema.get("properties"));
            if (props == null) {
                return out;
            }
            Map<String, Field> fieldMap = this.reflectFieldMap(typeHint);
            props.fields().forEachRemaining(entry -> {
                Class<?> fieldType;
                String propName = (String)entry.getKey();
                if (EXCLUDED_PROP_NAMES.contains(propName)) {
                    return;
                }
                JsonNode propSchema = (JsonNode)entry.getValue();
                Field f = (Field)fieldMap.get(propName);
                Class<?> clazz = fieldType = f != null ? ExampleBuilder.rawClass(f.getGenericType()) : null;
                if ("commandResponse".equals(propName) && this.isArraySchema(propSchema)) {
                    ArrayNode arr = out.putArray(propName);
                    JsonNode itemsSchema = propSchema.get("items");
                    Class<?> itemHint = f != null ? ExampleBuilder.genericListArgument(f) : null;
                    ObjectNode cmdObj = this.buildCommandObject(itemsSchema, itemHint);
                    arr.add((JsonNode)cmdObj);
                } else {
                    JsonNode value = this.buildNodeForSchema(propName, propSchema, f, fieldType);
                    out.set(propName, value);
                }
            });
            return out;
        }

        private ObjectNode buildCommandObject(JsonNode itemSchema, Class<?> itemHint) {
            Class<Object> effectiveHint = itemHint != null ? itemHint : GJaxbCommandResponse.class;
            ObjectNode cmd = this.buildForObject(itemSchema, effectiveHint);
            cmd.put("_note", "The four 'for*Response' blocks are OPTIONAL and mutually exclusive: in a real message, use only one of them and omit the others (or set them to null). 'candidates' is optional (0..*).");
            this.markOptionalBlocks(cmd);
            return cmd;
        }

        private JsonNode buildNodeForSchema(String propName, JsonNode propSchema, Field field, Class<?> fieldTypeHint) {
            Set<String> types = this.readTypes(propSchema);
            if (types.contains("object")) {
                Class<Object> hint;
                Class<?> clazz = hint = field != null ? ExampleBuilder.rawClass(field.getGenericType()) : fieldTypeHint;
                if (hint == null) {
                    hint = Object.class;
                }
                return this.buildForObject(propSchema, hint);
            }
            if (types.contains("array")) {
                ArrayNode arr = this.om.createArrayNode();
                JsonNode itemsSchema = propSchema.get("items");
                Class<?> itemHint = null;
                if (field != null) {
                    itemHint = ExampleBuilder.genericListArgument(field);
                }
                JsonNode exampleItem = this.buildNodeForSchema(propName + "[]", itemsSchema, null, itemHint);
                arr.add(exampleItem);
                if ("candidates".equals(propName)) {
                    arr.add(exampleItem.deepCopy());
                }
                return arr;
            }
            return this.buildPrimitivePlaceholder(propName, propSchema, field);
        }

        private JsonNode buildPrimitivePlaceholder(String propName, JsonNode schema, Field field) {
            boolean nullable;
            Set<String> types = this.readTypes(schema);
            boolean bl = nullable = types.contains("null") || this.isNillable(field);
            if ("processBpmnXml".equals(propName)) {
                return ExampleBuilder.text("<string-xml>");
            }
            if ("processJson".equals(propName)) {
                return ExampleBuilder.text("<string-json>");
            }
            if ("lat".equals(propName)) {
                return ExampleBuilder.text(nullable ? "<double|null>" : "<double>");
            }
            if ("lng".equals(propName)) {
                return ExampleBuilder.text(nullable ? "<double|null>" : "<double>");
            }
            if ("zoom".equals(propName)) {
                return ExampleBuilder.text(nullable ? "<int|null>" : "<int>");
            }
            if (types.contains("integer")) {
                return ExampleBuilder.text(nullable ? "<int|null>" : "<int>");
            }
            if (types.contains("number")) {
                return ExampleBuilder.text(nullable ? "<double|null>" : "<double>");
            }
            if (types.contains("boolean")) {
                return ExampleBuilder.text("<boolean>");
            }
            return ExampleBuilder.text("<string>");
        }

        private void markOptionalBlocks(ObjectNode cmdObj) {
            for (String name : List.of("forUserResponse", "forMapResponse", "forPersonResponse", "forBusinessResponse")) {
                JsonNode n = cmdObj.get(name);
                if (n == null || !n.isObject()) continue;
                ((ObjectNode)n).put("_optional", true);
            }
        }

        private Map<String, Field> reflectFieldMap(Class<?> type) {
            if (type == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            for (Field f : this.allFields(type)) {
                f.setAccessible(true);
                map.put(f.getName(), f);
            }
            return map;
        }

        private List<Field> allFields(Class<?> type) {
            ArrayList<Field> result = new ArrayList<Field>();
            for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
                result.addAll(Arrays.asList(t.getDeclaredFields()));
            }
            return result;
        }

        private boolean isArraySchema(JsonNode node) {
            return this.readTypes(node).contains("array");
        }

        private Set<String> readTypes(JsonNode schemaNode) {
            if (schemaNode == null) {
                return Collections.emptySet();
            }
            JsonNode typeNode = schemaNode.get("type");
            LinkedHashSet<String> types = new LinkedHashSet<String>();
            if (typeNode == null) {
                for (String kw : List.of("anyOf", "oneOf", "allOf")) {
                    JsonNode arr = schemaNode.get(kw);
                    if (arr == null || !arr.isArray()) continue;
                    for (JsonNode n : arr) {
                        types.addAll(this.readTypes(n));
                    }
                }
                return types;
            }
            if (typeNode.isTextual()) {
                types.add(typeNode.asText());
            } else if (typeNode.isArray()) {
                for (JsonNode n : typeNode) {
                    if (!n.isTextual()) continue;
                    types.add(n.asText());
                }
            }
            return types;
        }

        private static ObjectNode asObj(JsonNode n) {
            return n != null && n.isObject() ? (ObjectNode)n : null;
        }

        private static TextNode text(String s) {
            return new TextNode(s);
        }

        private static Class<?> rawClass(Type t) {
            if (t instanceof Class) {
                return (Class)t;
            }
            if (t instanceof ParameterizedType) {
                return (Class)((ParameterizedType)t).getRawType();
            }
            return Object.class;
        }

        private static Class<?> genericListArgument(Field f) {
            ParameterizedType pt;
            Type[] args;
            Type t = f.getGenericType();
            if (t instanceof ParameterizedType && (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length == 1) {
                Type arg = args[0];
                if (arg instanceof Class) {
                    return (Class)arg;
                }
                if (arg instanceof ParameterizedType) {
                    return (Class)((ParameterizedType)arg).getRawType();
                }
            }
            return Object.class;
        }

        private boolean isNillable(Field f) {
            if (f == null) {
                return false;
            }
            XmlElement ann = f.getAnnotation(XmlElement.class);
            return ann != null && ann.nillable();
        }
    }
}

