/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode;

import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.GeocoderHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.GoogleGeocoderHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.NominatimGeocoderHelper;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;

public class SmartGeocoderHelper
implements GeocoderHelper {
    private GoogleGeocoderHelper google;
    private final NominatimGeocoderHelper nomi;
    private Provider provider;
    private String language = "fr";
    private static SmartGeocoderHelper INSTANCE;

    private SmartGeocoderHelper() {
        String key = System.getenv("GOOGLE_API_KEY");
        if (key != null && !key.isBlank()) {
            this.google = new GoogleGeocoderHelper(key, this.language);
            this.provider = Provider.GOOGLE;
        } else {
            this.provider = Provider.NOMINATIM;
        }
        this.nomi = new NominatimGeocoderHelper("MapAgent/1.0", SmartGeocoderHelper.languageHeader(this.language));
    }

    public static synchronized SmartGeocoderHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SmartGeocoderHelper();
        }
        return INSTANCE;
    }

    public SmartGeocoderHelper(String googleApiKey, String language) {
        if (language != null && !language.isBlank()) {
            this.language = language;
        }
        if (googleApiKey != null && !googleApiKey.isBlank()) {
            this.google = new GoogleGeocoderHelper(googleApiKey, this.language);
            this.provider = Provider.GOOGLE;
        } else {
            this.provider = Provider.NOMINATIM;
        }
        this.nomi = new NominatimGeocoderHelper("MapAgent/1.0", SmartGeocoderHelper.languageHeader(this.language));
    }

    public Provider getActiveProvider() {
        return this.provider;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        if (language == null || language.isBlank()) {
            return;
        }
        this.language = language;
        if (this.google != null) {
            this.google.setLanguage(language);
        }
        this.nomi.setLanguage(SmartGeocoderHelper.languageHeader(language));
    }

    @Override
    public GJaxbPointType geocodeCity(String place) {
        GJaxbPointType point;
        if (this.google != null && !SmartGeocoderHelper.isZero(point = this.google.geocodeCity(place))) {
            this.provider = Provider.GOOGLE;
            return point;
        }
        point = this.nomi.geocodeCity(place);
        this.provider = Provider.NOMINATIM;
        return point == null ? new GJaxbPointType() : point;
    }

    @Override
    public GeocoderHelper.Address reverseGeocode(double lat, double lon) {
        GeocoderHelper.Address ga;
        if (this.google != null && (ga = this.google.reverseGeocode(lat, lon)) != null) {
            this.provider = Provider.GOOGLE;
            return ga;
        }
        GeocoderHelper.Address na = this.nomi.reverseGeocode(lat, lon);
        this.provider = Provider.NOMINATIM;
        return na;
    }

    private static boolean isZero(GJaxbPointType p) {
        if (p == null) {
            return true;
        }
        double lat = p.getLatitude() != null ? p.getLatitude() : 0.0;
        double lon = p.getLongitude() != null ? p.getLongitude() : 0.0;
        return lat == 0.0 && lon == 0.0;
    }

    private static String languageHeader(String language) {
        if (language == null || language.isBlank()) {
            return "fr-FR,fr;q=0.9";
        }
        if (language.contains(",") || language.contains(";")) {
            return language;
        }
        if (language.length() == 2) {
            return language + "-" + language.toUpperCase() + "," + language + ";q=0.9";
        }
        return language;
    }

    public static enum Provider {
        GOOGLE,
        NOMINATIM;

    }
}

