/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMonitoredAsset;
import fr.emac.gind.governance.ai.command.assistant.GJaxbSensor;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.SensorTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class GoodTools
extends AbstractAiTool {
    private final CoreGov coreGovClient;

    public GoodTools(CoreGov coreGovClient) {
        this.coreGovClient = coreGovClient;
    }

    @Tool(value={"Lookup a good's geolocation in Neo4j."})
    @ToolDoc(semantics={"where is {goodName}?", "locate {goodName}", "find {goodName}'s location"}, rules={"If the utterance contains where is / locate / find + goodName \u2192 findGoodLocation(<goodName>, <userLanguage>).", "The userLanguage is either EN (for English) or FR (for French).", "Pass the goodName perceived; the tool handles normalization and ambiguity.", "Returns the candidates found (zero, one, or multiple)"})
    public GJaxbCommandResponse findGoodLocation(@Named(value="goodName") String goodName, @Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        GJaxbCommandResponse resp = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            if (goodName == null || goodName.isBlank()) {
                if (userLanguage == UserTools.Language.FR) {
                    resp.setCommandOutputMessage("Aucun nom correct fourni");
                } else {
                    resp.setCommandOutputMessage("No good name given");
                }
                resp.setCommandOutputMessageType(GJaxbMessageType.WARNING);
                return resp;
            }
            String queryReq = "WITH $goodName AS gn,\n0.50 AS minW,\n0.10 AS bonusStarts,\n0.05 AS bonusInitial\n\nWITH gn, minW, bonusStarts, bonusInitial,\n     CASE WHEN gn IS NOT NULL AND size(trim(gn)) >= 3 THEN trim(gn) + '~' ELSE coalesce(gn,'') END AS term\nCALL db.index.fulltext.queryNodes('good_name_ft', coalesce(term,'')) YIELD node, score\n\n// s\u00e9curit\u00e9 label\nWITH node, score, minW, bonusStarts, bonusInitial\nWHERE node:$goodConcept\n\n// normalisation (2 WITH pour \u00e9viter l'erreur de port\u00e9e)\nWITH node AS p, score, minW, bonusStarts, bonusInitial,\n     toLower(trim(coalesce($goodName,''))) AS qN\nWITH p, score, minW, bonusStarts, bonusInitial, qN,\n     toLower(trim(coalesce(p.property_name,''))) AS nN\n\n// bigrammes\nWITH p, score, minW, bonusStarts, bonusInitial, qN, nN,\n     CASE WHEN qN = '' OR nN = '' THEN [] ELSE [i IN range(0, size(qN)-2) | substring(qN,i,2)] END AS qBi,\n     CASE WHEN qN = '' OR nN = '' THEN [] ELSE [i IN range(0, size(nN)-2) | substring(nN,i,2)] END AS nBi,\n     CASE WHEN qN <> '' AND nN STARTS WITH qN THEN bonusStarts ELSE 0.0 END AS bPref,\n     CASE WHEN qN <> '' AND substring(nN,0,1) = substring(qN,0,1) THEN bonusInitial ELSE 0.0 END AS bInit\nWITH p, score, minW, bPref, bInit,\n     size([x IN qBi WHERE x IN nBi]) AS inter,\n     size(qBi) AS a, size(nBi) AS b\nWITH p, score, minW, bPref, bInit,\n     (CASE WHEN (a + b - inter) = 0 THEN 1.0 ELSE toFloat(inter) / toFloat(a + b - inter) END) AS simName\nWITH p, score, (simName + bPref + bInit) AS confidence, minW\nWHERE confidence >= minW\nRETURN p, confidence, score\nORDER BY confidence DESC, score DESC\nLIMIT 25\n";
            queryReq = queryReq.replace("$goodName", "'" + goodName + "'");
            queryReq = queryReq.replace("$goodConcept", "`" + String.valueOf(GenericModelHelper.collab((String)"Good")) + "`");
            GJaxbQuery query = new GJaxbQuery();
            query.setSelectedKnowledgeSpace(this.getContext().getSelectedKnowledgeSpace());
            query.setQuery(queryReq);
            GJaxbQueryResponse queryResp = this.coreGovClient.query(query);
            resp.setForFindGoodLocationResponse(new GJaxbCommandResponse.ForFindGoodLocationResponse());
            resp.getForFindGoodLocationResponse().setGoodNameIdentified(goodName);
            if (queryResp.getSingle() == null || queryResp.getSingle().getGenericModel() == null || queryResp.getSingle().getGenericModel().getNode() == null) {
                if (userLanguage == UserTools.Language.FR) {
                    resp.setCommandOutputMessage("Je n'ai pas pu localiser " + goodName);
                } else {
                    resp.setCommandOutputMessage("I could not locate " + goodName);
                }
                resp.setCommandOutputMessageType(GJaxbMessageType.WARNING);
                return resp;
            }
            for (GJaxbNode node : queryResp.getSingle().getGenericModel().getNode()) {
                GJaxbCommandResponse.ForFindGoodLocationResponse.Candidate c = new GJaxbCommandResponse.ForFindGoodLocationResponse.Candidate();
                c.setId(node.getId());
                c.setName(GenericModelHelper.getName((GJaxbNode)node));
                if (node.getGeolocation() != null && node.getGeolocation().getItemView() != null && !node.getGeolocation().getItemView().isEmpty()) {
                    GJaxbNode.Geolocation.ItemView iv = (GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0);
                    if (iv.getPoint() != null) {
                        c.setPoint(iv.getPoint());
                    } else if (iv.getArea() != null) {
                        Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromItemView(iv);
                        Point pt = GeometryHelper.getInstance().getPolygonCenter(polygon);
                        c.setPoint(new GJaxbPointType());
                        c.getPoint().setLatitude(Double.valueOf(pt.getY()));
                        c.getPoint().setLongitude(Double.valueOf(pt.getX()));
                    }
                }
                resp.getForFindGoodLocationResponse().getCandidate().add(c);
            }
            List list = resp.getForFindGoodLocationResponse().getCandidate();
            if (list.isEmpty()) {
                if (userLanguage == UserTools.Language.FR) {
                    resp.setCommandOutputMessage("Je n'ai pas pu localiser " + goodName);
                } else {
                    resp.setCommandOutputMessage("I could not locate " + goodName);
                }
                resp.setCommandOutputMessageType(GJaxbMessageType.WARNING);
            } else if (list.size() > 1) {
                if (userLanguage == UserTools.Language.FR) {
                    resp.setCommandOutputMessage("Il y a plusieurs candidats pour " + goodName + ", veuillez \u00eatre plus pr\u00e9cis.");
                } else {
                    resp.setCommandOutputMessage("There are multiple candidates for " + goodName + ", please be more specific.");
                }
                resp.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            } else {
                GJaxbCommandResponse.ForFindGoodLocationResponse.Candidate c = (GJaxbCommandResponse.ForFindGoodLocationResponse.Candidate)list.get(0);
                if (c.getPoint() != null) {
                    if (userLanguage == UserTools.Language.FR) {
                        resp.setCommandOutputMessage("J'ai localis\u00e9 " + c.getName() + ". Je te le montre sur la carte.");
                    } else {
                        resp.setCommandOutputMessage("I located " + c.getName() + ". I show it on the map.");
                    }
                    resp.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
                } else {
                    if (userLanguage == UserTools.Language.FR) {
                        resp.setCommandOutputMessage("J'ai trouv\u00e9 " + c.getName() + " mais il n'a pas de g\u00e9olocalisation.");
                    } else {
                        resp.setCommandOutputMessage("I found " + c.getName() + " but it has no geolocation.");
                    }
                    resp.setCommandOutputMessageType(GJaxbMessageType.WARNING);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (userLanguage == UserTools.Language.FR) {
                resp.setCommandOutputMessage("Je n'ai pas pu trouver " + goodName);
            } else {
                resp.setCommandOutputMessage("I could not find " + goodName);
            }
            resp.setCommandOutputMessageType(GJaxbMessageType.ERROR);
        }
        return resp;
    }

    @Tool(value={"Find information on a good (descrition, sensors fixed onto ...)."})
    @ToolDoc(semantics={"what is {goodName}?", "What is the {goodName} building for?", "what is the function of {goodName}", "find the {goodName} description", "Give me a description of the {goodName} building."}, rules={"If the utterance contains what is / what are + goodName \u2192 whatIsThisGood(<goodName>, <userLanguage>).", "The userLanguage is either EN (for English) or FR (for French).", "Pass the goodName of an object  perceived; the tool handles normalization and ambiguity.", "Returns information on goods found (zero, one, or multiple)"})
    public String whatIsThisGood(@Named(value="goodName") String goodName, @Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            GJaxbCommandResponse goodFound = this.findGoodLocation(goodName, userLanguage);
            if (goodFound.getForFindGoodLocationResponse() == null || goodFound.getForFindGoodLocationResponse().getCandidate().isEmpty()) {
                return JSONJAXBContext.getInstance().marshallAnyElement((Object)goodFound);
            }
            if (goodFound.getForFindGoodLocationResponse().getCandidate().size() > 1) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Il y a plusieurs candidats pour " + goodName + ", veuillez \u00eatre plus pr\u00e9cis.");
                } else {
                    e.setCommandOutputMessage("There are multiple candidates for " + goodName + ", please be more specific.");
                }
                e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
                return JSONJAXBContext.getInstance().marshallAnyElement((Object)e);
            }
            GJaxbCommandResponse.ForFindGoodLocationResponse.Candidate candidate = (GJaxbCommandResponse.ForFindGoodLocationResponse.Candidate)goodFound.getForFindGoodLocationResponse().getCandidate().get(0);
            GJaxbQuery query = new GJaxbQuery();
            query.setSelectedKnowledgeSpace(this.getContext().getSelectedKnowledgeSpace());
            String queryReq = "\t\tMATCH (good:`{http://fr.emac.gind/collaborative-model}Good` { modelNodeId: \"$id\" })\n\t\tMATCH p= (good)<-[fo:`{http://fr.emac.gind/collaborative-model}Fixed_Onto`*0..]-(root)\n\t\tRETURN DISTINCT p;\n";
            queryReq = queryReq.replace("$id", Neo4JId.createIdUsingCollaboration((String)candidate.getId(), (String)this.getContext().getSelectedKnowledgeSpace().getCollaborationName(), (String)this.getContext().getSelectedKnowledgeSpace().getKnowledgeName()).toString());
            query.setQuery(queryReq);
            GJaxbQueryResponse queryResp = this.coreGovClient.query(query);
            GJaxbCommandResponse.ForWhatIsThisGoodResponse.Candidate candidateInfo = new GJaxbCommandResponse.ForWhatIsThisGoodResponse.Candidate();
            e.setForWhatIsThisGoodResponse(new GJaxbCommandResponse.ForWhatIsThisGoodResponse());
            e.getForWhatIsThisGoodResponse().getCandidate().add(candidateInfo);
            e.getForWhatIsThisGoodResponse().setGoodNameIdentified(goodName);
            GJaxbGenericModel modelMerged = GenericModelHelper.mergeModels((GJaxbGenericModel[])queryResp.getMultiple().getGenericModel().toArray(new GJaxbGenericModel[queryResp.getMultiple().getGenericModel().size()]));
            GenericModelManager man = new GenericModelManager(new GJaxbGenericModel[]{modelMerged});
            GJaxbNode good = (GJaxbNode)GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Good"), (List)modelMerged.getNode()).get(0);
            candidateInfo.setId(good.getId());
            candidateInfo.setName(GenericModelHelper.getName((GJaxbNode)good));
            candidateInfo.setDescription(GenericModelHelper.findProperty((String)"description", (List)good.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"description", (List)good.getProperty(), (boolean)false).getValue() : "");
            List<GJaxbMonitoredAsset> assets = SensorTools.findMonitorerdAssetsFromModel(modelMerged);
            candidateInfo.getMonitoredAsset().addAll(assets);
            Object msg = "";
            msg = userLanguage == UserTools.Language.FR ? "$name est un(e) $description.\n" : "$name is a $description.\n";
            GJaxbMonitoredAsset firstAsset = (GJaxbMonitoredAsset)candidateInfo.getMonitoredAsset().get(0);
            List<GJaxbSensor> sensors = SensorTools.getSensorsRecursively(firstAsset);
            msg = userLanguage == UserTools.Language.FR ? (String)msg + "il est compos\u00e9 de " + sensors.size() + " capteurs :\n" : (String)msg + "it is composed of " + sensors.size() + " sensors :\n";
            Map<String, List<GJaxbSensor>> mapSensors = this.classifySensorsByType(sensors);
            for (Map.Entry<String, List<GJaxbSensor>> sensorTypes : mapSensors.entrySet()) {
                Object sensorMsg = "";
                sensorMsg = userLanguage == UserTools.Language.FR ? "- " + sensorTypes.getValue().size() + " capteurs de type : " + sensorTypes.getKey() + "\n" : "- " + sensorTypes.getValue().size() + " sensors of type: " + sensorTypes.getKey() + "\n";
                msg = (String)msg + (String)sensorMsg;
            }
            msg = ((String)msg).replace("$name", GenericModelHelper.getName((GJaxbNode)good).toString());
            msg = ((String)msg).replace("$description", candidateInfo.getDescription() != null ? candidateInfo.getDescription() : "");
            e.setCommandOutputMessage((String)msg);
            e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Je n'ai pas pu trouver " + goodName);
            } else {
                e.setCommandOutputMessage("I could not find " + goodName);
            }
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
        }
        return JSONJAXBContext.getInstance().marshallAnyElement((Object)e);
    }

    private Map<String, List<GJaxbSensor>> classifySensorsByType(List<GJaxbSensor> sensors) {
        HashMap<String, List<GJaxbSensor>> mapSensors = new HashMap<String, List<GJaxbSensor>>();
        for (GJaxbSensor sensor : sensors) {
            if (!mapSensors.containsKey(sensor.getType())) {
                mapSensors.put(sensor.getType(), new ArrayList());
            }
            ((List)mapSensors.get(sensor.getType())).add(sensor);
        }
        return mapSensors;
    }
}

